/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/**
 * @module
 * @description
 * Entry point for all public APIs of the common package.
 */
export * from './private_export';
export * from './location/index';
export { formatDate } from './i18n/format_date';
export { formatCurrency, formatNumber, formatPercent } from './i18n/format_number';
export { NgLocaleLocalization, NgLocalization } from './i18n/localization';
export { registerLocaleData } from './i18n/locale_data';
export { Plural, NumberFormatStyle, FormStyle, TranslationWidth, FormatWidth, NumberSymbol, WeekDay, getNumberOfCurrencyDigits, getCurrencySymbol, getLocaleDayPeriods, getLocaleDayNames, getLocaleMonthNames, getLocaleId, getLocaleEraNames, getLocaleWeekEndRange, getLocaleFirstDayOfWeek, getLocaleDateFormat, getLocaleDateTimeFormat, getLocaleExtraDayPeriodRules, getLocaleExtraDayPeriods, getLocalePluralCase, getLocaleTimeFormat, getLocaleNumberSymbol, getLocaleNumberFormat, getLocaleCurrencyCode, getLocaleCurrencyName, getLocaleCurrencySymbol, getLocaleDirection } from './i18n/locale_data_api';
export { parseCookieValue as ɵparseCookieValue } from './cookie';
export { CommonModule } from './common_module';
export { NgClass, NgFor, NgForOf, NgForOfContext, NgIf, NgIfContext, NgPlural, NgPluralCase, NgStyle, NgSwitch, NgSwitchCase, NgSwitchDefault, NgTemplateOutlet, NgComponentOutlet } from './directives/index';
export { DOCUMENT } from './dom_tokens';
export { AsyncPipe, DatePipe, DATE_PIPE_DEFAULT_TIMEZONE, I18nPluralPipe, I18nSelectPipe, JsonPipe, LowerCasePipe, CurrencyPipe, DecimalPipe, PercentPipe, SlicePipe, UpperCasePipe, TitleCasePipe, KeyValuePipe } from './pipes/index';
export { PLATFORM_BROWSER_ID as ɵPLATFORM_BROWSER_ID, PLATFORM_SERVER_ID as ɵPLATFORM_SERVER_ID, PLATFORM_WORKER_APP_ID as ɵPLATFORM_WORKER_APP_ID, PLATFORM_WORKER_UI_ID as ɵPLATFORM_WORKER_UI_ID, isPlatformBrowser, isPlatformServer, isPlatformWorkerApp, isPlatformWorkerUi } from './platform_id';
export { VERSION } from './version';
export { ViewportScroller, NullViewportScroller as ɵNullViewportScroller } from './viewport_scroller';
export { XhrFactory } from './xhr';
export { IMAGE_LOADER, NgOptimizedImage, PRECONNECT_CHECK_BLOCKLIST, provideCloudflareLoader, provideCloudinaryLoader, provideImageKitLoader, provideImgixLoader } from './directives/ng_optimized_image';
//# sourceMappingURL=data:application/json;base64,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