// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_error_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceHTTPErrorRuleFrontendOKCode is the HTTP code returned for type ReplaceHTTPErrorRuleFrontendOK
const ReplaceHTTPErrorRuleFrontendOKCode int = 200

/*
ReplaceHTTPErrorRuleFrontendOK HTTP Error Rule replaced

swagger:response replaceHttpErrorRuleFrontendOK
*/
type ReplaceHTTPErrorRuleFrontendOK struct {

	/*
	  In: Body
	*/
	Payload *models.HTTPErrorRule `json:"body,omitempty"`
}

// NewReplaceHTTPErrorRuleFrontendOK creates ReplaceHTTPErrorRuleFrontendOK with default headers values
func NewReplaceHTTPErrorRuleFrontendOK() *ReplaceHTTPErrorRuleFrontendOK {

	return &ReplaceHTTPErrorRuleFrontendOK{}
}

// WithPayload adds the payload to the replace Http error rule frontend o k response
func (o *ReplaceHTTPErrorRuleFrontendOK) WithPayload(payload *models.HTTPErrorRule) *ReplaceHTTPErrorRuleFrontendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Http error rule frontend o k response
func (o *ReplaceHTTPErrorRuleFrontendOK) SetPayload(payload *models.HTTPErrorRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceHTTPErrorRuleFrontendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceHTTPErrorRuleFrontendAcceptedCode is the HTTP code returned for type ReplaceHTTPErrorRuleFrontendAccepted
const ReplaceHTTPErrorRuleFrontendAcceptedCode int = 202

/*
ReplaceHTTPErrorRuleFrontendAccepted Configuration change accepted and reload requested

swagger:response replaceHttpErrorRuleFrontendAccepted
*/
type ReplaceHTTPErrorRuleFrontendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.HTTPErrorRule `json:"body,omitempty"`
}

// NewReplaceHTTPErrorRuleFrontendAccepted creates ReplaceHTTPErrorRuleFrontendAccepted with default headers values
func NewReplaceHTTPErrorRuleFrontendAccepted() *ReplaceHTTPErrorRuleFrontendAccepted {

	return &ReplaceHTTPErrorRuleFrontendAccepted{}
}

// WithReloadID adds the reloadId to the replace Http error rule frontend accepted response
func (o *ReplaceHTTPErrorRuleFrontendAccepted) WithReloadID(reloadID string) *ReplaceHTTPErrorRuleFrontendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace Http error rule frontend accepted response
func (o *ReplaceHTTPErrorRuleFrontendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace Http error rule frontend accepted response
func (o *ReplaceHTTPErrorRuleFrontendAccepted) WithPayload(payload *models.HTTPErrorRule) *ReplaceHTTPErrorRuleFrontendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Http error rule frontend accepted response
func (o *ReplaceHTTPErrorRuleFrontendAccepted) SetPayload(payload *models.HTTPErrorRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceHTTPErrorRuleFrontendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceHTTPErrorRuleFrontendBadRequestCode is the HTTP code returned for type ReplaceHTTPErrorRuleFrontendBadRequest
const ReplaceHTTPErrorRuleFrontendBadRequestCode int = 400

/*
ReplaceHTTPErrorRuleFrontendBadRequest Bad request

swagger:response replaceHttpErrorRuleFrontendBadRequest
*/
type ReplaceHTTPErrorRuleFrontendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceHTTPErrorRuleFrontendBadRequest creates ReplaceHTTPErrorRuleFrontendBadRequest with default headers values
func NewReplaceHTTPErrorRuleFrontendBadRequest() *ReplaceHTTPErrorRuleFrontendBadRequest {

	return &ReplaceHTTPErrorRuleFrontendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace Http error rule frontend bad request response
func (o *ReplaceHTTPErrorRuleFrontendBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceHTTPErrorRuleFrontendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace Http error rule frontend bad request response
func (o *ReplaceHTTPErrorRuleFrontendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace Http error rule frontend bad request response
func (o *ReplaceHTTPErrorRuleFrontendBadRequest) WithPayload(payload *models.Error) *ReplaceHTTPErrorRuleFrontendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Http error rule frontend bad request response
func (o *ReplaceHTTPErrorRuleFrontendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceHTTPErrorRuleFrontendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceHTTPErrorRuleFrontendNotFoundCode is the HTTP code returned for type ReplaceHTTPErrorRuleFrontendNotFound
const ReplaceHTTPErrorRuleFrontendNotFoundCode int = 404

/*
ReplaceHTTPErrorRuleFrontendNotFound The specified resource was not found

swagger:response replaceHttpErrorRuleFrontendNotFound
*/
type ReplaceHTTPErrorRuleFrontendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceHTTPErrorRuleFrontendNotFound creates ReplaceHTTPErrorRuleFrontendNotFound with default headers values
func NewReplaceHTTPErrorRuleFrontendNotFound() *ReplaceHTTPErrorRuleFrontendNotFound {

	return &ReplaceHTTPErrorRuleFrontendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the replace Http error rule frontend not found response
func (o *ReplaceHTTPErrorRuleFrontendNotFound) WithConfigurationVersion(configurationVersion string) *ReplaceHTTPErrorRuleFrontendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace Http error rule frontend not found response
func (o *ReplaceHTTPErrorRuleFrontendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace Http error rule frontend not found response
func (o *ReplaceHTTPErrorRuleFrontendNotFound) WithPayload(payload *models.Error) *ReplaceHTTPErrorRuleFrontendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Http error rule frontend not found response
func (o *ReplaceHTTPErrorRuleFrontendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceHTTPErrorRuleFrontendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceHTTPErrorRuleFrontendDefault General Error

swagger:response replaceHttpErrorRuleFrontendDefault
*/
type ReplaceHTTPErrorRuleFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceHTTPErrorRuleFrontendDefault creates ReplaceHTTPErrorRuleFrontendDefault with default headers values
func NewReplaceHTTPErrorRuleFrontendDefault(code int) *ReplaceHTTPErrorRuleFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceHTTPErrorRuleFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace HTTP error rule frontend default response
func (o *ReplaceHTTPErrorRuleFrontendDefault) WithStatusCode(code int) *ReplaceHTTPErrorRuleFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace HTTP error rule frontend default response
func (o *ReplaceHTTPErrorRuleFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace HTTP error rule frontend default response
func (o *ReplaceHTTPErrorRuleFrontendDefault) WithConfigurationVersion(configurationVersion string) *ReplaceHTTPErrorRuleFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace HTTP error rule frontend default response
func (o *ReplaceHTTPErrorRuleFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace HTTP error rule frontend default response
func (o *ReplaceHTTPErrorRuleFrontendDefault) WithPayload(payload *models.Error) *ReplaceHTTPErrorRuleFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace HTTP error rule frontend default response
func (o *ReplaceHTTPErrorRuleFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceHTTPErrorRuleFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
