// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package bind

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// CreateBindLogForwardCreatedCode is the HTTP code returned for type CreateBindLogForwardCreated
const CreateBindLogForwardCreatedCode int = 201

/*
CreateBindLogForwardCreated Bind created

swagger:response createBindLogForwardCreated
*/
type CreateBindLogForwardCreated struct {

	/*
	  In: Body
	*/
	Payload *models.Bind `json:"body,omitempty"`
}

// NewCreateBindLogForwardCreated creates CreateBindLogForwardCreated with default headers values
func NewCreateBindLogForwardCreated() *CreateBindLogForwardCreated {

	return &CreateBindLogForwardCreated{}
}

// WithPayload adds the payload to the create bind log forward created response
func (o *CreateBindLogForwardCreated) WithPayload(payload *models.Bind) *CreateBindLogForwardCreated {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create bind log forward created response
func (o *CreateBindLogForwardCreated) SetPayload(payload *models.Bind) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateBindLogForwardCreated) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(201)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateBindLogForwardAcceptedCode is the HTTP code returned for type CreateBindLogForwardAccepted
const CreateBindLogForwardAcceptedCode int = 202

/*
CreateBindLogForwardAccepted Configuration change accepted and reload requested

swagger:response createBindLogForwardAccepted
*/
type CreateBindLogForwardAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.Bind `json:"body,omitempty"`
}

// NewCreateBindLogForwardAccepted creates CreateBindLogForwardAccepted with default headers values
func NewCreateBindLogForwardAccepted() *CreateBindLogForwardAccepted {

	return &CreateBindLogForwardAccepted{}
}

// WithReloadID adds the reloadId to the create bind log forward accepted response
func (o *CreateBindLogForwardAccepted) WithReloadID(reloadID string) *CreateBindLogForwardAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the create bind log forward accepted response
func (o *CreateBindLogForwardAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the create bind log forward accepted response
func (o *CreateBindLogForwardAccepted) WithPayload(payload *models.Bind) *CreateBindLogForwardAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create bind log forward accepted response
func (o *CreateBindLogForwardAccepted) SetPayload(payload *models.Bind) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateBindLogForwardAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateBindLogForwardBadRequestCode is the HTTP code returned for type CreateBindLogForwardBadRequest
const CreateBindLogForwardBadRequestCode int = 400

/*
CreateBindLogForwardBadRequest Bad request

swagger:response createBindLogForwardBadRequest
*/
type CreateBindLogForwardBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateBindLogForwardBadRequest creates CreateBindLogForwardBadRequest with default headers values
func NewCreateBindLogForwardBadRequest() *CreateBindLogForwardBadRequest {

	return &CreateBindLogForwardBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the create bind log forward bad request response
func (o *CreateBindLogForwardBadRequest) WithConfigurationVersion(configurationVersion string) *CreateBindLogForwardBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create bind log forward bad request response
func (o *CreateBindLogForwardBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create bind log forward bad request response
func (o *CreateBindLogForwardBadRequest) WithPayload(payload *models.Error) *CreateBindLogForwardBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create bind log forward bad request response
func (o *CreateBindLogForwardBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateBindLogForwardBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateBindLogForwardConflictCode is the HTTP code returned for type CreateBindLogForwardConflict
const CreateBindLogForwardConflictCode int = 409

/*
CreateBindLogForwardConflict The specified resource already exists

swagger:response createBindLogForwardConflict
*/
type CreateBindLogForwardConflict struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateBindLogForwardConflict creates CreateBindLogForwardConflict with default headers values
func NewCreateBindLogForwardConflict() *CreateBindLogForwardConflict {

	return &CreateBindLogForwardConflict{}
}

// WithConfigurationVersion adds the configurationVersion to the create bind log forward conflict response
func (o *CreateBindLogForwardConflict) WithConfigurationVersion(configurationVersion string) *CreateBindLogForwardConflict {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create bind log forward conflict response
func (o *CreateBindLogForwardConflict) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create bind log forward conflict response
func (o *CreateBindLogForwardConflict) WithPayload(payload *models.Error) *CreateBindLogForwardConflict {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create bind log forward conflict response
func (o *CreateBindLogForwardConflict) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateBindLogForwardConflict) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(409)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
CreateBindLogForwardDefault General Error

swagger:response createBindLogForwardDefault
*/
type CreateBindLogForwardDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateBindLogForwardDefault creates CreateBindLogForwardDefault with default headers values
func NewCreateBindLogForwardDefault(code int) *CreateBindLogForwardDefault {
	if code <= 0 {
		code = 500
	}

	return &CreateBindLogForwardDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the create bind log forward default response
func (o *CreateBindLogForwardDefault) WithStatusCode(code int) *CreateBindLogForwardDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the create bind log forward default response
func (o *CreateBindLogForwardDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the create bind log forward default response
func (o *CreateBindLogForwardDefault) WithConfigurationVersion(configurationVersion string) *CreateBindLogForwardDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create bind log forward default response
func (o *CreateBindLogForwardDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create bind log forward default response
func (o *CreateBindLogForwardDefault) WithPayload(payload *models.Error) *CreateBindLogForwardDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create bind log forward default response
func (o *CreateBindLogForwardDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateBindLogForwardDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
