package rtc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRecordFiles invokes the rtc.DescribeRecordFiles API synchronously
func (client *Client) DescribeRecordFiles(request *DescribeRecordFilesRequest) (response *DescribeRecordFilesResponse, err error) {
	response = CreateDescribeRecordFilesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRecordFilesWithChan invokes the rtc.DescribeRecordFiles API asynchronously
func (client *Client) DescribeRecordFilesWithChan(request *DescribeRecordFilesRequest) (<-chan *DescribeRecordFilesResponse, <-chan error) {
	responseChan := make(chan *DescribeRecordFilesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRecordFiles(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRecordFilesWithCallback invokes the rtc.DescribeRecordFiles API asynchronously
func (client *Client) DescribeRecordFilesWithCallback(request *DescribeRecordFilesRequest, callback func(response *DescribeRecordFilesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRecordFilesResponse
		var err error
		defer close(result)
		response, err = client.DescribeRecordFiles(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRecordFilesRequest is the request struct for api DescribeRecordFiles
type DescribeRecordFilesRequest struct {
	*requests.RpcRequest
	StartTime string           `position:"Query" name:"StartTime"`
	PageNum   requests.Integer `position:"Query" name:"PageNum"`
	TaskIds   *[]string        `position:"Query" name:"TaskIds"  type:"Repeated"`
	PageSize  requests.Integer `position:"Query" name:"PageSize"`
	ShowLog   string           `position:"Query" name:"ShowLog"`
	EndTime   string           `position:"Query" name:"EndTime"`
	OwnerId   requests.Integer `position:"Query" name:"OwnerId"`
	AppId     string           `position:"Query" name:"AppId"`
	ChannelId string           `position:"Query" name:"ChannelId"`
}

// DescribeRecordFilesResponse is the response struct for api DescribeRecordFiles
type DescribeRecordFilesResponse struct {
	*responses.BaseResponse
	TotalPage   int64        `json:"TotalPage" xml:"TotalPage"`
	RequestId   string       `json:"RequestId" xml:"RequestId"`
	TotalNum    int64        `json:"TotalNum" xml:"TotalNum"`
	RecordFiles []RecordFile `json:"RecordFiles" xml:"RecordFiles"`
}

// CreateDescribeRecordFilesRequest creates a request to invoke DescribeRecordFiles API
func CreateDescribeRecordFilesRequest() (request *DescribeRecordFilesRequest) {
	request = &DescribeRecordFilesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("rtc", "2018-01-11", "DescribeRecordFiles", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeRecordFilesResponse creates a response to parse from DescribeRecordFiles response
func CreateDescribeRecordFilesResponse() (response *DescribeRecordFilesResponse) {
	response = &DescribeRecordFilesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
