package retailcloud

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteAppResourceAlloc invokes the retailcloud.DeleteAppResourceAlloc API synchronously
func (client *Client) DeleteAppResourceAlloc(request *DeleteAppResourceAllocRequest) (response *DeleteAppResourceAllocResponse, err error) {
	response = CreateDeleteAppResourceAllocResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteAppResourceAllocWithChan invokes the retailcloud.DeleteAppResourceAlloc API asynchronously
func (client *Client) DeleteAppResourceAllocWithChan(request *DeleteAppResourceAllocRequest) (<-chan *DeleteAppResourceAllocResponse, <-chan error) {
	responseChan := make(chan *DeleteAppResourceAllocResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteAppResourceAlloc(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteAppResourceAllocWithCallback invokes the retailcloud.DeleteAppResourceAlloc API asynchronously
func (client *Client) DeleteAppResourceAllocWithCallback(request *DeleteAppResourceAllocRequest, callback func(response *DeleteAppResourceAllocResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteAppResourceAllocResponse
		var err error
		defer close(result)
		response, err = client.DeleteAppResourceAlloc(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteAppResourceAllocRequest is the request struct for api DeleteAppResourceAlloc
type DeleteAppResourceAllocRequest struct {
	*requests.RpcRequest
	AppEnvId requests.Integer `position:"Query" name:"AppEnvId"`
}

// DeleteAppResourceAllocResponse is the response struct for api DeleteAppResourceAlloc
type DeleteAppResourceAllocResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	ErrMsg    string `json:"ErrMsg" xml:"ErrMsg"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateDeleteAppResourceAllocRequest creates a request to invoke DeleteAppResourceAlloc API
func CreateDeleteAppResourceAllocRequest() (request *DeleteAppResourceAllocRequest) {
	request = &DeleteAppResourceAllocRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailcloud", "2018-03-13", "DeleteAppResourceAlloc", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteAppResourceAllocResponse creates a response to parse from DeleteAppResourceAlloc response
func CreateDeleteAppResourceAllocResponse() (response *DeleteAppResourceAllocResponse) {
	response = &DeleteAppResourceAllocResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
