package ots

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListClusterType invokes the ots.ListClusterType API synchronously
// api document: https://help.aliyun.com/api/ots/listclustertype.html
func (client *Client) ListClusterType(request *ListClusterTypeRequest) (response *ListClusterTypeResponse, err error) {
	response = CreateListClusterTypeResponse()
	err = client.DoAction(request, response)
	return
}

// ListClusterTypeWithChan invokes the ots.ListClusterType API asynchronously
// api document: https://help.aliyun.com/api/ots/listclustertype.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListClusterTypeWithChan(request *ListClusterTypeRequest) (<-chan *ListClusterTypeResponse, <-chan error) {
	responseChan := make(chan *ListClusterTypeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListClusterType(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListClusterTypeWithCallback invokes the ots.ListClusterType API asynchronously
// api document: https://help.aliyun.com/api/ots/listclustertype.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListClusterTypeWithCallback(request *ListClusterTypeRequest, callback func(response *ListClusterTypeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListClusterTypeResponse
		var err error
		defer close(result)
		response, err = client.ListClusterType(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListClusterTypeRequest is the request struct for api ListClusterType
type ListClusterTypeRequest struct {
	*requests.RpcRequest
	AccessKeyId     string           `position:"Query" name:"access_key_id"`
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
}

// ListClusterTypeResponse is the response struct for api ListClusterType
type ListClusterTypeResponse struct {
	*responses.BaseResponse
	RequestId        string           `json:"RequestId" xml:"RequestId"`
	ClusterTypeInfos ClusterTypeInfos `json:"ClusterTypeInfos" xml:"ClusterTypeInfos"`
}

// CreateListClusterTypeRequest creates a request to invoke ListClusterType API
func CreateListClusterTypeRequest() (request *ListClusterTypeRequest) {
	request = &ListClusterTypeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ots", "2016-06-20", "ListClusterType", "ots", "openAPI")
	return
}

// CreateListClusterTypeResponse creates a response to parse from ListClusterType response
func CreateListClusterTypeResponse() (response *ListClusterTypeResponse) {
	response = &ListClusterTypeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
