package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// JoinPublicIpsToEpnInstance invokes the ens.JoinPublicIpsToEpnInstance API synchronously
func (client *Client) JoinPublicIpsToEpnInstance(request *JoinPublicIpsToEpnInstanceRequest) (response *JoinPublicIpsToEpnInstanceResponse, err error) {
	response = CreateJoinPublicIpsToEpnInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// JoinPublicIpsToEpnInstanceWithChan invokes the ens.JoinPublicIpsToEpnInstance API asynchronously
func (client *Client) JoinPublicIpsToEpnInstanceWithChan(request *JoinPublicIpsToEpnInstanceRequest) (<-chan *JoinPublicIpsToEpnInstanceResponse, <-chan error) {
	responseChan := make(chan *JoinPublicIpsToEpnInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.JoinPublicIpsToEpnInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// JoinPublicIpsToEpnInstanceWithCallback invokes the ens.JoinPublicIpsToEpnInstance API asynchronously
func (client *Client) JoinPublicIpsToEpnInstanceWithCallback(request *JoinPublicIpsToEpnInstanceRequest, callback func(response *JoinPublicIpsToEpnInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *JoinPublicIpsToEpnInstanceResponse
		var err error
		defer close(result)
		response, err = client.JoinPublicIpsToEpnInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// JoinPublicIpsToEpnInstanceRequest is the request struct for api JoinPublicIpsToEpnInstance
type JoinPublicIpsToEpnInstanceRequest struct {
	*requests.RpcRequest
	EPNInstanceId string `position:"Query" name:"EPNInstanceId"`
	InstanceInfos string `position:"Query" name:"InstanceInfos"`
}

// JoinPublicIpsToEpnInstanceResponse is the response struct for api JoinPublicIpsToEpnInstance
type JoinPublicIpsToEpnInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateJoinPublicIpsToEpnInstanceRequest creates a request to invoke JoinPublicIpsToEpnInstance API
func CreateJoinPublicIpsToEpnInstanceRequest() (request *JoinPublicIpsToEpnInstanceRequest) {
	request = &JoinPublicIpsToEpnInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "JoinPublicIpsToEpnInstance", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateJoinPublicIpsToEpnInstanceResponse creates a response to parse from JoinPublicIpsToEpnInstance response
func CreateJoinPublicIpsToEpnInstanceResponse() (response *JoinPublicIpsToEpnInstanceResponse) {
	response = &JoinPublicIpsToEpnInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
