package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpLoadMap invokes the cloudwf.UpLoadMap API synchronously
// api document: https://help.aliyun.com/api/cloudwf/uploadmap.html
func (client *Client) UpLoadMap(request *UpLoadMapRequest) (response *UpLoadMapResponse, err error) {
	response = CreateUpLoadMapResponse()
	err = client.DoAction(request, response)
	return
}

// UpLoadMapWithChan invokes the cloudwf.UpLoadMap API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/uploadmap.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpLoadMapWithChan(request *UpLoadMapRequest) (<-chan *UpLoadMapResponse, <-chan error) {
	responseChan := make(chan *UpLoadMapResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpLoadMap(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpLoadMapWithCallback invokes the cloudwf.UpLoadMap API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/uploadmap.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpLoadMapWithCallback(request *UpLoadMapRequest, callback func(response *UpLoadMapResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpLoadMapResponse
		var err error
		defer close(result)
		response, err = client.UpLoadMap(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpLoadMapRequest is the request struct for api UpLoadMap
type UpLoadMapRequest struct {
	*requests.RpcRequest
	FileName   string           `position:"Query" name:"FileName"`
	UploadId   string           `position:"Query" name:"UploadId"`
	ObjectName string           `position:"Query" name:"ObjectName"`
	ChunkIndex requests.Integer `position:"Query" name:"ChunkIndex"`
	ChunkCnt   requests.Integer `position:"Query" name:"ChunkCnt"`
}

// UpLoadMapResponse is the response struct for api UpLoadMap
type UpLoadMapResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateUpLoadMapRequest creates a request to invoke UpLoadMap API
func CreateUpLoadMapRequest() (request *UpLoadMapRequest) {
	request = &UpLoadMapRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "UpLoadMap", "cloudwf", "openAPI")
	return
}

// CreateUpLoadMapResponse creates a response to parse from UpLoadMap response
func CreateUpLoadMapResponse() (response *UpLoadMapResponse) {
	response = &UpLoadMapResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
