package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteCen invokes the cbn.DeleteCen API synchronously
func (client *Client) DeleteCen(request *DeleteCenRequest) (response *DeleteCenResponse, err error) {
	response = CreateDeleteCenResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteCenWithChan invokes the cbn.DeleteCen API asynchronously
func (client *Client) DeleteCenWithChan(request *DeleteCenRequest) (<-chan *DeleteCenResponse, <-chan error) {
	responseChan := make(chan *DeleteCenResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteCen(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteCenWithCallback invokes the cbn.DeleteCen API asynchronously
func (client *Client) DeleteCenWithCallback(request *DeleteCenRequest, callback func(response *DeleteCenResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteCenResponse
		var err error
		defer close(result)
		response, err = client.DeleteCen(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteCenRequest is the request struct for api DeleteCen
type DeleteCenRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	CenId                string           `position:"Query" name:"CenId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteCenResponse is the response struct for api DeleteCen
type DeleteCenResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteCenRequest creates a request to invoke DeleteCen API
func CreateDeleteCenRequest() (request *DeleteCenRequest) {
	request = &DeleteCenRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "DeleteCen", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteCenResponse creates a response to parse from DeleteCen response
func CreateDeleteCenResponse() (response *DeleteCenResponse) {
	response = &DeleteCenResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
