package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeGroupStruct invokes the aegis.DescribeGroupStruct API synchronously
// api document: https://help.aliyun.com/api/aegis/describegroupstruct.html
func (client *Client) DescribeGroupStruct(request *DescribeGroupStructRequest) (response *DescribeGroupStructResponse, err error) {
	response = CreateDescribeGroupStructResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeGroupStructWithChan invokes the aegis.DescribeGroupStruct API asynchronously
// api document: https://help.aliyun.com/api/aegis/describegroupstruct.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeGroupStructWithChan(request *DescribeGroupStructRequest) (<-chan *DescribeGroupStructResponse, <-chan error) {
	responseChan := make(chan *DescribeGroupStructResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeGroupStruct(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeGroupStructWithCallback invokes the aegis.DescribeGroupStruct API asynchronously
// api document: https://help.aliyun.com/api/aegis/describegroupstruct.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeGroupStructWithCallback(request *DescribeGroupStructRequest, callback func(response *DescribeGroupStructResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeGroupStructResponse
		var err error
		defer close(result)
		response, err = client.DescribeGroupStruct(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeGroupStructRequest is the request struct for api DescribeGroupStruct
type DescribeGroupStructRequest struct {
	*requests.RpcRequest
	SourceIp  string `position:"Query" name:"SourceIp"`
	TagIdList string `position:"Query" name:"tagIdList"`
	Remark    string `position:"Query" name:"remark"`
}

// DescribeGroupStructResponse is the response struct for api DescribeGroupStruct
type DescribeGroupStructResponse struct {
	*responses.BaseResponse
	RequestId   string   `json:"RequestId" xml:"RequestId"`
	GroupFather int      `json:"GroupFather" xml:"GroupFather"`
	GroupId     int      `json:"GroupId" xml:"GroupId"`
	GroupName   string   `json:"GroupName" xml:"GroupName"`
	GroupIndex  int      `json:"GroupIndex" xml:"GroupIndex"`
	GroupFlag   int      `json:"GroupFlag" xml:"GroupFlag"`
	GroupLevel  int      `json:"GroupLevel" xml:"GroupLevel"`
	MachineNum  int      `json:"MachineNum" xml:"MachineNum"`
	Groups      []string `json:"Groups" xml:"Groups"`
}

// CreateDescribeGroupStructRequest creates a request to invoke DescribeGroupStruct API
func CreateDescribeGroupStructRequest() (request *DescribeGroupStructRequest) {
	request = &DescribeGroupStructRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeGroupStruct", "vipaegis", "openAPI")
	return
}

// CreateDescribeGroupStructResponse creates a response to parse from DescribeGroupStruct response
func CreateDescribeGroupStructResponse() (response *DescribeGroupStructResponse) {
	response = &DescribeGroupStructResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
