/**
 *  beep plugin for the Video Disk Recorder 
 *
 *  beep.c  -  define base plugin class
 *
 *  (c) 2004 - 2008 Andreas Brachold <vdr07 AT deltab de>
 *
 * This code is distributed under the terms and conditions of the
 * GNU GENERAL PUBLIC LICENSE. See the file COPYING for details.
 *
 */
 
#include <vdr/plugin.h>
#include <time.h>

#include "status.h"
#include "setup.h"
#include "menu.h"

static const char *VERSION        = "0.1.2";

class cPluginNotifyBeep : public cPlugin {
private:
  cStatusNotifyBeep * m_pStatusNotify;
  time_t m_lastTime;
public:
  cPluginNotifyBeep(void);
  virtual ~cPluginNotifyBeep();
  virtual const char *Version(void) { return VERSION; }
  virtual const char *Description(void) { return tr("Notify with a beep"); }
  virtual const char *CommandLineHelp(void){ return NULL; }
  virtual bool ProcessArgs(int argc, char *argv[]){ return true; }
  virtual bool Initialize(void){ return true; }
  virtual void Housekeeping(void) {  }
  virtual const char *MainMenuEntry(void) { return NULL; }
  virtual cOsdObject *MainMenuAction(void){ return NULL; }

  virtual bool Start(void);
  virtual cMenuSetupPage *SetupMenu(void);
  virtual bool SetupParse(const char *Name, const char *Value);
  virtual cString Active(void);
  };

cPluginNotifyBeep::cPluginNotifyBeep(void)
: m_pStatusNotify(NULL)
, m_lastTime(0)
{

}

cPluginNotifyBeep::~cPluginNotifyBeep()
{
   if(m_pStatusNotify)
     delete m_pStatusNotify;
   m_pStatusNotify = NULL;
}

bool cPluginNotifyBeep::Start(void)
{
  bool ret = false;

  m_pStatusNotify = new cStatusNotifyBeep();
  if (m_pStatusNotify)
  {
    ret = true;
  }
  return ret;
}

cMenuSetupPage *cPluginNotifyBeep::SetupMenu(void)
{
  // Return a setup menu in case the plugin supports one.
  return new cSetupMenuNotifyBeep();
}

bool cPluginNotifyBeep::SetupParse(const char * Name, const char * Value)
{
  if     (!strcasecmp(Name, "active"))      NotifyBeepSetup.active    = atoi(Value);
  else if(!strcasecmp(Name, "freq"))        
       {
           NotifyBeepSetup.freq = atoi(Value); 
           NotifyBeepSetup.freq = max(NotifyBeepSetup.freq,NotifyBeepSetup.freq_min);
           NotifyBeepSetup.freq = min(NotifyBeepSetup.freq,NotifyBeepSetup.freq_max);
       }
  else if(!strcasecmp(Name, "duration"))
       {
           NotifyBeepSetup.duration = atoi(Value); 
           NotifyBeepSetup.duration = max(NotifyBeepSetup.duration,NotifyBeepSetup.duration_min);
           NotifyBeepSetup.duration = min(NotifyBeepSetup.duration,NotifyBeepSetup.duration_max);
       }
  else if(!strcasecmp(Name, "console"))      
  {    
         strncpy(NotifyBeepSetup.console,Value,sizeof(NotifyBeepSetup.console));
  }
  else if(!strcasecmp(Name, "onshutdown"))      NotifyBeepSetup.onshutdown= atoi(Value);
  else if(!strcasecmp(Name, "oneditprocess"))   NotifyBeepSetup.oneditprocess= atoi(Value);
  else if(!strcasecmp(Name, "onanymessage"))    NotifyBeepSetup.onanymessage= atoi(Value);
  else return false;
  return true;
}

cString cPluginNotifyBeep::Active(void) {
  time_t t = time(NULL);
  if(((m_lastTime + 30) <= t) 
      && NotifyBeepSetup.active && NotifyBeepSetup.onshutdown) {
    m_pStatusNotify->notify();
  }
  m_lastTime = t;
  return 0;
}




VDRPLUGINCREATOR(cPluginNotifyBeep); // Don't touch this!
