/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.nvdl;

import java.util.regex.PatternSyntaxException;

class NamespaceSpecification {
    public static String DEFAULT_WILDCARD = "*";
    static final String ANY_NAMESPACE = "##any";
    String ns = "\u0000";
    String wildcard = DEFAULT_WILDCARD;

    public NamespaceSpecification(String string) {
        this(string, DEFAULT_WILDCARD);
    }

    public NamespaceSpecification(String string, String string2) {
        this.ns = string;
        this.wildcard = string2;
    }

    public boolean compete(NamespaceSpecification namespaceSpecification) {
        if ("".equals(namespaceSpecification.wildcard)) {
            return this.covers(namespaceSpecification.ns);
        }
        String[] stringArray = this.split(namespaceSpecification.ns, namespaceSpecification.wildcard);
        if (stringArray.length == 1) {
            return this.covers(namespaceSpecification.ns);
        }
        if ("".equals(this.wildcard)) {
            return namespaceSpecification.covers(this.ns);
        }
        String[] stringArray2 = this.split(this.ns, this.wildcard);
        if (stringArray2.length == 1) {
            return namespaceSpecification.covers(this.ns);
        }
        return NamespaceSpecification.matchPrefix(stringArray2[0], stringArray[0]) || NamespaceSpecification.matchPrefix(stringArray2[stringArray2.length - 1], stringArray[stringArray.length - 1]);
    }

    private static boolean matchPrefix(String string, String string2) {
        return string.startsWith(string2) || string2.startsWith(string);
    }

    private String[] split(String string, String string2) {
        String[] stringArray;
        try {
            stringArray = string.split("\\" + string2, -1);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            try {
                stringArray = string.split(string2, -1);
            }
            catch (PatternSyntaxException patternSyntaxException2) {
                stringArray = new String[]{string};
            }
        }
        return stringArray;
    }

    public boolean covers(String string) {
        if (ANY_NAMESPACE.equals(this.ns) || "".equals(this.wildcard)) {
            return this.ns.equals(string);
        }
        String[] stringArray = this.split(this.ns, this.wildcard);
        if (stringArray.length == 1) {
            return this.ns.equals(string);
        }
        if (!string.startsWith(stringArray[0])) {
            return false;
        }
        if (!string.endsWith(stringArray[stringArray.length - 1])) {
            return false;
        }
        int n = stringArray[0].length();
        int n2 = string.length() - stringArray[stringArray.length - 1].length();
        for (int i = 1; i < stringArray.length - 1; ++i) {
            if (n > n2) {
                return false;
            }
            int n3 = string.indexOf(stringArray[i], n);
            if (n3 == -1 || n3 + stringArray[i].length() > n2) {
                return false;
            }
            n = n3 + stringArray[i].length();
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof NamespaceSpecification) {
            NamespaceSpecification namespaceSpecification = (NamespaceSpecification)object;
            return this.ns.equals(namespaceSpecification.ns) && this.wildcard.equals(namespaceSpecification.wildcard);
        }
        return false;
    }

    public int hashCode() {
        return (this.wildcard + "|" + this.ns).hashCode();
    }
}

