package vcs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteProfileCatalog invokes the vcs.DeleteProfileCatalog API synchronously
func (client *Client) DeleteProfileCatalog(request *DeleteProfileCatalogRequest) (response *DeleteProfileCatalogResponse, err error) {
	response = CreateDeleteProfileCatalogResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteProfileCatalogWithChan invokes the vcs.DeleteProfileCatalog API asynchronously
func (client *Client) DeleteProfileCatalogWithChan(request *DeleteProfileCatalogRequest) (<-chan *DeleteProfileCatalogResponse, <-chan error) {
	responseChan := make(chan *DeleteProfileCatalogResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteProfileCatalog(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteProfileCatalogWithCallback invokes the vcs.DeleteProfileCatalog API asynchronously
func (client *Client) DeleteProfileCatalogWithCallback(request *DeleteProfileCatalogRequest, callback func(response *DeleteProfileCatalogResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteProfileCatalogResponse
		var err error
		defer close(result)
		response, err = client.DeleteProfileCatalog(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteProfileCatalogRequest is the request struct for api DeleteProfileCatalog
type DeleteProfileCatalogRequest struct {
	*requests.RpcRequest
	IsvSubId  string `position:"Body" name:"IsvSubId"`
	CorpId    string `position:"Body" name:"CorpId"`
	CatalogId string `position:"Body" name:"CatalogId"`
}

// DeleteProfileCatalogResponse is the response struct for api DeleteProfileCatalog
type DeleteProfileCatalogResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Data      bool   `json:"Data" xml:"Data"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteProfileCatalogRequest creates a request to invoke DeleteProfileCatalog API
func CreateDeleteProfileCatalogRequest() (request *DeleteProfileCatalogRequest) {
	request = &DeleteProfileCatalogRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vcs", "2020-05-15", "DeleteProfileCatalog", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteProfileCatalogResponse creates a response to parse from DeleteProfileCatalog response
func CreateDeleteProfileCatalogResponse() (response *DeleteProfileCatalogResponse) {
	response = &DeleteProfileCatalogResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
