package idrsservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteUserDepartments invokes the idrsservice.DeleteUserDepartments API synchronously
func (client *Client) DeleteUserDepartments(request *DeleteUserDepartmentsRequest) (response *DeleteUserDepartmentsResponse, err error) {
	response = CreateDeleteUserDepartmentsResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteUserDepartmentsWithChan invokes the idrsservice.DeleteUserDepartments API asynchronously
func (client *Client) DeleteUserDepartmentsWithChan(request *DeleteUserDepartmentsRequest) (<-chan *DeleteUserDepartmentsResponse, <-chan error) {
	responseChan := make(chan *DeleteUserDepartmentsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteUserDepartments(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteUserDepartmentsWithCallback invokes the idrsservice.DeleteUserDepartments API asynchronously
func (client *Client) DeleteUserDepartmentsWithCallback(request *DeleteUserDepartmentsRequest, callback func(response *DeleteUserDepartmentsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteUserDepartmentsResponse
		var err error
		defer close(result)
		response, err = client.DeleteUserDepartments(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteUserDepartmentsRequest is the request struct for api DeleteUserDepartments
type DeleteUserDepartmentsRequest struct {
	*requests.RpcRequest
	DepartmentId *[]string `position:"Query" name:"DepartmentId"  type:"Repeated"`
	UserId       *[]string `position:"Body" name:"UserId"  type:"Repeated"`
}

// DeleteUserDepartmentsResponse is the response struct for api DeleteUserDepartments
type DeleteUserDepartmentsResponse struct {
	*responses.BaseResponse
	Code      string                 `json:"Code" xml:"Code"`
	Data      map[string]interface{} `json:"Data" xml:"Data"`
	Message   string                 `json:"Message" xml:"Message"`
	RequestId string                 `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteUserDepartmentsRequest creates a request to invoke DeleteUserDepartments API
func CreateDeleteUserDepartmentsRequest() (request *DeleteUserDepartmentsRequest) {
	request = &DeleteUserDepartmentsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("idrsservice", "2020-06-30", "DeleteUserDepartments", "idrsservice", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteUserDepartmentsResponse creates a response to parse from DeleteUserDepartments response
func CreateDeleteUserDepartmentsResponse() (response *DeleteUserDepartmentsResponse) {
	response = &DeleteUserDepartmentsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
