package ddosbgp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddIp invokes the ddosbgp.AddIp API synchronously
// api document: https://help.aliyun.com/api/ddosbgp/addip.html
func (client *Client) AddIp(request *AddIpRequest) (response *AddIpResponse, err error) {
	response = CreateAddIpResponse()
	err = client.DoAction(request, response)
	return
}

// AddIpWithChan invokes the ddosbgp.AddIp API asynchronously
// api document: https://help.aliyun.com/api/ddosbgp/addip.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddIpWithChan(request *AddIpRequest) (<-chan *AddIpResponse, <-chan error) {
	responseChan := make(chan *AddIpResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddIp(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddIpWithCallback invokes the ddosbgp.AddIp API asynchronously
// api document: https://help.aliyun.com/api/ddosbgp/addip.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddIpWithCallback(request *AddIpRequest, callback func(response *AddIpResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddIpResponse
		var err error
		defer close(result)
		response, err = client.AddIp(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddIpRequest is the request struct for api AddIp
type AddIpRequest struct {
	*requests.RpcRequest
	IpList           string `position:"Query" name:"IpList"`
	ResourceGroupId  string `position:"Query" name:"ResourceGroupId"`
	InstanceId       string `position:"Query" name:"InstanceId"`
	SourceIp         string `position:"Query" name:"SourceIp"`
	ResourceRegionId string `position:"Query" name:"ResourceRegionId"`
}

// AddIpResponse is the response struct for api AddIp
type AddIpResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAddIpRequest creates a request to invoke AddIp API
func CreateAddIpRequest() (request *AddIpRequest) {
	request = &AddIpRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddosbgp", "2018-07-20", "AddIp", "ddosbgp", "openAPI")
	return
}

// CreateAddIpResponse creates a response to parse from AddIp response
func CreateAddIpResponse() (response *AddIpResponse) {
	response = &AddIpResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
