package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateTransitRouterRouteTable invokes the cbn.UpdateTransitRouterRouteTable API synchronously
func (client *Client) UpdateTransitRouterRouteTable(request *UpdateTransitRouterRouteTableRequest) (response *UpdateTransitRouterRouteTableResponse, err error) {
	response = CreateUpdateTransitRouterRouteTableResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateTransitRouterRouteTableWithChan invokes the cbn.UpdateTransitRouterRouteTable API asynchronously
func (client *Client) UpdateTransitRouterRouteTableWithChan(request *UpdateTransitRouterRouteTableRequest) (<-chan *UpdateTransitRouterRouteTableResponse, <-chan error) {
	responseChan := make(chan *UpdateTransitRouterRouteTableResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateTransitRouterRouteTable(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateTransitRouterRouteTableWithCallback invokes the cbn.UpdateTransitRouterRouteTable API asynchronously
func (client *Client) UpdateTransitRouterRouteTableWithCallback(request *UpdateTransitRouterRouteTableRequest, callback func(response *UpdateTransitRouterRouteTableResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateTransitRouterRouteTableResponse
		var err error
		defer close(result)
		response, err = client.UpdateTransitRouterRouteTable(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateTransitRouterRouteTableRequest is the request struct for api UpdateTransitRouterRouteTable
type UpdateTransitRouterRouteTableRequest struct {
	*requests.RpcRequest
	ResourceOwnerId                    requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken                        string           `position:"Query" name:"ClientToken"`
	TransitRouterRouteTableId          string           `position:"Query" name:"TransitRouterRouteTableId"`
	TransitRouterRouteTableDescription string           `position:"Query" name:"TransitRouterRouteTableDescription"`
	DryRun                             requests.Boolean `position:"Query" name:"DryRun"`
	TransitRouterRouteTableName        string           `position:"Query" name:"TransitRouterRouteTableName"`
	ResourceOwnerAccount               string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount                       string           `position:"Query" name:"OwnerAccount"`
	OwnerId                            requests.Integer `position:"Query" name:"OwnerId"`
}

// UpdateTransitRouterRouteTableResponse is the response struct for api UpdateTransitRouterRouteTable
type UpdateTransitRouterRouteTableResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateTransitRouterRouteTableRequest creates a request to invoke UpdateTransitRouterRouteTable API
func CreateUpdateTransitRouterRouteTableRequest() (request *UpdateTransitRouterRouteTableRequest) {
	request = &UpdateTransitRouterRouteTableRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "UpdateTransitRouterRouteTable", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateTransitRouterRouteTableResponse creates a response to parse from UpdateTransitRouterRouteTable response
func CreateUpdateTransitRouterRouteTableResponse() (response *UpdateTransitRouterRouteTableResponse) {
	response = &UpdateTransitRouterRouteTableResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
