package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetExploreUrl invokes the arms.GetExploreUrl API synchronously
func (client *Client) GetExploreUrl(request *GetExploreUrlRequest) (response *GetExploreUrlResponse, err error) {
	response = CreateGetExploreUrlResponse()
	err = client.DoAction(request, response)
	return
}

// GetExploreUrlWithChan invokes the arms.GetExploreUrl API asynchronously
func (client *Client) GetExploreUrlWithChan(request *GetExploreUrlRequest) (<-chan *GetExploreUrlResponse, <-chan error) {
	responseChan := make(chan *GetExploreUrlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetExploreUrl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetExploreUrlWithCallback invokes the arms.GetExploreUrl API asynchronously
func (client *Client) GetExploreUrlWithCallback(request *GetExploreUrlRequest, callback func(response *GetExploreUrlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetExploreUrlResponse
		var err error
		defer close(result)
		response, err = client.GetExploreUrl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetExploreUrlRequest is the request struct for api GetExploreUrl
type GetExploreUrlRequest struct {
	*requests.RpcRequest
	Expression string `position:"Query" name:"Expression"`
	ClusterId  string `position:"Query" name:"ClusterId"`
	Type       string `position:"Query" name:"Type"`
}

// GetExploreUrlResponse is the response struct for api GetExploreUrl
type GetExploreUrlResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateGetExploreUrlRequest creates a request to invoke GetExploreUrl API
func CreateGetExploreUrlRequest() (request *GetExploreUrlRequest) {
	request = &GetExploreUrlRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "GetExploreUrl", "", "")
	request.Method = requests.POST
	return
}

// CreateGetExploreUrlResponse creates a response to parse from GetExploreUrl response
func CreateGetExploreUrlResponse() (response *GetExploreUrlResponse) {
	response = &GetExploreUrlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
