Here are all of x11vnc command line options:

```
% x11vnc -opts      (see below for -help long descriptions)

x11vnc: allow VNC connections to real X11 displays. 0.9.13 lastmod: 2010-12-27

x11vnc options:
  -display disp            -auth file               -N
  -autoport n              -rfbport str             -6
  -no6                     -noipv6                  -noipv4
  -reopen                  -reflect host:N          -id windowid
  -sid windowid            -appshare                -clip WxH+X+Y
  -flashcmap               -shiftcmap n             -notruecolor
  -advertise_truecolor     -visual n                -overlay
  -overlay_nocursor        -8to24 [opts]            -24to32
  -scale fraction          -geometry WxH            -scale_cursor frac
  -viewonly                -shared                  -once
  -forever                 -loop                    -timeout n
  -sleepin n               -inetd                   -tightfilexfer
  -ultrafilexfer           -http                    -http_ssl
  -avahi                   -mdns                    -zeroconf
  -connect string          -connect_or_exit str     -proxy string
  -vncconnect              -novncconnect            -allow host1[,host2..]
  -localhost               -unixsock str            -listen6 str
  -nolookup                -input string            -grabkbd
  -grabptr                 -ungrabboth              -grabalways
  -viewpasswd string       -passwdfile filename     -showrfbauth filename
  -unixpw [list]           -unixpw_nis [list]       -unixpw_cmd cmd
  -find                    -finddpy                 -listdpy
  -findauth [disp]         -create                  -xdummy
  -xvnc                    -xvnc_redirect           -xdummy_xvfb
  -create_xsrv str         -svc                     -svc_xdummy
  -svc_xvnc                -svc_xdummy_xvfb         -xdmsvc
  -sshxdmsvc               -unixpw_system_greeter   -redirect port
  -display WAIT:...        -vencrypt mode           -anontls mode
  -sslonly                 -dhparams file           -nossl
  -ssl [pem]               -ssltimeout n            -sslnofail
  -ssldir dir              -sslverify path          -sslCRL path
  -sslGenCA [dir]          -sslGenCert type name    -sslEncKey pem
  -sslCertInfo pem         -sslDelCert pem          -sslScripts
  -stunnel [pem]           -stunnel3  [pem]         -enc cipher:keyfile
  -https [port]            -httpsredir [port]       -http_oneport
  -ssh user@host:disp      -usepw                   -storepasswd pass file
  -nopw                    -accept string           -afteraccept string
  -gone string             -users list              -noshm
  -flipbyteorder           -onetile                 -solid [color]
  -blackout string         -xinerama                -noxinerama
  -xtrap                   -xrandr [mode]           -rotate string
  -padgeom WxH             -o logfile               -flag file
  -rmflag file             -rc filename             -norc
  -env VAR=VALUE           -prog /path/to/x11vnc    -h, -help
  -?, -opts                -V, -version             -license
  -dbg                     -q, -quiet               -v, -verbose
  -bg                      -modtweak                -nomodtweak
  -xkb                     -noxkb                   -capslock
  -skip_lockkeys           -noskip_lockkeys         -skip_keycodes string
  -sloppy_keys             -skip_dups               -noskip_dups
  -add_keysyms             -noadd_keysyms           -clear_mods
  -clear_keys              -clear_all               -remap string
  -norepeat                -repeat                  -nofb
  -nobell                  -nosel                   -noprimary
  -nosetprimary            -noclipboard             -nosetclipboard
  -seldir string           -cursor [mode]           -nocursor
  -cursor_drag             -arrow n                 -noxfixes
  -alphacut n              -alphafrac fraction      -alpharemove
  -noalphablend            -nocursorshape           -cursorpos
  -nocursorpos             -xwarppointer            -noxwarppointer
  -always_inject           -buttonmap string        -nodragging
  -ncache n                -ncache_cr               -ncache_no_moveraise
  -ncache_no_dtchange      -ncache_no_rootpixmap    -ncache_keep_anims
  -ncache_old_wm           -ncache_pad n            -debug_ncache
  -wireframe [str]         -nowireframe             -nowireframelocal
  -wirecopyrect mode       -nowirecopyrect          -debug_wireframe
  -scrollcopyrect mode     -noscrollcopyrect        -scr_area n
  -scr_skip list           -scr_inc list            -scr_keys list
  -scr_term list           -scr_keyrepeat lo-hi     -scr_parms string
  -fixscreen string        -debug_scroll            -noxrecord
  -grab_buster             -nograb_buster           -debug_grabs
  -debug_sel               -pointer_mode n          -input_skip n
  -allinput                -input_eagerly           -speeds rd,bw,lat
  -wmdt string             -debug_pointer           -debug_keyboard
  -defer time              -wait time               -extra_fbur n
  -wait_ui factor          -setdefer n              -nowait_bog
  -slow_fb time            -xrefresh time           -nap
  -nonap                   -sb time                 -readtimeout n
  -ping n                  -nofbpm                  -fbpm
  -nodpms                  -dpms                    -forcedpms
  -clientdpms              -noserverdpms            -noultraext
  -chatwindow              -noxdamage               -xd_area A
  -xd_mem f                -sigpipe string          -threads
  -nothreads               -fs f                    -gaps n
  -grow n                  -fuzz n                  -debug_tiles
  -snapfb                  -rawfb string            -freqtab file
  -pipeinput cmd           -macnodim                -macnosleep
  -macnosaver              -macnowait               -macwheel n
  -macnoswap               -macnoresize             -maciconanim n
  -macmenu                 -macuskbd                -macnoopengl
  -macnorawfb              -gui [gui-opts]          -remote command
  -query variable          -QD variable             -sync
  -query_retries str       -remote_prefix str       -noremote
  -yesremote               -unsafe                  -safer
  -privremote              -nocmds                  -allowedcmds list
  -deny_all
```

LibVNCServer options:

```
-rfbport port          TCP port for RFB protocol
-rfbwait time          max time in ms to wait for RFB client
-rfbauth passwd-file   use authentication on RFB protocol
                       (use 'storepasswd' to create a password file)
-rfbversion 3.x        Set the version of the RFB we choose to advertise
-permitfiletransfer    permit file transfer support
-passwd plain-password use authentication
                       (use plain-password as password, USE AT YOUR RISK)
-deferupdate time      time in ms to defer updates (default 40)
-deferptrupdate time   time in ms to defer pointer updates (default none)
-desktop name          VNC desktop name (default "LibVNCServer")
-alwaysshared          always treat new clients as shared
-nevershared           never treat new clients as shared
-dontdisconnect        don't disconnect existing clients when a new non-shared
                       connection comes in (refuse new connection instead)
-httpdir dir-path      enable http server using dir-path home
-httpport portnum      use portnum for http connection
-enablehttpproxy       enable http proxy support
-progressive height    enable progressive updating for slow links
-listen ipaddr         listen for connections only on network interface with
                       addr ipaddr. '-listen localhost' and hostname work too.

libvncserver-tight-extension options:
-disablefiletransfer   disable file transfer
-ftproot string        set ftp root
```

Full x11vnc options:

```
% x11vnc -help

x11vnc: allow VNC connections to real X11 displays. 0.9.13 lastmod: 2010-12-27

(type "x11vnc -opts" to just list the options.)

Typical usage is:

   Run this command in a shell on the remote machine "far-host"
   with X session you wish to view:

       x11vnc -display :0

   Then run this in another window on the machine you are sitting at:

       vncviewer far-host:0

Once x11vnc establishes connections with the X11 server and starts listening
as a VNC server it will print out a string: PORT=XXXX where XXXX is typically
5900 (the default VNC server port).  One would next run something like
this on the local machine: "vncviewer hostname:N" where "hostname" is
the name of the machine running x11vnc and N is XXXX - 5900, i.e. usually
"vncviewer hostname:0".

By default x11vnc will not allow the screen to be shared and it will exit
as soon as the client disconnects.  See -shared and -forever below to override
these protections.  See the FAQ for details how to tunnel the VNC connection
through an encrypted channel such as ssh(1).  In brief:

       ssh -t -L 5900:localhost:5900 far-host 'x11vnc -localhost -display :0'

       vncviewer -encodings 'copyrect tight zrle hextile' localhost:0

Also, use of a VNC password (-rfbauth or -passwdfile) is strongly recommended.

For additional info see: http://www.karlrunge.com/x11vnc/
                    and  http://www.karlrunge.com/x11vnc/faq.html


Config file support: if the file $HOME/.x11vncrc exists then each line in
it is treated as a single command line option.  Disable with -norc.  For
each option name, the leading character "-" is not required.  E.g. a line
that is either "forever" or "-forever" may be used and are equivalent.
Likewise "wait 100" or "-wait 100" are acceptable and equivalent lines.
The "#" character comments out to the end of the line in the usual way
(backslash it for a literal).  Leading and trailing whitespace is trimmed off.
Lines may be continued with a "\" as the last character of a line (it
becomes a space character).

Options:

-display disp          X11 server display to connect to, usually :0.  The X
                       server process must be running on same machine and
                       support MIT-SHM.  Equivalent to setting the DISPLAY
                       environment variable to "disp".

                       See the description below of the "-display WAIT:..."
                       extensions, where alias "-find" will find the user's
                       display automatically, and "-create" will create a
                       Xvfb session if no session is found.

-auth file             Set the X authority file to be "file", equivalent to
                       setting the XAUTHORITY environment variable to "file"
                       before startup.  Same as -xauth file.  See Xsecurity(7),
                       xauth(1) man pages for more info.

                       Use '-auth guess' to have x11vnc use its -findauth
                       mechanism (described below) to try to guess the
                       XAUTHORITY filename and use it.

                       XDM/GDM/KDM: if you are running x11vnc as root and want
                       to find the XAUTHORITY before anyone has logged into an
                       X session yet, use: x11vnc -env FD_XDM=1 -auth guess ...
                       (This will also find the XAUTHORITY if a user is already
                       logged into the X session.)  When running as root,
                       FD_XDM=1 will be tried if the initial -auth guess fails.

-N                     If the X display is :N, try to set the VNC display to
                       also be :N This just sets the -rfbport option to 5900+N
                       The program will exit immediately if that port is not
                       available. The -N option only works with normal -display
                       usage, e.g. :0 or :8, -N is ignored in the -display
                       WAIT:..., -create, -find, -svc, -redirect, etc modes.

-autoport n            Automatically probe for a free VNC port starting at n.
                       The default is to start probing at 5900.  Use this to
                       stay away from other VNC servers near 5900.

-rfbport str           The VNC port to listen on (a LibVNCServer option), e.g.
                       5900, 5901, etc.  If specified as "-rfbport PROMPT"
                       then the x11vnc -gui is used to prompt the user to
                       enter the port number.

-6                     IPv6 listening support.  In addition to IPv4, the
                       IPv6 address is listened on for incoming connections.
                       The same port number as IPv4 is used.

                       NOTE:  This x11vnc binary was compiled to have the
                       "-6" IPv6 listening mode ENABLED by default (CPPFLAGS
                       -DX11VNC_LISTEN6=1).  So to disable IPv6 listening mode
                       you MUST supply the "-no6" option (see below.)

                       The "-6" mode works for both normal connections and
                       -ssl encrypted ones.  Nearly everything is supported
                       for the IPv6 case, but there are a few exceptions.
                       See -stunnel for its IPv6 support.

                       Currently, for absolutely everything to work correctly
                       the machine may need to have some IPv4 support, at the
                       least for the loopback interface.  However, for nearly
                       all usage modes no IPv4 support is required. See -noipv4
.

                       If you have trouble compiling or running in IPv6 mode,
                       set -DX11VNC_IPV6=0 in CPPFLAGS when configuring to
                       disable IPv6 support.

-no6                   Disable IPv6 listening support (only useful if the
                       "-6" mode is compiled in to be the default; see the
                       X11VNC_LISTEN6 description above under "-6".)

-noipv6                Do not try to use IPv6 for any listening or connecting
                       sockets.  This includes both the listening service
                       port(s) and outgoing connections from -connect,
                       -connect_or_exit, or -proxy.  Use this if you are having
                       problems due to IPv6.

-noipv4                Do not try to use IPv4 for any listening or connecting
                       sockets.  This is mainly for exploring the behavior of
                       x11vnc on an IPv6-only system, but may have other uses.

-reopen                If the X server connection is disconnected, try to
                       reopen the X display (up to one time.)  This is of use
                       for display managers like GDM (KillInitClients option)
                       that kill x11vnc just after the user logs into the
                       X session.  Note: the reopened state may be unstable.
                       Set X11VNC_REOPEN_DISPLAY=n to reopen n times and
                       set X11VNC_REOPEN_SLEEP_MAX to the number of seconds,
                       default 10, to keep trying to reopen the display (once
                       per second.)

                       Update: as of 0.9.9, x11vnc tries to automatically avoid
                       being killed by the display manager by delaying creating
                       windows or using XFIXES.  So you shouldn't need to use
                       KillInitClients=false as long as you log in quickly
                       enough (within 45 seconds of connecting.)  You can
                       disable this by setting X11VNC_AVOID_WINDOWS=never.
                       You can also set it to the number of seconds to delay.

-reflect host:N        Instead of connecting to and polling an X display,
                       connect to the remote VNC server host:N and be a
                       reflector/repeater for it.  This is useful for trying
                       to manage the case of many simultaneous VNC viewers
                       (e.g. classroom broadcasting) where, e.g. you put
                       a repeater on each network switch, etc, to improve
                       performance by distributing the load and network
                       traffic.  Implies -shared (use -noshared as a later
                       option to disable). See the discussion below under
                       -rawfb vnc:host:N for more details.

-id windowid           Show the X window corresponding to "windowid" not
                       the entire display.  New windows like popup menus,
                       transient toplevels, etc, may not be seen or may be
                       clipped.  Disabling SaveUnders or BackingStore in the
                       X server may help show them.  x11vnc may crash if the
                       window is initially partially obscured, changes size,
                       is iconified, etc.  Some steps are taken to avoid this
                       and the -xrandr mechanism is used to track resizes.  Use
                       xwininfo(1) to get the window id, or use "-id pick"
                       to have x11vnc run xwininfo(1) for you and extract
                       the id.  The -id option is useful for exporting very
                       simple applications (e.g. the current view on a webcam).
-sid windowid          As -id, but instead of using the window directly it
                       shifts a root view to it: this shows SaveUnders menus,
                       etc, although they will be clipped if they extend beyond
                       the window.

-appshare              Simple application sharing based on the -id/-sid
                       mechanism.  Every new toplevel window that the
                       application creates induces a new viewer window via
                       a reverse connection.  The -id/-sid and -connect
                       options are required.  Run 'x11vnc -appshare -help'
                       for more info.

-clip WxH+X+Y          Only show the sub-region of the full display that
                       corresponds to the rectangle geometry with size WxH and
                       offset +X+Y.  The VNC display has size WxH (i.e. smaller
                       than the full display).  This also works for -id/-sid
                       mode where the offset is relative to the upper left
                       corner of the selected window.  An example use of this
                       option would be to split a large (e.g. Xinerama) display
                       into two parts to be accessed via separate viewers by
                       running a separate x11vnc on each part.

                       Use '-clip xinerama0' to clip to the first xinerama
                       sub-screen (if xinerama is active).  xinerama1 for the
                       2nd sub-screen, etc.  This way you don't need to figure
                       out the WxH+X+Y of the desired xinerama sub-screen.
                       screens are sorted in increasing distance from the
                       (0,0) origin (I.e. not the Xserver's order).

-flashcmap             In 8bpp indexed color, let the installed colormap flash
                       as the pointer moves from window to window (slow).
                       Also try the -8to24 option to avoid flash altogether.
-shiftcmap n           Rare problem, but some 8bpp displays use less than 256
                       colorcells (e.g. 16-color grayscale, perhaps the other
                       bits are used for double buffering) *and* also need to
                       shift the pixels values away from 0, .., ncells.  "n"
                       indicates the shift to be applied to the pixel values.
                       To see the pixel values set DEBUG_CMAP=1 to print out
                       a colormap histogram.  Example: -shiftcmap 240
-notruecolor           For 8bpp displays, force indexed color (i.e. a colormap)
                       even if it looks like 8bpp TrueColor (rare problem).
-advertise_truecolor   If the X11 display is indexed color, lie to clients
                       when they first connect by telling them it is truecolor.
                       To workaround RealVNC: inPF has colourMap but not 8bpp
                       Use '-advertise_truecolor reset' to reset client fb too.

-visual n              This option probably does not do what you think.
                       It simply *forces* the visual used for the framebuffer;
                       this may be a bad thing... (e.g. messes up colors or
                       cause a crash). It is useful for testing and for some
                       workarounds.  n may be a decimal number, or 0x hex.
                       Run xdpyinfo(1) for the values.  One may also use
                       "TrueColor", etc. see <X11/X.h> for a list.  If the
                       string ends in ":m" then for better or for worse
                       the visual depth is forced to be m.  You may want to
                       use -noshm when using this option (so XGetImage may
                       automatically translate the pixel data).

-overlay               Handle multiple depth visuals on one screen, e.g. 8+24
                       and 24+8 overlay visuals (the 32 bits per pixel are
                       packed with 8 for PseudoColor and 24 for TrueColor).

                       Currently -overlay only works on Solaris via
                       XReadScreen(3X11) and IRIX using XReadDisplay(3).
                       On Solaris there is a problem with image "bleeding"
                       around transient popup menus (but not for the menu
                       itself): a workaround is to disable SaveUnders
                       by passing the "-su" argument to Xsun (in
                       /etc/dt/config/Xservers).

                       Use -overlay as a workaround for situations like these:
                       Some legacy applications require the default visual to
                       be 8bpp (8+24), or they will use 8bpp PseudoColor even
                       when the default visual is depth 24 TrueColor (24+8).
                       In these cases colors in some windows will be incorrect
                       in x11vnc unless -overlay is used.  Another use of
                       -overlay is to enable showing the exact mouse cursor
                       shape (details below).

                       Under -overlay, performance will be somewhat slower
                       due to the extra image transformations required.
                       For optimal performance do not use -overlay, but rather
                       configure the X server so that the default visual is
                       depth 24 TrueColor and try to have all apps use that
                       visual (e.g. some apps have -use24 or -visual options).
-overlay_nocursor      Sets -overlay, but does not try to draw the exact mouse
                       cursor shape using the overlay mechanism.

-8to24 [opts]          Try this option if -overlay is not supported on your
                       OS, and you have a legacy 8bpp app that you want to
                       view on a multi-depth display with default depth 24
                       (and is 32 bpp) OR have a default depth 8 display with
                       depth 24 overlay windows for some apps.  This option
                       may not work on all X servers and hardware (tested
                       on XFree86/Xorg mga driver and Xsun).  The "opts"
                       string is not required and is described below.

                       This mode enables a hack where x11vnc monitors windows
                       within 3 levels from the root window.  If it finds
                       any that are 8bpp it extracts the indexed color
                       pixel values using XGetImage() and then applies a
                       transformation using the colormap(s) to create TrueColor
                       RGB values that it in turn inserts into bits 1-24 of
                       the framebuffer.  This creates a depth 24 "view"
                       of the display that is then exported via VNC.

                       Conversely, for default depth 8 displays, the depth
                       24 regions are read by XGetImage() and everything is
                       transformed and inserted into a depth 24 TrueColor
                       framebuffer.

                       Note that even if there are *no* depth 24 visuals or
                       windows (i.e. pure 8bpp), this mode is potentially
                       an improvement over -flashcmap because it avoids the
                       flashing and shows each window in the correct color.

                       This method works OK, but may still have bugs and it
                       does hog resources.  If there are multiple 8bpp windows
                       using different colormaps, one may have to iconify all
                       but one for the colors to be correct.

                       There may be painting errors for clipping and switching
                       between windows of depths 8 and 24.  Heuristics are
                       applied to try to minimize the painting errors.  One can
                       also press 3 Alt_L's in a row to refresh the screen
                       if the error does not repair itself.  Also the option
                       -fixscreen 8=3.0 or -fixscreen V=3.0 may be used to
                       periodically refresh the screen at the cost of bandwidth
                       (every 3 sec for this example).

                       The [opts] string can contain the following settings.
                       Multiple settings are separated by commas.

                       For for some X servers with default depth 24 a
                       speedup may be achieved via the option "nogetimage".
                       This enables a scheme were XGetImage() is not used
                       to retrieve the 8bpp data.  Instead, it assumes that
                       the 8bpp data is in bits 25-32 of the 32bit X pixels.
                       There is no requirement that the X server should put
                       the data there for our poll requests, but some do and
                       so the extra steps to retrieve it can be skipped.
                       Tested with mga driver with XFree86/Xorg.  For the
                       default depth 8 case this option is ignored.

                       To adjust how often XGetImage() is used to poll the
                       non-default visual regions for changes, use the option
                       "poll=t" where "t" is a floating point time.
                       (default: 0.05)

                       Setting the option "level2" will limit the search
                       for non-default visual windows to two levels from the
                       root window.  Do this on slow machines where you know
                       the window manager only imposes one extra window between
                       the app window and the root window.

                       Also for very slow machines use "cachewin=t"
                       where t is a floating point amount of time to cache
                       XGetWindowAttributes results.  E.g. cachewin=5.0.
                       This may lead to the windows being unnoticed for this
                       amount of time when deiconifying, painting errors, etc.

                       While testing on a very old SS20 these options gave
                       tolerable response: -8to24 poll=0.2,cachewin=5.0. For
                       this machine -overlay is supported and gives better
                       response.

                       Debugging for this mode can be enabled by setting
                       "dbg=1", "dbg=2", or "dbg=3".

-24to32                Very rare problem: if the framebuffer (X display
                       or -rawfb) is 24bpp instead of the usual 32bpp, then
                       dynamically transform the pixels to 32bpp.  This will be
                       slower, but can be used to work around problems where
                       VNC viewers cannot handle 24bpp (e.g. "main: setPF:
                       not 8, 16 or 32 bpp?").  See the FAQ for more info.

                       In the case of -rawfb mode, the pixels are directly
                       modified by inserting a 0 byte to pad them out to 32bpp.
                       For X displays, a kludge is done that is equivalent to
                       "-noshm -visual TrueColor:32".  (If better performance
                       is needed for the latter, feel free to ask).

-scale fraction        Scale the framebuffer by factor "fraction".  Values
                       less than 1 shrink the fb, larger ones expand it. Note:
                       the image may not be sharp and response may be slower.
                       If "fraction" contains a decimal point "." it
                       is taken as a floating point number, alternatively
                       the notation "m/n" may be used to denote fractions
                       exactly, e.g. -scale 2/3

                       To scale asymmetrically in the horizontal and vertical
                       directions, specify a WxH geometry to stretch to:
                       e.g. '-scale 1024x768', or also '-scale 0.9x0.75'

                       Scaling Options: can be added after "fraction" via
                       ":", to supply multiple ":" options use commas.
                       If you just want a quick, rough scaling without
                       blending, append ":nb" to "fraction" (e.g. -scale
                       1/3:nb).  No blending is the default for 8bpp indexed
                       color, to force blending for this case use ":fb".

                       To disable -scrollcopyrect and -wirecopyrect under
                       -scale use ":nocr".  If you need to to enable them use
                       ":cr" or specify them explicitly on the command line.
                       If a slow link is detected, ":nocr" may be applied
                       automatically.  Default: :cr

                       More esoteric options: for compatibility with vncviewers
                       the scaled width is adjusted to be a multiple of 4:
                       to disable this use ":n4".  ":in" use interpolation
                       scheme even when shrinking, ":pad" pad scaled width
                       and height to be multiples of scaling denominator
                       (e.g. 3 for 2/3).

-geometry WxH          Same as -scale WxH

-scale_cursor frac     By default if -scale is supplied the cursor shape is
                       scaled by the same factor.  Depending on your usage,
                       you may want to scale the cursor independently of the
                       screen or not at all.  If you specify -scale_cursor
                       the cursor will be scaled by that factor.  When using
                       -scale mode to keep the cursor at its "natural" size
                       use "-scale_cursor 1".  Most of the ":" scaling
                       options apply here as well.

-viewonly              All VNC clients can only watch (default off).
-shared                VNC display is shared, i.e. more than one viewer can
                       connect at the same time (default off).
-once                  Exit after the first successfully connected viewer
                       disconnects, opposite of -forever. This is the Default.
-forever               Keep listening for more connections rather than exiting
                       as soon as the first client(s) disconnect. Same as -many

                       To get the standard non-shared VNC behavior where when
                       a new VNC client connects the existing VNC client is
                       dropped use:  -nevershared -forever   This method can
                       also be used to guard against hung TCP connections that
                       do not go away.

-loop                  Create an outer loop restarting the x11vnc process
                       whenever it terminates.  -bg and -inetd are ignored
                       in this mode (however see -loopbg below).

                       Useful for continuing even if the X server terminates
                       and restarts (at that moment the process will need
                       permission to reconnect to the new X server of course).

                       Use, e.g., -loop100 to sleep 100 millisecs between
                       restarts, etc.  Default is 2000ms (i.e. 2 secs) Use,
                       e.g. -loop300,5 to sleep 300 ms and only loop 5 times.

                       If -loopbg (plus any numbers) is specified instead,
                       the "-bg" option is implied and the mode approximates
                       inetd(8) usage to some degree.  In this case when
                       it goes into the background any listening sockets
                       (i.e. ports 5900, 5800) are closed, so the next one
                       in the loop can use them.  This mode will only be of
                       use if a VNC client (the only client for that process)
                       is already connected before the process goes into the
                       background, for example, usage of -display WAIT:..,
                       -svc, and -connect can make use of this "poor man's"
                       inetd mode.  The default wait time is 500ms in this
                       mode.  This usage could use useful:  -svc -bg -loopbg

-timeout n             Exit unless a client connects within the first n seconds
                       after startup.

                       If there have been no connection attempts after n
                       seconds x11vnc exits immediately.  If a client is
                       trying to connect but has not progressed to the normal
                       operating state, x11vnc gives it a few more seconds
                       to finish and exits if it does not make it to the
                       normal state.

                       For reverse connections via -connect or -connect_or_exit
                       a timeout of n seconds will be set for all reverse
                       connects.  If the connect timeout alarm goes off,
                       x11vnc will exit immediately.

-sleepin n             At startup sleep n seconds before proceeding (e.g. to
                       allow redirs and listening clients to start up)

                       If a range is given: '-sleepin min-max', a random value
                       between min and max is slept. E.g. '-sleepin 0-20' and
                       '-sleepin 10-30'.  Floats are allowed too.

-inetd                 Launched by inetd(8): stdio instead of listening socket.
                       Note: if you are not redirecting stderr to a log file
                       (via shell 2> or -o option) you MUST also specify the -q
                       option, otherwise the stderr goes to the viewer which
                       will cause it to abort.  Specifying both -inetd and -q
                       and no -o will automatically close the stderr.

-tightfilexfer         Enable the TightVNC file transfer extension. Note that
                       that when the -viewonly option is supplied all file
                       transfers are disabled.  Also clients that log in
                       viewonly cannot transfer files.  However, if the remote
                       control mechanism is used to change the global or
                       per-client viewonly state the filetransfer permissions
                       will NOT change.

                       IMPORTANT: please understand if -tightfilexfer is
                       specified and you run x11vnc as root for, say, inetd
                       or display manager (gdm, kdm, ...) access and you do
                       not have it switch users via the -users option, then
                       VNC Viewers that connect are able to do filetransfer
                       reads and writes as *root*.

                       Also, tightfilexfer is disabled in -unixpw mode.

-ultrafilexfer         Note: to enable UltraVNC filetransfer and to get it to
                       work you probably need to supply these LibVNCServer
                       options: "-rfbversion 3.6 -permitfiletransfer"
                       "-ultrafilexfer" is an alias for this combination.

                       IMPORTANT: please understand if -ultrafilexfer is
                       specified and you run x11vnc as root for, say, inetd
                       or display manager (gdm, kdm, ...) access and you do
                       not have it switch users via the -users option, then
                       VNC Viewers that connect are able to do filetransfer
                       reads and writes as *root*.

                       Note that sadly you cannot do both -tightfilexfer and
                       -ultrafilexfer at the same time because the latter
                       requires setting the version to 3.6 and tightvnc will
                       not do filetransfer when it sees that version number.

-http                  Instead of using -httpdir (see below) to specify
                       where the Java vncviewer applet is, have x11vnc try
                       to *guess* where the directory is by looking relative
                       to the program location and in standard locations
                       (/usr/local/share/x11vnc/classes, etc).  Under -ssl or
                       -stunnel the ssl classes subdirectory is sought.
-http_ssl              As -http, but force lookup for ssl classes subdir.

                       Note that for HTTPS, single-port Java applet delivery
                       you can set X11VNC_HTTPS_DOWNLOAD_WAIT_TIME to the
                       max number of seconds to wait for the applet download
                       to finish.  The default is 15.

-avahi                 Use the Avahi/mDNS ZeroConf protocol to advertise
                       this VNC server to the local network. (Related terms:
                       Rendezvous, Bonjour).  Depending on your setup, you
                       may need to start avahi-daemon and open udp port 5353
                       in your firewall.

                       You can set X11VNC_AVAHI_NAME, X11VNC_AVAHI_HOST,
                       and/or X11VNC_AVAHI_PORT environment variables
                       to override the default values.  For example:
                       -env X11VNC_AVAHI_NAME=wally

                       If the avahi API cannot be found at build time, a helper
                       program like avahi-publish(1) or dns-sd(1) will be tried

-mdns                  Same as -avahi.
-zeroconf              Same as -avahi.

-connect string        For use with "vncviewer -listen" reverse connections.
                       If "string" has the form "host" or "host:port"
                       the connection is made once at startup.

                       Use commas for a list of host's and host:port's.
                       E.g. -connect host1,host2 or host1:0,host2:5678.
                       Note that to reverse connect to multiple hosts at the
                       same time you will likely need to also supply: -shared

                       Note that unlike most vnc servers, x11vnc will require a
                       password for reverse as well as for forward connections.
                       (provided password auth has been enabled, -rfbauth, etc)
                       If you do not want to require a password for reverse
                       connections set X11VNC_REVERSE_CONNECTION_NO_AUTH=1 in
                       your environment before starting x11vnc.

                       If "string" contains "/" it is instead interpreted
                       as a file to periodically check for new hosts.
                       The first line is read and then the file is truncated.
                       Be careful about the location of this file if x11vnc
                       is running as root (e.g. via gdm(1), etc).


                       Repeater mode: Some services provide an intermediate
                       "vnc repeater": http://www.uvnc.com/addons/repeater.html
                       (and also http://koti.mbnet.fi/jtko/ for linux port)
                       that acts as a proxy/gateway.  Modes like these require
                       an initial string to be sent for the reverse connection
                       before the VNC protocol is started.  Here are the ways
                       to do this:

                         -connect pre=some_string+host:port
                         -connect pre128=some_string+host:port
                         -connect repeater=ID:1234+host:port
                         -connect repeater=23.45.67.89::5501+host:port

                       SSVNC notation is also supported:

                         -connect repeater://host:port+ID:1234

                       As with normal -connect usage, if the repeater port is
                       not supplied 5500 is assumed.

                       The basic idea is between the special tag, e.g. "pre="
                       and "+" is the pre-string to be sent.  Note that in
                       this case host:port is the repeater server, NOT the
                       vnc viewer.  Somehow the pre-string tells the repeater
                       server how to find the vnc viewer and connect you to it.

                       In the case pre=some_string+host:port, "some_string"
                       is simply sent. In the case preNNN=some_string+host:port
                       "some_string" is sent in a null padded buffer of
                       length NNN.  repeater= is the same as pre250=, this is
                       the ultravnc repeater buffer size.

                       Strings like "\n" and "\r", etc. are expanded to
                       newline and carriage return.  "\c" is expanded to
                       "," since the connect string is comma separated.

                       See also the -proxy option below for additional ways
                       to plumb reverse connections.

                       Reverse SSL: using -connect in -ssl mode makes x11vnc
                       act as an SSL client (initiates SSL connection) rather
                       than an SSL server.  The idea is x11vnc might be
                       connecting to stunnel on the viewer side with the
                       viewer in listening mode.  If you do not want this
                       behavior, use -env X11VNC_DISABLE_SSL_CLIENT_MODE=1.
                       With this the viewer side can act as the SSL client
                       as it normally does for forward connections.

                       Reverse SSL Repeater mode:  This will work, but note
                       that if the VNC Client does any sort of a 'Fetch Cert'
                       action before connecting, then the Repeater will
                       likely drop the connection and both sides will need
                       to restart.  Consider the use of -connect_or_exit
                       and -loop300,2 to have x11vnc reconnect once to the
                       repeater after the fetch.  You will probably also want
                       to supply -sslonly to avoid x11vnc thinking the delay
                       in response means the connection is VeNCrypt.  The env
                       var X11VNC_DISABLE_SSL_CLIENT_MODE=1 discussed above
                       may also be useful (i.e. the viewer can do a forward
                       connection as it normally does.)

                       IPv6: as of x11vnc 0.9.10 the -connect option should
                       connect to IPv6 hosts properly.  If there are problems
                       you can disable IPv6 by setting -DX11VNC_IPV6=0
                       in CPPFLAGS when configuring.  If there problems
                       connecting to IPv6 hosts consider a relay like the
                       included inet6to4 script or the -proxy option.

-connect_or_exit str   As with -connect, except if none of the reverse
                       connections succeed, then x11vnc shuts down immediately

                       An easier to type alias for this option is '-coe'

                       By the way, if you do not want x11vnc to listen on
                       ANY interface use -rfbport 0  which is handy for the
                       -connect_or_exit mode.

-proxy string          Use proxy in string (e.g. host:port) as a proxy for
                       making reverse connections (-connect or -connect_or_exit
                       options).

                       Web proxies are supported, but note by default most of
                       them only support destination connections to ports 443
                       or 563, so this might not be very useful (the viewer
                       would need to listen on that port or the router would
                       have to do a port redirection).

                       A web proxy may be specified by either "host:port"
                       or "http://host:port" (the port is required even if
                       it is the common choices 80 or 8080)

                       SOCKS4, SOCKS4a, and SOCKS5 are also supported.
                       SOCKS proxies normally do not have restrictions on the
                       destination port number.

                       Use a format like this: socks://host:port or
                       socks5://host:port.  Note that ssh -D does not support
                       SOCKS4a, so use socks5://.  For socks:// SOCKS4 is used
                       on a numerical IP and "localhost", otherwise SOCKS4a
                       is used (and so the proxy tries to do the DNS lookup).

                       An experimental mode is "-proxy http://host:port/..."
                       Note the "/" after the port that distinguishes it from
                       a normal web proxy.  The port must be supplied even if
                       it is the default 80.  For this mode a GET is done to
                       the supplied URL with the string host=H&port=P appended.
                       H and P will be the -connect reverse connect host
                       and port.  Use the string "__END__" to disable the
                       appending.  The basic idea here is that maybe some cgi
                       script provides the actual viewer hookup and tunnelling.
                       How to actually achieve this within cgi, php, etc. is
                       not clear...  A custom web server or apache module
                       would be straight-forward.

                       Another experimental mode is "-proxy ssh://user@host"
                       in which case a SSH tunnel is used for the proxying.
                       "user@" is not needed unless your unix username is
                       different on "host".  For a non-standard SSH port
                       use ssh://user@host:port.  If proxies are chained (see
                       next paragraph) then the ssh one must be the first one.
                       If ssh-agent is not active, then the ssh password needs
                       to be entered in the terminal where x11vnc is running.
                       Examples:

                         -connect localhost:0 -proxy ssh://me@friends-pc:2222

                         -connect snoopy:0 -proxy ssh://ssh.company.com

                       Multiple proxies may be chained together in case one
                       needs to ricochet off of a number of hosts to finally
                       reach the VNC viewer.  Up to 3 may be chained, separate
                       them by commas in the order they are to be connected to.
                       E.g.:  http://host1:port1,socks5://host2:port2 or three
                       like:  first,second,third

                       IPv6: as of x11vnc 0.9.10 the -proxy option should
                       connect to IPv6 hosts properly.  If there are problems
                       you can disable IPv6 by setting -DX11VNC_IPV6=0
                       in CPPFLAGS when configuring.  If there problems
                       connecting to IPv6 hosts consider a relay like the
                       included inet6to4 script.

-vncconnect            Monitor the VNC_CONNECT X property set by the standard
-novncconnect          VNC program vncconnect(1).  When the property is
                       set to "host" or "host:port" establish a reverse
                       connection.  Using xprop(1) instead of vncconnect may
                       work (see the FAQ).  The -remote control mechanism uses
                       X11VNC_REMOTE channel, and this option disables/enables
                       it as well.  Default: -vncconnect

                       To use different names for these X11 properties (e.g. to
                       have separate communication channels for multiple
                       x11vnc's on the same display) set the VNC_CONNECT or
                       X11VNC_REMOTE env. vars. to the string you want, for
                       example: -env X11VNC_REMOTE=X11VNC_REMOTE_12345
                       Both sides of the channel must use the same unique name.
                       The same can be done for the internal X11VNC_TICKER
                       property (heartbeat and timestamp) if desired.

-allow host1[,host2..] Only allow client connections from hosts matching
                       the comma separated list of hostnames or IP addresses.
                       Can also be a numerical IP prefix, e.g. "192.168.100."
                       to match a simple subnet, for more control build
                       LibVNCServer with libwrap support (See the FAQ).  If the
                       list contains a "/" it instead is a interpreted
                       as a file containing addresses or prefixes that is
                       re-read each time a new client connects.  Lines can be
                       commented out with the "#" character in the usual way.

                       -allow applies in -ssl mode, but not in -stunnel mode.

                       IPv6: as of x11vnc 0.9.10 a host can be specified
                       in IPv6 numerical format, e.g. 2001:4860:b009::93.

-localhost             Basically the same as "-allow 127.0.0.1".

                       Note: if you want to restrict which network interface
                       x11vnc listens on, see the -listen option below.
                       E.g. "-listen localhost" or "-listen 192.168.3.21".
                       As a special case, the option "-localhost" implies
                       "-listen localhost".

                       A rare case, but for non-localhost -listen usage, if
                       you use the remote control mechanism (-R) to change
                       the -listen interface you may need to manually adjust
                       the -allow list (and vice versa) to avoid situations
                       where no connections (or too many) are allowed.

                       If you do not want x11vnc to listen on ANY interface
                       (evidently you are using -connect or -connect_or_exit,
                       or plan to use remote control: -R connect:host), use
                       -rfbport 0

                       IPv6: if IPv6 is supported, this option automatically
                       implies the IPv6 loopback address '::1' as well.

-unixsock str          Listen on the unix socket (AF_UNIX) 'str'
                       for connections.  This mode is for either local
                       connections or a tunnel endpoint where one wants the
                       file permission of the unix socket file to determine
                       what can connect to it.  (This currently requires an
                       edit to libvnserver/rfbserver.c: comment out lines 310
                       and 311, 'close(sock)' and 'return NULL' in rfbserver.c
                       after the setsockopt() call.) Note that to disable all
                       tcp listening ports specify '-rfbport 0' and should be
                       useful with this mode.  Example:
                           mkdir ~/s; chmod 700 ~/s;
                           x11vnc -unixsock ~/s/mysock -rfbport 0 ...
                       The SSVNC unix vncviewer can connect to unix sockets.

-listen6 str           When in IPv6 listen mode "-6", listen only on the
                       network interface with address "str".  It also works
                       for link scope addresses (fe80::219:dbff:fee5:3f92%eth0)
                       and IPv6 hostname strings (e.g. ipv6.google.com.)
                       Use LibVNCServer -listen option for the IPv4 interface.

-nolookup              Do not use gethostbyname() or gethostbyaddr() to look up
                       host names or IP numbers.  Use this if name resolution
                       is incorrectly set up and leads to long pauses as name
                       lookups time out, etc.

-input string          Fine tuning of allowed user input.  If "string" does
                       not contain a comma "," the tuning applies only to
                       normal clients.  Otherwise the part before "," is
                       for normal clients and the part after for view-only
                       clients.  "K" is for Keystroke input, "M" for
                       Mouse-motion input, "B" for Button-click input, "C"
                       is for Clipboard input, and "F" is for File transfer
                       (ultravnc only).  Their presence in the string enables
                       that type of input.  E.g. "-input M" means normal
                       users can only move the mouse and  "-input KMBCF,M"
                       lets normal users do anything and enables view-only
                       users to move the mouse.  This option is ignored when
                       a global -viewonly is in effect (all input is discarded
                       in that case).

-grabkbd               When VNC viewers are connected, attempt to the grab
                       the keyboard so a (non-malicious) user sitting at the
                       physical display is not able to enter keystrokes.
                       This method uses XGrabKeyboard(3X11) and so it is
                       not secure and does not rule out the person at the
                       physical display injecting keystrokes by flooding the
                       server with them, grabbing the keyboard himself, etc.
                       Some degree of cooperation from the person at the
                       display is assumed.  This is intended for remote
                       help-desk or educational usage modes.

                       Note: on some recent (12/2010) X servers and/or
                       desktops, -grabkbd no longer works: it prevents the
                       window manager from resizing windows and similar things.
                       Try -ungrabboth below (might not work.)

-grabptr               As -grabkbd, but for the mouse pointer using
                       XGrabPointer(3X11).  Unfortunately due to the way the X
                       server works, the mouse can still be moved around by the
                       user at the physical display, but he will not be able to
                       change window focus with it.  Also some window managers
                       that call XGrabServer(3X11) for resizes, etc, will
                       act on the local user's input.  Again, some degree of
                       cooperation from the person at the display is assumed.

-ungrabboth            Whenever there is any input (either keyboard or
                       pointer), ungrab *both* the keyboard and the pointer
                       while injecting the synthetic input.  This is to allow
                       window managers, etc. a chance to grab.

-grabalways            Apply both -grabkbd and -grabptr even when no VNC
                       viewers are connected.  If you only want one of them,
                       use the -R remote control to turn the other back on,
                       e.g. -R nograbptr.

-viewpasswd string     Supply a 2nd password for view-only logins.  The -passwd
                       (full-access) password must also be supplied.

-passwdfile filename   Specify the LibVNCServer password via the first line
                       of the file "filename" (instead of via -passwd on
                       the command line where others might see it via ps(1)).

                       See the descriptions below for how to supply multiple
                       passwords, view-only passwords, to specify external
                       programs for the authentication, and other features.

                       If the filename is prefixed with "rm:" it will be
                       removed after being read.  Perhaps this is useful in
                       limiting the readability of the file.  In general, the
                       password file should not be readable by untrusted users
                       (BTW: neither should the VNC -rfbauth file: it is NOT
                       encrypted, only obscured with a fixed key).

                       If the filename is prefixed with "read:" it will
                       periodically be checked for changes and reread.  It is
                       guaranteed to be reread just when a new client connects
                       so that the latest passwords will be used.

                       If "filename" is prefixed with "cmd:" then the
                       string after the ":" is run as an external command:
                       the output of the command will be interpreted as if it
                       were read from a password file (see below).  If the
                       command does not exit with 0, then x11vnc terminates
                       immediately.  To specify more than 1000 passwords this
                       way set X11VNC_MAX_PASSWDS before starting x11vnc.
                       The environment variables are set as in -accept.

                       Note that due to the VNC protocol only the first 8
                       characters of a password are used (DES key).

                       If "filename" is prefixed with "custom:" then a
                       custom password checker is supplied as an external
                       command following the ":". The command will be run
                       when a client authenticates.  If the command exits with
                       0 the client is accepted, otherwise it is rejected.
                       The environment variables are set as in -accept.

                       The standard input to the custom command will be a
                       decimal digit "len" followed by a newline. "len"
                       specifies the challenge size and is usually 16 (the
                       VNC spec).  Then follows len bytes which is the random
                       challenge string that was sent to the client. This is
                       then followed by len more bytes holding the client's
                       response (i.e. the challenge string encrypted via DES
                       with the user password in the standard situation).

                       The "custom:" scheme can be useful to implement
                       dynamic passwords or to implement methods where longer
                       passwords and/or different encryption algorithms
                       are used.  The latter will require customizing the VNC
                       client as well.  One could create an MD5SUM based scheme
                       for example.

                       File format for -passwdfile:

                       If multiple non-blank lines exist in the file they are
                       all taken as valid passwords.  Blank lines are ignored.
                       Password lines may be "commented out" (ignored) if
                       they begin with the character "#" or the line contains
                       the string "__SKIP__".  Lines may be annotated by use
                       of the "__COMM__" string: from it to the end of the
                       line is ignored.  An empty password may be specified
                       via the "__EMPTY__" string on a line by itself (note
                       your viewer might not accept empty passwords).

                       If the string "__BEGIN_VIEWONLY__" appears on a
                       line by itself, the remaining passwords are used for
                       viewonly access.  For compatibility, as a special case
                       if the file contains only two password lines the 2nd
                       one is automatically taken as the viewonly password.
                       Otherwise the "__BEGIN_VIEWONLY__" token must be
                       used to have viewonly passwords.  (tip: make the 3rd
                       and last line be "__BEGIN_VIEWONLY__" to have 2
                       full-access passwords)

-showrfbauth filename  Print to the screen the obscured VNC password kept in
                       the rfbauth file "filename" and then exit.

-unixpw [list]         Use Unix username and password authentication.  x11vnc
                       will use the su(1) program to verify the user's
                       password.  [list] is an optional comma separated list
                       of allowed Unix usernames.  If the [list] string begins
                       with the character "!" then the entire list is taken
                       as an exclude list.  See below for per-user options
                       that can be applied.

                       A familiar "login:" and "Password:" dialog is
                       presented to the user on a black screen inside the
                       vncviewer.  The connection is dropped if the user fails
                       to supply the correct password in 3 tries or does not
                       send one before a 45 second timeout.  Existing clients
                       are view-only during this period.

                       If the first character received is "Escape" then the
                       unix username will not be displayed after "login:"
                       as it is typed.  This could be of use for VNC viewers
                       that automatically type the username and password.

                       Since the detailed behavior of su(1) can vary from
                       OS to OS and for local configurations, test the mode
                       before deployment to make sure it is working properly.
                       x11vnc will attempt to be conservative and reject a
                       login if anything abnormal occurs.

                       One case to note: FreeBSD and the other BSD's by
                       default it is impossible for the user running x11vnc to
                       validate his *own* password via su(1) (commenting out
                       the pam_self.so entry in /etc/pam.d/su eliminates this
                       behavior).  So the x11vnc login will always *FAIL* for
                       this case (even when the correct password is supplied).

                       A possible workaround for this on *BSD would be to
                       start x11vnc as root with the "-users +nobody" option
                       to immediately switch to user nobody where the su'ing
                       will proceed normally.

                       Another source of potential problems are PAM modules
                       that prompt for extra info, e.g. password aging modules.
                       These logins will fail as well even when the correct
                       password is supplied.

                       **IMPORTANT**: to prevent the Unix password being sent
                       in *clear text* over the network, one of two schemes
                       will be enforced: 1) the -ssl builtin SSL mode, or 2)
                       require both -localhost and -stunnel be enabled.

                       Method 1) ensures the traffic is encrypted between
                       viewer and server.  A PEM file will be required, see the
                       discussion under -ssl below (under some circumstances
                       a temporary one can be automatically generated).

                       Method 2) requires the viewer connection to appear
                       to come from the same machine x11vnc is running on
                       (e.g. from a ssh -L port redirection).  And that the
                       -stunnel SSL mode be used for encryption over the
                       network. (see the description of -stunnel below).

                       Note: as a convenience, if you ssh(1) in and start
                       x11vnc it will check if the environment variable
                       SSH_CONNECTION is set and appears reasonable.  If it
                       does, then the -ssl or -stunnel requirement will be
                       dropped since it is assumed you are using ssh for the
                       encrypted tunnelling.  -localhost is still enforced.
                       Use -ssl or -stunnel to force SSL usage even if
                       SSH_CONNECTION is set.

                       To override the above restrictions you can set
                       environment variables before starting x11vnc:

                       Set UNIXPW_DISABLE_SSL=1 to disable requiring either
                       -ssl or -stunnel (as under SSH_CONNECTION.)  Evidently
                       you will be using a different method to encrypt the
                       data between the vncviewer and x11vnc: perhaps ssh(1)
                       or an IPSEC VPN. -localhost is still enforced (however,
                       see the next paragraph.)

                       Set UNIXPW_DISABLE_LOCALHOST=1 to disable the -localhost
                       requirement in -unixpw modes.  One should never do this
                       (i.e. allow the Unix passwords to be sniffed on the
                       network.)  This also disables the localhost requirement
                       for reverse connections (see below.)

                       Note that use of -localhost with ssh(1) (and no -unixpw)
                       is roughly the same as requiring a Unix user login
                       (since a Unix password or the user's public key
                       authentication is used by sshd on the machine where
                       x11vnc runs and only local connections from that machine
                       are accepted).

                       Regarding reverse connections (e.g. -R connect:host
                       and -connect host), when the -localhost constraint is
                       in effect then reverse connections can only be used
                       to connect to the same machine x11vnc is running on
                       (default port 5500).  Please use a ssh or stunnel port
                       redirection to the viewer machine to tunnel the reverse
                       connection over an encrypted channel.

                       In -inetd mode the Method 1) will be enforced (not
                       Method 2).  With -ssl in effect reverse connections
                       are disabled.  If you override this via env. var, be
                       sure to also use encryption from the viewer to inetd.
                       Tip: you can also have your own stunnel spawn x11vnc
                       in -inetd mode (thereby bypassing inetd).  See the FAQ
                       for details.

                       The user names in the comma separated [list] may have
                       per-user options after a ":", e.g. "fred:opts"
                       where "opts" is a "+" separated list of
                       "viewonly", "fullaccess", "input=XXXX", or
                       "deny", e.g. "karl,wally:viewonly,boss:input=M".
                       For "input=" it is the K,M,B,C described under -input.

                       If an item in the list is "*" that means those
                       options apply to all users.  It ALSO implies all users
                       are allowed to log in after supplying a valid password.
                       Use "deny" to explicitly deny some users if you use
                       "*" to set a global option.  If [list] begins with the
                       "!" character then "*" is ignored for checking if
                       the user is allowed, but the option values associated
                       with it do apply as normal.

                       There are also some utilities for checking passwords
                       if [list] starts with the "%" character.  See the
                       quick_pw() function for more details.  Description:
                       "%-" or "%stdin" means read one line from stdin.
                       "%env" means it is in $UNIXPW env var.  A leading
                       "%/" or "%." means read the first line from the
                       filename that follows after the % character. % by
                       itself means prompt for the username and password.
                       Otherwise: %user:pass   E.g. -unixpw %fred:swordfish
                       For the other cases user:pass is read from the indicated
                       source.  If the password is correct 'Y user' is printed
                       and the program exit code is 0.  If the password is
                       incorrect it prints 'N user' and the exit code is 1.
                       If there is some other error the exit code is 2.
                       This feature enables x11vnc to be a general unix user
                       password checking tool; it could be used from scripts
                       or other programs.  These % password checks also apply
                       to the -unixpw_nis and -unixpw_cmd options.

                       For the % password check, if the env. var. UNIXPW_CMD
                       is set to a command then it is run as the user (assuming
                       the password is correct.)  The output of the command is
                       not printed, the program or script must manage that by
                       some other means.  The exit code of x11vnc will depend
                       on the exit code of the command that is run.

                       Use -nounixpw to disable unixpw mode if it was enabled
                       earlier in the cmd line (e.g. -svc mode)

-unixpw_nis [list]     As -unixpw above, however do not use su(1) but rather
                       use the traditional getpwnam(3) + crypt(3) method to
                       verify passwords. All of the above -unixpw options and
                       constraints apply.

                       This mode requires that the encrypted passwords be
                       readable.  Encrypted passwords stored in /etc/shadow
                       will be inaccessible unless x11vnc is run as root.

                       This is called "NIS" mode simply because in most
                       NIS setups user encrypted passwords are accessible
                       (e.g. "ypcat passwd") by an ordinary user and so that
                       user can authenticate ANY user.

                       NIS is not required for this mode to work (only that
                       getpwnam(3) return the encrypted password is required),
                       but it is unlikely it will work (as an ordinary user)
                       for most modern environments unless NIS is available.
                       On the other hand, when x11vnc is run as root it will
                       be able to to access /etc/shadow even if NIS is not
                       available (note running as root is often done when
                       running x11vnc from inetd and xdm/gdm/kdm).

                       Looked at another way, if you do not want to use the
                       su(1) method provided by -unixpw (i.e. su_verify()), you
                       can run x11vnc as root and use -unixpw_nis.  Any users
                       with passwords in /etc/shadow can then be authenticated.

                       In -unixpw_nis mode, under no circumstances is x11vnc's
                       user password verifying function based on su called
                       (i.e. the function su_verify() that runs /bin/su
                       in a pseudoterminal to verify passwords.)  However,
                       if -unixpw_nis is used in conjunction with the -find
                       and -create -display WAIT:... modes then, if x11vnc is
                       running as root, /bin/su may be called externally to
                       run the find or create commands.

-unixpw_cmd cmd        As -unixpw above, however do not use su(1) but rather
                       run the externally supplied command "cmd".  The first
                       line of its stdin will be the username and the second
                       line the received password.  If the command exits
                       with status 0 (success) the VNC user will be accepted.
                       It will be rejected for any other return status.

                       Dynamic passwords and non-unix passwords, e.g. LDAP,
                       can be implemented this way by providing your own custom
                       helper program.  Note that the remote viewer is given 3
                       tries to enter the correct password, and so the program
                       may be called in a row that many (or more) times.

                       If a list of allowed users is needed to limit who can
                       log in, use -unixpw [list] in addition to this option.

                       In FINDDISPLAY and FINDCREATEDISPLAY modes the "cmd"
                       will also be run with the RFB_UNIXPW_CMD_RUN env. var.
                       non-empty and set to the corresponding display
                       find/create command.  The first two lines of input are
                       the username and passwd as in the normal case described
                       above.  To support FINDDISPLAY and FINDCREATEDISPLAY,
                       "cmd" should run the requested command as the user
                       (and most likely refusing to run it if the password is
                       not correct.)  Here is an example script (note it has
                       a hardwired bogus password "abc"!)

                         #!/bin/sh
                         # Example x11vnc -unixpw_cmd script.
                         # Read the first two lines of stdin (user and passwd)
                         read user
                         read pass

                         debug=0
                         if [ $debug = 1 ]; then
                                echo "user: $user" 1>&2
                                echo "pass: $pass" 1>&2
                                env | egrep -i 'rfb|vnc' 1>&2
                         fi

                         # Check if the password is valid.
                         # (A real example would use ldap lookup, etc!)
                         if [ "X$pass" != "Xabc" ]; then
                                exit 1  # incorrect password
                         fi

                         if [ "X$RFB_UNIXPW_CMD_RUN" = "X" ]; then
                                exit 0  # correct password
                         else
                                # Run the requested command (finddisplay)
                                if [ $debug = 1 ]; then
                                        echo "run: $RFB_UNIXPW_CMD_RUN" 1>&2
                                fi
                                exec /bin/su - "$user" -c "$RFB_UNIXPW_CMD_RUN"
                         fi

                       In -unixpw_cmd mode, under no circumstances is x11vnc's
                       user password verifying function based on su called
                       (i.e. the function su_verify() that runs /bin/su in a
                       pseudoterminal to verify passwords.)  It is up to the
                       supplied unixpw_cmd to do user switching if desired
                       and if it has the permissions to do so.

-find                  Find the user's display using FINDDISPLAY. This
                       is an alias for "-display WAIT:cmd=FINDDISPLAY".

                       Note: if a -display occurs later on the command line
                       it will override the -find setting.

                       For this and the next few options see -display WAIT:...
                       below for all of the details.

-finddpy               Run the FINDDISPLAY program, print out the found
                       display (if any) and exit.  Output is like: DISPLAY=:0.0
                       DISPLAY=:0.0,XPID=12345 or DISPLAY=:0.0,VT=7.  XPID is
                       the process ID of the found X server.  VT is the Linux
                       virtual terminal of the X server.
-listdpy               Have the FINDDISPLAY program list all of your displays
                       (i.e. all the X displays on the local machine that you
                       have access rights to).  x11vnc then exits.

-findauth [disp]       Apply the -find/-finddpy heuristics to try to guess
                       the XAUTHORITY file for DISPLAY 'disp'.  If 'disp'
                       is not supplied, then the value in the -display on
                       the cmdline is used; failing that $DISPLAY is used;
                       and failing that ":0" is used.  x11vnc then exits.

                       If nothing is printed out, that means no XAUTHORITY was
                       found for 'disp'; i.e. failure.  If "XAUTHORITY="
                       is printed out, that means use the default (i.e. do
                       not set XAUTHORITY).  If "XAUTHORITY=/path/to/file"
                       is printed out, then use that file.

                       XDM/GDM/KDM: if you are running x11vnc as root and want
                       to find the XAUTHORITY before anyone has logged into an
                       X session yet, use: x11vnc -env FD_XDM=1 -findauth ...
                       (This will also find the XAUTHORITY if a user is already
                       logged into the X session.)  When running as root,
                       FD_XDM=1 will be tried if the initial -findauth fails.

-create                First try to find the user's display using FINDDISPLAY,
                       if that doesn't succeed create an X session via the
                       FINDCREATEDISPLAY method.  This is an alias for
                       "-display WAIT:cmd=FINDCREATEDISPLAY-Xvfb".

                       Note: if a -display occurs later on the command line
                       it will override the -create setting.

                       SSH NOTE: for both -find and -create you can (should!)
                       add the "-localhost" option to force SSH tunnel access.

-xdummy                As in -create, except Xdummy instead of Xvfb.
-xvnc                  As in -create, except Xvnc instead of Xvfb.
-xvnc_redirect         As in -create, except Xvnc.redirect instead of Xvfb.
-xdummy_xvfb           Sets WAIT:cmd=FINDCREATEDISPLAY-Xdummy,Xvfb

-create_xsrv str       Sets WAIT:cmd=FINDCREATEDISPLAY-<str>  Can be on cmdline
                       after anything that sets WAIT:.. and other things
                       (e.g. -svc, -xdmsvc) to adjust the X server list.
                       Example: -svc ... -create_xsrv Xdummy,X

-svc                   Terminal services mode based on SSL access.  Alias for
                       -display WAIT:cmd=FINDCREATEDISPLAY-Xvfb -unixpw -users
                       unixpw= -ssl SAVE   Also "-service".

                       Note: if a -display, -unixpw, -users, or -ssl occurs
                       later on the command line it will override the -svc
                       setting.

-svc_xdummy            As -svc except Xdummy instead of Xvfb.
-svc_xvnc              As -svc except Xvnc instead of Xvfb.
-svc_xdummy_xvfb       As -svc with Xdummy,Xvfb.

-xdmsvc                Display manager Terminal services mode based on SSL.
                       Alias for -display WAIT:cmd=FINDCREATEDISPLAY-Xvfb.xdmcp
                       -unixpw -users unixpw= -ssl SAVE  Also "-xdm_service".

                       Note: if a -display, -unixpw, -users, or -ssl occurs
                       later on the command line it will override the -xdmsvc
                       setting.

                       To create a session a user will have to first log in
                       to the -unixpw dialog and then log in again to the
                       XDM/GDM/KDM prompt.  Subsequent re-connections will
                       only require the -unixpw password.  See the discussion
                       under -display WAIT:... for more details about XDM,
                       etc configuration.

                       Remember to enable XDMCP in the xdm-config, gdm.conf,
                       or kdmrc configuration file.  See -display WAIT: for
                       more info.

-sshxdmsvc             Display manager Terminal services mode based on SSH.
                       Alias for -display WAIT:cmd=FINDCREATEDISPLAY-Xvfb.xdmcp
                       -localhost.

                       The -localhost option constrains connections to come
                       in via a SSH tunnel (which will require a login).
                       To create a session a user will also have to log into
                       the XDM GDM KDM prompt. Subsequent re-connections will
                       only only require the SSH login.  See the discussion
                       under -display WAIT:... for more details about XDM,
                       etc configuration.

                       Remember to enable XDMCP in the xdm-config, gdm.conf,
                       or kdmrc configuration file.  See -display WAIT: for
                       more info.

-unixpw_system_greeter Present a "Press 'Escape' for System Greeter" option
                       to the connecting VNC client in combined -unixpw
                       and xdmcp FINDCREATEDISPLAY modes (e.g. -xdmsvc).

                       Normally in a -unixpw mode the VNC client must
                       supply a valid username and password to gain access.
                       However, if -unixpw_system_greeter is supplied AND
                       the FINDCREATEDISPLAY command matches 'xdmcp', then
                       the user has the option to press Escape and then get a
                       XDM/GDM/KDM login/greeter panel instead. They will then
                       supply a username and password directly to the greeter.

                       Otherwise, in xdmcp FINDCREATEDISPLAY mode the user
                       must supply his username and password TWICE.  First to
                       the initial unixpw login dialog, and second to the
                       subsequent XDM/GDM/KDM greeter.  Note that if the user
                       re-connects and supplies his username and password in
                       the unixpw dialog the xdmcp greeter is skipped and
                       he is connected directly to his existing X session.
                       So the -unixpw_system_greeter option avoids the extra
                       password at X session creation time.

                       Example:  x11vnc -xdmsvc -unixpw_system_greeter
                       See -unixpw and -display WAIT:... for more info.

                       The special options after a colon at the end of the
                       username (e.g. user:solid) described under -display
                       WAIT: are also applied in this mode if they are typed
                       in before the user hits Escape.  The username is ignored
                       but the colon options are not.

                       The default message is 2 lines in a small font, set
                       the env. var. X11VNC_SYSTEM_GREETER1=true for a 1 line
                       message in a larger font.

                       If the user pressed Escape the FINDCREATEDISPLAY command
                       will be run with the env. var. X11VNC_XDM_ONLY=1.

                       Remember to enable XDMCP in the xdm-config, gdm.conf,
                       or kdmrc configuration file.  See -display WAIT: for
                       more info.

-redirect port         As in FINDCREATEDISPLAY-Xvnc.redirect mode except
                       redirect immediately (i.e. without X session finding
                       or creation) to a VNC server listening on port. You
                       can also supply host:port to redirect to a different
                       machine.

                       If 0 <= port < 200 it is taken as a VNC display (5900 is
                       added to get the actual port), if port < 0 then -port
                       is used.

                       Probably the only reason to use the -redirect option
                       is in conjunction with SSL support, e.g. -ssl SAVE.
                       This provides an easy way to add SSL encryption to a VNC
                       server that does not support SSL (e.g. Xvnc or vnc.so)
                       In fact, the protocol does not even need to be VNC,
                       and so "-rfbport port1 -ssl SAVE -redirect host:port2"
                       can act as a replacement for stunnel(1).

                       This mode only allows one redirected connection.
                       The -forever option does not apply.  Use -inetd or
                       -loop for persistent service.

-display_WAIT :...      A special usage mode for the normal -display option.
                       Useful with -unixpw, but can be used independently
                       of it.  If the display string begins with WAIT: then
                       x11vnc waits until a VNC client connects before opening
                       the X display (or -rawfb device).

                       This could be useful for delaying opening the display
                       for certain usage modes (say if x11vnc is started at
                       boot time and no X server is running or users logged
                       in yet).

                       If the string is, e.g. WAIT:0.0 or WAIT:1, i.e. "WAIT"
                       in front of a normal X display, then that indicated
                       display is used.

                       One can also insert a geometry between colons, e.g.
                       WAIT:1280x1024:... to set the size of the display the
                       VNC client first attaches to since some VNC viewers
                       will not automatically adjust to a new framebuffer size.

                       A more interesting case is like this:

                            WAIT:cmd=/usr/local/bin/find_display

                       in which case the command after "cmd=" is run to
                       dynamically work out the DISPLAY and optionally the
                       XAUTHORITY data.  The first line of the command output
                       must be of the form DISPLAY=<xdisplay>.  On Linux
                       if the virtual terminal is known append ",VT=n" to
                       this string and the chvt(1) program will also be run.
                       Any remaining output is taken as XAUTHORITY data.
                       It can be either of the form XAUTHORITY=<file> or raw
                       xauthority data for the display. For example;

                            xauth extract - $DISPLAY"

                       NOTE: As specified in the previous paragraph, you can
                       supply your own WAIT:cmd=... program or script, BUT
                       there are two very useful *BUILT-IN* ones: FINDDISPLAY
                       (alias -find above) and FINDCREATEDISPLAY (alias -create
                       above.)  Most people use these instead of creating
                       their own script.  Read the following (especially the
                       BUILT-IN modes sections) to see how to configure these
                       two useful builtin -display WAIT: modes.

                       In the case of -unixpw (and -unixpw_nis only if x11vnc
                       is running as root), then the cmd= command is run
                       as the user who just authenticated via the login and
                       password prompt.

                       In the case of -unixpw_cmd, the commands will also be
                       run as the logged-in user, as long as the user-supplied
                       helper program supports RFB_UNIXPW_CMD_RUN (see the
                       -unixpw_cmd option.)

                       Also in the case of -unixpw, the user logging in can
                       place a colon at the end of her username and supply
                       a few options: scale=, scale_cursor= (or sc=), solid
                       (or so), id=, clear_mods (or cm), clear_keys (or
                       ck), clear_all (or ca), repeat, speeds= (or sp=),
                       readtimeout= (or rd=), viewonly (or vo), nodisplay=
                       (or nd=), rotate= (or ro=), or noncache (or nc),
                       all separated by commas if there is more than one.
                       After the user logs in successfully, these options will
                       be applied to the VNC screen.  For example,

                          login: fred:scale=3/4,sc=1,repeat
                          Password: ...

                          login: runge:sp=modem,rd=120,solid

                       for convenience m/n implies scale= e.g. fred:3/4  If you
                       type and enter your password incorrectly, to retrieve
                       your long "login:" line press the Up arrow once
                       (before typing anything else).

                       Most of these colon options only apply to the builtin
                       FINDDISPLAY and FINDCREATEDISPLAY modes, but note
                       that they are passed to the extrenal command in the
                       environment as well and so could be used.

                       In the login panel, press F1 to get a list of the
                       available options that you can add after the username.

                       Another option is "geom=WxH" or "geom=WxHxD" (or
                       ge=). This only has an effect in FINDCREATEDISPLAY
                       mode when a virtual X server such as Xvfb is going
                       to be created.  It sets the width and height of
                       the new display, and optionally the color depth as
                       well.

                       You can also supply "gnome", "kde", "twm",
                       "fvwm", "mwm", "dtwm", "wmaker", "xfce",
                       "lxde", "enlightenment", "Xsession", or
                       "failsafe" (same as "xterm") to have the created
                       display use that mode for the user session.

                       Specify "tag=..." to set the unique FD_TAG desktop
                       session tag described below.  Note: this option will
                       be ignored if the FD_TAG env. var. is already set or
                       if the viewer-side supplied value is not completely
                       composed of alphanumeric or '_' or '-' characters.

                       User preferences file: Instead of having the user type
                       in geom=WxH,... etc. every time he logs in to find
                       or create his X session, if you set FD_USERPREFS to
                       a string that does not contain the "/" character,
                       then the user's home directory is prepended to that
                       string and if the file exists its first line is read
                       and appended to any options he supplied at the login:
                       prompt.  For example -env FD_USERPREFS=.x11vnc_create
                       and the user put "geom=1600x1200" in his
                       ~/.x11vnc_create file.

                       To disable the option setting set the environment
                       variable X11VNC_NO_UNIXPW_OPTS=1 before starting x11vnc.
                       To set any other options, the user can use the gui
                       (x11vnc -gui connect) or the remote control method
                       (x11vnc -R opt:val) during his VNC session.

                       So we see the combination of -display WAIT:cmd=... and
                       -unixpw allows automatic pairing of an unix
                       authenticated VNC user with his desktop.  This could
                       be very useful on SunRays and also any system where
                       multiple users share a given machine.  The user does
                       not need to remember special ports or passwords set up
                       for his desktop and VNC.

                       A nice way to use WAIT:cmd=... is out of inetd(8)
                       (it automatically forks a new x11vnc for each user).
                       You can have the x11vnc inetd spawned process run as,
                       say, root or nobody.  When run as root (for either inetd
                       or display manager), you can also supply the option
                       "-users unixpw=" to have the x11vnc process switch to
                       the user as well.  Note: there will be a 2nd SSL helper
                       process that will not switch, but it is only encoding
                       and decoding the encrypted stream at that point.

                       BUILT-IN modes:

                       -- Automatic Finding of User X Sessions --

                       As a special case, WAIT:cmd=FINDDISPLAY will run a
                       script that works on most Unixes to determine a user's
                       DISPLAY variable and xauthority data (see who(1)).

                       NOTE: The option "-find" is an alias for this mode.

                       To have this default script printed to stdout (e.g. for
                       customization) run with WAIT:cmd=FINDDISPLAY-print To
                       have the script run to print what display it would find
                       use "-finddpy" or WAIT:cmd=FINDDISPLAY-run

                       The standard script runs xdpyinfo(1) run on potential
                       displays.  If your X server(s) have a login greeter
                       that exclusively grabs the Xserver, then xdpyinfo
                       blocks forever and this mode will not work.  See
                       www.karlrunge.com/x11vnc/faq.html#faq-display-manager
                       for how to disable this for dtgreet on Solaris and
                       possibly for other greeters.

                       In -find/cmd=FINDDISPLAY mode, if you set FD_XDM=1,
                       e.g. 'x11vnc -env FD_XDM=1 -find ...' and x11vnc is
                       running as root (e.g. inetd) then it will try to find
                       the XAUTHORITY file of a running XDM/GDM/KDM login
                       greeter (i.e. no user has logged into an X session yet.)

                       As another special case, WAIT:cmd=HTTPONCE will allow
                       x11vnc to service one http request and then exit.
                       This is usually done in -inetd mode to run on, say,
                       port 5800 and allow the Java vncviewer to be downloaded
                       by client web browsers.  For example:

                        5815 stream tcp nowait root /usr/sbin/tcpd /.../x11vnc
\
                          -inetd -q -http_ssl -prog /.../x11vnc \
                          -display WAIT:cmd=HTTPONCE

                       Where /.../x11vnc is the full path to x11vnc.
                       It is used in the Apache SSL-portal example (see FAQ).

                       In this mode you can set X11VNC_SKIP_DISPLAY to a
                       comma separated list of displays (e.g. ":0,:1") to
                       ignore in the finding process.  The ":" is optional.
                       Ranges n-m e.g. 0-20 can also be supplied. This string
                       can also be set by the connecting user via "nd="
                       using "+" instead of ","  If "nd=all" or you set
                       X11VNC_SKIP_DISPLAY=all then all display finding fails
                       as if you set X11VNC_FINDDISPLAY_ALWAYS_FAILS=1 (below.)

                       On some systems lsof(1) can be very slow.  Set the
                       env. var. FIND_DISPLAY_NO_LSOF=1 to skip using lsof to
                       try to find the Linux VT the X server is running on.
                       set FIND_DISPLAY_NO_VT_FIND=1 to avoid looking at all.

                       -- Automatic Creation of User X Sessions --

                       An interesting option is WAIT:cmd=FINDCREATEDISPLAY
                       that is like FINDDISPLAY in that is uses the same method
                       to find an existing display.  However, if it does not
                       find one it will try to *start* up an X server session
                       for the user.  This is the only time x11vnc tries to
                       actually start up an X server.

                       NOTE: The option "-create" is an alias for this mode.

                       It will start looking for an open display number at :20
                       Override via X11VNC_CREATE_STARTING_DISPLAY_NUMBER=n
                       By default 80 X displays are allowed (i.e. going to :99)
                       Override via X11VNC_CREATE_MAX_DISPLAYS=n

                       For its heuristics, the create display script sets
                       LC_ALL=C so that command output is uniform.  By default
                       it will try to restore LC_ALL right before starting the
                       user session.  However, if you don't mind it keeping
                       LC_ALL=C set the env. var.: X11VNC_CREATE_LC_ALL_C_OK=1

                       By default FINDCREATEDISPLAY will try Xvfb and then
                       Xdummy:

                       The Xdummy wrapper is part of the x11vnc source code
                       (x11vnc/misc/Xdummy)  It should be available in PATH
                       and have run "Xdummy -install" once to create the
                       shared library.  Xdummy only works on Linux.  As of
                       12/2009 it no longer needs to be run as root, and the
                       default is to not run as root.  In some circumstances
                       permissions may require running it as root, in these
                       cases specify FD_XDUMMY_RUN_AS_ROOT=1, this is the same
                       as supplying -root to the Xdummy cmdline.

                       Xvfb is available on most platforms and does not
                       require root.

                       An advantage of Xdummy over Xvfb is that Xdummy supports
                       RANDR dynamic screen resizing.

                       When x11vnc exits (i.e. user disconnects) the X
                       server session stays running in the background.
                       The FINDDISPLAY will find it directly next time.
                       The user must exit the X session in the usual way for
                       it to terminate (or kill the X server process if all
                       else fails).

                       To troubleshoot the FINDCREATEDISPLAY mechanism,
                       set the following env. var. to an output log file,
                       e.g -env CREATE_DISPLAY_OUTPUT=/tmp/mydebug.txt

                       So this is a somewhat odd mode for x11vnc in that it
                       will start up and poll virtual X servers!  This can
                       be used from, say, inetd(8) to provide a means of
                       definitely getting a desktop (either real or virtual)
                       on the machine.  E.g. a desktop service:

                         5900 stream tcp nowait root /usr/sbin/tcpd /.../x11vnc
                          -inetd -q -http -ssl SAVE -unixpw -users unixpw=\
                          -passwd secret -prog /.../x11vnc \
                          -display WAIT:cmd=FINDCREATEDISPLAY

                       Where /.../x11vnc is the full path to x11vnc.

                       See the -svc/-service option alias above.

                       If for some reason you do not want x11vnc to ever
                       try to find an existing display set the env. var
                       X11VNC_FINDDISPLAY_ALWAYS_FAILS=1 (also -env ...)
                       This is the same as setting X11VNC_SKIP_DISPLAY=all or
                       supplying "nd=all" after "username:"

                       Use WAIT:cmd=FINDCREATEDISPLAY-print to print out the
                       script that is used for this.

                       You can specify the preferred X server order via e.g.,
                       WAIT:cmd=FINDCREATEDISPLAY-Xdummy,Xvfb,X  and/or leave
                       out ones you do not want.  The the case "X" means try
                       to start up a real, hardware X server using xinit(1)
                       or startx(1).  If there is already an X server running
                       the X case may only work on Linux (see startx(1)).

                       "Xvnc" will start up a VNC X server (real-
                       or tight-vnc, e.g. use if Xvfb is not available).
                       "Xsrv" will start up the server program in the
                       variable "FD_XSRV" if it is non-empty. You can make
                       this be a wrapper script if you like (it must handle :N,
                       -geometry, and -depth and other X server options).

                       You can set the environment variable FD_GEOM (or
                       X11VNC_CREATE_GEOM) to WxH or WxHxD to set the width
                       and height and optionally the color depth of the
                       created display.  You can also set FD_SESS to be the
                       session (short name of the windowmanager: kde, gnome,
                       twm, failsafe, etc.). FD_OPTS contains extra options
                       to pass to the X server. You can also set FD_PROG to
                       be the full path to the session/windowmanager program.

                       More FD tricks:  FD_CUPS=port or FD_CUPS=host:port
                       will set the cups printing environment.  Similarly for
                       FD_ESD=port or FD_ESD=host:port for esddsp sound
                       redirection.  Set FD_EXTRA to a command to be run a
                       few seconds after the X server starts up.  Set FD_TAG
                       to be a unique name for the session, it is set as an
                       X property, that makes FINDDISPLAY only find sessions
                       with that tag value.

                       Set FD_XDMCP_IF to the network interface that the
                       display manager is running on; default is 'localhost'
                       but you may need to set it to '::1' on some IPv6 only
                       systems or misconfigured display managers.

                       If you want the FINDCREATEDISPLAY session to contact an
                       XDMCP login manager (xdm/gdm/kdm) on the same machine,
                       then use "Xvfb.xdmcp" instead of "Xvfb", etc.
                       The user will have to supply his username and password
                       one more time (but he gets to select his desktop type
                       so that can be useful).  For this to work, you will
                       need to enable localhost XDMCP (udp port 177) for the
                       display manager.  This seems to be:

                        for gdm in gdm.conf:   Enable=true in section [xdmcp]
                        for kdm in kdmrc:      Enable=true in section [Xdmcp]
                        for xdm in xdm-config: DisplayManager.requestPort: 177

                       See the shorthand options above "-svc", "-xdmsvc"
                       and "-sshxdmsvc" that specify the above options for
                       some useful cases.

                       If you set the env. var WAITBG=1 x11vnc will go into
                       the background once listening in wait mode.

                       Another special mode is FINDCREATEDISPLAY-Xvnc.redirect,
                       (or FINDDISPLAY-Xvnc.redirect).  In this case it will
                       start up Xvnc as above if needed, but instead of
                       polling it in its normal way, it simply does a socket
                       redirection of the connected VNC viewer to the Xvnc.

                       So in Xvnc.redirect x11vnc does no VNC but merely
                       transfers the data back and forth.  This should be
                       faster then x11vnc's polling method, but not as fast
                       as connecting directly to the Xvnc with the VNC Viewer.
                       The idea here is to take advantage of x11vnc's display
                       finding/creating scheme, SSL, and perhaps a few others.
                       Most of x11vnc's options do not apply in this mode.

                       Xvnc.redirect should also work for the vnc.so X server
                       module for the h/w display however it will work only
                       for finding the display and the user must already be
                       logged into the X console.

-vencrypt mode         The VeNCrypt extension to the VNC protocol allows
                       encrypted SSL/TLS connections.  If the -ssl mode is
                       enabled, then VeNCrypt is enabled as well BY DEFAULT
                       (they both use a SSL/TLS tunnel, only the protocol
                       handshake is a little different.)

                       To control when and how VeNCrypt is used, specify the
                       mode string.  If mode is "never", then VeNCrypt is
                       not used.  If mode is "support" (the default) then
                       VeNCrypt is supported.  If mode is "only", then the
                       similar and older ANONTLS protocol is not simultaneously
                       supported.  x11vnc's normal SSL mode (vncs://) will be
                       supported under -ssl unless you set mode to "force".

                       If mode is prefixed with "nodh:", then Diffie Hellman
                       anonymous key exchange is disabled.  If mode is prefixed
                       with "nox509:", then X509 key exchange is disabled.

                       To disable all Anonymous Diffie-Hellman access
                       (susceptible to Man-In-The-Middle attack) you will need
                       to supply "-vencrypt nodh:support -anontls never"
                       or "-vencrypt nodh:only"

                       If mode is prefixed with "newdh:", then new Diffie
                       Hellman parameters are generated for each connection
                       (this can be time consuming: 1-60 secs; see -dhparams
                       below for a faster way) rather than using the
                       fixed values in the program.  Using fixed, publicly
                       known values is not known to be a security problem.
                       This setting applies to ANONTLS as well.

                       Long example: -vencrypt newdh:nox509:support

                       Also, if mode is prefixed with "plain:", then
                       if -unixpw mode is active the VeNCrypt "*Plain"
                       username+passwd method is enabled for Unix logins.
                       Otherwise in -unixpw mode the normal login panel is
                       provided.

                       You *MUST* supply the -ssl option for VeNCrypt to
                       be active.  The -vencrypt option only fine-tunes its
                       operation.

-anontls mode          The ANONTLS extension to the VNC protocol allows
                       encrypted SSL/TLS connections.  If the -ssl mode is
                       enabled, then ANONTLS is enabled as well BY DEFAULT
                       (they both use a SSL/TLS tunnel, only the protocol
                       handshake is a little different.)

                       ANONTLS is an older SSL/TLS mode introduced by vino.

                       It is referred to as 'TLS' for its registered VNC
                       security-type name, but we use the more descriptive
                       'ANONTLS' here because it provides only Anonymous
                       Diffie-Hellman encrypted connections, and hence no
                       possibility for certificate authentication.

                       To control when and how ANONTLS is used, specify the
                       mode string.  If mode is "never", then ANONTLS is not
                       used.  If mode is "support" (the default) then ANONTLS
                       is supported.  If mode is "only", then the similar
                       VeNCrypt protocol is not simultaneously supported.
                       x11vnc's normal SSL mode (vncs://) will be supported
                       under -ssl unless you set mode to "force".

                       If mode is prefixed with "newdh:", then new Diffie
                       Hellman parameters are generated for each connection
                       (this can be time consuming: 1-60 secs; see -dhparams
                       below for a faster way) rather than using the
                       fixed values in the program.  Using fixed, publicly
                       known values is not known to be a security problem.
                       This setting applies to VeNCrypt as well.  See the
                       description of "plain:" under -vencrypt.

                       Long example: -anontls newdh:plain:support

                       You *MUST* supply the -ssl option for ANONTLS to
                       be active.  The -anontls option only fine-tunes its
                       operation.

-sslonly               Same as: "-vencrypt never -anontls never"  i.e. it
                       disables the VeNCrypt and ANONTLS encryption methods
                       and only allows standard SSL tunneling.  You must also
                       supply the -ssl ... option (see below.)


-dhparams file         For some operations a set of Diffie Hellman parameters
                       (prime and generator) is needed.  If so, use the
                       parameters in "file". In particular, the VeNCrypt and
                       ANONTLS anonymous DH mode need them.  By default a
                       fixed set is used. If you do not want to do that you
                       can specify "newdh:" to the -vencrypt and -anontls
                       options to generate a new set each session.  If that
                       is too slow for you, use -dhparams file to a set you
                       created manually via "openssl dhparam -out file 1024"

-nossl                 Disable the -ssl option (see below). Since -ssl is off
                       by default -nossl would only be used on the commandline
                       to unset any *earlier* -ssl option (or -svc...)

-ssl [pem]             Use the openssl library (www.openssl.org) to provide a
                       built-in encrypted SSL/TLS tunnel between VNC viewers
                       and x11vnc.  This requires libssl support to be
                       compiled into x11vnc at build time.  If x11vnc is not
                       built with libssl support it will exit immediately when
                       -ssl is prescribed.  See the -stunnel option below for
                       an alternative.

                       The VNC Viewer-side needs to support SSL/TLS as well.
                       See this URL and also the discussion below for
                       ideas on how to enable SSL support for the viewer:
                       http://www.karlrunge.com/x11vnc/faq.html#faq-ssl-tun
                       nel-viewers .  x11vnc provides an SSL enabled Java
                       viewer applet in the classes/ssl directory (-http or
                       -httpdir options.)  The SSVNC viewer package supports
                       SSL tunnels too.

                       If the VNC Viewer supports VeNCrypt or ANONTLS (vino's
                       encryption mode) they are also supported by the -ssl
                       mode (see the -vencrypt and -anontls options for more
                       info; use -sslonly to disable both of them.)

                       Use "-ssl /path/to/mycert.pem" to specify an SSL
                       certificate file in PEM format to use to identify and
                       provide a key for this server.  See openssl(1) for more
                       info about PEMs and the -sslGenCert and "-ssl SAVE"
                       options below for how to create them.

                       The connecting VNC viewer SSL tunnel can (at its option)
                       authenticate this server if it has the public key part
                       of the certificate (or a common certificate authority,
                       CA, is a more sophisticated way to verify this server's
                       cert, see -sslGenCA below).  This authentication is
                       done to prevent Man-In-The-Middle attacks.  Otherwise,
                       if the VNC viewer simply accepts this server's key
                       WITHOUT verification, the traffic is protected from
                       passive sniffing on the network, but *NOT* from
                       Man-In-The-Middle attacks. There are hacker tools
                       like dsniff/webmitm and cain that implement SSL
                       Man-In-The-Middle attacks.

                       If [pem] is empty or the string "SAVE" then the
                       openssl(1) command must be available to generate the
                       certificate the first time.  A self-signed certificate
                       is generated (see -sslGenCA and -sslGenCert for use
                       of a Certificate Authority.)  It will be saved to the
                       file ~/.vnc/certs/server.pem.  On subsequent calls if
                       that file already exists it will be used directly.

                       Use "SAVE_NOPROMPT" to avoid being prompted to
                       protect the generated key with a passphrase.  However in
                       -inetd and -bg modes there will be no prompting for a
                       passphrase in either case.

                       If [pem] is "SAVE_PROMPT" the server.pem certificate
                       will be created based on your answers to its prompts for
                       all info such as OrganizationalName, CommonName, etc.

                       Use "SAVE-<string>" and "SAVE_PROMPT-<string>"
                       to refer to the file ~/.vnc/certs/server-<string>.pem
                       instead (it will be generated if it does not already
                       exist).  E.g. "SAVE-charlie" will store to the file
                       ~/.vnc/certs/server-charlie.pem

                       Examples: x11vnc -ssl SAVE -display :0 ...
                                 x11vnc -ssl SAVE-someother -display :0 ...

                       If [pem] is "TMP" and the openssl(1) utility
                       command exists in PATH, then a temporary, self-signed
                       certificate will be generated for this session.  If
                       openssl(1) cannot be used to generate a temporary
                       certificate x11vnc exits immediately.  The temporary
                       cert will be discarded when x11vnc exits.

                       If successful in using openssl(1) to generate a
                       temporary certificate in "SAVE" or "TMP" creation
                       modes, the public part of it will be displayed to stderr
                       (e.g. one could copy it to the client-side to provide
                       authentication of the server to VNC viewers.)

                       NOTE: In "TMP" mode, unless you safely copy the
                       public part of the temporary Cert to the viewer for
                       authenticate *every time* (unlikely...), then only
                       passive sniffing attacks are prevented and you are
                       still open to Man-In-The-Middle attacks.  This is
                       why the default "SAVE" mode is preferred (and more
                       sophisticated CA mode too).  Only with saved keys AND
                       the VNC viewer authenticating them (via the public
                       certificate), are Man-In-The-Middle attacks prevented.

                       If [pem] is "ANON" then the Diffie-Hellman anonymous
                       key exchange method is used.  In this mode there
                       are *no* SSL certificates and so it is not possible
                       to authenticate either the VNC server or VNC client.
                       Thus only passive network sniffing attacks are avoided:
                       the "ANON" method is susceptible to Man-In-The-Middle
                       attacks.  "ANON" is not recommended; instead use
                       a SSL PEM you created or the default "SAVE" method.

                       See -ssldir below to use a directory besides the
                       default ~/.vnc/certs

                       If your x11vnc binary was not compiled with OpenSSL
                       library support, use of the -ssl option will induce an
                       immediate failure and exit.  For such binaries, consider
                       using the -stunnel option for SSL encrypted connections.

                       Misc Info: In temporary cert creation mode "TMP", set
                       the env. var. X11VNC_SHOW_TMP_PEM=1 to have x11vnc print
                       out the entire certificate, including the PRIVATE KEY
                       part, to stderr.  There are better ways to get/save this
                       info.  See "SAVE" above and "-sslGenCert" below.

-ssltimeout n          Set SSL read timeout to n seconds.  In some situations
                       (i.e. an iconified viewer in Windows) the viewer stops
                       talking and the connection is dropped after the default
                       timeout (25s for about the first minute, 43200s later).
                       Set to zero to poll forever.  Set to a negative value
                       to use the builtin setting.

                       Note that this value does NOT apply to the *initial* ssl
                       init connection.  The default timeout for that is 20sec.
                       Use -env SSL_INIT_TIMEOUT=n to modify it.

-sslnofail             Exit at the first SSL connection failure. Useful when
                       scripting SSL connections (e.g. x11vnc is started via
                       ssh) and you do not want x11vnc waiting around for more
                       connections, tying up ports, etc.

-ssldir dir            Use "dir" as an alternate ssl certificate and key
                       management toplevel directory.  The default is
                       ~/.vnc/certs

                       This directory is used to store server and other
                       certificates and keys and also other materials.  E.g. in
                       the simplest case, "-ssl SAVE" will store the x11vnc
                       server cert in dir/server.pem

                       Use of alternate directories via -ssldir allows you to
                       manage multiple VNC Certificate Authority (CA) keys.
                       Another use is if ~/.vnc/cert is on an NFS share you
                       might want your certificates and keys to be on a local
                       filesystem to prevent network snooping (for example
                       -ssldir /var/lib/x11vnc-certs).

                       -ssldir affects nearly all of the other -ssl* options,
                       e.g. -ssl SAVE, -sslGenCert, etc..

-sslverify path        For either of the -ssl or -stunnel modes, use "path"
                       to provide certificates to authenticate incoming VNC
                       *Client* connections (normally only the server is
                       authenticated in SSL.)  This can be used as a method
                       to replace standard password authentication of clients.

                       If "path" is a directory it contains the client (or CA)
                       certificates in separate files.  If path is a file,
                       it contains one or more certificates. See special tokens
                       below.  These correspond to the "CApath = dir" and
                       "CAfile = file" stunnel options.  See the stunnel(8)
                       manpage for details.

                       Examples:
                              x11vnc -ssl -sslverify ~/my.crt
                              x11vnc -ssl -sslverify ~/my_pem_dir/

                       Note that if path is a directory, it must contain
                       the certs in separate files named like <HASH>.0, where
                       the value of <HASH> is found by running the command
                       "openssl x509 -hash -noout -in file.crt". Evidently
                       one uses <HASH>.1 if there is a collision...

                       The the key-management utility "-sslCertInfo HASHON"
                       and "-sslCertInfo HASHOFF" will create/delete these
                       hashes for you automatically (via symlink) in the HASH
                       subdirs it manages.  Then you can point -sslverify to
                       the HASH subdir.

                       Special tokens: in -ssl mode, if "path" is not a file or
                       a directory, it is taken as a comma separated list of
                       tokens that are interpreted as follows:

                       If a token is "CA" that means load the CA/cacert.pem
                       file from the ssl directory.  If a token is "clients"
                       then all the files clients/*.crt in the ssl directory
                       are loaded.  Otherwise the file clients/token.crt
                       is attempted to be loaded.  As a kludge, use a token
                       like ../server-foo to load a server cert if you find
                       that necessary.

                       Use -ssldir to use a directory different from the
                       ~/.vnc/certs default.

                       Note that if the "CA" cert is loaded you do not need
                       to load any of the certs that have been signed by it.
                       You will need to load any additional self-signed certs
                       however.

                       Examples:
                              x11vnc -ssl -sslverify CA
                              x11vnc -ssl -sslverify self:fred,self:jim
                              x11vnc -ssl -sslverify CA,clients

                       Usually "-sslverify CA" is the most effective.
                       See the -sslGenCA and -sslGenCert options below for
                       how to set up and manage the CA framework.



                       NOTE: the following utilities, -sslGenCA, -sslGenCert,
                       -sslEncKey, -sslCertInfo, and -sslCRL are provided for
                       completeness, but for casual usage they are overkill.

                       They provide VNC Certificate Authority (CA) key creation
                       and server / client key generation and signing.  So they
                       provide a basic Public Key management framework for
                       VNC-ing with x11vnc. (note that they require openssl(1)
                       be installed on the system)

                       However, the simplest usage mode, "-ssl TMP" (where
                       x11vnc automatically generates its own, self-signed,
                       temporary key and the VNC viewers always accept it,
                       e.g. accepting via a dialog box) is probably safe enough
                       for most scenarios.  CA management is not needed.

                       To protect against Man-In-The-Middle attacks the "TMP"
                       mode can be improved by using "-ssl SAVE" (same as
                       "-ssl", i.e. the default) to have x11vnc create a
                       longer term self-signed certificate, and then (safely)
                       copy the corresponding public key cert to the desired
                       client machines (care must be taken the private key part
                       is not stolen; you will be prompted for a passphrase).

                       So keep in mind no CA key creation or management
                       (-sslGenCA and -sslGenCert) is needed for either of
                       the above two common usage modes.

                       One might want to use -sslGenCA and -sslGenCert
                       if you had a large number of VNC client and server
                       workstations.  That way the administrator could generate
                       a single CA key with -sslGenCA and distribute its
                       certificate part to all of the workstations.

                       Next, he could create signed VNC server keys
                       (-sslGenCert server ...) for each workstation or user
                       that then x11vnc would use to authenticate itself to
                       any VNC client that has the CA cert.

                       Optionally, the admin could also make it so the
                       VNC clients themselves are authenticated to x11vnc
                       (-sslGenCert client ...)  For this -sslverify would be
                       pointed to the CA cert (and/or self-signed certs).

                       x11vnc will be able to use all of these cert and
                       key files.  On the VNC client side, they will need to
                       be "imported" somehow.  Web browsers have "Manage
                       Certificates" actions as does the Java applet plugin
                       Control Panel.  stunnel can also use these files (see
                       the ss_vncviewer example script in the FAQ and SSVNC.)

-sslCRL path           Set the Certificate Revocation Lists (CRL) to "path".
                       This setting applies for both -ssl and -stunnel modes.

                       If path is a file, the file contains one or more CRLs
                       in PEM format.  If path is a directory, it contains
                       hash named files of CRLs in the usual OpenSSL manner.
                       See the OpenSSL and stunnel(8) documentation for
                       more info.

                       This option only applies if -sslverify has been
                       supplied: it checks for revocation along the
                       certificate chain used to verify the VNC client.
                       The -sslCRL setting will be ignored when -sslverify is
                       not specified.

                       Note that if a CRL's expiration date has passed, all
                       SSL connections will fail regardless of if they are
                       related to the subject of the CRL or not.

                       Only rarely will one's x11vnc -ssl infrastructure be so
                       large that this option would be useful (since normally
                       maintaining the contents of the -sslverify file or
                       directory should be enough.)  However, when using
                       x11vnc with a Certificate Authority (see -sslGenCA)
                       to authenticate Clients via SSL/TLS, the -sslCRL option
                       can be useful to revoke users' certs whose private SSL
                       keys were lost or stolen (e.g. laptop.)  This way a new
                       CA cert+key does not need to be created and new signed
                       client keys generated and distributed to all users.

                       To create a CRL file with revoked certificates the
                       commands 'openssl ca -revoke ...' and 'openssl ca
                       -gencrl ...' are useful.  (Run them in ~/.vnc/certs)

-sslGenCA [dir]        Generate your own Certificate Authority private key,
                       certificate, and other files in directory [dir].
                       x11vnc then exits.

                       If [dir] is not supplied, a -ssldir setting is used,
                       or otherwise ~/.vnc/certs is used.

                       This command also creates directories where server and
                       client certs and keys will be stored.  The openssl(1)
                       program must be installed on the system and available
                       in PATH.

                       After the CA files and directories are created the
                       x11vnc command exits; the VNC server is not run.

                       You will be prompted for information to put into the CA
                       certificate.  The info does not have to be accurate just
                       as long as clients accept the cert for VNC connections.
                       You will also need to supply a passphrase of at least
                       4 characters for the CA private key.

                       Once you have generated the CA you can distribute
                       its certificate part, [dir]/CA/cacert.pem, to other
                       workstations where VNC viewers will be run.  One will
                       need to "import" this certificate in the applications,
                       e.g. Web browser, Java applet plugin, stunnel, etc.
                       Next, you can create and sign keys using the CA with
                       the -sslGenCert option below.

                       Examples:
                                x11vnc -sslGenCA
                                x11vnc -sslGenCA  ~/myCAdir
                                x11vnc -ssldir ~/myCAdir -sslGenCA

                       (the last two lines are equivalent)

-sslGenCert type name  Generate a VNC server or client certificate and private
                       key pair signed by the CA created previously with
                       -sslGenCA.  The openssl(1) program must be installed
                       on the system and available in PATH.

                       After the Certificate is generated x11vnc exits; the
                       VNC server is not run.

                       The type of key to be generated is the string "type".
                       It is either "server" (i.e. for use by x11vnc) or
                       "client" (for a VNC viewer).  Note that typically
                       only "server" is used: the VNC clients authenticate
                       themselves by a non-public-key method (e.g. VNC or
                       unix password).  "type" is required.

                       An arbitrary default name you want to associate with
                       the key is supplied by the "name" string.  You can
                       change it at the various prompts when creating the key.
                       "name" is optional.

                       If name is left blank for clients keys then "nobody"
                       is used.  If left blank for server keys, then the
                       primary server key: "server.pem" is created (this
                       is the saved one referenced by "-ssl SAVE" when the
                       server is started)

                       If "name" begins with the string "self:" then
                       a self-signed certificate is created instead of one
                       signed by your CA key.

                       If "name" begins with the string "req:" then only a
                       key (.key) and a certificate signing *request* (.req)
                       are generated.  You can then send the .req file to
                       an external CA (even a professional one, e.g. Thawte)
                       and then combine the .key and the received cert into
                       the .pem file with the same basename.

                       The distinction between "server" and "client" is
                       simply the choice of output filenames and sub-directory.
                       This makes it so the -ssl SAVE-name option can easily
                       pick up the x11vnc PEM file this option generates.
                       And similarly makes it easy for the -sslverify option
                       to pick up your client certs.

                       There is nothing special about the filename or directory
                       location of either the "server" and "client" certs.
                       You can rename the files or move them to wherever
                       you like.

                       Precede this option with -ssldir [dir] to use a
                       directory other than the default ~/.vnc/certs You will
                       need to run -sslGenCA on that directory first before
                       doing any -sslGenCert key creation.

                       Note you cannot recreate a cert with exactly the same
                       distiguished name (DN) as an existing one.  To do so,
                       you will need to edit the [dir]/CA/index.txt file to
                       delete the line.

                       Similar to -sslGenCA, you will be prompted to fill
                       in some information that will be recorded in the
                       certificate when it is created.

                       Tip: if you know the fully-qualified hostname other
                       people will be connecting to, you can use that as the
                       CommonName "CN" to avoid some applications (e.g. web
                       browsers and java plugin) complaining that it does not
                       match the hostname.

                       You will also need to supply the CA private key
                       passphrase to unlock the private key created from
                       -sslGenCA.  This private key is used to sign the server
                       or client certificate.

                       The "server" certs can be used by x11vnc directly by
                       pointing to them via the -ssl [pem] option.  The default
                       file will be ~/.vnc/certs/server.pem.  This one would
                       be used by simply typing -ssl SAVE.  The pem file
                       contains both the certificate and the private key.
                       server.crt file contains the cert only.

                       The "client" cert + private key file will need
                       to be copied and imported into the VNC viewer
                       side applications (Web browser, Java plugin,
                       stunnel, etc.)  Once that is done you can delete the
                       "client" private key file on this machine since
                       it is only needed on the VNC viewer side.  The,
                       e.g. ~/.vnc/certs/clients/<name>.pem contains both
                       the cert and private key.  The <name>.crt contains the
                       certificate only.

                       NOTE: It is very important to know one should
                       generate new keys with a passphrase.  Otherwise if an
                       untrusted user steals the key file he could use it to
                       masquerade as the x11vnc server (or VNC viewer client).
                       You will be prompted whether to encrypt the key with
                       a passphrase or not.  It is recommended that you do.
                       One inconvenience to a passphrase is that it must
                       be typed in EVERY time x11vnc or the client app is
                       started up.

                       Examples:

                               x11vnc -sslGenCert server
                               x11vnc -ssl SAVE -display :0 ...

                       and then on viewer using ss_vncviewer stunnel wrapper
                       (see the FAQ):
                               ss_vncviewer -verify ./cacert.crt hostname:0

                       (this assumes the cacert.crt cert from -sslGenCA
                       was safely copied to the VNC viewer machine where
                       ss_vncviewer is run)

                       Example using a name:

                               x11vnc -sslGenCert server charlie
                               x11vnc -ssl SAVE-charlie -display :0 ...

                       Example for a client certificate (rarely used):

                               x11vnc -sslGenCert client roger
                               scp ~/.vnc/certs/clients/roger.pem somehost:.
                               rm  ~/.vnc/certs/clients/roger.pem

                       x11vnc is then started with the option -sslverify
                       ~/.vnc/certs/clients/roger.crt (or simply -sslverify
                       roger), and on the viewer user on somehost could do
                       for example:

                               ss_vncviewer -mycert ./roger.pem hostname:0

                       If you set the env. var REQ_ARGS='...' it will be
                       passed to openssl req(1).  A common use would be
                       REQ_ARGS='-days 1095' to bump up the expiration date
                       (3 years in this case).

-sslEncKey pem         Utility to encrypt an existing PEM file with a
                       passphrase you supply when prompted.  For that key to be
                       used (e.g. by x11vnc) the passphrase must be supplied
                       each time.

                       The "SAVE" notation described under -ssl applies as
                       well. (precede this option with -ssldir [dir] to refer
                       a directory besides the default ~/.vnc/certs)

                       The openssl(1) program must be installed on the system
                       and available in PATH.  After the Key file is encrypted
                       the x11vnc command exits; the VNC server is not run.

                       Examples:
                               x11vnc -sslEncKey /path/to/foo.pem
                               x11vnc -sslEncKey SAVE
                               x11vnc -sslEncKey SAVE-charlie

-sslCertInfo pem       Prints out information about an existing PEM file.
                       In addition the public certificate is also printed.
                       The openssl(1) program must be in PATH. Basically the
                       command "openssl x509 -text" is run on the pem.

                       After the info is printed the x11vnc command exits;
                       the VNC server is not run.

                       The "SAVE" notation described under -ssl applies
                       as well.

                       Using  "LIST" will give a list of all certs being
                       managed (in the ~/.vnc/certs dir, use -ssldir to refer
                       to another dir).  "ALL" will print out the info for
                       every managed key (this can be very long).  Giving a
                       client or server cert shortname will also try a lookup
                       (e.g. -sslCertInfo charlie).  Use "LISTL" or "LL"
                       for a long (ls -l style) listing.

                       Using "HASHON" will create subdirs [dir]/HASH and
                       [dir]/HASH with OpenSSL hash filenames (e.g. 0d5fbbf1.0)
                       symlinks pointing up to the corresponding *.crt file.
                       ([dir] is ~/.vnc/certs or one given by -ssldir.)
                       This is a useful way for other OpenSSL applications
                       (e.g. stunnel) to access all of the certs without
                       having to concatenate them.  x11vnc will not use them
                       unless you specifically reference them.  "HASHOFF"
                       removes these HASH subdirs.

                       The LIST, LISTL, LL, ALL, HASHON, HASHOFF words can
                       also be lowercase, e.g. "list".

-sslDelCert pem        Prompts you to delete all .crt .pem .key .req files
                       associated with [pem].  x11vnc then exits. "SAVE"
                       and lookups as in -sslCertInfo apply as well.

-sslScripts            Prints out both the 'genCA' and 'genCert' x11vnc
                       openssl wrapper scripts for you to examine, modify, etc.
                       The scripts are printed to stdout and then the x11vnc
                       program exits.


-stunnel [pem]         Use the stunnel(8) (stunnel.mirt.net) to provide an
                       encrypted SSL tunnel between viewers and x11vnc.

                       This external tunnel method was implemented prior to the
                       integrated -ssl encryption described above.  It still
                       works well and avoids the requirement of linking with
                       the OpenSSL libraries.  This mode requires stunnel
                       to be installed on the system and available via PATH
                       (n.b. stunnel is often installed in sbin directories).
                       Version 4.x of stunnel is assumed (but see -stunnel3
                       below.)

                       [pem] is optional, use "-stunnel /path/to/stunnel.pem"
                       to specify a PEM certificate file to pass to stunnel.
                       See the -ssl option for more info on certificate files.

                       Whether or not your stunnel has its own certificate
                       depends on your stunnel configuration; stunnel often
                       generates one at install time.  See your stunnel
                       documentation for details.  In any event, if you want to
                       use this certificate you must supply the full path to it
                       as [pem].  Note: the file may only be readable by root.

                       [pem] may also be the special strings "TMP", "SAVE",
                       and "SAVE..." as described in the -ssl option.
                       If [pem] is not supplied, "SAVE" is assumed.

                       Note that the VeNCrypt, ANONTLS, and "ANON" modes
                       are not supported in -stunnel mode.

                       stunnel is started up as a child process of x11vnc and
                       any SSL connections stunnel receives are decrypted and
                       sent to x11vnc over a local socket.  The strings
                       "The SSL VNC desktop is ..." and "SSLPORT=..."
                       are printed out at startup to indicate this.

                       The -localhost option is enforced by default to avoid
                       people routing around the SSL channel.  Use -env
                       STUNNEL_DISABLE_LOCALHOST=1 to disable this security
                       requirement.

                       Set -env STUNNEL_DEBUG=1 for more debugging printout.

                       Set -env STUNNEL_PROG=xxx to the full path of stunnel
                       program you want to be used (e.g. /usr/bin/stunnel4).

                       Set -env STUNNEL_LISTEN=xxx to the address of the
                       network interface to listen on (the default is to listen
                       on all interfaces), e.g. STUNNEL_LISTEN=192.168.1.100.

                       A simple way to add IPv6 support is STUNNEL_LISTEN=::

                       Your VNC viewer will also need to be able to connect
                       via SSL.  Unfortunately not too many do this.  See the
                       information about SSL viewers under the -ssl option.
                       The x11vnc project's SSVNC is an option.

                       Also, in the x11vnc distribution, patched TightVNC
                       and UltraVNC Java applet jar files are provided in
                       the classes/ssl directory that do SSL connections.
                       Enable serving them with the -http, -http_ssl, or
                       -httpdir (see the option descriptions for more info.)

                       Note that for the Java viewer applet usage the
                       "?PORT=xxxx" in the various URLs printed at startup
                       will need to be supplied to the web browser to connect
                       properly.

                       Currently the automatic "single port" HTTPS mode of
                       -ssl is not fully supported in -stunnel mode.  However,
                       it can be emulated via:

                         % x11vnc -stunnel -http_ssl -http_oneport ...

                       In general, it is also not too difficult to set up
                       an stunnel or other SSL tunnel on the viewer side.
                       A simple example on Unix using stunnel 3.x is:

                         % stunnel -c -d localhost:5901 -r remotehost:5900
                         % vncviewer localhost:1

                       For Windows, stunnel has been ported to it and there
                       are probably other such tools available.  See the FAQ
                       and SSVNC for more examples.

-stunnel3  [pem]       Use version 3.x stunnel command line syntax instead of
                       version 4.x.  The -http/-httpdir Java applet serving
                       is currently not available in this mode.

-enc cipher:keyfile    Use symmetric encryption with cipher "cipher"
                       and secret key data in "keyfile".  If keyfile is
                       pw=<string> then "string" is used as the key data.

                       NOTE: It is recommended that you use SSL via the -ssl
                       option instead of this option because SSL is well
                       understood and takes great care to establish unique
                       session keys and is more compatible with other software.
                       Use this option if you do not want to deal with SSL
                       certificates for authentication and do not want to
                       use SSH but want some encryption for your VNC session.
                       Or if you must interface with a symmetric key tunnel
                       that you do not have control over.

                       Note that this mode will NOT work with the UltraVNC DSM
                       plugins because they alter the RFB protocol in addition
                       to tunnelling with the symmetric cipher (an unfortunate
                       choice of implementation...)

                       cipher can be one of:  arc4, aesv2, aes-cfb, blowfish,
                       aes256, or 3des.  See the OpenSSL documentation for
                       more info.  The keysize is 128 bits (except for aes256).
                       Here is one way to make a keyfile with that many bits:

                            dd if=/dev/random of=./my.key bs=16 count=1

                       you will need to securely share this key with the other
                       side of the VNC connection (See SSVNC for examples).

                       Example:  -enc blowfish:./my.key
                       Example:  -enc blowfish:pw=swordfish

                       By default 16 bytes of random salt followed by 16 bytes
                       of random initialization vector are sent at the very
                       beginning of the stream.  The other side must read these
                       and initialize their cipher with them.  These values
                       make the session key unique (without them the security
                       is minimal).  Similarly, the other side must send us
                       its random salt and IV with those same lengths.

                       The salt and key data are combined to create a session
                       key using an md5 hash as described in EVP_BytesToKey(3).

                       The exact call is: EVP_BytesToKey(Cipher, EVP_md5(),
                       salt, keydata, len, 1, keystr, NULL);  where salt is
                       the random data as described above, and keydata is the
                       shared secret key data.  keystr is the resulting session
                       key.  The cipher is then seeded with keystr and uses
                       the random initialization vector as its first block.

                       To modify the amount of random salt and initialization
                       vector use cipher@n,m where n is the salt length and
                       m the initialization vector length.  E.g.

                                 -enc aes-cfb@8,16:./my.key

                       It is not a good idea to set either one to zero,
                       although you may be forced to if the other side of the
                       tunnel is not under your control.

                       To skip the salt and EVP_BytesToKey MD5 entirely (no
                       hashing is done: the keydata is directly inserted into
                       the cipher) specify "-1" for the salt, e.g.

                                 -enc blowfish@-1,16:./my.key

                       The message digest can also be changed to something
                       besides the default MD5.  Use cipher@md+n,m where "md"
                       can be one of sha, sha1, md5, or ripe.  For example:

                                 -enc arc4@sha+8,16:./my.key

                       The SSVNC vnc viewer project supplies a symmetric
                       encryption tool named "ultravnc_dsm_helper" that can
                       be used on the viewer side.  For example:

                       ssvncviewer exec='ultravnc_dsm_helper arc4 my.key 0 h:p'

                       where h:p is the hostname and port of the x11vnc server.
                       ultravnc_dsm_helper may also be used standalone to
                       provide a symmetric encryption tunnel for any viewer
                       or server (VNC or otherwise.) The cipher (1st arg)
                       is basically the same syntax as we use above.

                       Also see the 'Non-Ultra DSM' SSVNC option for the
                       'UltraVNC DSM Encryption Plugin' advanced option.

                       For both ways of using the viewer, you can specify the
                       salt,ivec sizes (in GUI or, e.g. arc4@8,16).

-https [port]          Use a special, separate HTTPS port (-ssl and
                       -stunnel modes only) for HTTPS Java viewer applet
                       downloading. I.e. not 5900 and not 5800 (the defaults.)

                       BACKGROUND: In -ssl mode, it turns out you can use the
                       single VNC port (e.g. 5900) for both VNC and HTTPS
                       connections. (HTTPS is used to retrieve a SSL-aware
                       VncViewer.jar applet that is provided with x11vnc).
                       Since both use SSL the implementation was extended to
                       detect if HTTP traffic (i.e. GET) is taking place and
                       handle it accordingly.  The URL would be, e.g.:

                       https://mymachine.org:5900/

                       This is convenient for firewalls, etc, because only one
                       port needs to be allowed in.  However, this heuristic
                       adds a few seconds delay to each connection and can be
                       unreliable (especially if the user takes much time to
                       ponder the Certificate dialogs in his browser, Java VM,
                       or VNC Viewer applet.  That's right 3 separate "Are
                       you sure you want to connect?" dialogs!)

                       END OF BACKGROUND.

                       USAGE: So use the -https option to provide a separate,
                       more reliable HTTPS port that x11vnc will listen on.  If
                       [port] is not provided (or is 0), one is autoselected.
                       The URL to use is printed out at startup.

                       The SSL Java applet directory is specified via the
                       -httpdir option.  If not supplied, -https will try
                       to guess the directory as though the -http option
                       was supplied.

-httpsredir [port]     In -ssl mode with the Java applet retrieved via HTTPS,
                       when the HTML file containing applet parameters
                       ('index.vnc' or 'proxy.vnc') is sent do NOT set the
                       applet PORT parameter to the actual VNC port but set it
                       to "port" instead.  If "port" is not supplied, then
                       the port number is guessed from the Host: HTTP header.

                       This is useful when an incoming TCP connection
                       redirection is performed by a router/gateway/firewall
                       from one port to an internal machine where x11vnc is
                       listening on a different port. The Java applet needs to
                       connect to the firewall/router port, not the VNC port
                       on the internal workstation. For example, one could
                       redir from mygateway.com:443 to workstation:5900.

                       This spares the user from having to type in
                       https://mygateway.com/?PORT=443 into their web
                       browser. Note that port 443 is the default https port;
                       other ports must be explicitly indicated, for example:
                       https://mygateway.com:8000/?PORT=8000.  To avoid having
                       to include the PORT= in the browser URL, simply supply
                       "-httpsredir" to x11vnc.

                       This option does not work in -stunnel mode.

                       More tricks: set the env var X11VNC_EXTRA_HTTPS_PARAMS
                       to be extra URL parameters to use.  This way you do
                       not need to specify extra PARAMS in the index.vnc file.
                       E.g. x11vnc -env X11VNC_EXTRA_HTTPS_PARAMS='?GET=1' ...

                       If you do not want to expose the non-SSL HTTP port to
                       the network (i.e. you just want the single VNC/HTTPS
                       port, e.g. 5900, open for connections) then specify the
                       option -env X11VNC_HTTP_LISTEN_LOCALHOST=1  This way
                       the connection to the LibVNCServer httpd server will
                       only be available on localhost (note that in -ssl mode,
                       HTTPS requests are redirected from SSL to the non-SSL
                       LibVNCServer HTTP server.)

-http_oneport          For UN-encrypted connections mode (i.e. no -ssl,
                       -stunnel, or -enc options), allow the Java VNC Viewer
                       applet to be downloaded thru the VNC port via HTTP.

                       That is to say, you can use a single port for Java
                       applet viewer connections by using a URL in your web
                       browser like this, for example:

                       http://hostname:5900

                       The regular, two-port mode, URL http://hostname:5800
                       will continue to work as well.

                       As mentioned above, this mode will NOT work with
                       the -ssl, -stunnel, or -enc encryption options.
                       Note that is it equivalent to '-enc none' (i.e. it
                       uses the same detection mechanism as for HTTPS, but
                       with no encryption.)

                       HTTPS single-port is on by default in -ssl encrypted
                       mode (and -enc too), so you only need -http_oneport
                       when doing non-SSL encrypted connections.

                       This mode could also be useful for SSH tunnels since
                       it means only one port needs to be redirected.

                       The -httpsredir option may also be useful for this
                       mode when using an SSH tunnel as well as for router
                       port redirections.

                       Note that the -env X11VNC_HTTP_LISTEN_LOCALHOST=1
                       option described above under -httpsredir applies for
                       the LibVNCServer httpd server in all cases (ssl or not.)

-ssh user@host:disp    Create a remote listening port on machine "host"
                       via a SSH tunnel using the -R rport:localhost:lport
                       method. lport will be the local x11vnc listening port,
                       so a connection to rport (5900+disp) on "host"
                       will reach x11vnc.  E.g. fred@snoopy.com:0

                       This could be useful if a firewall/router prevents
                       incoming connections to the x11vnc machine, but
                       the ssh machine "host" can be reached by the VNC
                       viewer. "user@" is not needed unless the remote unix
                       username differs from the current one.

                       By default the remote sshd is usually configured to
                       listen only on localhost for rport, so the viewer may
                       need to ssh -L redir to "host" as well (See SSVNC to
                       automate this).  The sshd setting GatewayPorts enables
                       listening on all interfaces for rport; viewers can
                       reach it more easily.

                       "disp" is the VNC display for the remote SSH side,
                       e.g. 0 corresponds to port 5900, etc.  If disp is
                       greater than 200 the value is used as the port.  Use a
                       negative value to force a low port, e.g. host:-80 will
                       use port 80.

                       If ssh-agent is not active, then the ssh password needs
                       to be entered in the terminal where x11vnc is running.

                       By default the remote ssh will issue a 'sleep 300' to
                       wait for the incoming connection for 5 mins.  To modify
                       this use user@host:disp+secs.

                       If the remote SSH server is on a non-standard port
                       (i.e. not 22) use user@host:port:disp+secs.

                       Note that the ssh process MAY NOT be killed when
                       x11vnc exits.  It tries by looking at ps(1) output.

-usepw                 If no other password method was supplied on the command
                       line, first look for ~/.vnc/passwd and if found use it
                       with -rfbauth; next, look for ~/.vnc/passwdfile and
                       use it with -passwdfile; otherwise, prompt the user
                       for a password to create ~/.vnc/passwd and use it with
                       the -rfbauth option.  If none of these succeed x11vnc
                       exits immediately.

-storepasswd pass file Store password "pass" as the VNC password in the
                       file "file".  Once the password is stored the
                       program exits.  Use the password via "-rfbauth file"

                       If called with no arguments, "x11vnc -storepasswd",
                       the user is prompted for a password and it is stored
                       in the file ~/.vnc/passwd.  Called with one argument,
                       that will be the file to store the prompted password in.

-nopw                  Disable the big warning message when you use x11vnc
                       without some sort of password.

-accept string         Run a command (possibly to prompt the user at the
                       X11 display) to decide whether an incoming client
                       should be allowed to connect or not.  "string" is
                       an external command run via system(3) or some special
                       cases described below.  Be sure to quote "string"
                       if it contains spaces, shell characters, etc.  If the
                       external command returns 0 the client is accepted,
                       otherwise the client is rejected.  See below for an
                       extension to accept a client view-only.

                       If x11vnc is running as root (say from inetd(8) or from
                       display managers xdm(1), gdm(1), etc), think about the
                       security implications carefully before supplying this
                       option (likewise for the -gone option).

                       Environment: The RFB_CLIENT_IP environment variable will
                       be set to the incoming client IP number and the port
                       in RFB_CLIENT_PORT (or -1 if unavailable).  Similarly,
                       RFB_SERVER_IP and RFB_SERVER_PORT (the x11vnc side
                       of the connection), are set to allow identification
                       of the tcp virtual circuit.  The x11vnc process
                       id will be in RFB_X11VNC_PID, a client id number in
                       RFB_CLIENT_ID, and the number of other connected clients
                       in RFB_CLIENT_COUNT.  RFB_MODE will be "accept".
                       RFB_STATE will be PROTOCOL_VERSION, SECURITY_TYPE,
                       AUTHENTICATION, INITIALISATION, NORMAL, or UNKNOWN
                       indicating up to which state the client has achieved.
                       RFB_LOGIN_VIEWONLY will be 0, 1, or -1 (unknown).
                       RFB_USERNAME, RFB_LOGIN_TIME, and RFB_CURRENT_TIME may
                       also be set.

                       If "string" is "popup" then a builtin popup window
                       is used.  The popup will time out after 120 seconds,
                       use "popup:N" to modify the timeout to N seconds
                       (use 0 for no timeout).

                       In the case of "popup" and when the -unixpw option
                       is specified, then a *second* window will be popped
                       up after the user successfully logs in via his UNIX
                       password.  This time the user will be identified as
                       UNIX:username@hostname, the "UNIX:" prefix indicates
                       which user the viewer logged as via -unixpw.  The first
                       popup is only for whether to allow him to even *try*
                       to login via unix password.

                       If "string" is "xmessage" then an xmessage(1)
                       invocation is used for the command.  xmessage must be
                       installed on the machine for this to work.

                       Both "popup" and "xmessage" will present an option
                       for accepting the client "View-Only" (the client
                       can only watch).  This option will not be presented if
                       -viewonly has been specified, in which case the entire
                       display is view only.

                       If the user supplied command is prefixed with something
                       like "yes:0,no:*,view:3 mycommand ..." then this
                       associates the numerical command return code with
                       the actions: accept, reject, and accept-view-only,
                       respectively.  Use "*" instead of a number to indicate
                       the default action (in case the command returns an
                       unexpected value).  E.g. "no:*" is a good choice.

                       Note that x11vnc blocks while the external command
                       or popup is running (other clients may see no updates
                       during this period).  So a person sitting a the physical
                       display is needed to respond to an popup prompt. (use
                       a 2nd x11vnc if you lock yourself out).

                       More -accept tricks: use "popupmouse" to only allow
                       mouse clicks in the builtin popup to be recognized.
                       Similarly use "popupkey" to only recognize
                       keystroke responses.  These are to help avoid the
                       user accidentally accepting a client by typing or
                       clicking. All 3 of the popup keywords can be followed
                       by +N+M to supply a position for the popup window.
                       The default is to center the popup window.
-afteraccept string    As -accept, except to run a user supplied command after
                       a client has been accepted and authenticated. RFB_MODE
                       will be set to "afteraccept" and the other RFB_*
                       variables are as in -accept.  Unlike -accept, the
                       command return code is not interpreted by x11vnc.
                       Example: -afteraccept 'killall xlock &'
-gone string           As -accept, except to run a user supplied command when
                       a client goes away (disconnects).  RFB_MODE will be
                       set to "gone" and the other RFB_* variables are as
                       in -accept.  The "popup" actions apply as well.
                       Unlike -accept, the command return code is not
                       interpreted by x11vnc.  Example: -gone 'xlock &'

-users list            If x11vnc is started as root (say from inetd(8) or from
                       display managers xdm(1), gdm(1), etc), then as soon
                       as possible after connections to the X display are
                       established try to switch to one of the users in the
                       comma separated "list".  If x11vnc is not running as
                       root this option is ignored.

                       Why use this option?  In general it is not needed since
                       x11vnc is already connected to the X display and can
                       perform its primary functions.  The option was added
                       to make some of the *external* utility commands x11vnc
                       occasionally runs work properly.  In particular under
                       GNOME and KDE to implement the "-solid color" feature
                       external commands (gconftool-2 and dcop) unfortunately
                       must be run as the user owning the desktop session.
                       Since this option switches userid it also affects the
                       userid used to run the processes for the -accept and
                       -gone options.  It also affects the ability to read
                       files for options such as -connect, -allow, and -remap
                       and also the ultra and tight filetransfer feature if
                       enabled.  Note that the -connect file is also sometimes
                       written to.

                       So be careful with this option since in some situations
                       its use can decrease security.

                       In general the switch to a user will only take place
                       if the display can still be successfully opened as that
                       user (this is primarily to try to guess the actual owner
                       of the session). Example: "-users fred,wilma,betty".
                       Note that a malicious local user "barney" by
                       quickly using "xhost +" when logging in may possibly
                       get the x11vnc process to switch to user "fred".
                       What happens next?

                       Under display managers it may be a long time before
                       the switch succeeds (i.e. a user logs in).  To instead
                       make it switch immediately regardless if the display
                       can be reopened prefix the username with the "+"
                       character. E.g. "-users +bob" or "-users +nobody".

                       The latter (i.e. switching immediately to user
                       "nobody") is the only obvious use of the -users option
                       that increases security.

                       Use the following notation to associate a group with
                       a user: user1.group1,user2.group2,...  Note that
                       initgroups(2) will still be called first to try to
                       switch to ALL of a user's groups (primary and additional
                       groups).  Only if that fails or it is not available
                       then the single group specified as above (or the user's
                       primary group if not specified) is switched to with
                       setgid(2).  Use -env X11VNC_SINGLE_GROUP=1 to prevent
                       trying initgroups(2) and only switch to the single
                       group.  This sort of setting is only really needed to
                       make the ultra or tight filetransfer permissions work
                       properly. This format applies to any comma separated list
                       of users, even the special "=" modes described below.

                       In -unixpw mode, if "-users unixpw=" is supplied
                       then after a user authenticates himself via the
                       -unixpw mechanism, x11vnc will try to switch to that
                       user as though "-users +username" had been supplied.
                       If you want to limit which users this will be done for,
                       provide them as a comma separated list after "unixpw="
                       Groups can also be specified as described above.

                       Similarly, in -ssl mode, if "-users sslpeer=" is
                       supplied then after an SSL client authenticates with his
                       cert (the -sslverify option is required for this) x11vnc
                       will extract a UNIX username from the "emailAddress"
                       field (username@hostname.com) of the "Subject" of the
                       x509 SSL cert and then try to switch to that user as
                       though "-users +username" had been supplied.  If you
                       want to limit which users this will be done for, provide
                       them as a comma separated list after "sslpeer=".
                       Set the env. var X11VNC_SSLPEER_CN to use the Common
                       Name (normally a hostname) instead of the Email field.

                       NOTE: for sslpeer= mode the x11vnc administrator must
                       take care that any client certs he adds to -sslverify
                       have the intended UNIX username in the "emailAddress"
                       field of the cert.  Otherwise a user may be able to
                       log in as another.  This command can be of use in
                       checking: "openssl x509 -text -in file.crt", see the
                       "Subject:" line.  Also, along with the normal RFB_*
                       env. vars. (see -accept) passed to external cmd=
                       commands, RFB_SSL_CLIENT_CERT will be set to the
                       client's x509 certificate string.

                       The sslpeer= mode can aid finding X sessions via the
                       FINDDISPLAY and FINDCREATEDISPLAY mechanisms.

                       To immediately switch to a user *before* connections
                       to the X display are made or any files opened use the
                       "=" character: "-users =bob".  That user needs to
                       be able to open the X display and any files of course.

                       The special user "guess=" means to examine the utmpx
                       database (see who(1)) looking for a user attached to
                       the display number (from DISPLAY or -display option)
                       and try him/her.  To limit the list of guesses, use:
                       "-users guess=bob,betty".

                       Even more sinister is the special user "lurk="
                       that means to try to guess the DISPLAY from the utmpx
                       login database as well.  So it "lurks" waiting for
                       anyone to log into an X session and then connects to it.
                       Specify a list of users after the = to limit which users
                       will be tried.  To enable a different searching mode, if
                       the first user in the list is something like ":0" or
                       ":0-2" that indicates a range of DISPLAY numbers that
                       will be tried (regardless of whether they are in the
                       utmpx database) for all users that are logged in.  Also
                       see the "-display WAIT:..." functionality.  Examples:
                       "-users lurk=" and also "-users lurk=:0-1,bob,mary"

                       Be especially careful using the "guess=" and "lurk="
                       modes.  They are not recommended for use on machines
                       with untrustworthy local users.

-noshm                 Do not use the MIT-SHM extension for the polling.
                       Remote displays can be polled this way: be careful this
                       can use large amounts of network bandwidth.  This is
                       also of use if the local machine has a limited number
                       of shm segments and -onetile is not sufficient.
-flipbyteorder         Sometimes needed if remotely polled host has different
                       endianness.  Ignored unless -noshm is set.
-onetile               Do not use the new copy_tiles() framebuffer mechanism,
                       just use 1 shm tile for polling.  Limits shm segments
                       used to 3.

                       To disable any automatic shm reduction set the
                       env. var. X11VNC_NO_LIMIT_SHM.

-solid [color]         To improve performance, when VNC clients are connected
                       try to change the desktop background to a solid color.
                       The [color] is optional: the default color is "cyan4".
                       For a different one specify the X color (rgb.txt name,
                       e.g. "darkblue" or numerical "#RRGGBB").

                       Currently this option only works on GNOME, KDE, CDE,
                       XFCE, and classic X (i.e. with the background image
                       on the root window).  The "gconftool-2", "dcop"
                       and "xfconf-query" external commands are run for
                       GNOME, KDE, and XFCE respectively.  This also works
                       on native MacOSX.  (There is no color selection for
                       MacOSX or XFCE.)  Other desktops won't work, (send
                       us the corresponding commands if you find them).
                       If x11vnc is running as root (inetd(8) or gdm(1)),
                       the -users option may be needed for GNOME, KDE, XFCE.
                       If x11vnc guesses your desktop incorrectly, you can
                       force it by prefixing color with "gnome:", "kde:",
                       "cde:", "xfce:", or "root:".

                       Update: -solid no longer works on KDE4.

                       This mode works in a limited way on the Mac OS X Console
                       with one color ('kelp') using the screensaver writing
                       to the background.  Look in "~/Library/Screen Savers"
                       for VncSolidColor.png to change the color.

-blackout string       Black out rectangles on the screen. "string" is a
                       comma separated list of WxH+X+Y type geometries for
                       each rectangle.  If one of the items on the list is the
                       string "noptr" the mouse pointer will not be allowed
                       to go into a blacked out region.
-xinerama              If your screen is composed of multiple monitors
-noxinerama            glued together via XINERAMA, and that screen is
                       not a rectangle this option will try to guess the
                       areas to black out (if your system has libXinerama).
                       default: -xinerama

                       In general, we have noticed on XINERAMA displays you may
                       need to use the "-xwarppointer" option if the mouse
                       pointer misbehaves and it is enabled by default. Use
                       "-noxwarppointer" if you do not want this.

-xtrap                 Use the DEC-XTRAP extension for keystroke and mouse
                       input insertion.  For use on legacy systems, e.g. X11R5,
                       running an incomplete or missing XTEST extension.
                       By default DEC-XTRAP will be used if XTEST server grab
                       control is missing, use -xtrap to do the keystroke and
                       mouse insertion via DEC-XTRAP as well.

-xrandr [mode]         If the display supports the XRANDR (X Resize, Rotate
                       and Reflection) extension, and you expect XRANDR events
                       to occur to the display while x11vnc is running, this
                       options indicates x11vnc should try to respond to
                       them (as opposed to simply crashing by assuming the
                       old screen size).  See the xrandr(1) manpage and run
                       'xrandr -q' for more info.  [mode] is optional and
                       described below.

                       Since watching for XRANDR events and trapping errors
                       increases polling overhead, only use this option if
                       XRANDR changes are expected.  For example on a rotatable
                       screen PDA or laptop, or using a XRANDR-aware Desktop
                       where you resize often.  It is best to be viewing with a
                       vncviewer that supports the NewFBSize encoding, since it
                       knows how to react to screen size changes.  Otherwise,
                       LibVNCServer tries to do so something reasonable for
                       viewers that cannot do this (portions of the screen
                       may be clipped, unused, etc).

                       Note: the default now is to check for XRANDR events, but
                       do not trap every X call that may fail due to resize.
                       If a resize event is received, the full -xrandr mode
                       is enabled.  To disable even checking for events supply:
                       -noxrandr.

                       "mode" defaults to "resize", which means create a
                       new, resized, framebuffer and hope all viewers can cope
                       with the change.  "newfbsize" means first disconnect
                       all viewers that do not support the NewFBSize VNC
                       encoding, and then resize the framebuffer.  "exit"
                       means disconnect all viewer clients, and then terminate
                       x11vnc.

-rotate string         Rotate and/or flip the framebuffer view exported by VNC.
                       This transformation is independent of XRANDR and is
                       done in software in main memory and so may be slower.
                       This mode could be useful on a handheld with portrait or
                       landscape modes that do not correspond to the scanline
                       order of the actual framebuffer.  "string" can be:

                             x     flip along x-axis
                             y     flip along y-axis
                            xy     flip along x- and y-axes
                           +90     rotate 90 degrees clockwise
                           -90     rotate 90 degrees counter-clockwise
                          +90x     rotate 90 degrees CW, then flip along x
                          +90y     rotate 90 degrees CW, then flip along y

                       these give all possible rotations and reflections.

                       Aliases: same as xy:  yx, +180, -180, 180
                                same as -90: +270, 270
                                same as +90: 90, (ditto for 90x, 90y)

                       Like -scale, this transformation is applied at the very
                       end of any chain of framebuffer transformations and so
                       any options with geometries, e.g. -blackout, -clip, etc.
                       are relative to the original X (or -rawfb) framebuffer,
                       not the final one sent to VNC viewers.

                       If you do not want the cursor shape to be rotated
                       prefix "string" with "nc:", e.g. "nc:+90",
                       "nc:xy", etc.

-padgeom WxH           Whenever a new vncviewer connects, the framebuffer is
                       replaced with a fake, solid black one of geometry WxH.
                       Shortly afterwards the framebuffer is replaced with the
                       real one.  This is intended for use with vncviewers
                       that do not support NewFBSize and one wants to make
                       sure the initial viewer geometry will be big enough
                       to handle all subsequent resizes (e.g. under -xrandr,
                       -remote id:windowid, rescaling, etc.)

                       In -unixpw mode this sets the size of the login screen.
                       Use "once:WxH" it ignore padgeom after the login
                       screen is set up.

-o logfile             Write stderr messages to file "logfile" instead of to
                       the terminal.  Same as "-logfile file".  To append
                       to the file use "-oa file" or "-logappend file".
                       If "logfile" contains the string "%VNCDISPLAY"
                       it is expanded to the vnc display (the name may need
                       to be guessed at.)  "%HOME" works too.

-flag file             Write the "PORT=NNNN" (e.g. PORT=5900) string to
                       "file" in addition to stdout.  This option could be
                       useful by wrapper script to detect when x11vnc is ready.

-rmflag file           Remove "file" at exit to signal when x11vnc is done.
                       The file is created at startup if it does not already
                       exist or if "file" is prefixed with "create:".
                       If the file is created, the x11vnc PID is placed in
                       the file.  Otherwise the files contents is not changed.
                       Use prefix "nocreate:" to prevent creation.

-rc filename           Use "filename" instead of $HOME/.x11vncrc for rc file.
-norc                  Do not process any .x11vncrc file for options.

-env VAR=VALUE         Set the environment variable 'VAR' to value 'VALUE'
                       at x11vnc startup.  This is a convenience utility to
                       avoid shell script wrappers, etc. to set the env. var.
                       You may specify as many of these as needed on the
                       command line.
-prog /path/to/x11vnc  Set the full path to the x11vnc program for cases when
                       it cannot be determined from argv[0] (e.g. tcpd/inetd)

-h, -help              Print this help text.
-?, -opts              Only list the x11vnc options.
-V, -version           Print program version and last modification date.
-license               Print out license information.  Same as -copying and
                       -warranty.

-dbg                   Instead of exiting after cleaning up, run a simple
                       "debug crash shell" when fatal errors are trapped.

-q, -quiet             Be quiet by printing less informational output to
                       stderr. (use -noquiet to undo an earlier -quiet.)

                       The -quiet option does not eliminate all informational
                       output, it only reduces it.  It is ignored in most
                       auxiliary usage modes, e.g. -storepasswd.  To eliminate
                       all output use: 2>/dev/null 1>&2, etc.

-v, -verbose           Print out more information to stderr.

-bg                    Go into the background after screen setup.  Messages to
                       stderr are lost unless -o logfile is used.  Something
                       like this could be useful in a script:
                        port=`ssh -t $host "x11vnc -display :0 -bg" | grep PORT`
                        port=`echo "$port" | sed -e 's/PORT=//'`
                        port=`expr $port - 5900`
                        vncviewer $host:$port

-modtweak              Option -modtweak automatically tries to adjust the AltGr
-nomodtweak            and Shift modifiers for differing language keyboards
                       between client and host.  Otherwise, only a single key
                       press/release of a Keycode is simulated (i.e. ignoring
                       the state of the modifiers: this usually works for
                       identical keyboards).  Also useful in resolving cases
                       where a Keysym is bound to multiple keys (e.g. "<" + ">"
                       and "," + "<" keys).  Default: -modtweak

                       If you are having trouble with with keys and -xkb or
                       -noxkb, and similar things don't help, try -nomodtweak.

                       On some HP-UX systems it is been noted that they have
                       an odd keymapping where a single keycode will have a
                       keysym, e.g. "#", up to three times.  You can check
                       via "xmodmap -pk" or the -dk option.  The failure
                       is when you try to type "#" it yields "3".  If you
                       see this problem try setting the environment variable
                       MODTWEAK_LOWEST=1 to see if it helps.

-xkb                   When in modtweak mode, use the XKEYBOARD extension (if
-noxkb                 the X display supports it) to do the modifier tweaking.
                       This is powerful and should be tried if there are still
                       keymapping problems when using -modtweak by itself.
                       The default is to check whether some common keysyms,
                       e.g. !, @, [, are only accessible via -xkb mode and if
                       so then automatically enable the mode.  To disable this
                       automatic detection use -noxkb.

                       When -xkb mode is active you can set these env. vars.
                       They apply only when there is ambiguity as to which
                       key to choose (i.e the mapping is not one-to-one).
                       NOKEYHINTS=1: for up ascii keystrokes do not use score
                       hints saved when the key was pressed down. NOANYDOWN=1:
                       for up keystrokes do not resort to searching through
                       keys that are currently pressed down.  KEYSDOWN=N:
                       remember the last N keys press down for tie-breaking
                       when an up keystroke comes in.

-capslock              When in -modtweak (the default) or -xkb mode,
                       if a keysym in the range A-Z comes in check the X
                       server to see if the Caps_Lock is set.  If it is do
                       not artificially press Shift to generate the keysym.
                       This will enable the CapsLock key to behave correctly
                       in some circumstances: namely *both* the VNC viewer
                       machine and the x11vnc X server are in the CapsLock
                       on state.  If one side has CapsLock on and the other
                       off and the keyboard is not behaving as you think it
                       should you should correct the CapsLock states (hint:
                       pressing CapsLock inside and outside of the viewer can
                       help toggle them both to the correct state).  However,
                       for best results do not use this option, but rather
                       *only* enable CapsLock on the VNC viewer side (i.e. by
                       pressing CapsLock outside of the viewer window, also
                       -skip_lockkeys below).  Also try -nomodtweak for a
                       possible workaround.

-skip_lockkeys         Have x11vnc ignore all Caps_Lock, Shift_Lock, Num_Lock,
-noskip_lockkeys       Scroll_Lock keysyms received from viewers.  The idea is
                       you press Caps_Lock on the VNC Viewer side but that does
                       not change the lock state in the x11vnc-side X server.
                       Nevertheless your capitalized letters come in over
                       the wire and are applied correctly to the x11vnc-side
                       X server.  Note this mode probably won't do what you
                       want in -nomodtweak mode.  Also, a kludge for KP_n
                       digits is always done in this mode: they are mapped to
                       regular digit keysyms.  See also -capslock above.
                       The default is -noskip_lockkeys.

-skip_keycodes string  Ignore the comma separated list of decimal keycodes.
                       Perhaps these are keycodes not on your keyboard but
                       your X server thinks exist.  Currently only applies
                       to -xkb mode.  Use this option to help x11vnc in the
                       reverse problem it tries to solve: Keysym -> Keycode(s)
                       when ambiguities exist (more than one Keycode per
                       Keysym).  Run 'xmodmap -pk' to see your keymapping.
                       Example: "-skip_keycodes 94,114"
-sloppy_keys           Experimental option that tries to correct some
                       "sloppy" key behavior.  E.g. if at the viewer you
                       press Shift+Key but then release the Shift before
                       Key that could give rise to extra unwanted characters
                       (usually only between keyboards of different languages).
                       Only use this option if you observe problems with
                       some keystrokes.
-skip_dups             Some VNC viewers send impossible repeated key events,
-noskip_dups           e.g. key-down, key-down, key-up, key-up all for the same
                       key, or 20 downs in a row for the same modifier key!
                       Setting -skip_dups means to skip these duplicates and
                       just process the first event. Note: some VNC viewers
                       assume they can send down's without the corresponding
                       up's and so you should not set this option for
                       these viewers (symptom: some keys do not autorepeat)
                       Default: -noskip_dups
-add_keysyms           If a Keysym is received from a VNC viewer and that
-noadd_keysyms         Keysym does not exist in the X server, then add the
                       Keysym to the X server's keyboard mapping on an unused
                       key.  Added Keysyms will be removed periodically and
                       also when x11vnc exits.  Default: -add_keysyms
-clear_mods            At startup and exit clear the modifier keys by sending
                       KeyRelease for each one. The Lock modifiers are skipped.
                       Used to clear the state if the display was accidentally
                       left with any pressed down.
-clear_keys            As -clear_mods, except try to release ANY pressed key.
                       Note that this option and -clear_mods can interfere
                       with a person typing at the physical keyboard.
-clear_all             As -clear_keys, except try to release any CapsLock,
                       NumLock, etc. locks as well.

-remap string          Read Keysym remappings from file named "string".
                       Format is one pair of Keysyms per line (can be name
                       or hex value) separated by a space.  If no file named
                       "string" exists, it is instead interpreted as this
                       form: key1-key2,key3-key4,...  See <X11/keysymdef.h>
                       header file for a list of Keysym names, or use xev(1).

                       To map a key to a button click, use the fake Keysyms
                       "Button1", ..., etc. E.g: "-remap Super_R-Button2"
                       (useful for pasting on a laptop)

                       I use these if the machine I am viewing from does not
                       have a scrollwheel or I don't like using the one it has:

                              -remap Super_R-Button4,Menu-Button5
                              -remap KP_Add-Button4,KP_Enter-Button5

                       the former would be used on a PC, the latter on a
                       MacBook.  This way those little used keys can be used
                       to generate bigger hops than the Up and Down arrows
                       provide.  One can scroll through text or web pages more
                       quickly this way (especially if x11vnc scroll detection
                       is active.)

                       Use Button44, Button12, etc. for multiple clicks.

                       To disable a keysym (i.e. make it so it will not be
                       injected), remap it to "NoSymbol" or "None".

                       Dead keys: "dead" (or silent, mute) keys are keys that
                       do not produce a character but must be followed by a 2nd
                       keystroke.  This is often used for accenting characters,
                       e.g. to put "`" on top of "a" by pressing the dead
                       key and then "a".  Note that this interpretation
                       is not part of core X11, it is up to the toolkit or
                       application to decide how to react to the sequence.
                       The X11 names for these keysyms are "dead_grave",
                       "dead_acute", etc.  However some VNC viewers send the
                       keysyms "grave", "acute" instead thereby disabling
                       the accenting.  To work around this -remap can be used.
                       For example "-remap grave-dead_grave,acute-dead_acute"
                       As a convenience, "-remap DEAD" applies these remaps:

                               g     grave-dead_grave
                               a     acute-dead_acute
                               c     asciicircum-dead_circumflex
                               t     asciitilde-dead_tilde
                               m     macron-dead_macron
                               b     breve-dead_breve
                               D     abovedot-dead_abovedot
                               d     diaeresis-dead_diaeresis
                               o     degree-dead_abovering
                               A     doubleacute-dead_doubleacute
                               r     caron-dead_caron
                               e     cedilla-dead_cedilla

                       If you just want a subset use the first letter
                       label, e.g. "-remap DEAD=ga" to get the first two.
                       Additional remaps may also be supplied via commas,
                       e.g.  "-remap DEAD=ga,Super_R-Button2".  Finally,
                       "DEAD=missing" means to apply all of the above as
                       long as the left hand member is not already in the
                       X11 keymap.

-norepeat              Option -norepeat disables X server key auto repeat when
-repeat                VNC clients are connected and VNC keyboard input is
                       not idle for more than 5 minutes.  This works around a
                       repeating keystrokes bug (triggered by long processing
                       delays between key down and key up client events:
                       either from large screen changes or high latency).
                       Default: -norepeat

                       You can set the env. var. X11VNC_IDLE_TIMEOUT to the
                       number of idle seconds you want (5min = 300secs).

                       Note: your VNC viewer side will likely do autorepeating,
                       so this is no loss unless someone is simultaneously at
                       the real X display.

                       Use "-norepeat N" to set how many times norepeat will
                       be reset if something else (e.g. X session manager)
                       undoes it.  The default is 2.  Use a negative value
                       for unlimited resets.

-nofb                  Ignore video framebuffer: only process keyboard and
                       pointer.  Intended for use with Win2VNC and x2vnc
                       dual-monitor setups.
-nobell                Do not watch for XBell events. (no beeps will be heard)
                       Note: XBell monitoring requires the XKEYBOARD extension.
-nosel                 Do not manage exchange of X selection/cutbuffer between
                       VNC viewers and the X server at all.
-noprimary             Do not poll the PRIMARY selection for changes to send
                       back to clients.  (PRIMARY is still set on received
                       changes, however).
-nosetprimary          Do not set the PRIMARY selection for changes received
                       from VNC clients.
-noclipboard           Do not poll the CLIPBOARD selection for changes to send
                       back to clients.  (CLIPBOARD is still set on received
                       changes, however).
-nosetclipboard        Do not set the CLIPBOARD selection for changes
                       received from VNC clients.
-seldir string         If direction string is "send", only send the selection
                       to viewers, and if it is "recv" only receive it from
                       viewers.  To work around apps setting the selection
                       too frequently and messing up the other end.  You can
                       actually supply a comma separated list of directions,
                       including "debug" to turn on debugging output.

-cursor [mode]         Sets how the pointer cursor shape (little icon at the
-nocursor              mouse pointer) should be handled.  The "mode" string
                       is optional and is described below.  The default
                       is to show some sort of cursor shape(s).  How this
                       is done depends on the VNC viewer and the X server.
                       Use -nocursor to disable cursor shapes completely.

                       Some VNC viewers support the TightVNC CursorPosUpdates
                       and CursorShapeUpdates extensions (cuts down on
                       network traffic by not having to send the cursor image
                       every time the pointer is moved), in which case these
                       extensions are used (see -nocursorshape and -nocursorpos
                       below to disable).  For other viewers the cursor shape
                       is written directly to the framebuffer every time the
                       pointer is moved or changed and gets sent along with
                       the other framebuffer updates.  In this case, there
                       will be some lag between the vnc viewer pointer and
                       the remote cursor position.

                       If the X display supports retrieving the cursor shape
                       information from the X server, then the default is
                       to use that mode.  On Solaris this can be done with
                       the SUN_OVL extension using -overlay (see also the
                       -overlay_nocursor option).  A similar overlay scheme
                       is used on IRIX.  Xorg (e.g. Linux) and recent Solaris
                       Xsun servers support the XFIXES extension to retrieve
                       the exact cursor shape from the X server.  If XFIXES
                       is present it is preferred over Overlay and is used by
                       default (see -noxfixes below).  This can be disabled
                       with -nocursor, and also some values of the "mode"
                       option below.

                       Note that under XFIXES cursors with transparency (alpha
                       channel) will usually not be exactly represented and one
                       may find Overlay preferable.  See also the -alphacut
                       and -alphafrac options below as fudge factors to try
                       to improve the situation for cursors with transparency
                       for a given theme.

                       The "mode" string can be used to fine-tune the
                       displaying of cursor shapes.  It can be used the
                       following ways:

                       "-cursor arrow" - just show the standard arrow
                       nothing more or nothing less.

                       "-cursor none" - same as "-nocursor"

                       "-cursor X" - when the cursor appears to be on the
                       root window, draw the familiar X shape.  Some desktops
                       such as GNOME cover up the root window completely,
                       and so this will not work, try "X1", etc, to try to
                       shift the tree depth.  On high latency links or slow
                       machines there will be a time lag between expected and
                       the actual cursor shape.

                       "-cursor some" - like "X" but use additional
                       heuristics to try to guess if the window should have
                       a windowmanager-like resizer cursor or a text input
                       I-beam cursor.  This is a complete hack, but may be
                       useful in some situations because it provides a little
                       more feedback about the cursor shape.

                       "-cursor most" - try to show as many cursors as
                       possible.  Often this will only be the same as "some"
                       unless the display has overlay visuals or XFIXES
                       extensions available.  On Solaris and IRIX if XFIXES
                       is not available, -overlay mode will be attempted.

-cursor_drag           Show cursor shape changes even when the mouse is being
                       dragged with a mouse button down.  This is useful if you
                       want to be able to see Drag-and-Drop cursor icons, etc.

-arrow n               Choose an alternate "arrow" cursor from a set of
                       some common ones.  n can be 1 to 6.  Default is: 1
                       Ignored when in XFIXES cursor-grabbing mode.

-noxfixes              Do not use the XFIXES extension to draw the exact cursor
                       shape even if it is available.

                       Note: To work around a crash in Xorg 1.5 and later
                       some people needed to use -noxfixes.  The Xorg crash
                       occurred right after a Display Manager (e.g. GDM) login.
                       Starting with x11vnc 0.9.9 it tries to automatically
                       avoid using XFIXES until it is sure a window manager
                       is running.  See the -reopen option for more info and
                       how to use X11VNC_AVOID_WINDOWS=never to disable it.

-alphacut n            When using the XFIXES extension for the cursor shape,
                       cursors with transparency will not usually be displayed
                       exactly (but opaque ones will).  This option sets n as
                       a cutoff for cursors that have transparency ("alpha
                       channel" with values ranging from 0 to 255) Any cursor
                       pixel with alpha value less than n becomes completely
                       transparent.  Otherwise the pixel is completely opaque.
                       Default 240

-alphafrac fraction    With the threshold in -alphacut some cursors will become
                       almost completely transparent because their alpha values
                       are not high enough.  For those cursors adjust the
                       alpha threshold until fraction of the non-zero alpha
                       channel pixels become opaque.  Default 0.33
-alpharemove           By default, XFIXES cursors pixels with transparency have
                       the alpha factor multiplied into the RGB color values
                       (i.e. that corresponding to blending the cursor with a
                       black background).  Specify this option to remove the
                       alpha factor. (useful for light colored semi-transparent
                       cursors).
-noalphablend          In XFIXES mode do not send cursor alpha channel data
                       to LibVNCServer.  The default is to send it.  The
                       alphablend effect will only be visible in -nocursorshape
                       mode or for clients with cursorshapeupdates turned
                       off. (However there is a hack for 32bpp with depth 24,
                       it uses the extra 8 bits to store cursor transparency
                       for use with a hacked vncviewer that applies the
                       transparency locally.  See the FAQ for more info).

-nocursorshape         Do not use the TightVNC CursorShapeUpdates extension
                       even if clients support it.  See -cursor above.
-cursorpos             Option -cursorpos enables sending the X cursor position
-nocursorpos           back to all vnc clients that support the TightVNC
                       CursorPosUpdates extension.  Other clients will be able
                       to see the pointer motions. Default: -cursorpos
-xwarppointer          Move the pointer with XWarpPointer(3X) instead of
-noxwarppointer        the XTEST extension.  Use this as a workaround
                       if the pointer motion behaves incorrectly, e.g.
                       on touchscreens or other non-standard setups.

                       It is also sometimes needed on XINERAMA displays and is
                       enabled by default if XINERAMA is found to be active.
                       To prevent this, use -noxwarppointer.

-always_inject         Even if there is no displacement (dx = dy = 0) for a
                       VNC mouse event force the pointer to the indicated x,y
                       position anyway.  Recent (2009) gui toolkits (gnome)
                       have problems with x11vnc's original mouse input
                       injection method.  So x11vnc's mouse input injection
                       method has been modified.  To regain the OLD behavior
                       use this option: -always_inject.  Then x11vnc will
                       always force positioning the mouse to the x,y position
                       even if that position has not changed since the previous
                       VNC input event.

                       The first place this problem was noticed was in gnome
                       terminal: if you pressed and released mouse button 3, a
                       menu was posted and then its first element 'New Terminal
                       Window' was activated.  This was because x11vnc injected
                       the mouse position twice: once on ButtonPress and again
                       on ButtonRelease.  The toolkit interpreted the 2nd one
                       as mouse motion even though the mouse hadn't moved.
                       So now by default x11vnc tries to avoid injecting the
                       2nd one.

                       Note that with the new default x11vnc will be oblivious
                       to applications moving the pointer (warping) or the
                       user at the physical display moving it.  So it might,
                       e.g., inject ButtonRelease at the wrong position.
                       If this (or similar scenarios) causes problems in your
                       environment, specify -always_inject for the old method.

-buttonmap string      String to remap mouse buttons.  Format: IJK-LMN, this
                       maps buttons I -> L, etc., e.g.  -buttonmap 13-31

                       Button presses can also be mapped to keystrokes: replace
                       a button digit on the right of the dash with :<sym>:
                       or :<sym1>+<sym2>: etc. for multiple keys. For example,
                       if the viewing machine has a mouse-wheel (buttons 4 5)
                       but the x11vnc side does not, these will do scrolls:
                              -buttonmap 12345-123:Prior::Next:
                              -buttonmap 12345-123:Up+Up+Up::Down+Down+Down:

                       See <X11/keysymdef.h> header file for a list of Keysyms,
                       or use the xev(1) program.  Note: mapping of button
                       clicks to Keysyms may not work if -modtweak or -xkb is
                       needed for the Keysym.

                       If you include a modifier like "Shift_L" the
                       modifier's up/down state is toggled, e.g. to send
                       "The" use :Shift_L+t+Shift_L+h+e: (the 1st one is
                       shift down and the 2nd one is shift up). (note: the
                       initial state of the modifier is ignored and not reset)
                       To include button events use "Button1", ... etc.

                       -buttonmap currently does not work on MacOSX console
                       or in -rawfb mode.

                       Workaround: use -buttonmap IJ...-LM...=n to limit the
                       number of mouse buttons to n, e.g. 123-123=3.  This will
                       prevent x11vnc from crashing if the X server reports
                       there are 5 buttons (4/5 scroll wheel), but there are
                       only really 3.

-nodragging            Do not update the display during mouse dragging events
                       (mouse button held down).  Greatly improves response on
                       slow setups, but you lose all visual feedback for drags,
                       text selection, and some menu traversals.  It overrides
                       any -pointer_mode setting.

-ncache n              Client-side caching scheme.  Framebuffer memory "n"
                       (an integer) times that of the full display is allocated
                       below the actual framebuffer to cache screen contents
                       for rapid retrieval.  So a W x H frambuffer is expanded
                       to a W x (n+1)*H one.  Use 0 to disable.

                       The "n" is actually optional, the default is 10.

                       For this and the other -ncache* options below you can
                       abbreviate "-ncache" with "-nc".  Also, "-nonc"
                       is the same as "-ncache 0"

                       This is an experimental option, currently implemented in
                       an awkward way in that in the VNC Viewer you can see the
                       pixel cache contents if you scroll down, etc.  So you
                       will have to set things up so you can't see that region.
                       If this method is successful, the changes required for
                       clients to do this less awkwardly will be investigated.

                       The SSVNC viewer does a good job at automatically hiding
                       the pixel cache region.  Or use SSVNC's -ycrop option
                       to explicitly hide the region.

                       Note that this mode consumes a huge amount of memory,
                       both on the x11vnc server side and on the VNC Viewer
                       side.  If n=2 then the amount of RAM used is roughly
                       tripled for both x11vnc and the VNC Viewer.  As a rule
                       of thumb, note that 1280x1024 at depth 24 is about 5MB
                       of pixel data.

                       For reasonable response when cycling through 4 to 6
                       large (e.g. web browser) windows a value n of 6 to 12
                       is recommended. (that's right: ~10X more memory...)

                       Because of the way window backingstore and saveunders
                       are implemented, n must be even.  It will be incremented
                       by 1 if it is not.

                       This mode also works for native MacOS X, but may not
                       be as effective as the X version.  This is due to a
                       number of things, one is the drop-shadow compositing
                       that leaves extra areas that need to be repaired (see
                       -ncache_pad).  Another is the window iconification
                       animations need to be avoided (see -macicontime).
                       It appears the that the 'Scale' animation mode gives
                       better results than the 'Genie' one.  Also, window event
                       detection not as accurate as the X version.

-ncache_cr             In -ncache mode, try to do copyrect opaque window
                       moves/drags instead of wireframes (this can induce
                       painting errors).  The wireframe will still be used when
                       moving a window whose save-unders has not yet been set
                       or has been invalidated.

                       Some VNC Viewers provide better response than others
                       with this option.  On Unix, realvnc viewer gives
                       smoother drags than tightvnc viewer.  Response may also
                       be choppy if the server side machine is too slow.

                       Sometimes on very slow modem connections, this actually
                       gives an improvement because no pixel data at all
                       (not even the box animation) is sent during the drag.

-ncache_no_moveraise   In -ncache mode, do not assume that moving a window
                       will cause the window manager to raise it to the top
                       of the stack.  The default is to assume it does, and
                       so at the beginning of any wireframe, etc, window moves
                       the window will be pushed to top in the VNC viewer.

-ncache_no_dtchange    In -ncache mode, do not try to guess when the desktop
                       (viewport) changes to another one (i.e. another
                       workarea).  The default is to try to guess and when
                       detected try to make the transistion more smoothly.

-ncache_no_rootpixmap  In -ncache mode, do not try to snapshot the desktop
                       background to use in guessing or reconstructing window
                       save-unders.

-ncache_keep_anims     In -ncache mode, do not try to disable window
                       manager animations and other effects (that usually
                       degrade ncache performance or cause painting errors).
                       The default is to try to disable them on KDE (but not
                       GNOME) when VNC clients are connected.

                       For other window managers or desktops that provide
                       animations, effects, compositing, translucency,
                       etc. that interfere with the -ncache method you will
                       have to disable them manually.

-ncache_old_wm         In -ncache mode, enable some heuristics for old style
                       window managers such as fvwm and twm.

-ncache_pad n          In -ncache mode, pad each window with n pixels for the
                       caching rectangles.  This can be used to try to improve
                       the situation with dropshadows or other compositing
                       (e.g. MacOS X window manager), although it could make
                       things worse.  The default is 0 on Unix and 24 on
                       MacOS X.
-debug_ncache          Turn on debugging and profiling output under -ncache.

-wireframe [str]       Try to detect window moves or resizes when a mouse
-nowireframe           button is held down and show a wireframe instead of
                       the full opaque window.  This is based completely on
                       heuristics and may not always work: it depends on your
                       window manager and even how you move things around.
                       See -pointer_mode below for discussion of the "bogging
                       down" problem this tries to avoid.
                       Default: -wireframe

                       Shorter aliases:  -wf [str]  and -nowf

                       The value "str" is optional and, of course, is
                       packed with many tunable parameters for this scheme:

                       Format: shade,linewidth,percent,T+B+L+R,mod,t1+t2+t3+t4
                       Default: 0xff,2,0,32+8+8+8,all,0.15+0.30+5.0+0.125

                       If you leave nothing between commas: ",," the default
                       value is used.  If you don't specify enough commas,
                       the trailing parameters are set to their defaults.

                       "shade" indicate the "color" for the wireframe,
                       usually a greyscale: 0-255, however for 16 and 32bpp you
                       can specify an rgb.txt X color (e.g. "dodgerblue") or
                       a value > 255 is treated as RGB (e.g. red is 0xff0000).
                       "linewidth" sets the width of the wireframe in pixels.
                       "percent" indicates to not apply the wireframe scheme
                       to windows with area less than this percent of the
                       full screen.

                       "T+B+L+R" indicates four integers for how close in
                       pixels the pointer has to be from the Top, Bottom, Left,
                       or Right edges of the window to consider wireframing.
                       This is a speedup to quickly exclude a window from being
                       wireframed: set them all to zero to not try the speedup
                       (scrolling and selecting text will likely be slower).

                       "mod" specifies if a button down event in the
                       interior of the window with a modifier key (Alt, Shift,
                       etc.) down should indicate a wireframe opportunity.
                       It can be "0" or "none" to skip it, "1" or "all"
                       to apply it to any modifier, or "Shift", "Alt",
                       "Control", "Meta", "Super", or "Hyper" to only
                       apply for that type of modifier key.

                       "t1+t2+t3+t4" specify four floating point times in
                       seconds: t1 is how long to wait for the pointer to move,
                       t2 is how long to wait for the window to start moving
                       or being resized (for some window managers this can be
                       rather long), t3 is how long to keep a wireframe moving
                       before repainting the window. t4 is the minimum time
                       between sending wireframe "animations".  If a slow
                       link is detected, these values may be automatically
                       changed to something better for a slow link.

-nowireframelocal      By default, mouse motion and button presses of a
                       user sitting at the LOCAL display are monitored for
                       wireframing opportunities (so that the changes will be
                       sent efficiently to the VNC clients).  Use this option
                       to disable this behavior.

-wirecopyrect mode     Since the -wireframe mechanism evidently tracks moving
-nowirecopyrect        windows accurately, a speedup can be obtained by
                       telling the VNC viewers to locally copy the translated
                       window region.  This is the VNC CopyRect encoding:
                       the framebuffer update doesn't need to send the actual
                       new image data.

                       Shorter aliases:  -wcr [mode]  and -nowcr

                       "mode" can be "never" (same as -nowirecopyrect)
                       to never try the copyrect, "top" means only do it if
                       the window was not covered by any other windows, and
                       "always" means to translate the orginally unobscured
                       region (this may look odd as the remaining pieces come
                       in, but helps on a slow link).  Default: "always"

                       Note: there can be painting errors or slow response
                       when using -scale so you may want to disable CopyRect
                       in this case "-wirecopyrect never" on the command
                       line or by remote-control.  Or you can also use the
                       "-scale xxx:nocr" scale option.

-debug_wireframe       Turn on debugging info printout for the wireframe
                       heuristics.  "-dwf" is an alias.  Specify multiple
                       times for more output.

-scrollcopyrect mode   Like -wirecopyrect, but use heuristics to try to guess
-noscrollcopyrect      if a window has scrolled its contents (either vertically
                       or horizontally).  This requires the RECORD X extension
                       to "snoop" on X applications (currently for certain
                       XCopyArea and XConfigureWindow X protocol requests).
                       Examples: Hitting <Return> in a terminal window when the
                       cursor was at the bottom, the text scrolls up one line.
                       Hitting <Down> arrow in a web browser window, the web
                       page scrolls up a small amount.  Or scrolling with a
                       scrollbar or mouse wheel.

                       Shorter aliases:  -scr [mode]  and -noscr

                       This scheme will not always detect scrolls, but when
                       it does there is a nice speedup from using the VNC
                       CopyRect encoding (see -wirecopyrect).  The speedup
                       is both in reduced network traffic and reduced X
                       framebuffer polling/copying.  On the other hand, it may
                       induce undesired transients (e.g. a terminal cursor
                       being scrolled up when it should not be) or other
                       painting errors (window tearing, bunching-up, etc).
                       These are automatically repaired in a short period
                       of time.  If this is unacceptable disable the feature
                       with -noscrollcopyrect.

                       Screen clearing kludges:  for testing at least, there
                       are some "magic key sequences" (must be done in less
                       than 1 second) to aid repairing painting errors that
                       may be seen when using this mode:

                       3 Alt_L's   in a row: resend whole screen,
                       4 Alt_L's   in a row: reread and resend whole screen,
                       3 Super_L's in a row: mark whole screen for polling,
                       4 Super_L's in a row: reset RECORD context,
                       5 Super_L's in a row: try to push a black screen

                       note: Alt_L is the Left "Alt" key (a single key)
                       Super_L is the Left "Super" key (Windows flag).
                       Both of these are modifier keys, and so should not
                       generate characters when pressed by themselves.  Also,
                       your VNC viewer may have its own refresh hot-key
                       or button.

                       "mode" can be "never" (same as -noscrollcopyrect)
                       to never try the copyrect, "keys" means to try it
                       in response to keystrokes only, "mouse" means to
                       try it in response to mouse events only, "always"
                       means to do both. Default: "always"

                       Note: there can be painting errors or slow response
                       when using -scale so you may want to disable CopyRect
                       in this case "-scrollcopyrect never" on the command
                       line or by remote-control.  Or you can also use the
                       "-scale xxx:nocr" scale option.

-scr_area n            Set the minimum area in pixels for a rectangle
                       to be considered for the -scrollcopyrect detection
                       scheme.  This is to avoid wasting the effort on small
                       rectangles that would be quickly updated the normal way.
                       E.g. suppose an app updated the position of its skinny
                       scrollbar first and then shifted the large panel
                       it controlled.  We want to be sure to skip the small
                       scrollbar and get the large panel. Default: 60000

-scr_skip list         Skip scroll detection for applications matching
                       the comma separated list of strings in "list".
                       Some applications implement their scrolling in
                       strange ways where the XCopyArea, etc, also applies
                       to invisible portions of the window: if we CopyRect
                       those areas it looks awful during the scroll and
                       there may be painting errors left after the scroll.
                       Soffice.bin is the worst known offender.

                       Use "##" to denote the start of the application class
                       (e.g. "##XTerm") and "++" to denote the start
                       of the application instance name (e.g. "++xterm").
                       The string your list is matched against is of the form
                       "^^WM_NAME##Class++Instance<same-for-any-subwindows>"
                       The "xlsclients -la" command will provide this info.

                       If a pattern is prefixed with "KEY:" it only applies
                       to Keystroke generated scrolls (e.g. Up arrow).  If it
                       is prefixed with "MOUSE:" it only applies to Mouse
                       induced scrolls (e.g. dragging on a scrollbar).
                       Default: ##Soffice.bin,##StarOffice,##OpenOffice

-scr_inc list          Opposite of -scr_skip: this list is consulted first
                       and if there is a match the window will be monitored
                       via RECORD for scrolls irrespective of -scr_skip.
                       Use -scr_skip '*' to skip anything that does not match
                       your -scr_inc.  Use -scr_inc '*' to include everything.

-scr_keys list         For keystroke scroll detection, only apply the RECORD
                       heuristics to the comma separated list of keysyms in
                       "list".  You may find the RECORD overhead for every
                       one of your keystrokes disrupts typing too much, but you
                       don't want to turn it off completely with "-scr mouse"
                       and -scr_parms does not work or is too confusing.

                       The listed keysyms can be numeric or the keysym
                       names in the <X11/keysymdef.h> header file or from the
                       xev(1) program.  Example: "-scr_keys Up,Down,Return".
                       One probably wants to have application specific lists
                       (e.g. for terminals, etc) but that is too icky to think
                       about for now...

                       If "list" begins with the "-" character the list
                       is taken as an exclude list: all keysyms except those
                       list will be considered.  The special string "builtin"
                       expands to an internal list of keysyms that are likely
                       to cause scrolls.  BTW, by default modifier keys,
                       Shift_L, Control_R, etc, are skipped since they almost
                       never induce scrolling by themselves.

-scr_term list         Yet another cosmetic kludge.  Apply shell/terminal
                       heuristics to applications matching comma separated
                       list (same as for -scr_skip/-scr_inc).  For example an
                       annoying transient under scroll detection is if you
                       hit Enter in a terminal shell with full text window,
                       the solid text cursor block will be scrolled up.
                       So for a short time there are two (or more) block
                       cursors on the screen.  There are similar scenarios,
                       (e.g. an output line is duplicated).

                       These transients are induced by the approximation of
                       scroll detection (e.g. it detects the scroll, but not
                       the fact that the block cursor was cleared just before
                       the scroll).  In nearly all cases these transient errors
                       are repaired when the true X framebuffer is consulted
                       by the normal polling.  But they are distracting, so
                       what this option provides is extra "padding" near the
                       bottom of the terminal window: a few extra lines near
                       the bottom will not be scrolled, but rather updated
                       from the actual X framebuffer.  This usually reduces
                       the annoying artifacts.  Use "none" to disable.
                       Default: "term"

-scr_keyrepeat lo-hi   If a key is held down (or otherwise repeats rapidly) and
                       this induces a rapid sequence of scrolls (e.g. holding
                       down an Arrow key) the "scrollcopyrect" detection
                       and overhead may not be able to keep up.  A time per
                       single scroll estimate is performed and if that estimate
                       predicts a sustainable scrollrate of keys per second
                       between "lo" and "hi" then repeated keys will be
                       DISCARDED to maintain the scrollrate. For example your
                       key autorepeat may be 25 keys/sec, but for a large
                       window or slow link only 8 scrolls per second can be
                       sustained, then roughly 2 out of every 3 repeated keys
                       will be discarded during this period. Default: "4-20"

-scr_parms string      Set various parameters for the scrollcopyrect mode.
                       The format is similar to that for -wireframe and packed
                       with lots of parameters:

                       Format: T+B+L+R,t1+t2+t3,s1+s2+s3+s4+s5
                       Default: 0+64+32+32,0.02+0.10+0.9,0.03+0.06+0.5+0.1+5.0

                       If you leave nothing between commas: ",," the default
                       value is used.  If you don't specify enough commas,
                       the trailing parameters are set to their defaults.

                       "T+B+L+R" indicates four integers for how close in
                       pixels the pointer has to be from the Top, Bottom, Left,
                       or Right edges of the window to consider scrollcopyrect.
                       If -wireframe overlaps it takes precedence.  This is a
                       speedup to quickly exclude a window from being watched
                       for scrollcopyrect: set them all to zero to not try
                       the speedup (things like selecting text will likely
                       be slower).

                       "t1+t2+t3" specify three floating point times in
                       seconds that apply to scrollcopyrect detection with
                       *Keystroke* input: t1 is how long to wait after a key
                       is pressed for the first scroll, t2 is how long to keep
                       looking after a Keystroke scroll for more scrolls.
                       t3 is how frequently to try to update surrounding
                       scrollbars outside of the scrolling area (0.0 to
                       disable)

                       "s1+s2+s3+s4+s5" specify five floating point times
                       in seconds that apply to scrollcopyrect detection with
                       *Mouse* input: s1 is how long to wait after a mouse
                       button is pressed for the first scroll, s2 is how long
                       to keep waiting for additional scrolls after the first
                       Mouse scroll was detected.  s3 is how frequently to
                       try to update surrounding scrollbars outside of the
                       scrolling area (0.0 to disable).  s4 is how long to
                       buffer pointer motion (to try to get fewer, bigger
                       mouse scrolls). s5 is the maximum time to spend just
                       updating the scroll window without updating the rest
                       of the screen.

-fixscreen string      Periodically "repair" the screen based on settings
                       in "string".  Hopefully you won't need this option,
                       it is intended for cases when the -scrollcopyrect or
                       -wirecopyrect features leave too many painting errors,
                       but it can be used for any scenario.  This option
                       periodically performs costly operations and so
                       interactive response may be reduced when it is on.
                       You can use 3 Alt_L's (the Left "Alt" key) taps in
                       a row (as described under -scrollcopyrect) instead to
                       manually request a screen repaint when it is needed.

                       "string" is a comma separated list of one or more of
                       the following: "V=t", "C=t", "X=t", and "8=t".
                       In these "t" stands for a time in seconds (it is
                       a floating point even though one should usually use
                       values > 2 to avoid wasting resources).  V sets how
                       frequently the entire screen should be sent to viewers
                       (it is like the 3 Alt_L's).  C sets how long to wait
                       after a CopyRect to repaint the full screen.  X sets
                       how frequently to reread the full X11 framebuffer from
                       the X server and push it out to connected viewers.
                       Use of X should be rare, please report a bug if you
                       find you need it. 8= applies only for -8to24 mode: it
                       sets how often the non-default visual regions of the
                       screen (e.g. 8bpp windows) are refreshed.  Examples:
                       -fixscreen V=10 -fixscreen C=10

-debug_scroll          Turn on debugging info printout for the scroll
                       heuristics.  "-ds" is an alias.  Specify it multiple
                       times for more output.

-noxrecord             Disable any use of the RECORD extension.  This is
                       currently used by the -scrollcopyrect scheme and to
                       monitor X server grabs.

-grab_buster           Some of the use of the RECORD extension can leave a
-nograb_buster         tiny window for XGrabServer deadlock.  This is only if
                       the whole-server grabbing application expects mouse or
                       keyboard input before releasing the grab.  It is usually
                       a window manager that does this.  x11vnc takes care to
                       avoid the problem, but if caught x11vnc will freeze.
                       Without -grab_buster, the only solution is to go the
                       physical display and give it some input to satisfy the
                       grabbing app.  Or manually kill and restart the window
                       manager if that is feasible.  With -grab_buster, x11vnc
                       will fork a helper thread and if x11vnc appears to be
                       stuck in a grab after a period of time (20-30 sec) then
                       it will inject some user input: button clicks, Escape,
                       mouse motion, etc to try to break the grab.  If you
                       experience a lot of grab deadlock, please report a bug.

-debug_grabs           Turn on debugging info printout with respect to
                       XGrabServer() deadlock for -scrollcopyrect mode.

-debug_sel             Turn on debugging info printout with respect to
                       PRIMARY, CLIPBOARD, and CUTBUFFER0 selections.

-pointer_mode n        Various pointer motion update schemes. "-pm" is
                       an alias.  The problem is pointer motion can cause
                       rapid changes on the screen: consider the rapid
                       changes when you drag a large window around opaquely.
                       Neither x11vnc's screen polling and vnc compression
                       routines nor the bandwidth to the vncviewers can keep
                       up these rapid screen changes: everything will bog down
                       when dragging or scrolling.  So a scheme has to be used
                       to "eat" much of that pointer input before re-polling
                       the screen and sending out framebuffer updates. The
                       mode number "n" can be 0 to 4 and selects one of
                       the schemes desribed below.

                       Note that the -wireframe and -scrollcopyrect modes
                       complement -pointer_mode by detecting (and improving)
                       certain periods of "rapid screen change".

                       n=0: does the same as -nodragging. (all screen polling
                       is suspended if a mouse button is pressed.)

                       n=1: was the original scheme used to about Jan 2004:
                       it basically just skips -input_skip keyboard or pointer
                       events before repolling the screen.

                       n=2 is an improved scheme: by watching the current rate
                       of input events it tries to detect if it should try to
                       "eat" additional pointer events before continuing.

                       n=3 is basically a dynamic -nodragging mode: it detects
                       when the mouse motion has paused and then refreshes
                       the display.

                       n=4 attempts to measures network rates and latency,
                       the video card read rate, and how many tiles have been
                       changed on the screen.  From this, it aggressively tries
                       to push screen "frames" when it decides it has enough
                       resources to do so.  NOT FINISHED.

                       The default n is 2. Note that modes 2, 3, 4 will skip
                       -input_skip keyboard events (but it will not count
                       pointer events).  Also note that these modes are not
                       available in -threads mode which has its own pointer
                       event handling mechanism.

                       To try out the different pointer modes to see which
                       one gives the best response for your usage, it is
                       convenient to use the remote control function, for
                       example "x11vnc -R pm:4" or the tcl/tk gui (Tuning ->
                       pointer_mode -> n).

-input_skip n          For the pointer handling when non-threaded: try to
                       read n user input events before scanning display. n < 0
                       means to act as though there is always user input.
                       Default: 10

-allinput              Have x11vnc read and process all available client input
                       before proceeding.

-input_eagerly         Similar to -allinput but use the handleEventsEagerly
                       mechanism built into LibVNCServer.

-speeds rd,bw,lat      x11vnc tries to estimate some speed parameters that
                       are used to optimize scheduling (e.g. -pointer_mode
                       4, -wireframe, -scrollcopyrect) and other things.
                       Use the -speeds option to set these manually.
                       The triple "rd,bw,lat" corresponds to video h/w
                       read rate in MB/sec, network bandwidth to clients in
                       KB/sec, and network latency to clients in milliseconds,
                       respectively.  If a value is left blank, e.g. "-speeds
                       ,100,15", then the internal scheme is used to estimate
                       the empty value(s).

                       Typical PC video cards have read rates of 5-10 MB/sec.
                       If the framebuffer is in main memory instead of video
                       h/w (e.g. SunRay, shadowfb, dummy driver, Xvfb), the
                       read rate may be much faster.  "x11perf -getimage500"
                       can be used to get a lower bound (remember to factor
                       in the bytes per pixel).  It is up to you to estimate
                       the network bandwith and latency to clients.  For the
                       latency the ping(1) command can be used.

                       For convenience there are some aliases provided,
                       e.g. "-speeds modem".  The aliases are: "modem" for
                       6,4,200; "dsl" for 6,100,50; and "lan" for 6,5000,1

-wmdt string           For some features, e.g. -wireframe and -scrollcopyrect,
                       x11vnc has to work around issues for certain window
                       managers or desktops (currently kde and xfce).
                       By default it tries to guess which one, but it can
                       guess incorrectly.  Use this option to indicate which
                       wm/dt.  "string" can be "gnome", "kde", "cde",
                       "xfce", or "root" (classic X wm).  Anything else
                       is interpreted as "root".

-debug_pointer         Print debugging output for every pointer event.
-debug_keyboard        Print debugging output for every keyboard event.
                       Same as -dp and -dk, respectively.  Use multiple
                       times for more output.

-defer time            Time in ms to delay sending updates to connected clients
                       (deferUpdateTime)  Default: 20

-wait time             Time in ms to pause between screen polls.  Used to cut
                       down on load.  Default: 20

-extra_fbur n          Perform extra FrameBufferUpdateRequests checks to
                       try to be in better sync with the client's requests.
                       What this does is perform extra polls of the client
                       socket at critical times (before '-defer' and '-wait'
                       calls.)  The default is n=1.  Set to a larger number to
                       insert more checks or set to n=0 to disable.  A downside
                       of these extra calls is that more mouse input may be
                       processed than desired.

-wait_ui factor        Factor by which to cut the -wait time if there
                       has been recent user input (pointer or keyboard).
                       Improves response, but increases the load whenever you
                       are moving the mouse or typing.  Default: 2.00
-setdefer n            When the -wait_ui mechanism cuts down the wait time ms,
                       set the defer time to the same ms value. n=1 to enable,
                       0 to disable, and -1 to set defer to 0 (no delay).
                       Similarly, 2 and -2 indicate 'urgent_update' mode should
                       be used to push the updates even sooner.  Default: 1
-nowait_bog            Do not detect if the screen polling is "bogging down"
                       and sleep more.  Some activities with no user input can
                       slow things down a lot: consider a large terminal window
                       with a long build running in it continuously streaming
                       text output.  By default x11vnc will try to detect this
                       (3 screen polls in a row each longer than 0.25 sec with
                       no user input), and sleep up to 1.5 secs to let things
                       "catch up".  Use this option to disable that detection.
-slow_fb time          Floating point time in seconds to delay all screen
                       polling.  For special purpose usage where a low frame
                       rate is acceptable and desirable, but you want the
                       user input processed at the normal rate so you cannot
                       use -wait.
-xrefresh time         Floating point time in seconds to indicate how often to
                       do the equivalent of xrefresh(1) to force all windows
                       (in the viewable area if -id, -sid, or -clip is used)
                       to repaint themselves.  Use this only if applications
                       misbehave by not repainting themselves properly.
                       See also -noxdamage.
-nap                   Monitor activity and if it is low take longer naps
-nonap                 between screen polls to really cut down load when idle.
                       Default: take naps
-sb time               Time in seconds after NO activity (e.g. screen blank)
                       to really throttle down the screen polls (i.e. sleep
                       for about 1.5 secs). Use 0 to disable.  Default: 60
                       Set the env. var. X11VNC_SB_FACTOR to scale it.

-readtimeout n         Set LibVNCServer rfbMaxClientWait to n seconds. On
                       slow links that take a long time to paint the first
                       screen LibVNCServer may hit the timeout and drop the
                       connection.  Default: 20 seconds.
-ping n                Send a 1x1 framebuffer update to all clients every n
                       seconds (e.g. to try to keep a network connection alive)

-nofbpm                If the system supports the FBPM (Frame Buffer Power
-fbpm                  Management) extension (i.e. some Sun systems), then
                       prevent the video h/w from going into a reduced power
                       state when VNC clients are connected.

                       FBPM capable video h/w save energy when the workstation
                       is idle by going into low power states (similar to DPMS
                       for monitors).  This interferes with x11vnc's polling
                       of the framebuffer data.

                       "-nofbpm" means prevent FBPM low power states whenever
                       VNC clients are connected, while "-fbpm" means to not
                       monitor the FBPM state at all.  See the xset(1) manpage
                       for details.  -nofbpm is basically the same as running
                       "xset fbpm force on" periodically.  Default: -fbpm

-nodpms                If the system supports the DPMS (Display Power Management
-dpms                  Signaling) extension, then prevent the monitor from
                       going into a reduced power state when VNC clients
                       are connected.

                       DPMS reduced power monitor states are a good thing
                       and you normally want the power down to take place
                       (usually x11vnc has no problem exporting the display in
                       this state).  You probably only want to use "-nodpms"
                       to work around problems with Screen Savers kicking
                       on in DPMS low power states.  There is known problem
                       with kdesktop_lock on KDE where the screen saver keeps
                       kicking in every time user input stops for a second
                       or two.  Specifying "-nodpms" works around it.

                       "-nodpms" means prevent DPMS low power states whenever
                       VNC clients are connected, while "-dpms" means to not
                       monitor the DPMS state at all.  See the xset(1) manpage
                       for details.  -nodpms is basically the same as running
                       "xset dpms force on" periodically.  Default: -dpms

-forcedpms             If the system supports the DPMS (Display Power
                       Management Signaling) extension, then try to keep the
                       monitor in a powered off state.  This is to prevent
                       nosey people at the physical display from viewing what
                       is on the screen.  Be sure to lock the screen before
                       disconnecting.

                       This method is far from bullet proof, e.g. suppose
                       someone attaches a non-DPMS monitor, or loads the
                       machine so that there is a gap of time before x11vnc
                       restores the powered off state?  On many machines if
                       he floods it with keyboard and mouse input he can see
                       flashes of what is on the screen before the DPMS off
                       state is reestablished.  For this to work securely
                       there would need to be support in the X server to do
                       this exactly rather than approximately with DPMS.

-clientdpms            As -forcedpms but only when VNC clients are connected.

-noserverdpms          The UltraVNC ServerInput extension is supported.
                       This allows the VNC viewer to click a button that will
                       cause the server (x11vnc) to try to disable keyboard
                       and mouse input at the physical display and put the
                       monitor in dpms powered off state.  Use this option to
                       skip powering off the monitor.

-noultraext            Disable the following UltraVNC extensions: SingleWindow
                       and ServerInput.  The others managed by LibVNCServer
                       (textchat, 1/n scaling, rfbEncodingUltra) are not.

-chatwindow            Place a local UltraVNC chat window on the X11 display
                       that x11vnc is polling.  That way the person on the VNC
                       viewer-side can chat with the person at the physical
                       X11 console. (e.g. helpdesk w/o telephone)

                       For this to work the SSVNC package (version 1.0.21 or
                       later) MUST BE installed on the system where x11vnc runs
                       and the 'ssvnc' command must be available in $PATH.
                       The ssvncviewer is used as a chat window helper.
                       See http://www.karlrunge.com/x11vnc/ssvnc.html

                       This option implies '-rfbversion 3.6' so as to trick
                       UltraVNC viewers, otherwise they assume chat is not
                       available.  To specify a different rfbversion, place
                       it after the -chatwindow option on the cmdline.

                       See also the remote control 'chaton' and 'chatoff'
                       actions.  These can also be set from the tkx11vnc GUI.

-noxdamage             Do not use the X DAMAGE extension to detect framebuffer
                       changes even if it is available.  Use -xdamage if your
                       default is to have it off.

                       x11vnc's use of the DAMAGE extension: 1) significantly
                       reduces the load when the screen is not changing much,
                       and 2) detects changed areas (small ones by default)
                       more quickly.

                       Currently the DAMAGE extension is overly conservative
                       and often reports large areas (e.g. a whole terminal
                       or browser window) as damaged even though the actual
                       changed region is much smaller (sometimes just a few
                       pixels).  So heuristics were introduced to skip large
                       areas and use the damage rectangles only as "hints"
                       for the traditional scanline polling.  The following
                       tuning parameters are introduced to adjust this
                       behavior:

-xd_area A             Set the largest DAMAGE rectangle area "A" (in
                       pixels: width * height) to trust as truly damaged:
                       the rectangle will be copied from the framebuffer
                       (slow) no matter what.  Set to zero to trust *all*
                       rectangles. Default: 20000
-xd_mem f              Set how long DAMAGE rectangles should be "remembered",
                       "f" is a floating point number and is in units of the
                       scanline repeat cycle time (32 iterations).  The default
                       (1.0) should give no painting problems. Increase it if
                       there are problems or decrease it to live on the edge
                       (perhaps useful on a slow machine).

-sigpipe string        Broken pipe (SIGPIPE) handling.  "string" can be
                       "ignore" or "exit".  For "ignore" LibVNCServer
                       will handle the abrupt loss of a client and continue,
                       for "exit" x11vnc will cleanup and exit at the 1st
                       broken connection.

                       This option is not really needed since LibVNCServer
                       is doing the correct thing now for quite some time.
                       However, for convenience you can use it to ignore other
                       signals, e.g. "-sigpipe ignore:HUP,INT,TERM" in case
                       that would be useful for some sort of application.
                       You can also put "exit:.." in the list to have x11vnc
                       cleanup on the listed signals. "-sig" is an alias
                       for this option if you don't like the 'pipe'. Example:
                       -sig ignore:INT,TERM,exit:USR1

-threads               Whether or not to use the threaded LibVNCServer
-nothreads             algorithm [rfbRunEventLoop] if libpthread is available.
                       In this mode new threads (one for input and one
                       for output) are created to handle each new client.
                       Default: -nothreads.

                       Thread stability is much improved in version 0.9.8.

                       Multiple clients in threaded mode should be stable
                       for the ZRLE encoding on all platforms.  The Tight and
                       Zlib encodings are currently only stable on Linux for
                       multiple clients.  Compile with -DTLS=__thread if your
                       OS and compiler and linker support it.

                       For resizes (randr, etc.) set this env. var. to the number
                       of milliseconds to sleep: X11VNC_THREADS_NEW_FB_SLEEP
                       at various places in the do_new_fb() action.  This is to
                       let various activities settle.  Default is about 500ms.

                       Multiple clients in threaded mode could yield better
                       performance for 'class-room' broadcasting usage; also in
                       -appshare broadcast mode.  See also the -reflect option.

-fs f                  If the fraction of changed tiles in a poll is greater
                       than f, the whole screen is updated.  Default: 0.75
-gaps n                Heuristic to fill in gaps in rows or cols of n or
                       less tiles.  Used to improve text paging.  Default: 4
-grow n                Heuristic to grow islands of changed tiles n or wider
                       by checking the tile near the boundary.  Default: 3
-fuzz n                Tolerance in pixels to mark a tiles edges as changed.
                       Default: 2
-debug_tiles           Print debugging output for tiles, fb updates, etc.

-snapfb                Instead of polling the X display framebuffer (fb)
                       for changes, periodically copy all of X display fb
                       into main memory and examine that copy for changes.
                       (This setting also applies for non-X -rawfb modes).
                       Under some circumstances this will improve interactive
                       response, or at least make things look smoother, but in
                       others (most!) it will make the response worse.  If the
                       video h/w fb is such that reading small tiles is very
                       slow this mode could help.  To keep the "framerate"
                       up the screen size x bpp cannot be too large.  Note that
                       this mode is very wasteful of memory I/O resources
                       (it makes full screen copies even if nothing changes).
                       It may be of use in video capture-like applications,
                       webcams, or where window tearing is a problem.

-rawfb string          Instead of polling X, poll the memory object specified
                       in "string".

                       For file polling, to memory map mmap(2) a file use:
                       "map:/path/to/a/file@WxHxB", with framebuffer Width,
                       Height, and Bits per pixel.  "mmap:..." is the
                       same.

                       If there is trouble with mmap, use "file:/..."
                       for slower lseek(2) based reading.

                       Use "snap:..." to imply -snapfb mode and the "file:"
                       access (this is for unseekable devices that only provide
                       the fb all at once, e.g. a video camera provides the
                       whole frame).

                       For shared memory segments string is of the form:
                       "shm:N@WxHxB" which specifies a shm key(or a shmid) N and with
                       WxHxB as above.  See shmat(1) and ipcs(1)
					   
                      Since shm key can be defined constantly, you should use 
                      shm key rather than shmid. Unless you have a special purpose, 
                      a mutable shmid may cause problems.

                      If there is a new desktop like Wayland, use "drm:" to access 
                      GPU FrameBuffer. If you do not know the GPU path, just use 
                      "/dev/dri/card0@WxHxB".

                       If you do not supply a type "map" is assumed if
                       the file exists (see the next paragraphs for some
                       exceptions to this.)

                       If string is "setup:cmd", then the command "cmd"
                       is run and the first line from it is read and used
                       as "string".  This allows initializing the device,
                       determining WxHxB, etc. These are often done as root
                       so take care.

                       If the string begins with "video", see the VIDEO4LINUX
                       discussion below where the device may be queried for
                       (and possibly set) the framebuffer parameters.

                       If the string begins with "console", "/dev/fb",
                       "fb", or "vt", see the LINUX CONSOLE discussion
                       below where the framebuffer device is opened and
                       keystrokes (and possibly mouse events) are inserted
                       into the console.

                       If the string begins with "vnc", see the VNC HOST
                       discussion below where the framebuffer is taken as that
                       of another remote VNC server.

                       Optional suffixes are ":R/G/B", "+O", and "#VWxVH" to
                       specify red, green, and blue masks (in hex), offset into
                       the memory object, and virtual width and height.

                       If the masks are not provided x11vnc guesses them based on
                       the bpp (if the colors look wrong, you need to provide the
                       masks.)

                       Another optional suffix is the Bytes Per Line which in
                       some cases is not WxB/8.  Specify it as WxHxB-BPL
                       e.g. 800x600x16-2048.  This could be a normal width
                       1024 at 16bpp fb, but only width 800 shows up.

                       The last optional suffix is virtual dimensions VWxVH. Some
                       devices will double buffer the display in the framebuffer,
                       allowing updating contents of display and then "panning"
                       to the buffer via yoffset. x11vnc will map the virutal
                       size specified by the options stead of just WxH, and track
                       yoffset appropriately so remote clients get all updates to
                       the frame buffer.

                       So the full format is: mode:file@WxHxB:R/G/B+O-BPL#VWxVH

                       Examples:
                           -rawfb shm:210337933@800x600x32:ff/ff00/ff0000
                           -rawfb drm:/dev/dri/card0@800x600x32:ff/ff00/ff0000
                           -rawfb map:/dev/fb0@1024x768x32
                           -rawfb map:/dev/fb0@800x480x16#800x960
                           -rawfb map:/tmp/Xvfb_screen0@640x480x8+3232
                           -rawfb file:/tmp/my.pnm@250x200x24+37
                           -rawfb file:/dev/urandom@128x128x8
                           -rawfb snap:/dev/video0@320x240x24 -24to32
                           -rawfb video0
                           -rawfb video -pipeinput VID
                           -rawfb console
                           -rawfb vt2
                           -rawfb vnc:somehost:0

                       (see ipcs(1) and fbset(1) for the first two examples)

                       In general all user input is discarded by default (see
                       the -pipeinput option for how to use a helper program
                       to insert).  Most of the X11 (screen, keyboard, mouse)
                       options do not make sense and many will cause this
                       mode to crash, so please think twice before setting or
                       changing them in a running x11vnc.

                       If you DO NOT want x11vnc to close the X DISPLAY in
                       rawfb mode, prepend a "+" e.g. +file:/dev/fb0...
                       Keeping the display open enables the default
                       remote-control channel, which could be useful.
                       Alternatively, if you specify -noviewonly, then the
                       mouse and keyboard input are STILL sent to the X
                       display, this usage should be very rare, i.e. doing
                       something strange with /dev/fb0.

                       If the device is not "seekable" (e.g. webcam) try
                       reading it all at once in full snaps via the "snap:"
                       mode (note: this is a resource hog).  If you are using
                       file: or map: AND the device needs to be reopened for
                       *every* snapfb snapshot, set the environment variable:
                       SNAPFB_RAWFB_RESET=1 as well.

                       If you want x11vnc to dynamically transform a 24bpp
                       rawfb to 32bpp (note that this will be slower) also
                       supply the -24to32 option.  This would be useful for,
                       say, a video camera that delivers the pixel data as
                       24bpp packed RGB.  This is the default under "video"
                       mode if the bpp is 24.

                       Normally the bits per pixel, B, is 8, 16, or 32 (or
                       rarely 24), however there is also some support for
                       B < 8 (e.g. old graphics displays 4 bpp or 1 bpp).
                       In this case you certainly must supply the masks as
                       well: WxHxB:R/G/B.  The pixels will be padded out to
                       8 bpp using depth 8 truecolor.  The scheme currently
                       does not work with snap fb (ask if interested.) B=1
                       monochrome example: file:/dev/urandom@128x128x1:1/1/1
                       Some other like this are 128x128x2:3/3/3 128x128x4:7/7/7

                       For B < 8 framebuffers you can also set the env. var
                       RAWFB_CGA=1 to try a CGA mapping for B=4 (e.g. linux
                       vga16fb driver.)  Note with low bpp and/or resolution
                       VGA and VGA16 modes on the Linux console one's attempt
                       to export them via x11vnc can often be thwarted due to
                       special color palettes, pixel packings, and even video
                       painting buffering.  OTOH, often experimenting with the
                       RGB masks can yield something recognizable.

                       VIDEO4LINUX: on Linux some attempt is made to handle
                       video devices (webcams or TV tuners) automatically.
                       The idea is the WxHxB will be extracted from the
                       device itself.  So if you do not supply "@WxHxB...
                       parameters x11vnc will try to determine them.  It first
                       tries the v4l API if that support has been compiled in.
                       Otherwise it will run the v4l-info(1) external program
                       if it is available.

                       The simplest examples are "-rawfb video" and "-rawfb
                       video1" which imply the device file /dev/video and
                       /dev/video1, respectively.  You can also supply the
                       /dev if you like, e.g. "-rawfb /dev/video0"

                       Since the video capture device framebuffer usually
                       changes continuously (e.g. brightness fluctuations),
                       you may want to use the -wait, -slow_fb, or -defer
                       options to lower the "framerate" to cut down on
                       network VNC traffic.

                       A more sophisticated video device scheme allows
                       initializing the device's settings using:

                           -rawfb video:<settings>

                       The prefix could also be, as above, e.g. "video1:" to
                       specify the device file.  The v4l API must be available
                       for this to work.  Otherwise, you will need to try
                       to initialize the device with an external program,
                       e.g. xawtv, spcaview, and hope they persist when x11vnc
                       re-opens the device.

                       <settings> is a comma separated list of key=value pairs.
                       The device's brightness, color, contrast, and hue can
                       be set to percentages, e.g. br=80,co=50,cn=44,hu=60.

                       The device filename can be set too if needed (if it
                       does not start with "video"), e.g. fn=/dev/qcam.

                       The width, height and bpp of the framebuffer can be
                       set via, e.g., w=160,h=120,bpp=16.

                       Related to the bpp above, the pixel format can be set
                       via the fmt=XXX, where XXX can be one of: GREY, HI240,
                       RGB555, RGB565, RGB24, and RGB32 (with bpp 8, 8, 16, 16,
                       24, and 32 respectively).  See http://www.linuxtv.org
                       for more info (V4L api).

                       For TV/rf tuner cards one can set the tuning mode
                       via tun=XXX where XXX can be one of PAL, NTSC, SECAM,
                       or AUTO.

                       One can switch the input channel by the inp=XXX setting,
                       where XXX is the name of the input channel (Television,
                       Composite1, S-Video, etc).  Use the name that is in the
                       information about the device that is printed at startup.

                       For input channels with tuners (e.g. Television) one
                       can change which station is selected by the sta=XXX
                       setting.  XXX is the station number.  Currently only
                       the ntsc-cable-us (US cable) channels are built into
                       x11vnc.  See the -freqtab option below to supply one
                       from xawtv. If XXX is greater than 500, then it is
                       interpreted as a raw frequency in KHz.

                       Example:

                       -rawfb video:br=80,w=320,h=240,fmt=RGB32,tun=NTSC,sta=47

                       one might need to add inp=Television too for the input
                       channel to be TV if the card doesn't come up by default
                       in that one.

                       Note that not all video capture devices will support
                       all of the above settings.

                       See the -pipeinput VID option below for a way to control
                       the settings through the VNC Viewer via keystrokes.
                       As a shortcut, if the string begins "Video.." instead
                       of "video.." then -pipeinput VID is implied.

                       As above, if you specify a "@WxHxB..." after the
                       <settings> string they are used verbatim: the device
                       is not queried for the current values.  Otherwise the
                       device will be queried.

                       LINUX CONSOLE:  The following describes some ways to
                       view and possibly interact with the Linux text/graphics
                       console (i.e. not X11 XFree86/Xorg)

                       Note: If the LibVNCServer LinuxVNC program is on your
                       system you may want to use that instead of the following
                       method because it will be faster and more accurate
                       for the Linux text console and includes mouse support.
                       There is, however, the basic LinuxVNC functionality in
                       x11vnc if you replace "console" with "vt" in the
                       examples below.

                       If the rawfb string begins with "console" the
                       framebuffer device /dev/fb0 is opened and /dev/tty0 is
                       opened too.  The latter is used to inject keystrokes
                       (not all are supported, but the basic ones are).
                       You will need to be root to inject keystrokes, but
                       not necessarily to open /dev/fb0.  /dev/tty0 refers to
                       the active VT, to indicate one explicitly, use, e.g.,
                       "console2" for /dev/tty2, etc. by indicating the
                       specific VT number.

                       For the Linux framebuffer device, /dev/fb0, (fb1,
                       etc) to be enabled the appropriate kernel drivers must
                       be loaded.  E.g. vesafb or vga16fb and also by setting
                       the boot parameter vga=0x301 (or 0x314, 0x317, etc.)
                       (The vga=... method is the preferred way; set your
                       machines up that way.)  Otherwise there will be a
                       'No such device' error.  You can also load a Linux
                       framebuffer driver specific to your make of video card
                       for more functionality.  Once the machine is booted one
                       can often 'modprobe' the fb driver as root to obtain
                       a framebuffer device.

                       If you cannot get /dev/fb0 working on Linux, try
                       using the LinuxVNC emulation mode by "-rawfb vtN"
                       where N = 1, ... 6 is the Linux Virtual Terminal (aka
                       virtual console) you wish to view, e.g. "-rawfb vt2".
                       Unlike /dev/fb mode, it need not be the active Virtual
                       Terminal.  Note that this mode can only show text and
                       not graphics.  x11vnc polls the text in /dev/vcsaN

                       Set the env. var. RAWFB_VCSA_BW=1 to disable colors in
                       the "vtN" mode (i.e. black and white only.)  If you
                       do not prefer the default 16bpp set RAWFB_VCSA_BPP to
                       8 or 32.  If you need to tweak the rawfb parameters by
                       using the 'console_guess' string printed at startup,
                       be sure to indicate the snap: method.

                       uinput: If the Linux version appears to be 2.6
                       or later and the "uinput" module appears to be
                       present (modprobe uinput), then the uinput method
                       will be used instead of /dev/ttyN.  uinput allows
                       insertion of BOTH keystrokes and mouse input and so it
                       preferred when accessing graphical (e.g. QT-embedded)
                       linux console apps.  It also provides more accurate
                       keystroke insertion.  See -pipeinput UINPUT below for
                       more information on this mode; you will have to use
                       -pipeinput if you want to tweak any UINPUT parameters.
                       You may also want to also use the -nodragging and
                       -cursor none options.  Use "console0", etc  or
                       -pipeinput CONSOLE to force the /dev/ttyN method.

                       Note you can change the Linux VT remotely using the
                       chvt(1) command to make the one you want be the active
                       one (e.g. 'chvt 3').  Sometimes switching out and back
                       corrects the framebuffer's graphics state.  For the
                       "-rawfb vtN" mode there is no need to switch the VT's.

                       To skip input injecting entirely use "consolex"
                       or "vtx".

                       The string "/dev/fb0" (1, etc.) can be used instead
                       of "console".  This can be used to specify a different
                       framebuffer device, e.g. /dev/fb1.  As a shortcut the
                       "/dev/" can be dropped.  If the name is something
                       nonstandard, use "console:/dev/foofb"

                       If you do not want x11vnc to guess the framebuffer's
                       WxHxB and masks automatically (sometimes the kernel
                       gives incorrect information), specify them with a @WxHxB
                       (and optional :R/G/B masks) at the end of the string.

                       Examples:
                           -rawfb console
                           -rawfb /dev/fb0           (same)
                           -rawfb console3           (force /dev/tty3)
                           -rawfb consolex           (no keystrokes or mouse)
                           -rawfb console:/dev/nonstd
                           -rawfb console -pipeinput UINPUT:accel=4.0
                           -rawfb vt3                (/dev/tty3 w/o /dev/fb0)

                       VNC HOST: if the -rawfb string is of the form
                       "vnc:host:N" then the VNC display "N" on the remote
                       VNC server "host" is connected to (i.e. x11vnc acts as
                       a VNC client itself) and that framebuffer is exported.

                       This mode is really only of use if you are trying
                       to improve performance in the case of many (e.g. >
                       10) simultaneous VNC viewers, and you try a divide
                       and conquer scheme to reduce bandwidth and improve
                       responsiveness.  (However, another user found this mode
                       useful to export a demo display through a slow link:
                       then multiple demo viewers connected to the reflecting
                       x11vnc on the fast side of the link, and so avoided
                       all of the demo viewers going through the slow link.)

                       For example, if there will be 64 simultaneous VNC
                       viewers this can lead to a lot of redundant VNC traffic
                       to and from the server host:N, extra CPU usage,
                       and all viewers response can be reduced by having
                       to wait for writes to the slowest client to finish.
                       However, if you set up 8 reflectors/repeaters started
                       with option -rawfb vnc:host:N, then there are only
                       8 connections to host:N.  Each repeater then handles
                       8 vnc viewer connections thereby spreading the load
                       around.  In classroom broadcast usage, try to put the
                       repeaters on different switches.  This mode is the same
                       as -reflect host:N.  Replace "host:N" by "listen"
                       or "listen:port" for a reverse connection.

                       Overall performance will not be as good as a single
                       direct connection because, among other things,
                       there is an additional level of framebuffer polling
                       and pointer motion can still induce many changes per
                       second that must be propagated.  Tip: if the remote VNC
                       is x11vnc doing wireframing, or an X display that does
                       wireframing that gives much better response than opaque
                       window dragging.  Consider the -nodragging option if
                       the problem is severe.

                       The env. var. X11VNC_REFLECT_PASSWORD can be set to
                       the password needed to log into the vnc host server, or
                       to "file:path_to_file" to indicate a file containing
                       the password as its first line.

                       To set the pixel format that x11vnc requests as a VNC
                       CLIENT set the env. vars: X11VNC_REFLECT_bitsPerSample
                       X11VNC_REFLECT_samplesPerPixel, and
                       X11VNC_REFLECT_bytesPerPixel; the defaults are 8, 3, 4.
                       2, 3, 1 would give a low color mode.  See the function
                       rfbGetClient() in libvncclient for more info.

                       The VNC HOST mode implies -shared.  Use -noshared as
                       a subsequent cmdline option to disable sharing.

-freqtab file          For use with "-rawfb video" for TV tuner devices to
                       specify station frequencies.  Instead of using the built
                       in ntsc-cable-us mapping of station number to frequency,
                       use the data in file.  For stations that are not
                       numeric, e.g. SE20, they are placed above the highest
                       numbered station in the order they are found.  Example:
                       "-freqtab /usr/X11R6/share/xawtv/europe-west.list"
                       You can make your own freqtab by copying the xawtv
                       format.

-pipeinput cmd         This option lets you supply an external command in
                       "cmd" that x11vnc will pipe all of the user input
                       events to in a simple format.  In -pipeinput mode by
                       default x11vnc will not process any of the user input
                       events.  If you prefix "cmd" with "tee:" it will
                       both send them to the pipe command and process them.
                       For a description of the format run "-pipeinput
                       tee:/bin/cat".  Another prefix is "reopen" which
                       means to reopen pipe if it exits.  Separate multiple
                       prefixes with commas.

                       In combination with -rawfb one might be able to
                       do amusing things (e.g. control non-X devices).
                       To facilitate this, if -rawfb is in effect then the
                       value is stored in X11VNC_RAWFB_STR for the pipe command
                       to use if it wants. Do 'env | grep X11VNC' for more.

                       Built-in pipeinput modes (no external program required):

                       If cmd is "VID" and you are using the -rawfb for a
                       video capture device, then an internal list of keyboard
                       mappings is used to set parameters of the video.
                       The mappings are:

                         "B" and "b" adjust the brightness up and down.
                         "H" and "h" adjust the hue.
                         "C" and "c" adjust the colour.
                         "N" and "n" adjust the contrast.
                         "S" and "s" adjust the size of the capture screen.
                         "I" and "i" cycle through input channels.
                         Up and Down arrows adjust the station (if a tuner)
                         F1, F2, ..., F6 will switch the video capture pixel
                         format to HI240, RGB565, RGB24, RGB32, RGB555, and
                         GREY respectively.  See -rawfb video for details.

                       If cmd is "CONSOLE" or "CONSOLEn" where n
                       is a Linux console number, then the linux console
                       keystroke insertion to /dev/ttyN (see -rawfb console)
                       is performed.

                       If cmd begins with "UINPUT" then the Linux uinput
                       module is used to insert both keystroke and mouse events
                       to the Linux console (see -rawfb above).  This usually
                       is the /dev/input/uinput device file (you may need to
                       create it with "mknod /dev/input/uinput c 10 223"
                       and insert the module with "modprobe uinput".

                       The UINPUT mode currently only does US keyboards (a
                       scan code option may be added), and not all keysyms
                       are supported.  But it is probably more accurate than
                       the "CONSOLE" method.

                       You may want to use the options -cursor none and
                       -nodragging in this mode.

                       Additional tuning options may be supplied via:
                       UINPUT:opt1,opt2,... (a comma separated list). If an
                       option begins with "/" it is taken as the uinput
                       device file.

                       Which uinput is injected can be controlled by an option
                       string made of the characters "K", "M", and "B"
                       (see the -input option), e.g. "KM" allows keystroke
                       and motion but not button clicks.

                       A UINPUT option of the form: accel=f, or accel=fx+fy
                       sets the mouse motion "acceleration".  This is used
                       to correct raw mouse relative motion into how much the
                       application cursor moves (x11vnc has no control over,
                       or knowledge of how the windowing application interprets
                       the raw mouse motions).  Typically the acceleration
                       for an X display is 2 (see xset "m" option).  "f"
                       is a floating point number, e.g. 3.0.  Use "fx+fy"
                       if you need to supply different corrections for x and y.

                       Note: the default acceleration is 2.0 since it seems
                       both X and qt-embedded often (but not always) use
                       this value.

                       Even with a correct accel setting the mouse position
                       will get out of sync (probably due to a mouse
                       "threshold" setting where the acceleration doe not
                       apply, set xset(1)).  The option reset=N sets the
                       number of ms (default 150) after which the cursor is
                       attempted to be reset (by forcing the mouse to (0,
                       0) via small increments and then back out to (x, y)
                       in 1 jump), This correction seems to be needed but can
                       cause jerkiness or unexpected behavior with menus, etc.
                       Use reset=0 to disable.

                       If you set the env. var X11VNC_UINPUT_THRESHOLDS then
                       the thresh=n mode will be enabled.  It is currently
                       not working well.  If |dx| <= thresh and |dy| < thresh
                       no acceleration is applied.  Use "thresh=+n" |dx| +
                       |dy| < thresh to be used instead (X11?)

                       Example:
                           -pipeinput UINPUT:accel=4.0 -cursor none

                       If the uinput device has an absolute pointer (as opposed
                       to a normal mouse that is a relative pointer) you can
                       specify the option "abs".  Note that a touchpad
                       on a laptop is an absolute device to some degree.
                       This (usually) avoids all the problems with mouse
                       acceleration.  If x11vnc has trouble deducing the
                       size of the device, use "abs=WxH".  Furthermore,
                       if the device is a touchscreen (assumed to have an
                       absolute pointer) use "touch" or "touch=WxH".
                       For touchscreens, when a mouse button is pressed,
                       a pressure increase is injected, and when the button
                       is released a pressure of zero is injected.

                       If touch has been set, use "touch_always=1" to
                       indicate whenever the mouse moves with no button
                       pressed, a touch event of zero pressure should be
                       sent anyway.  Also use "btn_touch=1" to indicate a
                       BTN_TOUCH keystroke press or release should be sent
                       instead of a pressure change.  Set "dragskip=n" to
                       skip n dragged mouse touches (with pressure applied)
                       before injecting one.  To indicate the pressure that
                       should be sent when there is a button click for a
                       touchscreen device, specify pressure=n, e.g. n=5. The
                       default is n=1.

                       If a touch screen is being used ("touch" above)
                       and it is having its input processed by tslib, you can
                       specify the tslib calibration file via tslib_cal=<file>.
                       For example, tslib_cal=/etc/pointercal.  To get accurate
                       or even usable positioning this is required when tslib
                       is in use.

                       The Linux uinput mechanism can be bypassed and one can
                       write input events DIRECTLY to the devices instead.
                       To do this, specify one or more of the following
                       for the input classes: direct_rel=<device>
                       direct_abs=<device> direct_btn=<device> or
                       direct_key=<device>.  The <device> file is usually
                       something like /dev/input/event1 but you can specify
                       any device file or pipe.  You must specify each one
                       of the above classes even if they correspond to the
                       same device file (rel/abs and btn are often the same.)
                       Look at the file /proc/bus/input/devices to get an idea
                       what is available and the device filenames.  Note:
                       The /dev/input/mouse* devices do not seem to work,
                       use the corresponding /dev/input/event* file instead.
                       Any input class not directly specified as above will be
                       handled via the uinput mechanism.  To disable creating a
                       uinput device (and thereby discarding unhandled input),
                       specify "nouinput".

                       Examples:

                         -pipeinput UINPUT:direct_abs=/dev/input/event1

                       this was used on a qtmoko Neo freerunner (armel):

                         -pipeinput UINPUT:touch,tslib_cal=/etc/pointercal,
                          direct_abs=/dev/input/event1,nouinput,dragskip=4

                       (where the long line has been split into two.)

                       You can set the env. var X11VNC_UINPUT_DEBUG=1 or higher
                       to get debugging output for UINPUT mode.

-macnodim              For the native MacOSX server, disable dimming.
-macnosleep            For the native MacOSX server, disable display sleep.
-macnosaver            For the native MacOSX server, disable screensaver.
-macnowait             For the native MacOSX server, do not wait for the
                       user to switch back to his display.
-macwheel n            For the native MacOSX server, set the mouse wheel
                       speed to n (default 5).
-macnoswap             For the native MacOSX server, do not swap mouse
                       buttons 2 and 3.
-macnoresize           For the native MacOSX server, do not resize or reset
                       the framebuffer even if it is detected that the screen
                       resolution or depth has changed.
-maciconanim n         For the native MacOSX server, set n to the number
                       of milliseconds that the window iconify/deiconify
                       animation takes.  In -ncache mode this value will be
                       used to skip the animation if possible. (default 400)
-macmenu               For the native MacOSX server, in -ncache client-side
                       caching mode, try to cache pull down menus (not perfect
                       because they have animated fades, etc.)
-macuskbd              For the native MacOSX server, use the original
                       keystroke insertion code based on a US keyboard.
-macnoopengl           For the native MacOSX server, do not use OpenGL for
                       screen capture, but rather use the original, deprecated
                       raw memory access method: addr = CGDisplayBaseAddress().
-macnorawfb            For the native MacOSX server, disable the raw memory
                       address screen capture method.

                       MACOSX NOTE: There are some deprecated MacOSX interfaces
                       to inject keyboard and mouse events and the raw memory
                       access method is deprecated as well (however, OpenGL
                       will be preferred if available because it is faster.)
                       One can force not using any deprecated interfaces at
                       compile time by setting -DX11VNC_MACOSX_NO_DEPRECATED=1
                       in CPPFLAGS.  Or to turn them off one by one:
                       -DX11VNC_MACOSX_NO_DEPRECATED_LOCALEVENTS=1,
                       -DX11VNC_MACOSX_NO_DEPRECATED_POSTEVENTS=1 or
                       -DX11VNC_MACOSX_NO_DEPRECATED_FRAMEBUFFER=1
                       At run time, for testing and workarounds, one can
                       disable them by using:
                       -env X11VNC_MACOSX_NO_DEPRECATED=1
                       -env X11VNC_MACOSX_NO_DEPRECATED_LOCALEVENTS=1
                       -env X11VNC_MACOSX_NO_DEPRECATED_POSTEVENTS=1 or
                       -env X11VNC_MACOSX_NO_DEPRECATED_FRAMEBUFFER=1
                       Note: When doing either of these for the mouse input
                       not everything works currently, e.g. double clicks and
                       wireframing.  Also, screen resolution and pixel depth
                       changes will not be automatically detected unless the
                       deprecated framebuffer interfaces are allowed.

                       Conversely, if you are compiling on an
                       older machine that does not have some of
                       the newer interfaces, you may need to specify
                       -DX11VNC_MACOSX_NO_CGEVENTCREATESCROLLWHEELEVENT
                       -DX11VNC_MACOSX_NO_CGEVENTCREATEMOUSEEVENT or
                       -DX11VNC_MACOSX_NO_CGEVENTCREATEKEYBOARDEVENT.  Use
                       -DX11VNC_MACOSX_USE_GETMAINDEVICE to regain the very
                       old QuickDraw GetMainDevice() interface (rare...)

-gui [gui-opts]        Start up a simple tcl/tk gui based on the remote
                       control options -remote/-query described below.
                       Requires the "wish" program to be installed on the
                       machine.  "gui-opts" is not required: the default
                       is to start up both the full gui and x11vnc with the
                       gui showing up on the X display in the environment
                       variable DISPLAY.

                       "gui-opts" can be a comma separated list of items.
                       Currently there are these types of items: 1) a gui
                       mode, a 2) gui "simplicity", 3) the X display the
                       gui should display on, 4) a "tray" or "icon" mode,
                       and 5) a gui geometry.

                       1) The gui mode can be "start", "conn", or "wait"
                       "start" is the default mode above and is not required.
                       "conn" means do not automatically start up x11vnc,
                       but instead just try to connect to an existing x11vnc
                       process.  "wait" means just start the gui and nothing
                       else (you will later instruct the gui to start x11vnc
                       or connect to an existing one.)

                       2) The gui simplicity is off by default (a power-user
                       gui with all options is presented) To start with
                       something less daunting supply the string "simple"
                       ("ez" is an alias for this).  Once the gui is
                       started you can toggle between the two with "Misc ->
                       simple_gui".

                       3) Note the possible confusion regarding the potentially
                       two different X displays: x11vnc polls one, but you
                       may want the gui to appear on another.  For example, if
                       you ssh in and x11vnc is not running yet you may want
                       the gui to come back to you via your ssh redirected X
                       display (e.g. localhost:10).

                       If you do not specify a gui X display in "gui-opts"
                       then the DISPLAY environment variable and -display
                       option are tried (in that order).  Regarding the x11vnc
                       X display the gui will try to communication with, it
                       first tries -display and then DISPLAY.  For example,
                       "x11vnc -display :0 -gui otherhost:0", will remote
                       control an x11vnc polling :0 and display the gui on
                       otherhost:0 The "tray/icon" mode below reverses this
                       preference, preferring to display on the x11vnc display.

                       4) When "tray" or "icon" is specified, the gui
                       presents itself as a small icon with behavior typical
                       of a "system tray" or "dock applet".  The color
                       of the icon indicates status (connected clients) and
                       there is also a balloon status.  Clicking on the icon
                       gives a menu from which properties, etc, can be set and
                       the full gui is available under "Advanced".  To be
                       fully functional, the gui mode should be "start"
                       (the default).

                       Note that tray or icon mode will imply the -forever
                       x11vnc option (if the x11vnc server is started along
                       with the gui) unless -connect or -connect_or_exit has
                       been specified.  So x11vnc (and the tray/icon gui)
                       will wait for more connections after the first client
                       disconnects.  If you want only one viewer connection
                       include the -once option.

                       For "icon" the gui just a small standalone window.
                       For "tray" it will attempt to embed itself in the
                       "system tray" if possible. If "=setpass" is appended the
n
                       at startup the X11 user will be prompted to set the
                       VNC session password.  If =<hexnumber> is appended
                       that icon will attempt to embed itself in the window
                       given by hexnumber.  Use =noadvanced to disable the
                       full gui. (To supply more than one, use "+" sign).
                       E.g. -gui tray=setpass and -gui icon=0x3600028

                       Other modes: "full", the default and need not be
                       specified.  "-gui none", do not show a gui, useful
                       to override a ~/.x11vncrc setting, etc.

                       5) When "geom=+X+Y" is specified, that geometry
                       is passed to the gui toplevel.  This is the icon in
                       icon/tray mode, or the full gui otherwise.  You can
                       also specify width and height, i.e. WxH+X+Y, but it
                       is not recommended.  In "tray" mode the geometry is
                       ignored unless the system tray manager does not seem
                       to be running.  One could imagine using something like
                       "-gui tray,geom=+4000+4000" with a display manager
                       to keep the gui invisible until someone logs in...

                       More icon tricks, "icon=minimal" gives an icon just
                       with the VNC display number.  You can also set the font
                       with "iconfont=...".  The following could be useful:
                       "-gui icon=minimal,iconfont=5x8,geom=24x10+0-0"

                       General examples of the -gui option: "x11vnc -gui",
                       "x11vnc -gui ez" "x11vnc -gui localhost:10",
                       "x11vnc -gui conn,host:0", "x11vnc -gui tray,ez"
                       "x11vnc -gui tray=setpass"

                       If you do not intend to start x11vnc from the gui
                       (i.e. just remote control an existing one), then the
                       gui process can run on a different machine from the
                       x11vnc server as long as X permissions, etc. permit
                       communication between the two.

                       FONTS: On some systems the tk fonts can be too small,
                       jagged, or otherwise unreadable.  There are 4 env vars
                       you can set to be the tk font you prefer:

                       X11VNC_FONT_BOLD   main font for menus and buttons.
                       X11VNC_FONT_FIXED  font for fixed width text.

                       X11VNC_FONT_BOLD_SMALL  tray icon font.
                       X11VNC_FONT_REG_SMALL   tray icon menu font.

                       The last two only apply for the tray icon mode.

                       Here are some examples:

                       -env X11VNC_FONT_BOLD='Helvetica -16 bold'
                       -env X11VNC_FONT_FIXED='Courier -14'
                       -env X11VNC_FONT_REG_SMALL='Helvetica -12'

                       You can put the lines like the above (without the
                       quotes) in your ~/.x11vncrc file to avoid having to
                       specify them on the x11vnc command line.

-remote command        Remotely control some aspects of an already running
                       x11vnc server.  "-R" and "-r" are aliases for
                       "-remote".  After the remote control command is
                       sent to the running server the 'x11vnc -remote ...'
                       x11vnc command exits.  You can often use the -query
                       command (see below) to see if the x11vnc server
                       processed your -remote command.

                       The default communication channel is that of X
                       properties (specifically X11VNC_REMOTE), and so this
                       command must be run with correct settings for DISPLAY
                       and possibly XAUTHORITY to connect to the X server
                       and set the property.  Alternatively, use the -display
                       and -auth options to set them to the correct values.
                       The running server cannot use the -novncconnect option
                       because that disables the communication channel.
                       See below for alternate channels.

                       For example: 'x11vnc -remote stop' (which is the same as
                       'x11vnc -R stop') will close down the x11vnc server.
                       'x11vnc -R shared' will enable shared connections, and
                       'x11vnc -R scale:3/4' will rescale the desktop.

                       To use a different name for the X11 property (e.g. to
                       have separate communication channels for multiple
                       x11vnc's on the same display) set the X11VNC_REMOTE
                       environment variable to the string you want, for
                       example: -env X11VNC_REMOTE=X11VNC_REMOTE_12345
                       Both sides of the channel must use the same unique name.

                       To run a bunch of commands in a sequence use something
                       like: x11vnc -R 'script:firstcmd;secondcmd;...'

                       Use x11vnc -R script:file=/path/to/file to read commands
                       from a file (can be multi-line and use the comment '#'
                       character in the normal way.  The ';' separator must
                       still be used to separate each command.)

                       To not try to contact another x11vnc process and instead
                       just run the command (or query) directly, prefix the
                       command with the string "DIRECT:"

                       The following -remote/-R commands are supported:

                       stop            terminate the server, same as "quit"
                                       "exit" or "shutdown".
                       ping            see if the x11vnc server responds.
                                       return is: ans=ping:<display>
                       ping:mystring   as above, but use your own unique string.
                                       return is: ans=ping:mystring:<xdisplay>
                       blacken         try to push a black fb update to all
                                       clients (due to timings a client
                                       could miss it). Same as "zero", also
                                       "zero:x1,y1,x2,y2" for a rectangle.
                       refresh         send the entire fb to all clients.
                       reset           recreate the fb, polling memory, etc.
                       id:windowid     set -id window to "windowid". empty
                                       or "root" to go back to root window
                       sid:windowid    set -sid window to "windowid"
                       id_cmd:cmd      cmds: raise, lower, map, unmap, iconify,
                                       move:dXdY, resize:dWdH, geom:WxH+X+Y. dX
                                       dY, dW, and dH must have a leading "+"
                                       or "-" e.g.: move:-30+10 resize:+20+35
                                       also: wm_delete, wm_name:string and
                                       icon_name:string. Also id_cmd:win=N:cmd
                       waitmapped      wait until subwin is mapped.
                       nowaitmapped    do not wait until subwin is mapped.
                       clip:WxH+X+Y    set -clip mode to "WxH+X+Y"
                       flashcmap       enable  -flashcmap mode.
                       noflashcmap     disable -flashcmap mode.
                       shiftcmap:n     set -shiftcmap to n.
                       notruecolor     enable  -notruecolor mode.
                       truecolor       disable -notruecolor mode.
                       overlay         enable  -overlay mode (if applicable).
                       nooverlay       disable -overlay mode.
                       overlay_cursor  in -overlay mode, enable cursor drawing.
                       overlay_nocursor disable cursor drawing. same as
                                        nooverlay_cursor.
                       8to24           enable  -8to24 mode (if applicable).
                       no8to24         disable -8to24 mode.
                       8to24_opts:str  set the -8to24 opts to "str".
                       24to32          enable  -24to32 mode (if applicable).
                       no24to32        disable -24to32 mode.
                       visual:vis      set -visual to "vis"
                       scale:frac      set -scale to "frac"
                       scale_cursor:f  set -scale_cursor to "f"
                       viewonly        enable  -viewonly mode.
                       noviewonly      disable -viewonly mode.
                       shared          enable  -shared mode.
                       noshared        disable -shared mode.
                       forever         enable  -forever mode.
                       noforever       disable -forever mode.
                       timeout:n       reset -timeout to n, if there are
                                       currently no clients, exit unless one
                                       connects in the next n secs.
                       tightfilexfer   enable  filetransfer for NEW clients.
                       notightfilexfer disable filetransfer for NEW clients.
                       ultrafilexfer   enable  filetransfer for clients.
                       noultrafilexfer disable filetransfer for clients.
                       rfbversion:n.m  set -rfbversion for new clients.
                       http            enable  http client connections.
                       nohttp          disable http client connections.
                       deny            deny any new connections, same as "lock"
                       nodeny          allow new connections, same as "unlock"
                       avahi           enable  avahi service advertising.
                       noavahi         disable avahi service advertising.
                       mdns            enable  avahi service advertising.
                       nomdns          disable avahi service advertising.
                       zeroconf        enable  avahi service advertising.
                       nozeroconf      disable avahi service advertising.
                       connect:host    do reverse connection to host, "host"
                                       may be a comma separated list of hosts
                                       or host:ports.  See -connect.  Passwords
                                       required as with fwd connections.
                                       See X11VNC_REVERSE_CONNECTION_NO_AUTH=1
                       disconnect:host disconnect any clients from "host"
                                       same as "close:host".  Use host
                                       "all" to close all current clients.
                                       If you know the client internal hex ID,
                                       e.g. 0x3 (returned by "-query clients"
                                       and RFB_CLIENT_ID) you can use that too.
                       proxy:host:port set reverse connection proxy (empty to
                                       disable).
                       allowonce:host  For the next connection only, allow
                                       connection from "host". In -ssl mode
                                       two connections are allowed (i.e. Fetch
                                       Cert) unless X11VNC_NO_SSL_ALLOW_TWICE=1
                       allow:hostlist  set -allow list to (comma separated)
                                       "hostlist". See -allow and -localhost.
                                       Do not use with -allow /path/to/file
                                       Use "+host" to add a single host, and
                                       use "-host" to delete a single host
                       localhost       enable  -localhost mode
                       nolocalhost     disable -localhost mode
                       listen:str      set -listen to str, empty to disable.
                       noipv6          enable  -noipv6 mode.
                       ipv6            disable -noipv6 mode.
                       noipv4          enable  -noipv4 mode.
                       ipv4            disable -noipv4 mode.
                       6               enable  -6 IPv6 listening mode.
                       no6             disable -6 IPv6 listening mode.
                       lookup          disable -nolookup mode.
                       nolookup        enable  -nolookup mode.
                       lookup          disable -nolookup mode.
                       input:str       set -input to "str", empty to disable.
                       grabkbd         enable  -grabkbd mode.
                       nograbkbd       disable -grabkbd mode.
                       grabptr         enable  -grabptr mode.
                       nograbptr       disable -grabptr mode.
                       grabalways      enable  -grabalways mode.
                       nograbalways    disable -grabalways mode.
                       grablocal:n     set -grablocal to n.
                       client_input:str set the K, M, B -input on a per-client
                                       basis.  select which client as for
                                       disconnect, e.g. client_input:host:MB
                                       or client_input:0x2:K
                       accept:cmd      set -accept "cmd" (empty to disable).
                       afteraccept:cmd set -afteraccept (empty to disable).
                       gone:cmd        set -gone "cmd" (empty to disable).
                       noshm           enable  -noshm mode.
                       shm             disable -noshm mode (i.e. use shm).
                       flipbyteorder   enable -flipbyteorder mode, you may need
                                       to set noshm for this to do something.
                       noflipbyteorder disable -flipbyteorder mode.
                       onetile         enable  -onetile mode. (you may need to
                                       set shm for this to do something)
                       noonetile       disable -onetile mode.
                       solid           enable  -solid mode
                       nosolid         disable -solid mode.
                       solid_color:color set -solid color (and apply it).
                       blackout:str    set -blackout "str" (empty to disable).
                                       See -blackout for the form of "str"
                                       (basically: WxH+X+Y,...)
                                       Use "+WxH+X+Y" to append a single
                                       rectangle use "-WxH+X+Y" to delete one
                       xinerama        enable  -xinerama mode. (if applicable)
                       noxinerama      disable -xinerama mode.
                       xtrap           enable  -xtrap input mode(if applicable)
                       noxtrap         disable -xtrap input mode.
                       xrandr          enable  -xrandr mode. (if applicable)
                       noxrandr        disable -xrandr mode.
                       xrandr_mode:mode set the -xrandr mode to "mode".
                       rotate:mode     set the -rotate mode to "mode".
                       padgeom:WxH     set -padgeom to WxH (empty to disable)
                                       If WxH is "force" or "do" the padded
                                       geometry fb is immediately applied.
                       quiet           enable  -quiet mode.
                       noquiet         disable -quiet mode.
                       modtweak        enable  -modtweak mode.
                       nomodtweak      enable  -nomodtweak mode.
                       xkb             enable  -xkb modtweak mode.
                       noxkb           disable -xkb modtweak mode.
                       capslock        enable  -capslock mode.
                       nocapslock      disable -capslock mode.
                       skip_lockkeys   enable  -skip_lockkeys mode.
                       noskip_lockkeys disable -skip_lockkeys mode.
                       skip_keycodes:str enable -xkb -skip_keycodes "str".
                       sloppy_keys     enable  -sloppy_keys mode.
                       nosloppy_keys   disable -sloppy_keys mode.
                       skip_dups       enable  -skip_dups mode.
                       noskip_dups     disable -skip_dups mode.
                       add_keysyms     enable -add_keysyms mode.
                       noadd_keysyms   stop adding keysyms. those added will
                                       still be removed at exit.
                       clear_mods      enable  -clear_mods mode and clear them.
                       noclear_mods    disable -clear_mods mode.
                       clear_keys      enable  -clear_keys mode and clear them.
                       noclear_keys    disable -clear_keys mode.
                       clear_locks     do the clear_locks action.
                       clear_all       do the clear_all action.
                       keystate        have x11vnc print current keystate.
                       remap:str       set -remap "str" (empty to disable).
                                       See -remap for the form of "str"
                                       (basically: key1-key2,key3-key4,...)
                                       Use "+key1-key2" to append a single
                                       keymapping, use "-key1-key2" to delete.
                       norepeat        enable  -norepeat mode.
                       repeat          disable -norepeat mode.
                       nofb            enable  -nofb mode.
                       fb              disable -nofb mode.
                       bell            enable  bell (if supported).
                       nobell          disable bell.
                       sendbell        ring the bell now.
                       nosel           enable  -nosel mode.
                       sel             disable -nosel mode.
                       noprimary       enable  -noprimary mode.
                       primary         disable -noprimary mode.
                       nosetprimary    enable  -nosetprimary mode.
                       setprimary      disable -nosetprimary mode.
                       noclipboard     enable  -noclipboard mode.
                       clipboard       disable -noclipboard mode.
                       nosetclipboard  enable  -nosetclipboard mode.
                       setclipboard    disable -nosetclipboard mode.
                       seldir:str      set -seldir to "str"
                       resend_cutbuffer resend the most recent CUTBUFFER0 copy
                       resend_clipboard resend the most recent CLIPBOARD copy
                       resend_primary   resend the most recent PRIMARY copy
                       cursor:mode     enable  -cursor "mode".
                       show_cursor     enable  showing a cursor.
                       noshow_cursor   disable showing a cursor. (same as
                                       "nocursor")
                       cursor_drag     enable  cursor changes during drag.
                       nocursor_drag   disable cursor changes during drag.
                       arrow:n         set -arrow to alternate n.
                       xfixes          enable  xfixes cursor shape mode.
                       noxfixes        disable xfixes cursor shape mode.
                       alphacut:n      set -alphacut to n.
                       alphafrac:f     set -alphafrac to f.
                       alpharemove     enable  -alpharemove mode.
                       noalpharemove   disable -alpharemove mode.
                       alphablend      disable -noalphablend mode.
                       noalphablend    enable  -noalphablend mode.
                       cursorshape     disable -nocursorshape mode.
                       nocursorshape   enable  -nocursorshape mode.
                       cursorpos       disable -nocursorpos mode.
                       nocursorpos     enable  -nocursorpos mode.
                       xwarp           enable  -xwarppointer mode.
                       noxwarp         disable -xwarppointer mode.
                       always_inject   enable  -always_inject mode.
                       noalways_inject disable -always_inject mode.
                       buttonmap:str   set -buttonmap "str", empty to disable
                       dragging        disable -nodragging mode.
                       nodragging      enable  -nodragging mode.
                       ncache          reenable -ncache mode.
                       noncache        disable  -ncache mode.
                       ncache_size:n   set -ncache size to n.
                       ncache_cr       enable  -ncache_cr mode.
                       noncache_cr     disable -ncache_cr mode.
                       ncache_no_moveraise     enable  no_moveraise mode.
                       noncache_no_moveraise   disable no_moveraise mode.
                       ncache_no_dtchange      enable  ncache_no_dtchange mode.
                       noncache_no_dtchange    disable ncache_no_dtchange mode.
                       ncache_old_wm           enable  ncache_old_wm mode.
                       noncache_old_wm         disable ncache_old_wm mode.
                       ncache_no_rootpixmap    enable  ncache_no_rootpixmap.
                       noncache_no_rootpixmap  disable ncache_no_rootpixmap.
                       ncache_reset_rootpixmap recheck the root pixmap, ncrp
                       ncache_keep_anims       enable  ncache_keep_anims.
                       noncache_keep_anims     disable ncache_keep_anims.
                       ncache_pad:n    set -ncache_pad to n.
                       wireframe       enable  -wireframe mode. same as "wf"
                       nowireframe     disable -wireframe mode. same as "nowf"
                       wireframe:str   enable  -wireframe mode string.
                       wireframe_mode:str enable  -wireframe mode string.
                       wireframelocal  enable  wireframelocal. same as "wfl"
                       nowireframe     disable wireframelocal. same as "nowfl"
                       wirecopyrect:str set -wirecopyrect string. same as "wcr:"
                       scrollcopyrect:str set -scrollcopyrect string. same "scr"
                       noscrollcopyrect disable -scrollcopyrect mode. "noscr"
                       scr_area:n      set -scr_area to n
                       scr_skip:list   set -scr_skip to "list"
                       scr_inc:list    set -scr_inc to "list"
                       scr_keys:list   set -scr_keys to "list"
                       scr_term:list   set -scr_term to "list"
                       scr_keyrepeat:str set -scr_keyrepeat to "str"
                       scr_parms:str   set -scr_parms parameters.
                       fixscreen:str   set -fixscreen to "str".
                       noxrecord       disable all use of RECORD extension.
                       xrecord         enable  use of RECORD extension.
                       reset_record    reset RECORD extension (if avail.)
                       pointer_mode:n  set -pointer_mode to n. same as "pm"
                       input_skip:n    set -input_skip to n.
                       allinput        enable  use of -allinput mode.
                       noallinput      disable use of -allinput mode.
                       input_eagerly   enable  use of -input_eagerly mode.
                       noinput_eagerly disable use of -input_eagerly mode.
                       ssltimeout:n    set -ssltimeout to n.
                       speeds:str      set -speeds to str.
                       wmdt:str        set -wmdt to str.
                       debug_pointer   enable  -debug_pointer, same as "dp"
                       nodebug_pointer disable -debug_pointer, same as "nodp"
                       debug_keyboard   enable  -debug_keyboard, same as "dk"
                       nodebug_keyboard disable -debug_keyboard, same as "nodk"
                       keycode:n       inject keystroke 'keycode' (xmodmap -pk)
                       keycode:n,down  inject 'keycode' (down=0,1)
                       keysym:str      inject keystroke 'keysym' (number/name)
                       keysym:str,down inject 'keysym' (down=0,1)
                       ptr:x,y,mask    inject pointer event x, y, button-mask
                       fakebuttonevent:button,down direct XTestFakeButtonEvent.
                       sleep:t         sleep floating point time t.
                       get_xprop:p     get X property named 'p'.
                       set_xprop:p:val set X property named 'p' to 'val'.
                                       p -> id=NNN:p for hex/dec window id.
                       wininfo:id      get info about X window id.  use 'root'
                                       for root window, use +id for children.
                       grab_state      get state of pointer and keyboard grab.
                       pointer_pos     print XQueryPointer x,y cursor position.
                       pointer_x       print XQueryPointer x cursor position.
                       pointer_y       print XQueryPointer y cursor position.
                       pointer_same    print XQueryPointer ptr on same screen.
                       pointer_root    print XQueryPointer curr ptr rootwin.
                       pointer_mask    print XQueryPointer button and mods mask
                       mouse_x         print x11vnc's idea of cursor position.
                       mouse_y         print x11vnc's idea of cursor position.
                       noop            do nothing.
                       defer:n         set -defer to n ms,same as deferupdate:n
                       wait:n          set -wait to n ms.
                       extra_fbur:n    set -extra_fbur to n.
                       wait_ui:f       set -wait_ui factor to f.
                       setdefer:n      set -setdefer to -2,-1,0,1, or 2.
                       wait_bog        disable -nowait_bog mode.
                       nowait_bog      enable  -nowait_bog mode.
                       slow_fb:f       set -slow_fb to f seconds.
                       xrefresh:f      set -xrefresh to f seconds.
                       readtimeout:n   set read timeout to n seconds.
                       nap             enable  -nap mode.
                       nonap           disable -nap mode.
                       sb:n            set -sb to n s, same as screen_blank:n
                       fbpm            disable -nofbpm mode.
                       nofbpm          enable  -nofbpm mode.
                       dpms            disable -nodpms mode.
                       nodpms          enable  -nodpms mode.
                       forcedpms       enable  -forcedpms mode.
                       noforcedpms     disable -forcedpms mode.
                       clientdpms      enable  -clientdpms mode.
                       noclientdpms    disable -clientdpms mode.
                       noserverdpms    enable  -noserverdpms mode.
                       serverdpms      disable -noserverdpms mode.
                       noultraext      enable  -noultraext mode.
                       ultraext        disable -noultraext mode.
                       chatwindow      enable  local chatwindow mode.
                       nochatwindow    disable local chatwindow mode.
                       chaton          begin chat using local window.
                       chatoff         end   chat using local window.
                       xdamage         enable  xdamage polling hints.
                       noxdamage       disable xdamage polling hints.
                       xd_area:A       set -xd_area max pixel area to "A"
                       xd_mem:f        set -xd_mem remembrance to "f"
                       fs:frac         set -fs fraction to "frac", e.g. 0.5
                       gaps:n          set -gaps to n.
                       grow:n          set -grow to n.
                       fuzz:n          set -fuzz to n.
                       snapfb          enable  -snapfb mode.
                       nosnapfb        disable -snapfb mode.
                       rawfb:str       set -rawfb mode to "str".
                       uinput_accel:f  set uinput_accel to f.
                       uinput_thresh:n set uinput_thresh to n.
                       uinput_reset:n  set uinput_reset to n ms.
                       uinput_always:n set uinput_always to 1/0.
                       progressive:n   set LibVNCServer -progressive slice
                                       height parameter to n.
                       desktop:str     set -desktop name to str for new clients.
                       rfbport:n       set -rfbport to n.
                       macnosaver      enable  -macnosaver mode.
                       macsaver        disable -macnosaver mode.
                       macnowait       enable  -macnowait  mode.
                       macwait         disable -macnowait  mode.
                       macwheel:n      set -macwheel to n.
                       macnoswap       enable  -macnoswap mouse button mode.
                       macswap         disable -macnoswap mouse button mode.
                       macnoresize     enable  -macnoresize mode.
                       macresize       disable -macnoresize mode.
                       maciconanim:n   set -maciconanim to n.
                       macmenu         enable  -macmenu  mode.
                       macnomenu       disable -macmenu  mode.
                       macuskbd        enable  -macuskbd mode.
                       macnouskbd      disable -macuskbd mode.
                       httpport:n      set -httpport to n.
                       httpdir:dir     set -httpdir to dir (and enable http).
                       enablehttpproxy   enable  -enablehttpproxy mode.
                       noenablehttpproxy disable -enablehttpproxy mode.
                       alwaysshared     enable  -alwaysshared mode.
                       noalwaysshared   disable -alwaysshared mode.
                                        (may interfere with other options)
                       nevershared      enable  -nevershared mode.
                       nonevershared    disable -nevershared mode.
                                        (may interfere with other options)
                       dontdisconnect   enable  -dontdisconnect mode.
                       nodontdisconnect disable -dontdisconnect mode.
                                        (may interfere with other options)
                       debug_xevents   enable  debugging X events.
                       nodebug_xevents disable debugging X events.
                       debug_xdamage   enable  debugging X DAMAGE mechanism.
                       nodebug_xdamage disable debugging X DAMAGE mechanism.
                       debug_wireframe enable   debugging wireframe mechanism.
                       nodebug_wireframe disable debugging wireframe mechanism.
                       debug_scroll    enable  debugging scrollcopy mechanism.
                       nodebug_scroll  disable debugging scrollcopy mechanism.
                       debug_tiles     enable  -debug_tiles
                       nodebug_tiles   disable -debug_tiles
                       debug_grabs     enable  -debug_grabs
                       nodebug_grabs   disable -debug_grabs
                       debug_sel       enable  -debug_sel
                       nodebug_sel     disable -debug_sel
                       debug_ncache    enable  -debug_ncache
                       nodebug_ncache  disable -debug_ncache
                       dbg             enable  -dbg crash shell
                       nodbg           disable -dbg crash shell

                       noremote        disable the -remote command processing,
                                       it cannot be turned back on.

                       bcx_xattach:str  This remote control command is for
                       use with the BARCO xattach program or the x2x program.
                       Both of these programs are for 'pointer and keyboard'
                       sharing between separate X displays.  In general the
                       two displays are usually nearby, e.g. on the same desk,
                       and this allows the user to share a single pointer and
                       keyboard between them.  The user moves the mouse to
                       an edge and then the mouse pointer appears to 'jump'
                       to the other display screen.  Thus it emulates what a
                       single X server would do for two screens (e.g. :0.0 and
                       :0.1) The illusion of a single Xserver with multiple
                       screens is achieved by forwarding events to the 2nd
                       one via the XTEST extension.

                       What the x11vnc bcx_xattach command does is to perform
                       some pointer movements to try to INDUCE xattach/x2x
                       to 'jump' to the other display.  In what follows the
                       'master' display refers to the one that when it has
                       'focus' it is basically doing nothing besides watching
                       for the mouse to go over an edge.  The 'slave'
                       display refers to the one to which the mouse and
                       keyboard is redirected to once an edge in the master
                       has been crossed.  Note that the x11vnc executing the
                       bcx_xattach command MUST be the one connected to the
                       *master* display.

                       Also note that when input is being redirected (via
                       XTEST) from the master display to the slave display,
                       the master display's pointer and keyboard are *grabbed*
                       by xattach/x2x.  x11vnc can use this info to verify that
                       the master/slave mode change has taken place correctly.
                       If you specify the "ifneeded" option (see below)
                       and the initial grab state is that of the desired
                       final state, then no pointer movements are injected
                       and "DONE,GRAB_OK" is returned.

                       "str" must contain one of "up", "down", "left",
                       or "right" to indicate the direction of the 'jump'.
                       "str" must also contain one of "master_to_slave"
                       or "slave_to_master" to indicate the type of mode
                       change induced by the jump.  Use "M2S" and "S2M"
                       as shorter aliases.

                       "str" may be a "+" separated list of additional
                       tuning options.  The "shift=n" option indicates an
                       offset shift position away from (0,0) (default 20).
                       "final=x+y" specifies the final position of the cursor
                       at the end of the normal move sequence; default 30+30.
                       "extra_move=x+y" means to do one more pointer move
                       after "final" to x+y.  "dt=n" sets the sleep time
                       in milliseconds between pointer moves (default: 40ms)
                       "retry=n" specifies the maximum number of retries if
                       the grab state change fails. "ifneeded" means to not
                       apply the pointer movements if the initial grab state is
                       that of the desired final state. "nograbcheck" means
                       to not check if the grab state changed as expected and
                       only apply the pointer movements (default is to check
                       the grab states.)

                       If you do not specify "up", etc., to bcx_xattach
                       nothing will be attempted and the command returns
                       the string FAIL,NO_DIRECTION_SPECIFIED.  If you do
                       not specify "master_to_slave" or "M2S", etc., to
                       bcx_xattach nothing will be attempted and the command
                       returns the string FAIL,NO_MODE_CHANGE_SPECIFIED.

                       Otherwise, the returned string will contain "DONE".
                       It will be "DONE,GRAB_OK" if the grab state changed
                       as expected (or if "ifneeded" was supplied and
                       the initial grab state was already the desired
                       one.)  If the initial grab state was incorrect,
                       but the final grab state was correct then it is
                       "DONE,GRAB_FAIL_INIT".  If the initial grab state
                       was correct, but the final grab state was incorrect
                       then it is "DONE,GRAB_FAIL_FINAL".  If both are
                       incorrect it will be "DONE,GRAB_FAIL".  Under grab
                       failure the string will be followed by ":p1,k1-p2,k2"
                       where  p1,k1 indicates the initial pointer and keyboard
                       grab states and p2,k2 the final ones. If GRAB_FAIL or
                       GRAB_FAIL_FINAL occurs, the action will be retried up
                       to 3 times; trying to reset the state and sleeping a
                       bit between each try.  Set retry=n to adjust the number
                       of retries, zero to disable retries.

                       Examples:
                           -R bcx_xattach:down+M2S
                           -R bcx_xattach:up+S2M
                           -R bcx_xattach:up+S2M+nograbcheck+dt=30
                           -R bcx_xattach:down+M2S+extra_move=100+100

                       or use -Q instead of -R to retrieve the result text.

                       End of the bcx_xattach:str description.

                       The vncconnect(1) command from standard VNC
                       distributions may also be used if string is prefixed
                       with "cmd=" E.g. 'vncconnect cmd=stop'.  Under some
                       circumstances xprop(1) can used if it supports -set
                       (see the FAQ).

                       If "-connect /path/to/file" has been supplied to the
                       running x11vnc server then that file can be used as a
                       communication channel (this is the only way to remote
                       control one of many x11vnc's polling the same X display)
                       Simply run: 'x11vnc -connect /path/to/file -remote ...'
                       or you can directly write to the file via something
                       like: "echo cmd=stop > /path/to/file", etc.

-query variable        Like -remote, except just query the value of
                       "variable".  "-Q" is an alias for "-query".
                       Multiple queries can be done by separating variables
                       by commas, e.g. -query var1,var2. The results come
                       back in the form ans=var1:value1,ans=var2:value2,...
                       to the standard output.  If a variable is read-only,
                       it comes back with prefix "aro=" instead of "ans=".

                       Some -remote commands are pure actions that do not make
                       sense as variables, e.g. "stop" or "disconnect", in
                       these cases the value returned is "N/A".  To direct a
                       query straight to the X11VNC_REMOTE property or connect
                       file use "qry=..." instead of "cmd=..."

                       ans= stop quit exit shutdown ping resend_cutbuffer
                       resend_clipboard resend_primary blacken zero refresh
                       reset close disconnect id_cmd id sid waitmapped
                       nowaitmapped clip flashcmap noflashcmap shiftcmap
                       truecolor notruecolor overlay nooverlay overlay_cursor
                       overlay_yescursor nooverlay_nocursor nooverlay_cursor
                       nooverlay_yescursor overlay_nocursor 8to24 no8to24
                       8to24_opts 24to32 no24to32 visual scale scale_cursor
                       viewonly noviewonly shared noshared forever noforever
                       once timeout tightfilexfer notightfilexfer ultrafilexfer
                       noultrafilexfer rfbversion deny lock nodeny unlock avahi
                       mdns zeroconf noavahi nomdns nozeroconf connect proxy
                       allowonce allow noipv6 ipv6 noipv4 ipv4 no6 6 localhost
                       nolocalhost listen lookup nolookup accept afteraccept
                       gone shm noshm flipbyteorder noflipbyteorder onetile
                       noonetile solid_color solid nosolid blackout xinerama
                       noxinerama xtrap noxtrap xrandr noxrandr xrandr_mode
                       rotate padgeom quiet q noquiet modtweak nomodtweak xkb
                       noxkb capslock nocapslock skip_lockkeys noskip_lockkeys
                       skip_keycodes sloppy_keys nosloppy_keys skip_dups
                       noskip_dups add_keysyms noadd_keysyms clear_mods
                       noclear_mods clear_keys noclear_keys clear_all
                       clear_locks keystate remap repeat norepeat fb nofb bell
                       nobell sendbell sel nosel primary noprimary setprimary
                       nosetprimary clipboard noclipboard setclipboard
                       nosetclipboard seldir cursorshape nocursorshape
                       cursorpos nocursorpos cursor_drag nocursor_drag cursor
                       show_cursor noshow_cursor nocursor arrow xfixes noxfixes
                       xdamage noxdamage xd_area xd_mem alphacut alphafrac
                       alpharemove noalpharemove alphablend noalphablend
                       xwarppointer xwarp noxwarppointer noxwarp always_inject
                       noalways_inject buttonmap dragging nodragging ncache_cr
                       noncache_cr ncache_no_moveraise noncache_no_moveraise
                       ncache_no_dtchange noncache_no_dtchange
                       ncache_no_rootpixmap noncache_no_rootpixmap
                       ncache_reset_rootpixmap ncrp ncache_keep_anims
                       noncache_keep_anims ncache_old_wm noncache_old_wm
                       ncache_pad ncache noncache ncache_size debug_ncache
                       nodebug_ncache wireframe_mode wireframe wf nowireframe
                       nowf wireframelocal wfl nowireframelocal nowfl
                       wirecopyrect wcr nowirecopyrect nowcr scr_area
                       scr_skip scr_inc scr_keys scr_term scr_keyrepeat
                       scr_parms scrollcopyrect scr noscrollcopyrect
                       noscr fixscreen noxrecord xrecord reset_record
                       pointer_mode pm input_skip allinput noallinput
                       input_eagerly noinput_eagerly input grabkbd nograbkbd
                       grabptr nograbptr grabalways nograbalways grablocal
                       client_input ssltimeout speeds wmdt debug_pointer dp
                       nodebug_pointer nodp debug_keyboard dk nodebug_keyboard
                       nodk keycode keysym ptr fakebuttonevent sleep get_xprop
                       set_xprop wininfo bcx_xattach deferupdate defer
                       setdefer extra_fbur wait_ui wait_bog nowait_bog
                       slow_fb xrefresh wait readtimeout nap nonap sb
                       screen_blank fbpm nofbpm dpms nodpms clientdpms
                       noclientdpms forcedpms noforcedpms noserverdpms
                       serverdpms noultraext ultraext chatwindow nochatwindow
                       chaton chatoff fs gaps grow fuzz snapfb nosnapfb
                       rawfb uinput_accel uinput_thresh uinput_reset
                       uinput_always progressive rfbport http nohttp httpport
                       httpdir enablehttpproxy noenablehttpproxy alwaysshared
                       noalwaysshared nevershared noalwaysshared dontdisconnect
                       nodontdisconnect desktop debug_xevents nodebug_xevents
                       debug_xevents debug_xdamage nodebug_xdamage
                       debug_xdamage debug_wireframe nodebug_wireframe
                       debug_wireframe debug_scroll nodebug_scroll debug_scroll
                       debug_tiles dbt nodebug_tiles nodbt debug_tiles
                       debug_grabs nodebug_grabs debug_sel nodebug_sel dbg
                       nodbg macnosaver macsaver nomacnosaver macnowait macwait
                       nomacnowait macwheel macnoswap macswap nomacnoswap
                       macnoresize macresize nomacnoresize maciconanim macmenu
                       macnomenu nomacmenu macuskbd nomacuskbd noremote

                       aro=  noop display vncdisplay icon_mode autoport
                       loop loopbg desktopname guess_desktop guess_dbus
                       http_url auth xauth users rootshift clipshift scale_str
                       scaled_x scaled_y scale_numer scale_denom scale_fac_x
                       scale_fac_y scaling_blend scaling_nomult4 scaling_pad
                       scaling_interpolate inetd privremote unsafe safer nocmds
                       passwdfile unixpw unixpw_nis unixpw_list ssl ssl_pem
                       sslverify stunnel stunnel_pem https httpsredir usepw
                       using_shm logfile o flag rmflag rc norc h help V version
                       lastmod bg sigpipe threads readrate netrate netlatency
                       pipeinput clients client_count pid ext_xtest ext_xtrap
                       ext_xrecord ext_xkb ext_xshm ext_xinerama ext_overlay
                       ext_xfixes ext_xdamage ext_xrandr rootwin num_buttons
                       button_mask mouse_x mouse_y grab_state pointer_pos
                       pointer_x pointer_y pointer_same pointer_root
                       pointer_mask bpp depth indexed_color dpy_x dpy_y wdpy_x
                       wdpy_y off_x off_y cdpy_x cdpy_y coff_x coff_y rfbauth
                       passwd viewpasswd

-QD variable           Just like -query variable, but returns the default
                       value for that parameter (no running x11vnc server
                       is consulted)

-sync                  By default -remote commands are run asynchronously, that
                       is, the request is posted and the program immediately
                       exits.  Use -sync to have the program wait for an
                       acknowledgement from the x11vnc server that command was
                       processed (somehow).  On the other hand -query requests
                       are always processed synchronously because they have
                       to wait for the answer.

                       Also note that if both -remote and -query requests are
                       supplied on the command line, the -remote is processed
                       first (synchronously: no need for -sync), and then
                       the -query request is processed in the normal way.
                       This allows for a reliable way to see if the -remote
                       command was processed by querying for any new settings.
                       Note however that there is timeout of a few seconds
                       (see the next paragraph) so if the x11vnc takes longer
                       than that to process the requests the requester will
                       think that a failure has taken place.

                       The default is to wait 3.5 seconds.  Or if cmd=stop
                       only 1.0 seconds.  If cmd matches 'script:' then it
                       will wait up to 10.0 seconds.  Set X11VNC_SYNC_TIMEOUT
                       to the number of seconds you want it to wait.

-query_retries str     If a query fails to get a response from an x11vnc
                       server, retry up to n times.  "str" is specified as
                       n[:t][/match]  Optionally the delay between tries may
                       be specified by "t" a floating point time (default
                       0.5 seconds.)  Note: the response is not checked for
                       validity or whether it corresponds to the query sent.
                       The query "ping:mystring" may be used to help uniquely
                       identify the query.  Optionally, a matching string after
                       a "/" will be used to check the result text.  Up to
                       n retries will take place until the matching string is
                       found in the output text.  If the match string is never
                       found the program's exit code is 1; if the match is
                       found it exits with 0.  Note that there may be stdout
                       printed for each retry (i.e. multiple lines printed
                       out to stdout.)
                       Example: -query_retries 4:1.5/grab_state

-remote_prefix str     Enable a remote-control communication channel for
                       connected VNC clients.  str is a non-empty string. If a
                       VNC client sends rfbCutText having the prefix "str"
                       then the part after it is processed as though it were
                       sent via 'x11vnc -remote ...'.  If it begins with
                       neither 'cmd=' nor 'qry=' then 'qry=' is assumed.
                       Any corresponding output text for that remote control
                       command is sent back to all client as rfbCutText.
                       The returned output is also prefixed with "str".
                       Example: -remote_prefix DO_THIS:

                       Note that enabling -remote_prefix allows the remote
                       VNC viewers to run x11vnc -remote commands.  Do not
                       use this option if they are not to be trusted.

-noremote              Do not process any remote control commands or queries.
-yesremote             Do process remote control commands or queries.
                       Default: -yesremote

                       A note about security wrt remote control commands.
                       If someone can connect to the X display and change
                       the property X11VNC_REMOTE, then they can remotely
                       control x11vnc.  Normally access to the X display is
                       protected.  Note that if they can modify X11VNC_REMOTE
                       on the X server, they have enough permissions to also
                       run their own x11vnc and thus have complete control
                       of the desktop.  If the  "-connect /path/to/file"
                       channel is being used, obviously anyone who can write
                       to /path/to/file can remotely control x11vnc.  So be
                       sure to protect the X display and that file's write
                       permissions.  See -privremote below.

                       If you are paranoid and do not think -noremote is
                       enough, to disable the X11VNC_REMOTE property channel
                       completely use -novncconnect, or use the -safer option
                       that shuts many things off.

-unsafe                A few remote commands are disabled by default
                       (currently: id:pick, accept:<cmd>, gone:<cmd>, and
                       rawfb:setup:<cmd>) because they are associated with
                       running external programs.  If you specify -unsafe, then
                       these remote-control commands are allowed.  Note that
                       you can still specify these parameters on the command
                       line, they just cannot be invoked via remote-control.
-safer                 Equivalent to: -novncconnect -noremote and prohibiting
                       -gui and the -connect file. Shuts off communcation
                       channels.
-privremote            Perform some sanity checks and disable remote-control
                       commands if it appears that the X DISPLAY and/or
                       connectfile can be accessed by other users.  Once
                       remote-control is disabled it cannot be turned back on.
-nocmds                No external commands (e.g. system(3), popen(3), exec(3))
                       will be run at all.
-allowedcmds list      "list" contains a comma separated list of the only
                       external commands that can be run.  The full list of
                       associated options is:

                        stunnel, ssl, unixpw, WAIT, zeroconf, id, accept,
                        afteraccept, gone, pipeinput, v4l-info, rawfb-setup,
                        dt, gui, ssh, storepasswd, passwdfile, custom_passwd,
                        findauth, crash.

                       See each option's help to learn the associated external
                       command.  Note that the -nocmds option takes precedence
                       and disables all external commands.

-deny_all              For use with -remote nodeny: start out denying all
                       incoming clients until "-remote nodeny" is used to
                       let them in.
```

These options are passed to LibVNCServer:

```
-rfbport port          TCP port for RFB protocol
-rfbwait time          max time in ms to wait for RFB client
-rfbauth passwd-file   use authentication on RFB protocol
                       (use 'storepasswd' to create a password file)
-rfbversion 3.x        Set the version of the RFB we choose to advertise
-permitfiletransfer    permit file transfer support
-passwd plain-password use authentication
                       (use plain-password as password, USE AT YOUR RISK)
-deferupdate time      time in ms to defer updates (default 40)
-deferptrupdate time   time in ms to defer pointer updates (default none)
-desktop name          VNC desktop name (default "LibVNCServer")
-alwaysshared          always treat new clients as shared
-nevershared           never treat new clients as shared
-dontdisconnect        don't disconnect existing clients when a new non-shared
                       connection comes in (refuse new connection instead)
-httpdir dir-path      enable http server using dir-path home
-httpport portnum      use portnum for http connection
-enablehttpproxy       enable http proxy support
-progressive height    enable progressive updating for slow links
-listen ipaddr         listen for connections only on network interface with
                       addr ipaddr. '-listen localhost' and hostname work too.

libvncserver-tight-extension options:
-disablefiletransfer   disable file transfer
-ftproot string        set ftp root
```

Pretty wild huh? Contact me if you have any questions or problems.

Personally, I use:

```
x11vnc -rfbauth $HOME/.vnc/passwd -solid
```
