--[[--
hash =              -- SHA3-224 digest (in hex notation) of input string
moonhash.sha3_224(
  data              -- input string
)

Calculates the SHA3-224 checksum with a security of 112 bits for collision attacks and 224 bits for preimage and second preimage attacks.

--]]--
-- Implemented in moonhash.c and moonhash_sha3.c
--//--


--[[--
hash =              -- SHA3-256 digest (in hex notation) of input string
moonhash.sha3_256(
  data              -- input string
)

Calculates the SHA3-256 checksum with a security of 128 bits for collision attacks and 256 bits for preimage and second preimage attacks.

--]]--
-- Implemented in moonhash.c and moonhash_sha3.c
--//--


--[[--
hash =              -- SHA3-384 digest (in hex notation) of input string
moonhash.sha3_384(
  data              -- input string
)

Calculates the SHA3-384 checksum with a security of 192 bits for collision attacks and 384 bits for preimage and second preimage attacks.

--]]--
-- Implemented in moonhash.c and moonhash_sha3.c
--//--


--[[--
hash =              -- SHA3-512 digest (in hex notation) of input string
moonhash.sha3_512(
  data              -- input string
)

Calculates the SHA3-512 checksum with a security of 512 bits for collision attacks and 256 bits for preimage and second preimage attacks.

--]]--
-- Implemented in moonhash.c and moonhash_sha3.c
--//--


--[[--
hash =              -- SHAKE128 digest of input string
moonhash.shake128(
  input_data,       -- input string
  output_length,    -- number of characters (not bytes or bits) in output, defaults to 32
  output_alphabet   -- characters for encoding, defaults to "0123456789abcdef" for hex encoding
)

Calculates a SHAKE128 digest (FIPS 202) with a security of math.min(128, math.log(#output_alphabet, 2) * output_length/2) for collision attacks and math.min(128, math.log(#output_alphabet, 2) * output_length) for preimage and second preimage attacks. If #output_alphabet is a power of 2, a direct base-N encoding is performed. Otherwise, a base-N encoding with N equal to the next higher power of 2 is performed, and all character values smaller than or equal to #output_alphabet are discarded from the stream (the process is repeated until the hash length reaches the required output_length).

--]]--
-- Implemented in moonhash.c and moonhash_sha3.c
--//--


--[[--
hash =              -- SHAKE256 digest of input string
moonhash.shake256(
  input_data,       -- input string
  output_length,    -- number of characters (not bytes or bits) in output, defaults to 64
  output_alphabet   -- characters for encoding, defaults to "0123456789abcdef" for hex encoding
)

Calculates a SHAKE256 digest (FIPS 202) with a security of math.min(256, math.log(#output_alphabet, 2) * output_length/2) for collision attacks and math.min(256, math.log(#output_alphabet, 2) * output_length) for preimage and second preimage attacks. If #output_alphabet is a power of 2, a direct base-N encoding is performed. Otherwise, a base-N encoding with N equal to the next higher power of 2 is performed, and all character values smaller than or equal to #output_alphabet are discarded from the stream (the process is repeated until the hash length reaches the required output_length).

--]]--
-- Implemented in moonhash.c and moonhash_sha3.c
--//--

