--[[--
text =                     -- a string
format.file_path_element(
  value,                   -- part of an encoded file path, see encode.file_path_element(...)
  options                  -- options as supported by format.string(...)
)

Undoes the encoding done by encode.file_path_element(...) and additionally formats the resulting string using the options available for format.string(...).

--]]--

function format.file_path_element(value, options)
  local options = options or {}
  if value == nil then
    return options.nil_as or ""
  else
    return format.string(
      string.gsub(
        tostring(value),
        "%%(%x%x)",
        function (hexcode)
          return string.char(tonumber("0x" .. hexcode))
        end
      ),
      options
    )
  end
end
