#ifndef SMT2NEWCONTEXT_H
#define SMT2NEWCONTEXT_H

#include <iostream>
#include <stdlib.h>
#include <list>

using namespace std;

enum ASTType {
      CMD_T      , CMDL_T
    , SYM_T      , SYML_T
    , NUM_T      , NUML_T
    , SORT_T     , SORTL_T
    , SV_T       , SVL_T
    , UATTR_T    , UATTRL_T
    , PATTR_T    , PATTRL_T
    , GATTR_T    , GATTRL_T
    , SPECC_T    , SPECCL_T
    , SEXPR_T    , SEXPRL_T
    , ID_T       , IDL_T
    , LID_T      , LIDL_T
    , DEC_T      , DECL_T
    , HEX_T      , HEXL_T
    , BIN_T      , BINL_T
    , STR_T      , STRL_T
    , AS_T       , ASL_T
    , VARB_T     , VARBL_T
    , TERM_T     , TERML_T
    , QID_T      , QITL_T
    , LQID_T     , LQIDL_T
    , LET_T      , LETL_T
    , FORALL_T   , FORALLL_T
    , EXISTS_T   , EXISTSL_T
    , BANG_T     , BANGL_T
    , SSYMD_T    , SSYMDL_T
    , FSYMD_T    , FSYMDL_T
    , PFSYMD_T   , PFSYMDL_T
    , PFID_T     , PFIDL_T
    , TATTR_T    , TATTRL_T
    , TDECL_T    , TDECLL_T
    , LATTR_T    , LATTRL_T
    , LOGIC_T    , LOGICL_T
    , BOOL_T     , BOOLL_T
    , OPTION_T   , OPTIONL_T
    , INFO_T     , INFOL_T
};



class ASTNode {
  private:
    ASTType             type;
    const char*         val;
    static const char*  typestr[];
  public:
    list< ASTNode* >*   children;
    ASTNode(ASTType t, const char* v) : type(t), val(v), children(NULL) {}
    void print(ostream& o, int indent);
    inline const char *typeToStr() { return typestr[type]; }
};

class Smt2newContext {
  private:
    void        init_scanner();
    void        destroy_scanner();
    char*       buffer;
    int         buffer_sz;
    int         buffer_cap;
    ASTNode*    root;
  public:
    void*       scanner;
    int         result;
    FILE*       is;

    Smt2newContext(FILE* in) :
       buffer_sz(0)
     , buffer_cap(1)
     , root(NULL)
     , result(0)
     , is(in)
    {
        init_scanner();
        buffer = (char *)malloc(buffer_cap);
    }

    ~Smt2newContext() {
        destroy_scanner();
    }

    void insertBuf(char c) {
        if (buffer_cap < buffer_sz + 1) {
            buffer_cap *= 2;
            buffer = (char*) realloc(buffer, buffer_cap);
        }
        buffer[buffer_sz++] = c;
    }

    const char* getBuf() {
        insertBuf('\0');
        return buffer;
    }

    void clearBuf() {
        buffer_sz = 0;
    }

    void insertRoot(ASTNode* n) {
        root = n;
    }

    void prettyPrint(ostream& o) {
        o << "Starting print" << endl;
        root->print(o, 0);
    }
};

int smt2newparse(Smt2newContext*);

#endif
