#!/bin/bash -
# libguestfs
# Copyright (C) 2013 Red Hat Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

# Regression test for:
# https://bugzilla.redhat.com/show_bug.cgi?id=957772
# Ensure that tar-out and base64-out commands properly quote arguments.

source ./functions.sh
set -e
set -x

skip_if_skipped

guestfish -N rhbz957772.img=fs -m /dev/sda1 <<EOF
mkdir "/test 1"
touch "/test 2"
tar-out "/test 1" /dev/null
base64-out "/test 2" /dev/null
EOF

rm rhbz957772.img
