/*
* This code is released under the GNU General Public License.  See COPYING for 
* details.  Copyright 2003 John Spray: spray_john@users.sourceforge.net
*/




#ifndef VECTOR_H
#define VECTOR_H

class Vector{
	public:
	void Unitize();
	void Randomize();
	int InCube(Vector,Vector);
	void Scalef(float xs,float ys,float zs);
	Vector();
	float Mag();
	float Mag2();
	void Set3f(float xnew,float ynew, float znew);
	
	float x;
	float y;
	float z;
	friend const Vector operator+(const Vector& left,const Vector& right);
	friend const Vector operator-(const Vector& left,const Vector& right);
	friend const Vector operator-(const Vector& original);
	friend const Vector operator*(const float& left,const Vector& right);
	friend const Vector operator*(const Vector& left,const float& right);
 	friend const Vector operator/(const Vector& left,const float& right);
	friend const Vector operator*(const Vector& left,const Vector& right);
	friend const Vector operator^(const Vector& left,const Vector& right);//cross product
	friend const float operator%(Vector& left,Vector& right);//angle-between
	friend const float operator|(const Vector& left,const Vector& right);//dot product
	friend int operator==(const Vector& left,const Vector& right);
	friend int operator>(Vector& left,Vector& right);
	friend int operator<(Vector& left,Vector& right);


	friend Vector& operator+=(Vector& left,const Vector& right);
	friend Vector& operator-=(Vector& left,const Vector& right);
	friend Vector& operator*=(Vector& left,const Vector& right);
	friend Vector& operator*=(Vector& left,const float& right);
	void operator=(const float& right)
	{
		x=right;
		y=right;
		z=right;
	}
};

const Vector PerpLinePoint(Vector l1,Vector l2,Vector p);
const int PointOnLine(Vector l1,Vector l2,Vector p);
const float Absf(float x);

#endif //VECTOR_H

