/*
* This code is released under the GNU General Public License.  See COPYING for 
* details.  Copyright 2003 John Spray: spray_john@users.sourceforge.net
*/


#ifndef LLIST_H
#define LLIST_H

#include <stdlib.h>

template<class TYPE>
class LListItem{
public:
	LListItem<TYPE>* next;
	TYPE data;
};


template<class TYPE>
class LList{
public:
	LList()
	{
		head=NULL;
		count=0;
	}
	~LList()
	{
		Flush();
	}
	TYPE* Add(TYPE* target)
	{
		LListItem<TYPE>* newitem;

		newitem=new LListItem<TYPE>;
		newitem->data=*target;
		newitem->next=head;
		head=newitem;
		count++;
		return &newitem->data;
	}

	LListItem<TYPE>* Del(LListItem<TYPE>* target)
	{
		LListItem<TYPE>* curr=NULL;
		LListItem<TYPE>* targetnext=NULL;
		curr=head;
		while(curr)
		{
			if(curr->next==target){
				curr->next=target->next;
				break;
			}
			curr=curr->next;
		}

		if(target==head)
		 head=target->next;

		targetnext=target->next;
		delete target;
		count--;
		return targetnext;

		
	}
	void Flush()
	{
		LListItem<TYPE>* curr=NULL;
  		curr=head;
		while(curr)
		{
			curr=Del(curr);
		}
		count=0;
	}
	LListItem<TYPE>* head;
	int count;
};

#endif //LLIST_H




