/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.lang;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.aspectj.lang.NoAspectBoundException;

public class Aspects {
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Class[] PEROBJECT_CLASS_ARRAY = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = Aspects.class$("java.lang.Object")) : class$java$lang$Object};
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final String ASPECTOF = "aspectOf";
    static /* synthetic */ Class class$java$lang$Object;

    public static Object aspectOf(Class aspectClass) throws NoAspectBoundException {
        try {
            return Aspects.getSingletonAspectOf(aspectClass).invoke(null, EMPTY_OBJECT_ARRAY);
        }
        catch (Exception e) {
            throw new NoAspectBoundException(aspectClass.getName(), e);
        }
    }

    public static Object aspectOf(Class aspectClass, Object perObject) throws NoAspectBoundException {
        try {
            return Aspects.getPerObjectAspectOf(aspectClass).invoke(null, perObject);
        }
        catch (Exception e) {
            throw new NoAspectBoundException(aspectClass.getName(), e);
        }
    }

    public static Object aspectOf(Class aspectClass, Thread perThread) throws NoAspectBoundException {
        try {
            return Aspects.getSingletonAspectOf(aspectClass).invoke(null, EMPTY_OBJECT_ARRAY);
        }
        catch (Exception e) {
            throw new NoAspectBoundException(aspectClass.getName(), e);
        }
    }

    private static Method getSingletonAspectOf(Class aspectClass) throws NoSuchMethodException {
        Method method = aspectClass.getDeclaredMethod(ASPECTOF, EMPTY_CLASS_ARRAY);
        return Aspects.checkAspectOf(method, aspectClass);
    }

    private static Method getPerObjectAspectOf(Class aspectClass) throws NoSuchMethodException {
        Method method = aspectClass.getDeclaredMethod(ASPECTOF, PEROBJECT_CLASS_ARRAY);
        return Aspects.checkAspectOf(method, aspectClass);
    }

    private static Method checkAspectOf(Method method, Class aspectClass) throws NoSuchMethodException {
        ((AccessibleObject)method).setAccessible(true);
        if (!(method.isAccessible() && Modifier.isPublic(method.getModifiers()) && Modifier.isStatic(method.getModifiers()))) {
            throw new NoSuchMethodException(aspectClass.getName() + ".aspectOf(..) is not accessible public static");
        }
        return method;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

