/*
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once

namespace apache::thrift {

struct ServerRequestData;

// A common interface for completion for server requests
// All the components that will invoke callbacks during request
// destruction should inherit from this class
class RequestCompletionCallback {
 public:
  virtual ~RequestCompletionCallback() {}

  virtual void onRequestFinished(ServerRequestData&) = 0;
};

} // namespace apache::thrift
