/*
 *  gd.xml.tiny package: classes for parsing XML documents
 *  Copyright (C) 1999  Tom Gibara <tom@srac.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package gd.xml.tiny;

import java.util.*;


/** Stores an element of parsed XML.
 *  Instances of this class are used to compose a parse tree.
 *  It's methods may be used to retrieve it's attributes and it's child nodes.
 *  @author Tom Gibara
 */

public interface ParsedXML {

    /**
     *  @return a short string which descibes the contents of this node
     */

    public String getTypeName();


    /** Used to obtain the tag name which produced this node.
     *  @return a tag name or null if node was not generated by a tag
     */

    public String getName();


    /** Used to obtain the textual content of tags, comments and CDATA.
     *  @return a string, may be null
     */

    public String getContent();


    /** Used to determine whether the tag which generated this node was empty.
     *  This method always returns true when called on nodes not generated by tags.
     *  @return true if the tag was empty, false otherwise
     */

    public boolean isEmpty();


    /** Used to obtain an enumeration of this node's children.
     *  The children of a node correspond to data contained between start and end tag pairs.
     *  The enumeration is always empty for nodes which were not generated from tag pairs.
     *  @return the child nodes
     */

    public Enumeration elements();


    /** Used to obtain an enumeration of the attributes applied to an XML element.
     *  The contents of the enumeration are the names of attributes within an XML start tag.
     *  The enumeration is always empty for nodes which were not generated by tags.
     *  @return the names of tag attributes as strings
     */

    public Enumeration attributes();


    /** Used to obtain the value of a tag attribute.
     *  @return the value of the specified attribute or null if it doesn't exist
     */

    public String getAttribute(String a);


}
