/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import megamek.common.IGame;
import megamek.common.Player;
import megamek.common.TurnOrdered;
import megamek.common.TurnVectors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Team
extends TurnOrdered
implements Serializable {
    private static final long serialVersionUID = 2270215552964191597L;
    private Vector<Player> players = new Vector();
    private int id;

    public Team(int n) {
        this.id = n;
    }

    public int getSize() {
        return this.players.size();
    }

    public Enumeration<Player> getPlayers() {
        return this.players.elements();
    }

    public void resetTeam() {
        this.players.removeAllElements();
    }

    public void addPlayer(Player player) {
        this.players.addElement(player);
    }

    @Override
    public void clearInitiative() {
        this.getInitiative().clear();
        TurnOrdered.rollInitiative(this.players);
    }

    public TurnVectors determineTeamOrder(IGame iGame) {
        return TurnOrdered.generateTurnOrder(this.players, iGame);
    }

    public int getId() {
        return this.id;
    }

    @Override
    public int getNormalTurns(IGame iGame) {
        int n = this.getMultiTurns(iGame) + this.getOtherTurns();
        if (0 == n) {
            n = this.getEvenTurns();
        }
        return n;
    }

    @Override
    public int getEvenTurns() {
        int n = 0;
        Enumeration<Player> enumeration = this.players.elements();
        while (enumeration.hasMoreElements()) {
            n += enumeration.nextElement().getEvenTurns();
        }
        return n;
    }

    @Override
    public int getOtherTurns() {
        int n = 0;
        Enumeration<Player> enumeration = this.players.elements();
        while (enumeration.hasMoreElements()) {
            n += enumeration.nextElement().getOtherTurns();
        }
        return n;
    }

    @Override
    public int getMultiTurns(IGame iGame) {
        int n = 0;
        Enumeration<Player> enumeration = this.players.elements();
        while (enumeration.hasMoreElements()) {
            n += enumeration.nextElement().getMultiTurns(iGame);
        }
        return n;
    }

    @Override
    public int getSpaceStationTurns() {
        int n = 0;
        Enumeration<Player> enumeration = this.players.elements();
        while (enumeration.hasMoreElements()) {
            n += enumeration.nextElement().getSpaceStationTurns();
        }
        return n;
    }

    @Override
    public int getJumpshipTurns() {
        int n = 0;
        Enumeration<Player> enumeration = this.players.elements();
        while (enumeration.hasMoreElements()) {
            n += enumeration.nextElement().getJumpshipTurns();
        }
        return n;
    }

    @Override
    public int getWarshipTurns() {
        int n = 0;
        Enumeration<Player> enumeration = this.players.elements();
        while (enumeration.hasMoreElements()) {
            n += enumeration.nextElement().getWarshipTurns();
        }
        return n;
    }

    @Override
    public int getDropshipTurns() {
        int n = 0;
        Enumeration<Player> enumeration = this.players.elements();
        while (enumeration.hasMoreElements()) {
            n += enumeration.nextElement().getDropshipTurns();
        }
        return n;
    }

    @Override
    public int getSmallCraftTurns() {
        int n = 0;
        Enumeration<Player> enumeration = this.players.elements();
        while (enumeration.hasMoreElements()) {
            n += enumeration.nextElement().getSmallCraftTurns();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Team team = (Team)object;
        if (team.getId() != this.getId() || team.getSize() != this.getSize()) {
            return false;
        }
        Enumeration<Player> enumeration = this.getPlayers();
        Enumeration<Player> enumeration2 = team.getPlayers();
        while (enumeration.hasMoreElements()) {
            if (enumeration.nextElement().equals(enumeration2.nextElement())) continue;
            return false;
        }
        return true;
    }

    public boolean hasTAG(IGame iGame) {
        Enumeration<Player> enumeration = iGame.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = enumeration.nextElement();
            if (this.getId() != player.getTeam() || !player.hasTAG()) continue;
            return true;
        }
        return false;
    }

    public int getTotalInitBonus() {
        Player player;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Enumeration<Player> enumeration = this.getPlayers();
        while (enumeration.hasMoreElements()) {
            player = enumeration.nextElement();
            if (player.getConstantInitBonus() > n && player.getConstantInitBonus() != 0) {
                n = player.getConstantInitBonus();
            }
            if (player.getConstantInitBonus() >= 0 || n != 0) continue;
            n = player.getConstantInitBonus();
        }
        enumeration = this.getPlayers();
        while (enumeration.hasMoreElements()) {
            player = enumeration.nextElement();
            n2 += player.getTurnInitBonus();
            if (player.getCommandBonus() <= n3) continue;
            n3 = player.getCommandBonus();
        }
        return n + n2 + n3;
    }

    public Vector<Integer> getAirborneVTOL() {
        Vector<Integer> vector = new Vector<Integer>();
        Enumeration<Player> enumeration = this.players.elements();
        while (enumeration.hasMoreElements()) {
            Player player = enumeration.nextElement();
            vector.addAll(player.getAirborneVTOL());
        }
        return vector;
    }
}

