/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT.widget;

import java.awt.Graphics;
import java.awt.Image;

public class BackGroundDrawer {
    public static final int NO_TILING = 1;
    public static final int TILING_VERTICAL = 2;
    public static final int TILING_HORIZONTAL = 4;
    public static final int TILING_BOTH = 8;
    public static final int VALIGN_TOP = 16;
    public static final int VALIGN_CENTER = 32;
    public static final int VALIGN_BOTTOM = 64;
    public static final int VALIGN_EXACT = 128;
    public static final int HALIGN_LEFT = 256;
    public static final int HALIGN_CENTER = 512;
    public static final int HALIGN_RIGHT = 1024;
    public static final int HALIGN_EXACT = 2048;
    private static final int TILING_TYPE_MASK = 4080;
    private static final int VALIGN_MASK = 3855;
    private static final int HALIGN_MASK = 255;
    private static final int TILING_TYPE_SELECT_MASK = 15;
    private static final int VALIGN_SELECT_MASK = 240;
    private static final int HALIGN_SELECT_MASK = 3840;
    private Image mainImage;
    private int behavior = 545;
    private int fixedX = 0;
    private int fixedY = 0;

    public BackGroundDrawer(Image image, int n) {
        this.mainImage = image;
        this.behavior = n;
    }

    public BackGroundDrawer(Image image) {
        this.mainImage = image;
    }

    public void setImage(Image image) {
        this.mainImage = image;
    }

    public Image getImage() {
        return this.mainImage;
    }

    public void setTilingType(int n) {
        this.behavior &= 0xFF0;
        this.behavior |= (n &= 0xF);
    }

    public void setValign(int n) {
        this.behavior &= 0xF0F;
        this.behavior |= (n &= 0xF0);
    }

    public void setHalign(int n) {
        this.behavior &= 0xFF;
        this.behavior |= (n &= 0xF00);
    }

    public void setValignExactAt(int n) {
        this.setValign(128);
        this.fixedY = n;
    }

    public void setHalignExactAt(int n) {
        this.setHalign(2048);
        this.fixedX = n;
    }

    public int getBehavior() {
        return this.behavior;
    }

    public void drawInto(Graphics graphics, int n, int n2) {
        if (this.mainImage == null) {
            return;
        }
        if ((this.behavior & 1) != 0) {
            this.drawNoTiling(graphics, n, n2);
            return;
        }
        if ((this.behavior & 8) != 0) {
            this.drawTilingBoth(graphics, n, n2);
            return;
        }
        if ((this.behavior & 2) != 0) {
            this.drawTilingVertical(graphics, n, n2);
            return;
        }
        if ((this.behavior & 4) != 0) {
            this.drawTilingHorizontal(graphics, n, n2);
            return;
        }
    }

    private void drawNoTiling(Graphics graphics, int n, int n2) {
        int n3 = this.getDX(n);
        int n4 = this.getDY(n2);
        graphics.drawImage(this.mainImage, n3, n4, null);
    }

    private void drawTilingBoth(Graphics graphics, int n, int n2) {
        int n3 = this.mainImage.getWidth(null);
        int n4 = this.mainImage.getHeight(null);
        int n5 = n / n3;
        if (n % n3 != 0) {
            ++n5;
        }
        int n6 = n2 / n4;
        if (n2 % n4 != 0) {
            ++n6;
        }
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n6; ++j) {
                graphics.drawImage(this.mainImage, i * n3, j * n4, null);
            }
        }
    }

    private void drawTilingVertical(Graphics graphics, int n, int n2) {
        int n3 = this.getDX(n);
        int n4 = this.mainImage.getHeight(null);
        int n5 = n2 / n4;
        if (n2 % n4 != 0) {
            ++n5;
        }
        for (int i = 0; i < n5; ++i) {
            graphics.drawImage(this.mainImage, n3, i * n4, null);
        }
    }

    private void drawTilingHorizontal(Graphics graphics, int n, int n2) {
        int n3 = this.getDY(n2);
        int n4 = this.mainImage.getWidth(null);
        int n5 = n / n4;
        if (n % n4 != 0) {
            ++n5;
        }
        for (int i = 0; i < n5; ++i) {
            graphics.drawImage(this.mainImage, i * n4, n3, null);
        }
    }

    private int getDX(int n) {
        int n2 = 0;
        int n3 = this.mainImage.getWidth(null);
        if ((this.behavior & 0x100) != 0) {
            n2 = 0;
        } else if ((this.behavior & 0x200) != 0) {
            n2 = (n - n3) / 2;
            if (n2 < 0) {
                n2 = 0;
            }
        } else if ((this.behavior & 0x400) != 0) {
            n2 = n - n3;
        } else if ((this.behavior & 0x800) != 0) {
            n2 = this.fixedX;
        }
        return n2;
    }

    private int getDY(int n) {
        int n2 = 0;
        int n3 = this.mainImage.getHeight(null);
        if ((this.behavior & 0x10) != 0) {
            n2 = 0;
        } else if ((this.behavior & 0x20) != 0) {
            n2 = (n - n3) / 2;
            if (n2 < 0) {
                n2 = 0;
            }
        } else if ((this.behavior & 0x40) != 0) {
            n2 = n - n3;
        } else if ((this.behavior & 0x80) != 0) {
            n2 = this.fixedY;
        }
        return n2;
    }
}

