/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT;

import java.awt.Button;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Enumeration;
import java.util.Vector;
import megamek.client.Client;
import megamek.client.event.BoardViewEvent;
import megamek.client.event.BoardViewListener;
import megamek.client.ui.AWT.AlertDialog;
import megamek.client.ui.AWT.BoardView1;
import megamek.client.ui.AWT.ClientGUI;
import megamek.client.ui.AWT.DoneButtoned;
import megamek.client.ui.AWT.SingleChoiceDialog;
import megamek.client.ui.AWT.StatusBarPhaseDisplay;
import megamek.client.ui.Messages;
import megamek.common.Aero;
import megamek.common.Board;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.Player;
import megamek.common.event.GameListener;
import megamek.common.event.GamePhaseChangeEvent;
import megamek.common.event.GameTurnChangeEvent;

public class DeploymentDisplay
extends StatusBarPhaseDisplay
implements BoardViewListener,
ActionListener,
DoneButtoned,
KeyListener,
GameListener {
    private static final long serialVersionUID = 6264922297603128233L;
    public static final String DEPLOY_TURN = "deployTurn";
    public static final String DEPLOY_NEXT = "deployNext";
    public static final String DEPLOY_LOAD = "deployLoad";
    public static final String DEPLOY_UNLOAD = "deployUnload";
    public static final String DEPLOY_REMOVE = "deployRemove";
    public static final String DEPLOY_ASSAULTDROP = "assaultDrop";
    public static final String DEPLOY_FORM_SQUADRON = "formSquadron";
    public Client client;
    private ClientGUI clientgui;
    private Panel panButtons;
    private Button butNext;
    private Button butTurn;
    private Button butLoad;
    private Button butUnload;
    private Button butRemove;
    private Button butAssaultDrop;
    private Button butFormSquadron;
    private Button butDone;
    private int cen = -1;
    private boolean turnMode = false;
    private boolean assaultDropPreference = false;

    public DeploymentDisplay(ClientGUI clientGUI) {
        this.clientgui = clientGUI;
        this.client = clientGUI.getClient();
        this.client.game.addGameListener(this);
        clientGUI.getBoardView().addBoardViewListener(this);
        this.setupStatusBar(Messages.getString("DeploymentDisplay.waitingForDeploymentPhase"));
        this.butTurn = new Button(Messages.getString("DeploymentDisplay.Turn"));
        this.butTurn.addActionListener(this);
        this.butTurn.setActionCommand(DEPLOY_TURN);
        this.butTurn.setEnabled(false);
        this.butLoad = new Button(Messages.getString("DeploymentDisplay.Load"));
        this.butLoad.addActionListener(this);
        this.butLoad.setActionCommand(DEPLOY_LOAD);
        this.butLoad.setEnabled(false);
        this.butUnload = new Button(Messages.getString("DeploymentDisplay.Unload"));
        this.butUnload.addActionListener(this);
        this.butUnload.setActionCommand(DEPLOY_UNLOAD);
        this.butUnload.setEnabled(false);
        this.butNext = new Button(Messages.getString("DeploymentDisplay.NextUnit"));
        this.butNext.addActionListener(this);
        this.butNext.setActionCommand(DEPLOY_NEXT);
        this.butNext.setEnabled(true);
        this.butRemove = new Button(Messages.getString("DeploymentDisplay.Remove"));
        this.butRemove.addActionListener(this);
        this.butRemove.setActionCommand(DEPLOY_REMOVE);
        this.setRemoveEnabled(true);
        this.butFormSquadron = new Button(Messages.getString("DeploymentDisplay.FormSquadron"));
        this.butFormSquadron.addActionListener(this);
        this.butFormSquadron.setActionCommand(DEPLOY_FORM_SQUADRON);
        this.setFormSquadronEnabled(true);
        this.butAssaultDrop = new Button(Messages.getString("DeploymentDisplay.AssaultDropOn"));
        this.butAssaultDrop.addActionListener(this);
        this.butAssaultDrop.setActionCommand(DEPLOY_ASSAULTDROP);
        this.butAssaultDrop.setEnabled(false);
        this.butDone = new Button(Messages.getString("DeploymentDisplay.Deploy"));
        this.butDone.addActionListener(this);
        this.butDone.setEnabled(false);
        this.panButtons = new Panel();
        this.panButtons.setLayout(new GridLayout(0, 8));
        this.panButtons.add(this.butNext);
        this.panButtons.add(this.butTurn);
        this.panButtons.add(this.butLoad);
        this.panButtons.add(this.butUnload);
        this.panButtons.add(this.butRemove);
        this.panButtons.add(this.butAssaultDrop);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addBag(this.panButtons, gridBagLayout, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        this.addBag(this.panStatus, gridBagLayout, gridBagConstraints);
        clientGUI.bv.addKeyListener(this);
        this.addKeyListener(this);
    }

    private void addBag(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
        component.addKeyListener(this);
    }

    public void selectEntity(int n) {
        if (this.client.game.getEntity(n) == null) {
            System.err.println("DeploymentDisplay: tried to select non-existant entity: " + n);
            return;
        }
        if (this.clientgui.bv instanceof BoardView1) {
            ((BoardView1)this.clientgui.bv).clearC3Networks();
        }
        this.cen = n;
        this.clientgui.setSelectedEntityNum(n);
        this.setTurnEnabled(true);
        this.butDone.setEnabled(false);
        this.setLoadEnabled(true);
        this.setUnloadEnabled(true);
        this.clientgui.getBoardView().select(null);
        this.clientgui.getBoardView().cursor(null);
        if (null != this.ce()) {
            switch (this.client.getLocalPlayer().getStartingPos()) {
                case 8: {
                    this.ce().setFacing(1);
                    this.ce().setSecondaryFacing(1);
                    break;
                }
                case 7: {
                    this.ce().setFacing(1);
                    this.ce().setSecondaryFacing(1);
                    break;
                }
                case 6: {
                    this.ce().setFacing(0);
                    this.ce().setSecondaryFacing(0);
                    break;
                }
                case 5: {
                    this.ce().setFacing(5);
                    this.ce().setSecondaryFacing(5);
                    break;
                }
                case 4: {
                    this.ce().setFacing(5);
                    this.ce().setSecondaryFacing(5);
                    break;
                }
                case 3: {
                    this.ce().setFacing(4);
                    this.ce().setSecondaryFacing(4);
                    break;
                }
                case 2: {
                    this.ce().setFacing(3);
                    this.ce().setSecondaryFacing(3);
                    break;
                }
                case 1: {
                    this.ce().setFacing(2);
                    this.ce().setSecondaryFacing(2);
                    break;
                }
                case 0: {
                    this.ce().setFacing(0);
                    this.ce().setSecondaryFacing(0);
                }
            }
            this.setAssaultDropEnabled(this.ce().canAssaultDrop() && this.ce().getGame().getOptions().booleanOption("assault_drop"));
            if (!this.ce().canAssaultDrop() && this.ce().getGame().getOptions().booleanOption("assault_drop")) {
                this.butAssaultDrop.setLabel(Messages.getString("DeploymentDisplay.AssaultDropOn"));
                this.assaultDropPreference = false;
            }
            this.clientgui.mechD.displayEntity(this.ce());
            this.clientgui.mechD.showPanel("movement");
            this.clientgui.getMenuBar().setEntity(this.ce());
        }
    }

    private void beginMyTurn() {
        this.clientgui.setDisplayVisible(true);
        this.selectEntity(this.client.getFirstDeployableEntityNum());
        this.setNextEnabled(true);
        Player player = this.client.getLocalPlayer();
        this.clientgui.bv.markDeploymentHexesFor(player);
        if (this.client.getBoard().inSpace() && this.client.game.getOptions().booleanOption("stratops_capital_fighter")) {
            this.setFormSquadronEnabled(true);
        }
    }

    private void endMyTurn() {
        this.disableButtons();
        Entity entity = this.client.game.getNextEntity(this.client.game.getTurnIndex());
        if (IGame.Phase.PHASE_DEPLOYMENT == this.client.game.getPhase() && null != entity && null != this.ce() && entity.getOwnerId() != this.ce().getOwnerId()) {
            this.clientgui.setDisplayVisible(false);
        }
        this.cen = -1;
        this.clientgui.getBoardView().select(null);
        this.clientgui.getBoardView().highlight(null);
        this.clientgui.getBoardView().cursor(null);
        this.clientgui.bv.markDeploymentHexesFor(null);
    }

    private void disableButtons() {
        this.setTurnEnabled(false);
        this.setNextEnabled(false);
        this.butDone.setEnabled(false);
        this.setLoadEnabled(false);
        this.setUnloadEnabled(false);
        this.setFormSquadronEnabled(false);
    }

    private void deploy() {
        this.disableButtons();
        Entity entity = this.ce();
        this.client.deploy(this.cen, entity.getPosition(), entity.getFacing(), entity.getLoadedUnits(), this.assaultDropPreference);
        entity.setDeployed(true);
    }

    private void remove() {
        this.disableButtons();
        this.client.sendDeleteEntity(this.cen);
        this.selectEntity(this.client.getNextDeployableEntityNum(this.cen));
        if (this.client.getNextDeployableEntityNum(this.cen) == -1) {
            this.butNext.setEnabled(false);
            this.endMyTurn();
        }
    }

    private Entity ce() {
        return this.client.game.getEntity(this.cen);
    }

    public void die() {
        if (this.client.isMyTurn()) {
            this.endMyTurn();
        }
        this.clientgui.bv.markDeploymentHexesFor(null);
        this.client.game.removeGameListener(this);
        this.clientgui.getBoardView().removeBoardViewListener(this);
        this.removeAll();
    }

    public void gameTurnChange(GameTurnChangeEvent gameTurnChangeEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (this.client.isMyTurn()) {
            this.beginMyTurn();
            this.setStatusBarText(Messages.getString("DeploymentDisplay.its_your_turn"));
        } else {
            this.endMyTurn();
            this.setStatusBarText(Messages.getString("DeploymentDisplay.its_others_turn", new Object[]{gameTurnChangeEvent.getPlayer().getName()}));
        }
    }

    public void gamePhaseChange(GamePhaseChangeEvent gamePhaseChangeEvent) {
        this.clientgui.bv.markDeploymentHexesFor(null);
        if (this.isIgnoringEvents()) {
            return;
        }
        if (this.client.game.getPhase() == IGame.Phase.PHASE_DEPLOYMENT) {
            this.setStatusBarText(Messages.getString("DeploymentDisplay.waitingForDeploymentPhase"));
        }
    }

    public void hexMoused(BoardViewEvent boardViewEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (boardViewEvent.getType() != 2) {
            return;
        }
        if (!this.client.isMyTurn() || this.ce() == null || (boardViewEvent.getModifiers() & 0x10) == 0) {
            return;
        }
        if ((boardViewEvent.getModifiers() & 2) != 0 || (boardViewEvent.getModifiers() & 8) != 0) {
            return;
        }
        boolean bl = (boardViewEvent.getModifiers() & 1) != 0;
        Coords coords = boardViewEvent.getCoords();
        if (this.ce().getPosition() != null && (bl || this.turnMode)) {
            this.ce().setFacing(this.ce().getPosition().direction(coords));
            this.ce().setSecondaryFacing(this.ce().getFacing());
            this.clientgui.bv.redrawEntity(this.ce());
            this.turnMode = false;
        } else {
            if (this.ce().isBoardProhibited(this.client.game.getBoard().getType())) {
                AlertDialog alertDialog = new AlertDialog(this.clientgui.frame, Messages.getString("DeploymentDisplay.alertDialog.title"), Messages.getString("DeploymentDisplay.wrongMapType", new Object[]{this.ce().getShortName(), Board.getTypeName(this.client.game.getBoard().getType())}));
                alertDialog.setVisible(true);
                return;
            }
            if (!this.client.game.getBoard().isLegalDeployment(coords, this.ce().getOwner()) && !this.assaultDropPreference || this.ce().isHexProhibited(this.client.game.getBoard().getHex(coords))) {
                AlertDialog alertDialog = new AlertDialog(this.clientgui.frame, Messages.getString("DeploymentDisplay.alertDialog.title"), Messages.getString("DeploymentDisplay.cantDeployInto", new Object[]{this.ce().getShortName(), coords.getBoardNum()}));
                alertDialog.setVisible(true);
                return;
            }
            if (this.ce() instanceof Aero && this.client.game.getBoard().inAtmosphere() && this.ce().getElevation() <= this.client.game.getBoard().getHex(coords).ceiling()) {
                AlertDialog alertDialog = new AlertDialog(this.clientgui.frame, Messages.getString("DeploymentDisplay.alertDialog.title"), Messages.getString("DeploymentDisplay.elevationTooLow", new Object[]{this.ce().getShortName(), coords.getBoardNum()}));
                alertDialog.setVisible(true);
                return;
            }
            if (Compute.stackingViolation(this.client.game, this.ce().getId(), coords) != null) {
                return;
            }
            this.ce().setPosition(coords);
            this.clientgui.bv.redrawEntity(this.ce());
            this.butDone.setEnabled(true);
        }
        this.clientgui.getBoardView().select(coords);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        if (this.statusBarActionPerformed(actionEvent, this.client)) {
            return;
        }
        if (!this.client.isMyTurn()) {
            return;
        }
        if (actionEvent.getSource() == this.butDone) {
            this.deploy();
        } else if (actionEvent.getActionCommand().equals(DEPLOY_NEXT)) {
            this.ce().setPosition(null);
            this.clientgui.bv.redrawEntity(this.ce());
            Enumeration<Entity> enumeration = this.ce().getLoadedUnits().elements();
            while (enumeration.hasMoreElements()) {
                Entity entity = enumeration.nextElement();
                this.ce().unload(entity);
                entity.setTransportId(-1);
                entity.newRound(this.client.game.getRoundCount());
            }
            this.selectEntity(this.client.getNextDeployableEntityNum(this.cen));
        } else if (actionEvent.getActionCommand().equals(DEPLOY_TURN)) {
            this.turnMode = true;
        } else if (actionEvent.getActionCommand().equals(DEPLOY_LOAD)) {
            Entity entity;
            Vector<Entity> vector = new Vector<Entity>();
            Enumeration<Entity> enumeration = this.client.game.getEntities();
            while (enumeration.hasMoreElements()) {
                entity = enumeration.nextElement();
                if (!entity.isSelectableThisTurn() || !this.ce().canLoad(entity)) continue;
                vector.addElement(entity);
            }
            if (vector.size() > 0) {
                String[] stringArray = new String[vector.size()];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = ((Entity)vector.elementAt(i)).getShortName();
                }
                SingleChoiceDialog singleChoiceDialog = new SingleChoiceDialog(this.clientgui.frame, Messages.getString("DeploymentDisplay.loadUnitDialog.title"), Messages.getString("DeploymentDisplay.loadUnitDialog.message", new Object[]{this.ce().getShortName(), this.ce().getUnusedString()}), stringArray);
                singleChoiceDialog.setVisible(true);
                if (singleChoiceDialog.getAnswer()) {
                    entity = (Entity)vector.elementAt(singleChoiceDialog.getChoice());
                    this.ce().load(entity);
                    entity.setTransportId(this.cen);
                    this.clientgui.mechD.displayEntity(this.ce());
                }
            } else {
                AlertDialog alertDialog = new AlertDialog(this.clientgui.frame, Messages.getString("DeploymentDisplay.allertDialog1.title"), Messages.getString("DeploymentDisplay.allertDialog1.message", new Object[]{this.ce().getShortName()}));
                alertDialog.setVisible(true);
            }
        } else if (actionEvent.getActionCommand().equals(DEPLOY_UNLOAD)) {
            Vector<Entity> vector = this.ce().getLoadedUnits();
            if (vector.size() > 0) {
                Entity entity = null;
                String[] stringArray = new String[vector.size()];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = vector.elementAt(i).getShortName();
                }
                SingleChoiceDialog singleChoiceDialog = new SingleChoiceDialog(this.clientgui.frame, Messages.getString("DeploymentDisplay.unloadUnitDialog.title"), Messages.getString("DeploymentDisplay.unloadUnitDialog.message", new Object[]{this.ce().getShortName(), this.ce().getUnusedString()}), stringArray);
                singleChoiceDialog.setVisible(true);
                if (singleChoiceDialog.getAnswer()) {
                    entity = vector.elementAt(singleChoiceDialog.getChoice());
                    if (this.ce().unload(entity)) {
                        entity.setTransportId(-1);
                        entity.newRound(this.client.game.getRoundCount());
                        this.clientgui.mechD.displayEntity(this.ce());
                    } else {
                        System.out.println("Could not unload " + entity.getShortName() + " from " + this.ce().getShortName());
                    }
                }
            } else {
                AlertDialog alertDialog = new AlertDialog(this.clientgui.frame, Messages.getString("DeploymentDisplay.allertDialog2.title"), Messages.getString("DeploymentDisplay.allertDialog2.message", new Object[]{this.ce().getShortName()}));
                alertDialog.setVisible(true);
            }
        } else if (actionEvent.getActionCommand().equals(DEPLOY_REMOVE)) {
            this.remove();
        } else if (actionEvent.getActionCommand().equals(DEPLOY_ASSAULTDROP)) {
            boolean bl = this.assaultDropPreference = !this.assaultDropPreference;
            if (this.assaultDropPreference) {
                this.butAssaultDrop.setLabel(Messages.getString("DeploymentDisplay.AssaultDropOff"));
            } else {
                this.butAssaultDrop.setLabel(Messages.getString("DeploymentDisplay.AssaultDropOn"));
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void finishedMovingUnits(BoardViewEvent boardViewEvent) {
    }

    public void unitSelected(BoardViewEvent boardViewEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        Entity entity = this.client.game.getEntity(boardViewEvent.getEntityId());
        if (null == entity) {
            return;
        }
        if (this.client.isMyTurn()) {
            if (this.client.game.getTurn().isValidEntity(entity, this.client.game)) {
                if (this.ce() != null) {
                    this.ce().setPosition(null);
                    this.clientgui.bv.redrawEntity(this.ce());
                    Enumeration<Entity> enumeration = this.ce().getLoadedUnits().elements();
                    while (enumeration.hasMoreElements()) {
                        Entity entity2 = enumeration.nextElement();
                        this.ce().unload(entity2);
                        entity2.setTransportId(-1);
                        entity2.newRound(this.client.game.getRoundCount());
                    }
                }
                this.selectEntity(entity.getId());
                if (null != entity.getPosition()) {
                    this.clientgui.bv.centerOnHex(entity.getPosition());
                }
            }
        } else {
            this.clientgui.setDisplayVisible(true);
            this.clientgui.mechD.displayEntity(entity);
            if (entity.isDeployed()) {
                this.clientgui.bv.centerOnHex(entity.getPosition());
            }
        }
    }

    private void setNextEnabled(boolean bl) {
        this.butNext.setEnabled(bl);
        this.clientgui.getMenuBar().setDeployNextEnabled(bl);
    }

    private void setTurnEnabled(boolean bl) {
        this.butTurn.setEnabled(bl);
        this.clientgui.getMenuBar().setDeployTurnEnabled(bl);
    }

    private void setLoadEnabled(boolean bl) {
        this.butLoad.setEnabled(bl);
        this.clientgui.getMenuBar().setDeployLoadEnabled(bl);
    }

    private void setUnloadEnabled(boolean bl) {
        this.butUnload.setEnabled(bl);
        this.clientgui.getMenuBar().setDeployUnloadEnabled(bl);
    }

    private void setRemoveEnabled(boolean bl) {
        this.butRemove.setEnabled(bl);
        this.clientgui.getMenuBar().setDeployNextEnabled(bl);
    }

    private void setAssaultDropEnabled(boolean bl) {
        this.butAssaultDrop.setEnabled(bl);
        this.clientgui.getMenuBar().setDeployAssaultDropEnabled(bl);
    }

    private void setFormSquadronEnabled(boolean bl) {
        this.butFormSquadron.setEnabled(bl);
        this.clientgui.getMenuBar().setDeployFormSquadronEnabled(bl);
    }

    public Button getDoneButton() {
        return this.butDone;
    }

    public void removeAllListeners() {
        this.die();
    }
}

