/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.time.Weekday;
import org.jquantlib.time.WesternCalendar;
import org.jquantlib.time.calendars.DelegateCalendar;
import org.jquantlib.util.Date;
import org.jquantlib.util.Month;

public class Turkey
extends DelegateCalendar {
    private static final Turkey ISE_CALENDAR = new Turkey(Market.ISE);

    private Turkey(Market market) {
        TurkeyISECalendar delegate;
        switch (market) {
            case ISE: {
                delegate = new TurkeyISECalendar();
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown market");
            }
        }
        this.setDelegate(delegate);
    }

    public static Turkey getCalendar(Market market) {
        switch (market) {
            case ISE: {
                return ISE_CALENDAR;
            }
        }
        throw new IllegalArgumentException("unknown market");
    }

    private static final class TurkeyISECalendar
    extends WesternCalendar {
        private TurkeyISECalendar() {
        }

        @Override
        public String getName() {
            return "Istanbul Stock Exchange Turkey";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.getWeekday();
            int d = date.getDayOfMonth();
            int m = date.getMonth();
            int y = date.getYear();
            if (this.isWeekend(w) || d == 1 && m == Month.JANUARY.toInteger() || d == 23 && m == Month.APRIL.toInteger() || d == 19 && m == Month.MAY.toInteger() || d == 30 && m == Month.AUGUST.toInteger() || d == 29 && m == Month.OCTOBER.toInteger()) {
                return false;
            }
            return !(y == 2004 ? m == Month.FEBRUARY.toInteger() && d <= 4 || m == Month.NOVEMBER.toInteger() && d >= 14 && d <= 16 : (y == 2005 ? m == Month.JANUARY.toInteger() && d >= 19 && d <= 21 || m == Month.NOVEMBER.toInteger() && d >= 2 && d <= 5 : (y == 2006 ? m == Month.JANUARY.toInteger() && d >= 9 && d <= 13 || m == Month.OCTOBER.toInteger() && d >= 23 && d <= 25 || m == Month.DECEMBER.toInteger() && d >= 30 : (y == 2007 ? m == Month.JANUARY.toInteger() && d <= 4 || m == Month.OCTOBER.toInteger() && d >= 11 && d <= 14 || m == Month.DECEMBER.toInteger() && d >= 19 && d <= 23 : y == 2008 && (m == Month.SEPTEMBER.toInteger() && d >= 29 || m == Month.OCTOBER.toInteger() && d <= 2 || m == Month.DECEMBER.toInteger() && d >= 7 && d <= 11)))));
        }
    }

    public static enum Market {
        ISE;

    }
}

