/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.distributions;

import org.jquantlib.math.distributions.CumulativeNormalDistribution;
import org.jquantlib.math.randomnumbers.InverseCumulative;

public class InverseCumulativeNormal
implements InverseCumulative {
    static final double a1_ = -39.69683028665376;
    static final double a2_ = 220.9460984245205;
    static final double a3_ = -275.9285104469687;
    static final double a4_ = 138.357751867269;
    static final double a5_ = -30.66479806614716;
    static final double a6_ = 2.506628277459239;
    static final double b1_ = -54.47609879822406;
    static final double b2_ = 161.5858368580409;
    static final double b3_ = -155.6989798598866;
    static final double b4_ = 66.80131188771972;
    static final double b5_ = -13.28068155288572;
    static final double c1_ = -0.007784894002430293;
    static final double c2_ = -0.3223964580411365;
    static final double c3_ = -2.400758277161838;
    static final double c4_ = -2.549732539343734;
    static final double c5_ = 4.374664141464968;
    static final double c6_ = 2.938163982698783;
    static final double d1_ = 0.007784695709041462;
    static final double d2_ = 0.3224671290700398;
    static final double d3_ = 2.445134137142996;
    static final double d4_ = 3.754408661907416;
    protected double average;
    protected double sigma;
    static final double x_low_ = 0.02425;
    static final double x_high_ = 0.97575;
    private boolean highPrecision = false;

    public InverseCumulativeNormal() {
        this(0.0, 1.0);
    }

    public InverseCumulativeNormal(double average, double sigma) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma must be greater than 0.0 (" + sigma + " not allowed)");
        }
        this.average = average;
        this.sigma = sigma;
    }

    @Override
    public double evaluate(double x) {
        double r;
        double z;
        if (x <= 0.0) {
            return 0.0;
        }
        if (x >= 1.0) {
            return 1.0;
        }
        if (this.sigma <= 0.0) {
            throw new IllegalArgumentException("sigma must be greater than 0.0 (" + this.sigma + " not allowed)");
        }
        if (x < 0.02425) {
            z = Math.sqrt(-2.0 * Math.log(x));
            z = (((((-0.007784894002430293 * z + -0.3223964580411365) * z + -2.400758277161838) * z + -2.549732539343734) * z + 4.374664141464968) * z + 2.938163982698783) / ((((0.007784695709041462 * z + 0.3224671290700398) * z + 2.445134137142996) * z + 3.754408661907416) * z + 1.0);
        } else if (x <= 0.97575) {
            z = x - 0.5;
            r = z * z;
            z = (((((-39.69683028665376 * r + 220.9460984245205) * r + -275.9285104469687) * r + 138.357751867269) * r + -30.66479806614716) * r + 2.506628277459239) * z / (((((-54.47609879822406 * r + 161.5858368580409) * r + -155.6989798598866) * r + 66.80131188771972) * r + -13.28068155288572) * r + 1.0);
        } else {
            z = Math.sqrt(-2.0 * Math.log(1.0 - x));
            z = -(((((-0.007784894002430293 * z + -0.3223964580411365) * z + -2.400758277161838) * z + -2.549732539343734) * z + 4.374664141464968) * z + 2.938163982698783) / ((((0.007784695709041462 * z + 0.3224671290700398) * z + 2.445134137142996) * z + 3.754408661907416) * z + 1.0);
        }
        if (this.highPrecision) {
            CumulativeNormalDistribution f_ = new CumulativeNormalDistribution();
            r = (f_.evaluate(z) - x) * 1.4142135623730951 * 1.772453850905516 * Math.exp(0.5 * z * z);
            z -= r / (1.0 + 0.5 * z * r);
        }
        return this.average + z * this.sigma;
    }
}

