/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math;

import org.jquantlib.math.Array;

final class Grid {
    private Grid() {
    }

    static final Array CenteredGrid(double center, double dx, int steps) {
        Array result = new Array(steps + 1);
        for (int i = 0; i < steps + 1; ++i) {
            result.set(i, center + ((double)i - (double)steps / 2.0) * dx);
        }
        return result;
    }

    static final Array BoundedGrid(double xMin, double xMax, int steps) {
        Array result = new Array(steps + 1);
        double x = xMin;
        double dx = (xMax - xMin) / (double)steps;
        int i = 0;
        while (i < steps + 1) {
            result.set(i, x);
            ++i;
            x += dx;
        }
        return result;
    }

    static final Array BoundedLogGrid(double xMin, double xMax, int steps) {
        Array result = new Array(steps + 1);
        double gridLogSpacing = (Math.log(xMax) - Math.log(xMin)) / (double)steps;
        double edx = Math.exp(gridLogSpacing);
        result.set(0, xMin);
        for (int j = 1; j < steps + 1; ++j) {
            result.set(j, result.get(j - 1) * edx);
        }
        return result;
    }
}

