/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.discovery.plaintext;

import com.sun.jini.discovery.ClientSubjectChecker;
import com.sun.jini.discovery.DatagramBufferFactory;
import com.sun.jini.discovery.MulticastAnnouncement;
import com.sun.jini.discovery.MulticastAnnouncementEncoder;
import com.sun.jini.discovery.MulticastRequest;
import com.sun.jini.discovery.MulticastRequestDecoder;
import com.sun.jini.discovery.UnicastDiscoveryServer;
import com.sun.jini.discovery.UnicastResponse;
import com.sun.jini.discovery.internal.Plaintext;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Collection;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.UnsupportedConstraintException;

public class Server
implements MulticastRequestDecoder,
MulticastAnnouncementEncoder,
UnicastDiscoveryServer {
    public String getFormatName() {
        return "net.jini.discovery.plaintext";
    }

    public MulticastRequest decodeMulticastRequest(ByteBuffer buf, InvocationConstraints constraints, ClientSubjectChecker checker) throws IOException {
        Plaintext.checkConstraints(constraints);
        if (checker != null) {
            checker.checkClientSubject(null);
        }
        return Plaintext.decodeMulticastRequest(buf);
    }

    public void encodeMulticastAnnouncement(MulticastAnnouncement announcement, DatagramBufferFactory bufs, InvocationConstraints constraints) throws IOException {
        Plaintext.checkConstraints(constraints);
        Plaintext.encodeMulticastAnnouncement(announcement, bufs);
    }

    public void checkUnicastDiscoveryConstraints(InvocationConstraints constraints) throws UnsupportedConstraintException {
        Plaintext.checkConstraints(constraints);
    }

    public void handleUnicastDiscovery(UnicastResponse response, Socket socket, InvocationConstraints constraints, ClientSubjectChecker checker, Collection context, ByteBuffer received, ByteBuffer sent) throws IOException {
        Plaintext.checkConstraints(constraints);
        if (checker != null) {
            checker.checkClientSubject(null);
        }
        BufferedOutputStream out = new BufferedOutputStream(socket.getOutputStream());
        Plaintext.writeUnicastResponse(out, response, context);
        ((OutputStream)out).flush();
    }
}

