/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.jetty.internal;

import java.io.InputStream;
import java.util.ArrayList;
import org.osgi.framework.Bundle;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.MetaTypeProvider;
import org.osgi.service.metatype.ObjectClassDefinition;

class ConfigMetaTypeProvider
implements MetaTypeProvider {
    private final Bundle bundle;

    public ConfigMetaTypeProvider(Bundle bundle) {
        this.bundle = bundle;
    }

    public String[] getLocales() {
        return null;
    }

    public ObjectClassDefinition getObjectClassDefinition(String id, String locale) {
        if (!"org.apache.felix.http".equals(id)) {
            return null;
        }
        final ArrayList<AttributeDefinitionImpl> adList = new ArrayList<AttributeDefinitionImpl>();
        adList.add(new AttributeDefinitionImpl("org.apache.felix.http.host", "Host Name", "IP Address or Host Name of the interface to which HTTP and HTTPS bind. The default is \"0.0.0.0\" indicating all interfaces.", "0.0.0.0", this.bundle.getBundleContext().getProperty("org.apache.felix.http.host")));
        adList.add(new AttributeDefinitionImpl("org.apache.felix.http.enable", "Enable HTTP", "Whether or not HTTP is enabled. Defaults to true thus HTTP enabled.", true, this.bundle.getBundleContext().getProperty("org.apache.felix.http.enable")));
        adList.add(new AttributeDefinitionImpl("org.osgi.service.http.port", "HTTP Port", "Port to listen on for HTTP requests. Defaults to 8080.", 8080, this.bundle.getBundleContext().getProperty("org.osgi.service.http.port")));
        adList.add(new AttributeDefinitionImpl("org.apache.felix.http.timeout", "Connection Timeout", "Time limit for reaching an timeout specified in milliseconds. This property applies to both HTTP and HTTP connections. Defaults to 60 seconds.", 60000, this.bundle.getBundleContext().getProperty("org.apache.felix.http.timeout")));
        adList.add(new AttributeDefinitionImpl("org.apache.felix.https.enable", "Enable HTTPS", "Whether or not HTTPS is enabled. Defaults to false thus HTTPS disabled.", false, this.bundle.getBundleContext().getProperty("org.apache.felix.https.enable")));
        adList.add(new AttributeDefinitionImpl("org.osgi.service.http.port.secure", "HTTPS Port", "Port to listen on for HTTPS requests. Defaults to 443.", 443, this.bundle.getBundleContext().getProperty("org.osgi.service.http.port.secure")));
        adList.add(new AttributeDefinitionImpl("org.apache.felix.https.keystore", "Keystore", "Absolute Path to the Keystore to use for HTTPS. Only used if HTTPS is enabled in which case this property is required.", null, this.bundle.getBundleContext().getProperty("org.apache.felix.https.keystore")));
        adList.add(new AttributeDefinitionImpl("org.apache.felix.https.keystore.password", "Keystore Password", "Password to access the Keystore. Only used if HTTPS is enabled.", null, this.bundle.getBundleContext().getProperty("org.apache.felix.https.keystore.password")));
        adList.add(new AttributeDefinitionImpl("org.apache.felix.https.keystore.key.password", "Key Password", "Password to unlock the secret key from the Keystore. Only used if HTTPS is enabled.", null, this.bundle.getBundleContext().getProperty("org.apache.felix.https.keystore.key.password")));
        adList.add(new AttributeDefinitionImpl("org.apache.felix.https.truststore", "Truststore", "Absolute Path to the Truststore to use for HTTPS. Only used if HTTPS is enabled.", null, this.bundle.getBundleContext().getProperty("org.apache.felix.https.truststore")));
        adList.add(new AttributeDefinitionImpl("org.apache.felix.https.truststore.password", "Truststore Password", "Password to access the Truststore. Only used if HTTPS is enabled.", null, this.bundle.getBundleContext().getProperty("org.apache.felix.https.truststore.password")));
        adList.add(new AttributeDefinitionImpl("org.apache.felix.https.clientcertificate", "Client Certificate", "Requirement for the Client to provide a valid certificate. Defaults to none.", 1, new String[]{"none"}, 0, new String[]{"No Client Certificate", "Client Certificate Wanted", "Client Certificate Needed"}, new String[]{"none", "wants", "needs"}, this.bundle.getBundleContext().getProperty("org.apache.felix.https.clientcertificate")));
        adList.add(new AttributeDefinitionImpl("org.apache.felix.http.context_path", "Context Path", "The Servlet Context Path to use for the Http Service. If this property is not configured it defaults to \"/\". This must be a valid path starting with a slash and not ending with a slash (unless it is the root context).", "/", this.bundle.getBundleContext().getProperty("org.apache.felix.http.context_path")));
        adList.add(new AttributeDefinitionImpl("org.apache.felix.http.mbeans", "Register MBeans", "Whether or not to use register JMX MBeans from the servlet container (Jetty). If this is enabled Jetty Request and Connector statistics are also enabled. The default is to not enable JMX.", false, this.bundle.getBundleContext().getProperty("org.apache.felix.http.mbeans")));
        adList.add(new AttributeDefinitionImpl("org.apache.felix.http.session.timeout", "Session Timeout", "Default lifetime of an HTTP session specified in a whole number of minutes. If the timeout is 0 or less, sessions will by default never timeout. The default is 0.", 0, this.bundle.getBundleContext().getProperty("org.apache.felix.http.session.timeout")));
        adList.add(new AttributeDefinitionImpl("org.apache.felix.http.jetty.threadpool.max", "Thread Pool Max", "Maximum number of jetty threads. Using the default -1 uses Jetty's default (200).", -1, this.bundle.getBundleContext().getProperty("org.apache.felix.http.jetty.threadpool.max")));
        adList.add(new AttributeDefinitionImpl("org.apache.felix.http.jetty.acceptors", "Acceptors", "Number of acceptor threads to use, or -1 for a default value. Acceptors accept new TCP/IP connections. If 0, then the selector threads are used to accept connections.", -1, this.bundle.getBundleContext().getProperty("org.apache.felix.http.jetty.acceptors")));
        adList.add(new AttributeDefinitionImpl("org.apache.felix.http.jetty.selectors", "Selectors", "Number of selector threads, or <=0 for a default value. Selectors notice and schedule established connection that can make IO progress.", -1, this.bundle.getBundleContext().getProperty("org.apache.felix.http.jetty.selectors")));
        adList.add(new AttributeDefinitionImpl("org.apache.felix.http.jetty.headerBufferSize", "Header Buffer Size", "Size of the buffer for request and response headers. Default is 16KB.", 16384, this.bundle.getBundleContext().getProperty("org.apache.felix.http.jetty.headerBufferSize")));
        adList.add(new AttributeDefinitionImpl("org.apache.felix.http.jetty.requestBufferSize", "Request Buffer Size", "Size of the buffer for requests not fitting the header buffer. Default is 8KB.", 8192, this.bundle.getBundleContext().getProperty("org.apache.felix.http.jetty.requestBufferSize")));
        adList.add(new AttributeDefinitionImpl("org.apache.felix.http.jetty.responseBufferSize", "Response Buffer Size", "Size of the buffer for responses. Default is 24KB.", 24576, this.bundle.getBundleContext().getProperty("org.apache.felix.http.jetty.responseBufferSize")));
        adList.add(new AttributeDefinitionImpl("org.apache.felix.http.jetty.maxFormSize", "Maximum Form Size", "Size of Body for submitted form content. Default is 200KB.", 204800, this.bundle.getBundleContext().getProperty("org.apache.felix.http.jetty.maxFormSize")));
        adList.add(new AttributeDefinitionImpl("org.apache.felix.http.path_exclusions", "Path Exclusions", "Contains a list of context path prefixes. If a Web Application Bundle is started with a context path matching any of these prefixes, it will not be deployed in the servlet container.", 1, new String[]{"/system"}, Integer.MAX_VALUE, null, null, this.getStringArray(this.bundle.getBundleContext().getProperty("org.apache.felix.http.path_exclusions"))));
        adList.add(new AttributeDefinitionImpl("org.apache.felix.https.jetty.ciphersuites.excluded", "Excluded Cipher Suites", "List of cipher suites that should be excluded. Default is none.", 1, null, Integer.MAX_VALUE, null, null, this.getStringArray(this.bundle.getBundleContext().getProperty("org.apache.felix.https.jetty.ciphersuites.excluded"))));
        adList.add(new AttributeDefinitionImpl("org.apache.felix.https.jetty.ciphersuites.included", "Included Cipher Suites", "List of cipher suites that should be included. Default is none.", 1, null, Integer.MAX_VALUE, null, null, this.getStringArray(this.bundle.getBundleContext().getProperty("org.apache.felix.https.jetty.ciphersuites.included"))));
        adList.add(new AttributeDefinitionImpl("org.apache.felix.http.jetty.sendServerHeader", "Send Server Header", "If enabled, the server header is sent.", false, this.bundle.getBundleContext().getProperty("org.apache.felix.http.jetty.sendServerHeader")));
        adList.add(new AttributeDefinitionImpl("org.apache.felix.https.jetty.protocols.included", "Included Protocols", "List of SSL protocols to include by default. Protocols may be any supported by the Java platform such as SSLv2Hello, SSLv3, TLSv1, TLSv1.1, or TLSv1.2. Any listed protocol not supported is silently ignored. Default is none assuming to use any protocol enabled and supported on the platform.", 1, null, Integer.MAX_VALUE, null, null, this.getStringArray(this.bundle.getBundleContext().getProperty("org.apache.felix.https.jetty.protocols.included"))));
        adList.add(new AttributeDefinitionImpl("org.apache.felix.https.jetty.protocols.excluded", "Excluded Protocols", "List of SSL protocols to exclude. This property further restricts the enabled protocols by explicitly disabling. Any protocol listed in both this property and the Included protocols property is excluded. Default is none such as to accept all protocols enabled on platform or explicitly listed by the Included protocols property.", 1, null, Integer.MAX_VALUE, null, null, this.getStringArray(this.bundle.getBundleContext().getProperty("org.apache.felix.https.jetty.protocols.excluded"))));
        adList.add(new AttributeDefinitionImpl("org.apache.felix.proxy.load.balancer.connection.enable", "Enable Proxy/Load Balancer Connection", "Whether or not the Proxy/Load Balancer Connection is enabled. Defaults to false thus disabled.", false, this.bundle.getBundleContext().getProperty("org.apache.felix.proxy.load.balancer.connection.enable")));
        adList.add(new AttributeDefinitionImpl("org.apache.felix.https.jetty.renegotiateAllowed", "Renegotiation allowed", "Whether TLS renegotiation is allowed (true by default)", false, this.bundle.getBundleContext().getProperty("org.apache.felix.https.jetty.renegotiateAllowed")));
        adList.add(new AttributeDefinitionImpl("org.apache.felix.https.jetty.session.cookie.httpOnly", "Session Cookie httpOnly", "Session Cookie httpOnly (true by default)", true, this.bundle.getBundleContext().getProperty("org.apache.felix.https.jetty.session.cookie.httpOnly")));
        adList.add(new AttributeDefinitionImpl("org.apache.felix.https.jetty.session.cookie.secure", "Session Cookie secure", "Session Cookie secure (false by default)", false, this.bundle.getBundleContext().getProperty("org.apache.felix.https.jetty.session.cookie.secure")));
        adList.add(new AttributeDefinitionImpl("org.eclipse.jetty.servlet.SessionIdPathParameterName", "Session Id path parameter", "Defaults to jsessionid. If set to null or \"none\" no URL rewriting will be done.", "jsessionid", this.bundle.getBundleContext().getProperty("org.eclipse.jetty.servlet.SessionIdPathParameterName")));
        adList.add(new AttributeDefinitionImpl("org.eclipse.jetty.servlet.CheckingRemoteSessionIdEncoding", "Check remote session encoding", "If true, Jetty will add JSESSIONID parameter even when encoding external urls with calls to encodeURL() (true by default)", true, this.bundle.getBundleContext().getProperty("org.eclipse.jetty.servlet.CheckingRemoteSessionIdEncoding")));
        adList.add(new AttributeDefinitionImpl("org.eclipse.jetty.servlet.SessionCookie", "Session Cookie Name", "Session Cookie Name", "JSESSIONID", this.bundle.getBundleContext().getProperty("org.eclipse.jetty.servlet.SessionCookie")));
        adList.add(new AttributeDefinitionImpl("org.eclipse.jetty.servlet.SessionDomain", "Session Domain", "If this property is set, then it is used as the domain for session cookies. If it is not set, then no domain is specified for the session cookie. Default is none.", null, this.bundle.getBundleContext().getProperty("org.eclipse.jetty.servlet.SessionDomain")));
        adList.add(new AttributeDefinitionImpl("org.eclipse.jetty.servlet.SessionPath", "Session Path", "If this property is set, then it is used as the path for the session cookie. Default is context path.", null, this.bundle.getBundleContext().getProperty("org.eclipse.jetty.servlet.SessionDomain")));
        adList.add(new AttributeDefinitionImpl("org.eclipse.jetty.servlet.MaxAge", "Session Max Age", "Max age for the session cookie. Default is -1.", -1, this.bundle.getBundleContext().getProperty("org.eclipse.jetty.servlet.MaxAge")));
        adList.add(new AttributeDefinitionImpl("org.eclipse.jetty.servlet.MaxAge", "Session Scavenging Interval", "Interval of session scavenging in seconds. Default is " + String.valueOf(600L), 600L, this.bundle.getBundleContext().getProperty("org.eclipse.jetty.servlet.SessionScavengingInterval")));
        adList.add(new AttributeDefinitionImpl("org.apache.felix.http.name", "HTTP Service Name", "HTTP Service Name used in service filter to target specific HTTP instance. Default is null.", null, this.bundle.getBundleContext().getProperty("org.apache.felix.http.name")));
        adList.add(new AttributeDefinitionImpl("org.apache.felix.jetty.gziphandler.enable", "Enable GzipHandler", "Whether the server should use a server-wide gzip handler. Default is false.", false, this.bundle.getBundleContext().getProperty("org.apache.felix.jetty.gziphandler.enable")));
        adList.add(new AttributeDefinitionImpl("org.apache.felix.jetty.gzip.minGzipSize", "Gzip Min Size", String.format("The minimum response size to trigger dynamic compression. Default is %d.", 16), 16, this.bundle.getBundleContext().getProperty("org.apache.felix.jetty.gzip.minGzipSize")));
        adList.add(new AttributeDefinitionImpl("org.apache.felix.jetty.gzip.compressionLevel", "Gzip Compression Level", String.format("The compression level to use. Default is %d.", -1), -1, this.bundle.getBundleContext().getProperty("org.apache.felix.jetty.gzip.compressionLevel")));
        adList.add(new AttributeDefinitionImpl("org.apache.felix.jetty.gzip.inflateBufferSize", "Gzip Inflate Buffer Size", "The size in bytes of the buffer to inflate compressed request, or <= 0 for no inflation. Default is -1.", -1, this.bundle.getBundleContext().getProperty("org.apache.felix.jetty.gzip.inflateBufferSize")));
        adList.add(new AttributeDefinitionImpl("org.apache.felix.jetty.gzip.syncFlush", "Gzip Sync Flush", "True if Deflater#SYNC_FLUSH should be used, else Deflater#NO_FLUSH will be used. Default is false.", false, this.bundle.getBundleContext().getProperty("org.apache.felix.jetty.gzip.syncFlush")));
        adList.add(new AttributeDefinitionImpl("org.apache.felix.jetty.gzip.excludedUserAgents", "Gzip Exclude User Agents", "The regular expressions matching additional user agents to exclude. Default is none.", 1, null, Integer.MAX_VALUE, null, null, this.getStringArray(this.bundle.getBundleContext().getProperty("org.apache.felix.jetty.gzip.excludedUserAgents"))));
        adList.add(new AttributeDefinitionImpl("org.apache.felix.jetty.gzip.includedMethods", "Gzip Include Methods", "The additional http methods to include in compression. Default is none.", 1, null, Integer.MAX_VALUE, null, null, this.getStringArray(this.bundle.getBundleContext().getProperty("org.apache.felix.jetty.gzip.includedMethods"))));
        adList.add(new AttributeDefinitionImpl("org.apache.felix.jetty.gzip.excludedMethods", "Gzip Exclude Methods", "The additional http methods to exclude in compression. Default is none.", 1, null, Integer.MAX_VALUE, null, null, this.getStringArray(this.bundle.getBundleContext().getProperty("org.apache.felix.jetty.gzip.excludedMethods"))));
        adList.add(new AttributeDefinitionImpl("org.apache.felix.jetty.gzip.includedPaths", "Gzip Included Paths", "The additional path specs to include. Inclusion takes precedence over exclusion. Default is none.", 1, null, Integer.MAX_VALUE, null, null, this.getStringArray(this.bundle.getBundleContext().getProperty("org.apache.felix.jetty.gzip.includedPaths"))));
        adList.add(new AttributeDefinitionImpl("org.apache.felix.jetty.gzip.excludedPaths", "Gzip Excluded Paths", "The additional path specs to exclude. Inclusion takes precedence over exclusion. Default is none.", 1, null, Integer.MAX_VALUE, null, null, this.getStringArray(this.bundle.getBundleContext().getProperty("org.apache.felix.jetty.gzip.excludedPaths"))));
        adList.add(new AttributeDefinitionImpl("org.apache.felix.jetty.gzip.includedMimeTypes", "Gzip Included Mime Types", "The included mime types. Inclusion takes precedence over exclusion. Default is none.", 1, null, Integer.MAX_VALUE, null, null, this.getStringArray(this.bundle.getBundleContext().getProperty("org.apache.felix.jetty.gzip.includedMimeTypes"))));
        adList.add(new AttributeDefinitionImpl("org.apache.felix.jetty.gzip.excludedMimeTypes", "Gzip Excluded Mime Types", "The excluded mime types. Inclusion takes precedence over exclusion. Default is none.", 1, null, Integer.MAX_VALUE, null, null, this.getStringArray(this.bundle.getBundleContext().getProperty("org.apache.felix.jetty.gzip.excludedMimeTypes"))));
        adList.add(new AttributeDefinitionImpl("org.apache.felix.http.session.invalidate", "Invalidate Container Session", "If this property is set, the container session is automatically validated.", true, this.bundle.getBundleContext().getProperty("org.apache.felix.http.session.invalidate")));
        adList.add(new AttributeDefinitionImpl("org.apache.felix.http.session.uniqueid", "Unique Session Id", "If this property is set, each http context gets a unique session id (derived from the container session).", true, this.bundle.getBundleContext().getProperty("org.apache.felix.http.session.uniqueid")));
        return new ObjectClassDefinition(){
            private final AttributeDefinition[] attrs;
            {
                this.attrs = adList.toArray(new AttributeDefinition[adList.size()]);
            }

            public String getName() {
                return "Apache Felix Jetty Based Http Service";
            }

            public InputStream getIcon(int arg0) {
                return null;
            }

            public String getID() {
                return "org.apache.felix.http";
            }

            public String getDescription() {
                return "Configuration for the embedded Jetty Servlet Container.";
            }

            public AttributeDefinition[] getAttributeDefinitions(int filter) {
                return filter == 2 ? null : this.attrs;
            }
        };
    }

    private String[] getStringArray(String value) {
        if (value != null) {
            return value.trim().split(",");
        }
        return null;
    }

    private static class AttributeDefinitionImpl
    implements AttributeDefinition {
        private final String id;
        private final String name;
        private final String description;
        private final int type;
        private final String[] defaultValues;
        private final int cardinality;
        private final String[] optionLabels;
        private final String[] optionValues;

        AttributeDefinitionImpl(String id, String name, String description, String defaultValue, String overrideValue) {
            String[] stringArray;
            String[] stringArray2;
            if (defaultValue == null) {
                stringArray2 = null;
            } else {
                String[] stringArray3 = new String[1];
                stringArray2 = stringArray3;
                stringArray3[0] = defaultValue;
            }
            if (overrideValue == null) {
                stringArray = null;
            } else {
                String[] stringArray4 = new String[1];
                stringArray = stringArray4;
                stringArray4[0] = overrideValue;
            }
            this(id, name, description, 1, stringArray2, 0, null, null, stringArray);
        }

        AttributeDefinitionImpl(String id, String name, String description, long defaultValue, String overrideValue) {
            String[] stringArray;
            String[] stringArray2 = new String[]{String.valueOf(defaultValue)};
            if (overrideValue == null) {
                stringArray = null;
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = overrideValue;
            }
            this(id, name, description, 2, stringArray2, 0, null, null, stringArray);
        }

        AttributeDefinitionImpl(String id, String name, String description, int defaultValue, String overrideValue) {
            String[] stringArray;
            String[] stringArray2 = new String[]{String.valueOf(defaultValue)};
            if (overrideValue == null) {
                stringArray = null;
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = overrideValue;
            }
            this(id, name, description, 3, stringArray2, 0, null, null, stringArray);
        }

        AttributeDefinitionImpl(String id, String name, String description, boolean defaultValue, String overrideValue) {
            String[] stringArray;
            String[] stringArray2 = new String[]{String.valueOf(defaultValue)};
            if (overrideValue == null) {
                stringArray = null;
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = overrideValue;
            }
            this(id, name, description, 11, stringArray2, 0, null, null, stringArray);
        }

        AttributeDefinitionImpl(String id, String name, String description, int type, String[] defaultValues, int cardinality, String[] optionLabels, String[] optionValues, String overrideValue) {
            String[] stringArray;
            if (overrideValue == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = overrideValue;
            }
            this(id, name, description, type, defaultValues, cardinality, optionLabels, optionValues, stringArray);
        }

        AttributeDefinitionImpl(String id, String name, String description, int type, String[] defaultValues, int cardinality, String[] optionLabels, String[] optionValues, String[] overrideValues) {
            this.id = id;
            this.name = name;
            this.description = description;
            this.type = type;
            this.defaultValues = overrideValues != null ? overrideValues : defaultValues;
            this.cardinality = cardinality;
            this.optionLabels = optionLabels;
            this.optionValues = optionValues;
        }

        public int getCardinality() {
            return this.cardinality;
        }

        public String[] getDefaultValue() {
            return this.defaultValues;
        }

        public String getDescription() {
            return this.description;
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String[] getOptionLabels() {
            return this.optionLabels;
        }

        public String[] getOptionValues() {
            return this.optionValues;
        }

        public int getType() {
            return this.type;
        }

        public String validate(String arg0) {
            return null;
        }
    }
}

