/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.pricingengines.vanilla;

import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.exercise.AmericanExercise;
import org.jquantlib.exercise.Exercise;
import org.jquantlib.instruments.Option;
import org.jquantlib.instruments.PlainVanillaPayoff;
import org.jquantlib.math.distributions.CumulativeNormalDistribution;
import org.jquantlib.pricingengines.BlackCalculator;
import org.jquantlib.pricingengines.VanillaOptionEngine;
import org.jquantlib.pricingengines.arguments.OneAssetOptionArguments;
import org.jquantlib.pricingengines.results.OneAssetOptionResults;
import org.jquantlib.processes.GeneralizedBlackScholesProcess;

public class BjerksundStenslandApproximationEngine
extends VanillaOptionEngine {
    private CumulativeNormalDistribution cumNormalDist = new CumulativeNormalDistribution();

    @Override
    public void calculate() {
        if (((OneAssetOptionArguments)this.arguments).exercise.type() != Exercise.Type.AMERICAN) {
            throw new ArithmeticException("not an American Option");
        }
        if (!(((OneAssetOptionArguments)this.arguments).exercise instanceof AmericanExercise)) {
            throw new ArithmeticException("non-American exercise given");
        }
        AmericanExercise ex = (AmericanExercise)((OneAssetOptionArguments)this.arguments).exercise;
        if (ex.payoffAtExpiry()) {
            throw new ArithmeticException("payoff at expiry not handled");
        }
        if (!(((OneAssetOptionArguments)this.arguments).payoff instanceof PlainVanillaPayoff)) {
            throw new ArithmeticException("non-plain payoff given");
        }
        PlainVanillaPayoff payoff = (PlainVanillaPayoff)((OneAssetOptionArguments)this.arguments).payoff;
        if (!(((OneAssetOptionArguments)this.arguments).stochasticProcess instanceof GeneralizedBlackScholesProcess)) {
            throw new ArithmeticException("Black-Scholes process required");
        }
        GeneralizedBlackScholesProcess process = (GeneralizedBlackScholesProcess)((OneAssetOptionArguments)this.arguments).stochasticProcess;
        double variance = process.blackVolatility().getLink().blackVariance(ex.lastDate(), payoff.strike());
        double dividendDiscount = process.dividendYield().getLink().discount(ex.lastDate());
        double riskFreeDiscount = process.riskFreeRate().getLink().discount(ex.lastDate());
        double spot = process.stateVariable().getLink().evaluate();
        double strike = payoff.strike();
        if (payoff.optionType() == Option.Type.PUT) {
            double tmp = spot;
            spot = strike;
            strike = tmp;
            tmp = riskFreeDiscount;
            riskFreeDiscount = dividendDiscount;
            dividendDiscount = tmp;
            payoff = new PlainVanillaPayoff(Option.Type.CALL, strike);
        }
        if (dividendDiscount >= 1.0) {
            double forwardPrice = spot * dividendDiscount / riskFreeDiscount;
            BlackCalculator black = new BlackCalculator(payoff, forwardPrice, Math.sqrt(variance), riskFreeDiscount);
            ((OneAssetOptionResults)this.results).value = black.value();
            ((OneAssetOptionResults)this.results).delta = black.delta(spot);
            ((OneAssetOptionResults)this.results).deltaForward = black.deltaForward();
            ((OneAssetOptionResults)this.results).elasticity = black.elasticity(spot);
            ((OneAssetOptionResults)this.results).gamma = black.gamma(spot);
            DayCounter rfdc = process.riskFreeRate().getLink().dayCounter();
            DayCounter divdc = process.dividendYield().getLink().dayCounter();
            DayCounter voldc = process.blackVolatility().getLink().dayCounter();
            double t = rfdc.yearFraction(process.riskFreeRate().getLink().referenceDate(), ((OneAssetOptionArguments)this.arguments).exercise.lastDate());
            ((OneAssetOptionResults)this.results).rho = black.rho(t);
            t = divdc.yearFraction(process.dividendYield().getLink().referenceDate(), ((OneAssetOptionArguments)this.arguments).exercise.lastDate());
            ((OneAssetOptionResults)this.results).dividendRho = black.dividendRho(t);
            t = voldc.yearFraction(process.blackVolatility().getLink().referenceDate(), ((OneAssetOptionArguments)this.arguments).exercise.lastDate());
            ((OneAssetOptionResults)this.results).vega = black.vega(t);
            ((OneAssetOptionResults)this.results).theta = black.theta(spot, t);
            ((OneAssetOptionResults)this.results).thetaPerDay = black.thetaPerDay(spot, t);
            ((OneAssetOptionResults)this.results).strikeSensitivity = black.strikeSensitivity();
            ((OneAssetOptionResults)this.results).itmCashProbability = black.itmCashProbability();
        } else {
            ((OneAssetOptionResults)this.results).value = this.americanCallApproximation(spot, strike, riskFreeDiscount, dividendDiscount, variance);
        }
    }

    private double phi(double S, double gamma, double H, double I, double rT, double bT, double variance) {
        double lambda = -rT + gamma * bT + 0.5 * gamma * (gamma - 1.0) * variance;
        double d = -(Math.log(S / H) + (bT + (gamma - 0.5) * variance)) / Math.sqrt(variance);
        double kappa = 2.0 * bT / variance + (2.0 * gamma - 1.0);
        return Math.exp(lambda) * Math.pow(S, gamma) * (this.cumNormalDist.evaluate(d) - Math.pow(I / S, kappa) * this.cumNormalDist.evaluate(d - 2.0 * Math.log(I / S) / Math.sqrt(variance)));
    }

    private double americanCallApproximation(double S, double X, double rfD, double dD, double variance) {
        double ht;
        double bT = Math.log(dD / rfD);
        double rT = Math.log(1.0 / rfD);
        double beta = 0.5 - bT / variance + Math.sqrt(Math.pow(bT / variance - 0.5, 2.0) + 2.0 * rT / variance);
        double BInfinity = beta / (beta - 1.0) * X;
        double B0 = Math.max(X, rT / (rT - bT) * X);
        double I = B0 + (BInfinity - B0) * (1.0 - Math.exp(ht = -(bT + 2.0 * Math.sqrt(variance)) * B0 / (BInfinity - B0)));
        if (!(I >= X)) {
            throw new ArithmeticException("Bjerksund-Stensland approximation not applicable to this set of parameters");
        }
        if (S >= I) {
            return S - X;
        }
        double alpha = (I - X) * Math.pow(I, -beta);
        return alpha * Math.pow(S, beta) - alpha * this.phi(S, beta, I, I, rT, bT, variance) + this.phi(S, 1.0, I, I, rT, bT, variance) - this.phi(S, 1.0, X, I, rT, bT, variance) - X * this.phi(S, 0.0, I, I, rT, bT, variance) + X * this.phi(S, 0.0, X, I, rT, bT, variance);
    }
}

