/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.unicode.fontmap;

import com.kreative.unicode.fontmap.FontMapEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontMapTableModel
extends AbstractTableModel
implements List<FontMapEntry> {
    private static final long serialVersionUID = 1L;
    private final List<FontMapEntry> entries = new ArrayList<FontMapEntry>();

    public FontMapTableModel() {
    }

    public FontMapTableModel(Collection<? extends FontMapEntry> collection) {
        this.entries.addAll(collection);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "Code Point Range";
            }
            case 1: {
                return "Font Name";
            }
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.entries.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.entries.get(n).getCodePointsString();
            }
            case 1: {
                return this.entries.get(n).getFontString();
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 0: {
                this.entries.get(n).setCodePointsString(object.toString());
                break;
            }
            case 1: {
                this.entries.get(n).setFontString(object.toString());
            }
        }
    }

    @Override
    public boolean add(FontMapEntry fontMapEntry) {
        int n = this.entries.size();
        if (this.entries.add(fontMapEntry)) {
            this.fireTableRowsInserted(n, n);
            return true;
        }
        return false;
    }

    @Override
    public void add(int n, FontMapEntry fontMapEntry) {
        this.entries.add(n, fontMapEntry);
        this.fireTableRowsInserted(n, n);
    }

    @Override
    public boolean addAll(Collection<? extends FontMapEntry> collection) {
        int n = this.entries.size();
        if (this.entries.addAll(collection)) {
            this.fireTableRowsInserted(n, n + collection.size() - 1);
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(int n, Collection<? extends FontMapEntry> collection) {
        if (this.entries.addAll(n, collection)) {
            this.fireTableRowsInserted(n, n + collection.size() - 1);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.entries.isEmpty()) {
            return;
        }
        int n = this.entries.size();
        this.entries.clear();
        this.fireTableRowsDeleted(0, n - 1);
    }

    @Override
    public boolean contains(Object object) {
        return this.entries.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.entries.containsAll(collection);
    }

    @Override
    public FontMapEntry get(int n) {
        return this.entries.get(n);
    }

    @Override
    public int indexOf(Object object) {
        return this.entries.indexOf(object);
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public Iterator<FontMapEntry> iterator() {
        return Collections.unmodifiableList(this.entries).iterator();
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.entries.lastIndexOf(object);
    }

    @Override
    public ListIterator<FontMapEntry> listIterator() {
        return Collections.unmodifiableList(this.entries).listIterator();
    }

    @Override
    public ListIterator<FontMapEntry> listIterator(int n) {
        return Collections.unmodifiableList(this.entries).listIterator(n);
    }

    @Override
    public boolean remove(Object object) {
        int n = this.entries.indexOf(object);
        if (this.entries.remove(object)) {
            this.fireTableRowsDeleted(n, n);
            return true;
        }
        return false;
    }

    @Override
    public FontMapEntry remove(int n) {
        FontMapEntry fontMapEntry = this.entries.remove(n);
        this.fireTableRowsDeleted(n, n);
        return fontMapEntry;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        if (this.entries.removeAll(collection)) {
            this.fireTableDataChanged();
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        if (this.entries.retainAll(collection)) {
            this.fireTableDataChanged();
            return true;
        }
        return false;
    }

    @Override
    public FontMapEntry set(int n, FontMapEntry fontMapEntry) {
        fontMapEntry = this.entries.set(n, fontMapEntry);
        this.fireTableRowsUpdated(n, n);
        return fontMapEntry;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public List<FontMapEntry> subList(int n, int n2) {
        return Collections.unmodifiableList(this.entries).subList(n, n2);
    }

    @Override
    public Object[] toArray() {
        return this.entries.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.entries.toArray(TArray);
    }
}

