/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.u8m;

import com.kreative.bitsnpicas.u8m.U8MMapEntry;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class U8MMapData
extends ArrayList<U8MMapEntry> {
    private static final long serialVersionUID = 1L;
    public int mapLocation;
    public int mapEntryCount;

    public boolean mapContains(int n) {
        for (U8MMapEntry u8MMapEntry : this) {
            if (!u8MMapEntry.contains(n)) continue;
            return true;
        }
        return false;
    }

    public int mapGet(int n) {
        for (U8MMapEntry u8MMapEntry : this) {
            if (!u8MMapEntry.contains(n)) continue;
            return u8MMapEntry.get(n);
        }
        return 0;
    }

    public void mapPut(int n, int n2) {
        for (U8MMapEntry u8MMapEntry : this) {
            if (u8MMapEntry.contains(n) && u8MMapEntry.get(n) == n2) {
                return;
            }
            if (!u8MMapEntry.contains(n - 1) || u8MMapEntry.get(n - 1) != n2 - 1) continue;
            ++u8MMapEntry.lastIndexValue;
            return;
        }
        U8MMapEntry u8MMapEntry = new U8MMapEntry();
        u8MMapEntry.firstIndexValue = n;
        u8MMapEntry.lastIndexValue = n;
        u8MMapEntry.firstOutdexValue = n2;
        this.add(u8MMapEntry);
        Collections.sort(this);
    }

    public int mapSize() {
        int n = 0;
        for (U8MMapEntry u8MMapEntry : this) {
            n += u8MMapEntry.size();
        }
        return n;
    }

    public int setMapLocation(int n) {
        if (this.isEmpty()) {
            this.mapLocation = 0;
            this.mapEntryCount = 0;
            return n;
        }
        this.mapEntryCount = this.size();
        int n2 = this.mapEntryCount * 4;
        if ((n & 0xFF) + n2 > 256) {
            n = (n | 0xFF) + 1;
        }
        this.mapLocation = n;
        return this.mapLocation + n2;
    }

    public void readHeader(DataInput dataInput) throws IOException {
        int n = Integer.reverseBytes(dataInput.readInt());
        this.mapLocation = n & 0xFFFFFF;
        this.mapEntryCount = n >> 24 & 0xFF;
    }

    public void writeHeader(DataOutput dataOutput) throws IOException {
        int n = this.mapLocation & 0xFFFFFF | this.mapEntryCount << 24;
        dataOutput.writeInt(Integer.reverseBytes(n));
    }

    public void readData(DataInput dataInput) throws IOException {
        this.clear();
        for (int i = 0; i < this.mapEntryCount; ++i) {
            U8MMapEntry u8MMapEntry = new U8MMapEntry();
            u8MMapEntry.read(dataInput);
            this.add(u8MMapEntry);
        }
    }

    public void writeData(DataOutput dataOutput) throws IOException {
        for (U8MMapEntry u8MMapEntry : this) {
            u8MMapEntry.write(dataOutput);
        }
    }
}

