/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.puaa;

import com.kreative.bitsnpicas.puaa.PuaaCodec;
import com.kreative.bitsnpicas.puaa.PuaaUtility;
import com.kreative.bitsnpicas.truetype.PuaaSubtable;
import com.kreative.bitsnpicas.truetype.PuaaSubtableEntry;
import com.kreative.bitsnpicas.truetype.PuaaTable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCategoryCodec
extends PuaaCodec {
    protected final String fileName;
    protected final String propName;
    protected final List<String> propValues;

    protected AbstractCategoryCodec(String string, String string2, List<String> list) {
        this.fileName = string;
        this.propName = string2;
        this.propValues = list;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public String[] getPropertyNames() {
        return new String[]{this.propName};
    }

    @Override
    public void compile(PuaaTable puaaTable, Scanner scanner) {
        Object object;
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        while (scanner.hasNextLine()) {
            object = PuaaUtility.splitLine(scanner.nextLine());
            if (object == null || ((String[])object).length < 2) continue;
            try {
                int[] nArray = PuaaUtility.splitRange((String)object[0]);
                String string = ((String)object[1]).trim();
                for (int i = nArray[0]; i <= nArray[1]; ++i) {
                    hashMap.put(i, string);
                }
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        object = puaaTable.getOrCreateSubtable(this.propName);
        ((ArrayList)object).addAll(PuaaUtility.createEntriesFromStringMap(hashMap));
    }

    @Override
    public void decompile(PuaaTable puaaTable, PrintWriter printWriter) {
        PuaaSubtable puaaSubtable = puaaTable.getSubtable(this.propName);
        if (puaaSubtable == null || puaaSubtable.isEmpty()) {
            return;
        }
        List<PuaaSubtableEntry.Single> list = PuaaUtility.createRunsFromEntries(puaaSubtable);
        Collections.sort(list, new Comparator<PuaaSubtableEntry.Single>(){

            @Override
            public int compare(PuaaSubtableEntry.Single single, PuaaSubtableEntry.Single single2) {
                int n;
                int n2 = AbstractCategoryCodec.this.propValues.indexOf(single.value);
                if (n2 != (n = AbstractCategoryCodec.this.propValues.indexOf(single2.value))) {
                    return n2 - n;
                }
                int n3 = single.value.compareTo(single2.value);
                if (n3 != 0) {
                    return n3;
                }
                if (single.firstCodePoint != single2.firstCodePoint) {
                    return single.firstCodePoint - single2.firstCodePoint;
                }
                if (single.lastCodePoint != single2.lastCodePoint) {
                    return single.lastCodePoint - single2.lastCodePoint;
                }
                return 0;
            }
        });
        for (PuaaSubtableEntry.Single single : list) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(PuaaUtility.joinRange(single));
            while (stringBuffer.length() < 14) {
                stringBuffer.append(" ");
            }
            stringBuffer.append("; ");
            stringBuffer.append(single.value);
            printWriter.println(stringBuffer.toString());
        }
    }
}

