/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.mover;

import com.kreative.bitsnpicas.mover.MoverIcons;
import com.kreative.unicode.data.EncodingList;
import com.kreative.unicode.data.GlyphList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MoverInfoPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final JLabel iconLabel;
    private final JLabel fileNameLabel;
    private final JLabel kindLabel;
    private final JComboBox encoding;

    public MoverInfoPanel(File file) {
        String string;
        ImageIcon imageIcon;
        if (file == null) {
            imageIcon = MoverIcons.SUITCASE_FONT_32;
            string = "Untitled Suitcase";
        } else {
            imageIcon = MoverIcons.getFileIcon(file);
            string = file.getName();
        }
        this.iconLabel = new JLabel(imageIcon);
        this.fileNameLabel = new JLabel(string);
        this.kindLabel = new JLabel(imageIcon.getDescription());
        this.encoding = new JComboBox<Object>(EncodingList.instance().glyphLists().toArray());
        this.encoding.setEditable(false);
        this.encoding.setSelectedItem(EncodingList.instance().getGlyphList("MacRoman"));
        this.kindLabel.setFont(this.kindLabel.getFont().deriveFont(0));
        this.fileNameLabel.setFont(this.fileNameLabel.getFont().deriveFont(1));
        JPanel jPanel = new JPanel(new BorderLayout(8, 8));
        jPanel.add((Component)new JLabel("Encoding:"), "Before");
        jPanel.add((Component)this.encoding, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 3));
        jPanel2.add(Box.createVerticalGlue());
        jPanel2.add(jPanel);
        jPanel2.add(Box.createVerticalGlue());
        JPanel jPanel3 = new JPanel(new GridLayout(0, 1, 4, 4));
        jPanel3.add(this.fileNameLabel);
        jPanel3.add(this.kindLabel);
        JPanel jPanel4 = new JPanel(new BorderLayout(12, 12));
        jPanel4.add((Component)this.iconLabel, "Before");
        jPanel4.add((Component)jPanel3, "Center");
        jPanel4.add((Component)jPanel2, "After");
        this.setLayout(new GridLayout());
        this.add(jPanel4);
    }

    public void setFile(File file) {
        String string;
        ImageIcon imageIcon;
        if (file == null) {
            imageIcon = MoverIcons.SUITCASE_FONT_32;
            string = "Untitled Suitcase";
        } else {
            imageIcon = MoverIcons.getFileIcon(file);
            string = file.getName();
        }
        this.iconLabel.setIcon(imageIcon);
        this.fileNameLabel.setText(string);
        this.kindLabel.setText(imageIcon.getDescription());
    }

    public GlyphList getSelectedEncoding() {
        return (GlyphList)this.encoding.getSelectedItem();
    }

    public void setSelectedEncoding(GlyphList glyphList) {
        this.encoding.setSelectedItem(glyphList);
    }

    public boolean readOnly() {
        return !((ImageIcon)this.iconLabel.getIcon()).getDescription().contains("suitcase");
    }
}

