/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.main;

import com.kreative.bitsnpicas.truetype.SbixEntry;
import com.kreative.bitsnpicas.truetype.SbixSubtable;
import com.kreative.bitsnpicas.truetype.SbixTable;
import com.kreative.bitsnpicas.truetype.TrueTypeFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class ExtractSbix {
    public static void main(String[] stringArray) {
        try {
            System.setProperty("apple.awt.UIElement", "true");
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (String string : stringArray) {
            File file = new File(string);
            System.out.print("Processing " + file.getAbsolutePath() + "... ");
            try {
                byte[] byArray = new byte[(int)file.length()];
                FileInputStream fileInputStream = new FileInputStream(file);
                fileInputStream.read(byArray);
                fileInputStream.close();
                TrueTypeFile trueTypeFile = new TrueTypeFile();
                trueTypeFile.decompile(byArray);
                SbixTable sbixTable = (SbixTable)trueTypeFile.getByTableName("sbix");
                if (sbixTable == null) {
                    System.out.println("no sbix table found.");
                    continue;
                }
                File file2 = new File(file.getParent(), file.getName() + ".sbix.d");
                if (!file2.exists()) {
                    file2.mkdir();
                }
                for (SbixSubtable sbixSubtable : sbixTable) {
                    File file3 = new File(file2, Integer.toString(sbixSubtable.ppem));
                    if (!file3.exists()) {
                        file3.mkdir();
                    }
                    for (int i = 0; i < sbixSubtable.size(); ++i) {
                        SbixEntry sbixEntry = (SbixEntry)sbixSubtable.get(i);
                        if (sbixEntry.imageData == null || sbixEntry.imageData.length <= 0) continue;
                        String string2 = "glyph_" + Integer.toString(i);
                        String string3 = "." + sbixEntry.getImageTypeString().trim();
                        File file4 = new File(file3, string2 + string3);
                        FileOutputStream fileOutputStream = new FileOutputStream(file4);
                        fileOutputStream.write(sbixEntry.imageData);
                        fileOutputStream.flush();
                        fileOutputStream.close();
                    }
                }
                System.out.println("done.");
            }
            catch (Exception exception) {
                System.out.println("failed (" + exception.getClass().getSimpleName() + ": " + exception.getMessage() + ").");
            }
        }
    }
}

