/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.exporter;

import com.kreative.bitsnpicas.VectorFont;
import com.kreative.bitsnpicas.VectorFontExporter;
import com.kreative.bitsnpicas.VectorFontGlyph;
import com.kreative.bitsnpicas.VectorInstruction;
import com.kreative.bitsnpicas.VectorPath;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class KpcasVectorFontExporter
implements VectorFontExporter {
    public byte[] exportFontToBytes(VectorFont vectorFont) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        this.exportFont(vectorFont, dataOutputStream);
        dataOutputStream.close();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public void exportFontToStream(VectorFont vectorFont, OutputStream outputStream) throws IOException {
        this.exportFont(vectorFont, new DataOutputStream(outputStream));
    }

    public void exportFontToFile(VectorFont vectorFont, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
        this.exportFont(vectorFont, dataOutputStream);
        dataOutputStream.close();
        fileOutputStream.close();
    }

    private void exportFont(VectorFont vectorFont, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(1262644816);
        dataOutputStream.writeInt(1885561203);
        dataOutputStream.writeInt(1);
        dataOutputStream.writeDouble(vectorFont.getEmAscent2D());
        dataOutputStream.writeDouble(vectorFont.getEmDescent2D());
        dataOutputStream.writeDouble(vectorFont.getLineAscent2D());
        dataOutputStream.writeDouble(vectorFont.getLineDescent2D());
        dataOutputStream.writeDouble(vectorFont.getLineGap2D());
        dataOutputStream.writeDouble(vectorFont.getXHeight2D());
        for (Map.Entry<Integer, String> entry : vectorFont.names(false).entrySet()) {
            dataOutputStream.writeInt(1851878757);
            dataOutputStream.writeInt(1);
            dataOutputStream.writeInt(entry.getKey());
            dataOutputStream.writeUTF(entry.getValue());
        }
        for (Map.Entry<Integer, String> entry : vectorFont.characters(false).entrySet()) {
            dataOutputStream.writeInt(1667785074);
            dataOutputStream.writeInt(1);
            dataOutputStream.writeInt(entry.getKey());
            VectorFontGlyph vectorFontGlyph = (VectorFontGlyph)((Object)entry.getValue());
            dataOutputStream.writeDouble(vectorFontGlyph.getCharacterWidth2D());
            Collection<VectorPath> collection = vectorFontGlyph.getContours();
            dataOutputStream.writeInt(collection.size());
            for (VectorPath vectorPath : collection) {
                block10: for (VectorInstruction vectorInstruction : vectorPath) {
                    List<Number> list = vectorInstruction.getOperands();
                    switch (vectorInstruction.getOperation()) {
                        case 'M': {
                            dataOutputStream.writeInt(1836021349);
                            dataOutputStream.writeDouble(list.size() > 0 ? list.get(0).doubleValue() : 0.0);
                            dataOutputStream.writeDouble(list.size() > 1 ? list.get(1).doubleValue() : 0.0);
                            continue block10;
                        }
                        case 'L': {
                            dataOutputStream.writeInt(1818848869);
                            dataOutputStream.writeDouble(list.size() > 0 ? list.get(0).doubleValue() : 0.0);
                            dataOutputStream.writeDouble(list.size() > 1 ? list.get(1).doubleValue() : 0.0);
                            continue block10;
                        }
                        case 'Q': {
                            dataOutputStream.writeInt(1903518052);
                            dataOutputStream.writeDouble(list.size() > 0 ? list.get(0).doubleValue() : 0.0);
                            dataOutputStream.writeDouble(list.size() > 1 ? list.get(1).doubleValue() : 0.0);
                            dataOutputStream.writeDouble(list.size() > 2 ? list.get(2).doubleValue() : 0.0);
                            dataOutputStream.writeDouble(list.size() > 3 ? list.get(3).doubleValue() : 0.0);
                            continue block10;
                        }
                        case 'C': {
                            dataOutputStream.writeInt(1668637285);
                            dataOutputStream.writeDouble(list.size() > 0 ? list.get(0).doubleValue() : 0.0);
                            dataOutputStream.writeDouble(list.size() > 1 ? list.get(1).doubleValue() : 0.0);
                            dataOutputStream.writeDouble(list.size() > 2 ? list.get(2).doubleValue() : 0.0);
                            dataOutputStream.writeDouble(list.size() > 3 ? list.get(3).doubleValue() : 0.0);
                            dataOutputStream.writeDouble(list.size() > 4 ? list.get(4).doubleValue() : 0.0);
                            dataOutputStream.writeDouble(list.size() > 5 ? list.get(5).doubleValue() : 0.0);
                            continue block10;
                        }
                        case 'Z': {
                            dataOutputStream.writeInt(795898984);
                            continue block10;
                        }
                    }
                    dataOutputStream.writeShort(vectorInstruction.getOperation());
                    dataOutputStream.writeShort(list.size());
                    for (Number number : list) {
                        dataOutputStream.writeDouble(number.doubleValue());
                    }
                }
                dataOutputStream.writeInt(795047026);
            }
        }
        dataOutputStream.writeInt(1718185518);
    }
}

