/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.edit;

import com.kreative.bitsnpicas.Font;
import com.kreative.bitsnpicas.FontGlyph;
import com.kreative.bitsnpicas.edit.GlyphComponent;
import com.kreative.bitsnpicas.edit.GlyphComponentListener;
import com.kreative.bitsnpicas.edit.GlyphList;
import com.kreative.bitsnpicas.edit.GlyphLocator;
import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlyphEditPanel<G extends FontGlyph>
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final GlyphComponent<G> glyphComponent;
    private final GlyphList<G> glyphList;
    private GlyphLocator<G> locator;

    public GlyphEditPanel(GlyphLocator<G> glyphLocator, GlyphList<G> glyphList) {
        this.glyphComponent = new GlyphComponent<G>(glyphLocator.getGlyphFont(), glyphLocator.getGlyph());
        this.glyphList = glyphList;
        this.locator = glyphLocator;
        this.setLayout(new BorderLayout());
        this.add(this.glyphComponent, "Center");
        this.glyphComponent.addGlyphComponentListener(new GlyphComponentListener<G>(){

            @Override
            public void metricsChanged(G g, Font<G> font) {
                if (GlyphEditPanel.this.glyphList != null) {
                    GlyphEditPanel.this.glyphList.metricsChanged();
                }
            }

            @Override
            public void glyphChanged(G g, Font<G> font) {
                if (GlyphEditPanel.this.glyphList != null) {
                    GlyphEditPanel.this.glyphList.glyphContentChanged();
                }
            }

            @Override
            public Cursor getCursor(MouseEvent mouseEvent, Point2D point2D, G g, Font<G> font) {
                return null;
            }

            @Override
            public boolean mouseMoved(MouseEvent mouseEvent, Point2D point2D, G g, Font<G> font) {
                return false;
            }

            @Override
            public boolean mousePressed(MouseEvent mouseEvent, Point2D point2D, G g, Font<G> font) {
                return false;
            }

            @Override
            public boolean mouseDragged(MouseEvent mouseEvent, Point2D point2D, G g, Font<G> font) {
                return false;
            }

            @Override
            public boolean mouseReleased(MouseEvent mouseEvent, Point2D point2D, G g, Font<G> font) {
                return false;
            }

            @Override
            public boolean mouseWheelMoved(MouseWheelEvent mouseWheelEvent, Point2D point2D, G g, Font<G> font) {
                return false;
            }
        });
    }

    public GlyphComponent<G> getGlyphComponent() {
        return this.glyphComponent;
    }

    public Font<G> getGlyphFont() {
        return this.glyphComponent.getGlyphFont();
    }

    public G getGlyph() {
        return this.glyphComponent.getGlyph();
    }

    public GlyphList<G> getGlyphList() {
        return this.glyphList;
    }

    public GlyphLocator<G> getGlyphLocator() {
        return this.locator;
    }

    public void setGlyph(GlyphLocator<G> glyphLocator, Class<G> clazz) {
        if (glyphLocator == null) {
            return;
        }
        Font<G> font = glyphLocator.getGlyphFont();
        Object object = glyphLocator.getGlyph();
        if (object == null) {
            if (clazz == null) {
                return;
            }
            try {
                object = (FontGlyph)clazz.newInstance();
                glyphLocator.setGlyph(object);
                this.glyphList.glyphRepertoireChanged();
            }
            catch (Exception exception) {
                return;
            }
        }
        this.glyphComponent.setGlyph(font, object);
        this.locator = glyphLocator;
    }
}

