/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.edit;

import com.kreative.bitsnpicas.Font;
import com.kreative.bitsnpicas.FontGlyph;
import com.kreative.bitsnpicas.edit.GlyphList;
import com.kreative.bitsnpicas.edit.GlyphListModel;
import com.kreative.bitsnpicas.edit.GlyphLocator;
import com.kreative.bitsnpicas.edit.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CreateGlyphsDialog<G extends FontGlyph>
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final GlyphList<G> glyphList;
    private JRadioButton byCodePointButton;
    private JRadioButton byIndexButton;
    private JCheckBox overwriteButton;
    private JTextArea specificationField;
    private JButton cancelButton;
    private JButton okButton;
    private static final Pattern RANGE_PATTERN = Pattern.compile("\\{([0-9]+)(-+|:+|\\.\\.+)([0-9]+)\\}");

    public CreateGlyphsDialog(Dialog dialog, GlyphList<G> glyphList) {
        super(dialog, "Create Glyphs");
        this.glyphList = glyphList;
        this.setModal(true);
        this.make();
    }

    public CreateGlyphsDialog(Frame frame, GlyphList<G> glyphList) {
        super(frame, "Create Glyphs");
        this.glyphList = glyphList;
        this.setModal(true);
        this.make();
    }

    public CreateGlyphsDialog(Window window, GlyphList<G> glyphList) {
        super(window, "Create Glyphs");
        this.glyphList = glyphList;
        this.setModal(true);
        this.make();
    }

    private void make() {
        this.byCodePointButton = new JRadioButton("By Code Point");
        this.byIndexButton = new JRadioButton("By Index");
        this.overwriteButton = new JCheckBox("Overwrite existing glyphs");
        this.specificationField = new JTextArea();
        this.cancelButton = new JButton("Cancel");
        this.okButton = new JButton("OK");
        boolean bl = CreateGlyphsDialog.isUnicodeRange(this.glyphList.getModel());
        this.byCodePointButton.setSelected(bl);
        this.byIndexButton.setSelected(!bl);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.byCodePointButton);
        buttonGroup.add(this.byIndexButton);
        JPanel jPanel = new JPanel(new GridLayout(1, 0, 8, 8));
        jPanel.add(this.byCodePointButton);
        jPanel.add(this.byIndexButton);
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 4, 4));
        jPanel2.add(jPanel);
        jPanel2.add(new JLabel("(Non-numeric values will be treated as glyph names.)"));
        jPanel2.add(this.overwriteButton);
        Dimension dimension = new Dimension(240, 120);
        this.specificationField.setMinimumSize(dimension);
        this.specificationField.setPreferredSize(dimension);
        this.specificationField.setLineWrap(true);
        this.specificationField.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(this.specificationField, 22, 31);
        JPanel jPanel3 = new JPanel(new BorderLayout(8, 8));
        jPanel3.add((Component)jPanel2, "First");
        jPanel3.add((Component)jScrollPane, "Center");
        JPanel jPanel4 = new JPanel(new FlowLayout());
        jPanel4.add(this.cancelButton);
        jPanel4.add(this.okButton);
        JPanel jPanel5 = new JPanel(new BorderLayout(8, 8));
        jPanel5.add((Component)jPanel3, "Center");
        jPanel5.add((Component)jPanel4, "Last");
        jPanel5.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.setContentPane(jPanel5);
        SwingUtils.setCancelButton(this.getRootPane(), this.cancelButton);
        SwingUtils.setDefaultButton(this.getRootPane(), this.okButton);
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(null);
        this.specificationField.requestFocusInWindow();
        this.specificationField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    case 10: {
                        CreateGlyphsDialog.this.okButton.doClick();
                        break;
                    }
                    case 27: {
                        CreateGlyphsDialog.this.cancelButton.doClick();
                        break;
                    }
                    case 85: {
                        if (!keyEvent.isControlDown() && !keyEvent.isMetaDown()) break;
                        CreateGlyphsDialog.this.byCodePointButton.doClick();
                        break;
                    }
                    case 73: {
                        if (!keyEvent.isControlDown() && !keyEvent.isMetaDown()) break;
                        CreateGlyphsDialog.this.byIndexButton.doClick();
                        break;
                    }
                    case 79: {
                        if (!keyEvent.isControlDown() && !keyEvent.isMetaDown()) break;
                        CreateGlyphsDialog.this.overwriteButton.doClick();
                    }
                }
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreateGlyphsDialog.this.createGlyphs(CreateGlyphsDialog.this.specificationField.getText(), CreateGlyphsDialog.this.byIndexButton.isSelected(), CreateGlyphsDialog.this.overwriteButton.isSelected());
                CreateGlyphsDialog.this.dispose();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreateGlyphsDialog.this.dispose();
            }
        });
    }

    public abstract G createGlyph();

    private static boolean isUnicodeRange(GlyphListModel glyphListModel) {
        int n = -1;
        int n2 = glyphListModel.getCellCount();
        for (int i = 0; i < n2; ++i) {
            int n3;
            block4: {
                block3: {
                    if (!glyphListModel.isCodePoint(i)) break block3;
                    n3 = glyphListModel.getCodePoint(i);
                    if (n < 0 || n + 1 == n3) break block4;
                }
                return false;
            }
            n = n3;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void createGlyphs(String string, boolean bl, boolean bl2) {
        void var12_19;
        Font<G> font = this.glyphList.getGlyphFont();
        GlyphListModel glyphListModel = this.glyphList.getModel();
        ArrayList<GlyphLocator<G>> arrayList = new ArrayList<GlyphLocator<G>>();
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        TreeSet<String> treeSet2 = new TreeSet<String>();
        String[] stringArray = string.split("[,;]");
        Object object = stringArray;
        int n = ((String[])object).length;
        boolean bl3 = false;
        while (var12_19 < n) {
            block13: {
                String string2 = object[var12_19];
                try {
                    int n2;
                    int[] nArray = CreateGlyphsDialog.parseRange(string2);
                    if (bl) {
                        n2 = glyphListModel.getCellCount();
                        for (int i = nArray[0]; i <= nArray[1]; ++i) {
                            if (i < 0 || i >= n2) continue;
                            arrayList.add(new GlyphLocator<G>(font, glyphListModel, i));
                        }
                    } else {
                        for (n2 = nArray[0]; n2 <= nArray[1]; ++n2) {
                            treeSet.add(n2);
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    string2 = string2.trim();
                    if (string2.length() <= 0) break block13;
                    CreateGlyphsDialog.parseGlyphNames(string2, treeSet2);
                }
            }
            ++var12_19;
        }
        for (GlyphLocator glyphLocator : arrayList) {
            if (!bl2 && glyphLocator.getGlyph() != null) continue;
            glyphLocator.setGlyph(this.createGlyph());
        }
        object = treeSet.iterator();
        while (object.hasNext()) {
            int string3 = (Integer)object.next();
            if (!bl2 && font.getCharacter(string3) != null) continue;
            font.putCharacter(string3, this.createGlyph());
        }
        for (String iterator : treeSet2) {
            if (!bl2 && font.getNamedGlyph(iterator) != null) continue;
            font.putNamedGlyph(iterator, this.createGlyph());
        }
        this.glyphList.glyphRepertoireChanged();
        object = new TreeSet();
        for (GlyphLocator glyphLocator : arrayList) {
            ((TreeSet)object).add(glyphLocator.getGlyphIndex());
        }
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            int n3 = (Integer)iterator.next();
            ((TreeSet)object).add(glyphListModel.indexOfCodePoint(n3));
        }
        for (String string3 : treeSet2) {
            ((TreeSet)object).add(glyphListModel.indexOfGlyphName(string3));
        }
        this.glyphList.setSelectedIndices((Collection<Integer>)object, true);
    }

    private static int[] parseRange(String string) {
        String[] stringArray = string.split("-+|:+|\\.\\.+", 2);
        if (stringArray.length == 2) {
            int n = CreateGlyphsDialog.parseInt(stringArray[0].trim());
            int n2 = CreateGlyphsDialog.parseInt(stringArray[1].trim());
            int n3 = Math.min(n, n2);
            int n4 = Math.max(n, n2);
            return new int[]{n3, n4};
        }
        int n = CreateGlyphsDialog.parseInt(string.trim());
        return new int[]{n, n};
    }

    private static int parseInt(String string) {
        if (string.startsWith("0x")) {
            return Integer.parseInt(string.substring(2), 16);
        }
        if (string.startsWith("0X")) {
            return Integer.parseInt(string.substring(2), 16);
        }
        if (string.startsWith("U+")) {
            return Integer.parseInt(string.substring(2), 16);
        }
        if (string.startsWith("u+")) {
            return Integer.parseInt(string.substring(2), 16);
        }
        if (string.startsWith("$")) {
            return Integer.parseInt(string.substring(1), 16);
        }
        if (string.startsWith("#")) {
            return Integer.parseInt(string.substring(1), 10);
        }
        return Integer.parseInt(string, 10);
    }

    private static void parseGlyphNames(String string, Collection<String> collection) {
        Matcher matcher = RANGE_PATTERN.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group(1);
            String string3 = matcher.group(3);
            int n = Integer.parseInt(string2);
            int n2 = Integer.parseInt(string3);
            int n3 = Math.min(string2.length(), string3.length());
            int n4 = Math.min(n, n2);
            int n5 = Math.max(n, n2);
            String string4 = string.substring(0, matcher.start());
            String string5 = string.substring(matcher.end());
            for (int i = n4; i <= n5; ++i) {
                String string6 = Integer.toString(i);
                while (string6.length() < n3) {
                    string6 = "0" + string6;
                }
                CreateGlyphsDialog.parseGlyphNames(string4 + string6 + string5, collection);
            }
        } else {
            collection.add(string);
        }
    }
}

