#
# Configuration file for TIERS. The P. are used to identify the 
# different parameters, so do not change them or the order of the parameters
# in this file without changing the code in tiers_config.cc.
#
# Parse syntax is to ignore newlines and line beginning with #
# then to look for a P., read until a space, then treat the characters 
# following as the parameter value until another # or the end of the line
# The character ; also acts as a parameter separator.
#

# Type of output produced by the model, e.g. generic or gnuplot
P.OP_TYPE gnuplot
#P.OP_TYPE generic

# If defined, TIERS_VERBOSE causes the output to contain the
# parameters used to generate the model and helpful headings
# If undefined, the output is a plain list of nodes and edges
P.TIERS_VERBOSE true

# If set, TIERS_LABEL causes the output to contain a label 
# (the unique node number) for each of the nodes
P.TIERS_LABEL_WAN true
P.TIERS_LABEL_MAN true
P.TIERS_LABEL_LAN false

# If defined, the operation of the model is more verbose
# If undefined, the model (should) run with no debugging output
P.TIERS_DEBUG true

# If defined as true, then an undirected list of edges is produced in the 
# output, i.e. the edges (i,j) and (j,i) only appear once in the output
# Note that all LAN edges are assumed bidirectional
P.REMOVE_DUP_EDGES true

# Set these true to apply proximity tests to nodes in each network type
P.PROXIMITY_TEST_WAN false
P.PROXIMITY_TEST_MAN false
P.PROXIMITY_TEST_LAN false

# The size of a unit in WAN, MAN and LAN grids
# e.g. 1000km, 1km, 1m would be best, but the current values fit with 
# the size of integers and are good for viewing graphs
P.WAN_SCALE 40
P.MAN_SCALE 8
P.LAN_SCALE 2	

# GRID is the size of the square grid on which points are placed
P.GRID 100

# The comment character for output 
# TODO not implemented yet
P.COM '#'

#
# GNUPLOT variables
#

# The title for results from gnuplot
P.title Generated Network

# The output directory for results from gnuplot
P.outputdir .

# The unique identifier for a particular network, default is the seed used 
# to generate it
#P.ModelId ModelId
#P.ModelId 847404895
P.ModelId 856566616

#
# The cost table
#
# Must specify all nine entries. Symmetry is not assumed
# bandwidth; fixed delay; delay per unit distance
P.LAN->LAN 10;5;1  	# LAN->LAN 
P.LAN->MAN 10;50;1	# LAN->MAN e.g. bridge/router
P.LAN->WAN 0;0;1 	# LAN->WAN not permitted in TIERS
P.MAN->LAN 10;50;1 	# MAN->LAN symmetrical with LAN->MAN
P.MAN->MAN 100;100;10 	# MAN->MAN
P.MAN->WAN 100;1000;1 	# MAN->WAN e.g. gateway
P.WAN->LAN 0;0;1 	# WAN->LAN not permitted in TIERS
P.WAN->MAN 100;1000;1 	# WAN->MAN
P.WAN->WAN 1000;150;100 # WAN->WAN

# End of file
