/* $Id: xp_defines.h,v 1.1 2002/01/21 18:28:46 mixter Exp $ */
/*
** Copyright (C) 2001 Fyodor Yarochkin <fygrave@tigerteam.net>,
**                    Ofir Arkin       <ofir@sys-security.com>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** All material for nonprofit, educational use only.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef DEFINES_H
#define DEFINES_H

#ifndef VERSION
#define VERSION "0.0.1"
#endif
#define BANNER "X probe ver. "VERSION"\n------------------"

#define DATA_SIZE 20
#define DEF_TIMEOUT 5
#define PACKBUF_SIZ 1024


#define TYPE_MS_WINDOWS_BRANCH   1
#define TYPE_LINUX_KERNEL_24     2
#define TYPE_ULTRIX              3
#define TYPE_SOME_SOLARIS        4
#define TYPE_SUN_SOLARIS_HPUX    5
#define TYPE_UNIX_BRANCH         6
#define TYPE_CONTINUE            7


#define UDP_PORT 32132
#define UDP_DATA_SIZE 70
#define UDP_LEN_ALL (sizeof(struct ip) + sizeof(struct udphdr) + UDP_DATA_SIZE)

#define UDP_CKSUM_BADDGRAM -1
#define UDP_CKSUM_ZERO      0
#define UDP_CKSUM_BAD       1
#define UDP_CKSUM_GOOD      2

/* we don't expect packets bigger than 1500 */
#define LPCAP_SNAPLEN       1500
#define LPCAP_TIMEOUT       500
#define READ_ICMP_TIMEOUT   5

/* return values for ICMP_UNREACH length check */

#define ICMPUNREACH_LEN_OK  1
#define ICMPUNREACH_LEN_GT  2
#define ICMPUNREACH_LEN_LS  3

/* teturn values for frag bits test */

#define FRAG_BITS_OK        0
#define FRAG_BITS_FLIPPED   1
#define FRAG_BITS_ZERO      2

#endif /* DEFINES_H */
