//////////////////////////////////////////////////////////////////////////////
//                                                                          //
//                  Network Security Analysis Tool                          //
//              Distributed.h - distributed scanning protocol               //
//                                                                          //
//   Copyright (C) 1999-2002 by Mixter and 2xs ltd. <mixter@2xs.co.il>      //
//                                                                          //
// This program is free software; you can redistribute it and/or modify     //
// it under the terms of the GNU General Public License as published by     //
// the Free Software Foundation; either version 2 of the License, or        //
// (at your option) any later version.                                      //
//                                                                          //
// This program is distributed in the hope that it will be useful,          //
// but WITHOUT ANY WARRANTY; without even the implied warranty of           //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
// GNU General Public License for more details.                             //
//                                                                          //
// You should have received a copy of the GNU General Public License        //
// along with this program; if not, write to the Free Software              //
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

#ifndef DISTRIBUTED_H
#define DISTRIBUTED_H
#pragma interface "distributed"

#include "nsat.h"

class Distributed
{
  private:
  unsigned short mymode;	// 0: none! 1: I'm agent 2: I'm client
  int mastersocket;			// for agents
  int clientsockets[MAX_AGENTS];	// for the client
  unsigned int clientaddrs[MAX_AGENTS];
  int nodecount;
  int nxt;
  int curfd;

  public:
    int concount;

    int Connections(void);
    void Accept(void);
    int SendRequests(int num, unsigned int *addrs);
    int GetResponses(void);
    int WriteToMaster(char *buf, int len);

    Distributed();		// for agents
    Distributed(FILE *list);	// for the client
    ~Distributed(void);
};

#endif
