// Copyright (c) 2022 Proton Technologies AG
//
// This file is part of ProtonMail Bridge.
//
// ProtonMail Bridge is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// ProtonMail Bridge is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with ProtonMail Bridge.  If not, see <https://www.gnu.org/licenses/>.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.33.0
// 	protoc        v3.21.12
// source: bridge.proto

package grpc

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// **********************************************************
// Log related message
// **********************************************************
// Note: the enum values are prefixed with 'LOG_' to avoid a clash in C++ on Windows with the ERROR macro defined in wingdi.h
type LogLevel int32

const (
	LogLevel_LOG_PANIC LogLevel = 0
	LogLevel_LOG_FATAL LogLevel = 1
	LogLevel_LOG_ERROR LogLevel = 2
	LogLevel_LOG_WARN  LogLevel = 3
	LogLevel_LOG_INFO  LogLevel = 4
	LogLevel_LOG_DEBUG LogLevel = 5
	LogLevel_LOG_TRACE LogLevel = 6
)

// Enum value maps for LogLevel.
var (
	LogLevel_name = map[int32]string{
		0: "LOG_PANIC",
		1: "LOG_FATAL",
		2: "LOG_ERROR",
		3: "LOG_WARN",
		4: "LOG_INFO",
		5: "LOG_DEBUG",
		6: "LOG_TRACE",
	}
	LogLevel_value = map[string]int32{
		"LOG_PANIC": 0,
		"LOG_FATAL": 1,
		"LOG_ERROR": 2,
		"LOG_WARN":  3,
		"LOG_INFO":  4,
		"LOG_DEBUG": 5,
		"LOG_TRACE": 6,
	}
)

func (x LogLevel) Enum() *LogLevel {
	p := new(LogLevel)
	*p = x
	return p
}

func (x LogLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LogLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_bridge_proto_enumTypes[0].Descriptor()
}

func (LogLevel) Type() protoreflect.EnumType {
	return &file_bridge_proto_enumTypes[0]
}

func (x LogLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LogLevel.Descriptor instead.
func (LogLevel) EnumDescriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{0}
}

// **********************************************************
// user related messages
// **********************************************************
type UserState int32

const (
	UserState_SIGNED_OUT UserState = 0
	UserState_LOCKED     UserState = 1
	UserState_CONNECTED  UserState = 2
)

// Enum value maps for UserState.
var (
	UserState_name = map[int32]string{
		0: "SIGNED_OUT",
		1: "LOCKED",
		2: "CONNECTED",
	}
	UserState_value = map[string]int32{
		"SIGNED_OUT": 0,
		"LOCKED":     1,
		"CONNECTED":  2,
	}
)

func (x UserState) Enum() *UserState {
	p := new(UserState)
	*p = x
	return p
}

func (x UserState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UserState) Descriptor() protoreflect.EnumDescriptor {
	return file_bridge_proto_enumTypes[1].Descriptor()
}

func (UserState) Type() protoreflect.EnumType {
	return &file_bridge_proto_enumTypes[1]
}

func (x UserState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use UserState.Descriptor instead.
func (UserState) EnumDescriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{1}
}

type LoginErrorType int32

const (
	LoginErrorType_USERNAME_PASSWORD_ERROR LoginErrorType = 0
	LoginErrorType_FREE_USER               LoginErrorType = 1
	LoginErrorType_CONNECTION_ERROR        LoginErrorType = 2
	LoginErrorType_TFA_ERROR               LoginErrorType = 3
	LoginErrorType_TFA_ABORT               LoginErrorType = 4
	LoginErrorType_TWO_PASSWORDS_ERROR     LoginErrorType = 5
	LoginErrorType_TWO_PASSWORDS_ABORT     LoginErrorType = 6
	LoginErrorType_HV_ERROR                LoginErrorType = 7
)

// Enum value maps for LoginErrorType.
var (
	LoginErrorType_name = map[int32]string{
		0: "USERNAME_PASSWORD_ERROR",
		1: "FREE_USER",
		2: "CONNECTION_ERROR",
		3: "TFA_ERROR",
		4: "TFA_ABORT",
		5: "TWO_PASSWORDS_ERROR",
		6: "TWO_PASSWORDS_ABORT",
		7: "HV_ERROR",
	}
	LoginErrorType_value = map[string]int32{
		"USERNAME_PASSWORD_ERROR": 0,
		"FREE_USER":               1,
		"CONNECTION_ERROR":        2,
		"TFA_ERROR":               3,
		"TFA_ABORT":               4,
		"TWO_PASSWORDS_ERROR":     5,
		"TWO_PASSWORDS_ABORT":     6,
		"HV_ERROR":                7,
	}
)

func (x LoginErrorType) Enum() *LoginErrorType {
	p := new(LoginErrorType)
	*p = x
	return p
}

func (x LoginErrorType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LoginErrorType) Descriptor() protoreflect.EnumDescriptor {
	return file_bridge_proto_enumTypes[2].Descriptor()
}

func (LoginErrorType) Type() protoreflect.EnumType {
	return &file_bridge_proto_enumTypes[2]
}

func (x LoginErrorType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LoginErrorType.Descriptor instead.
func (LoginErrorType) EnumDescriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{2}
}

type UpdateErrorType int32

const (
	UpdateErrorType_UPDATE_MANUAL_ERROR UpdateErrorType = 0
	UpdateErrorType_UPDATE_FORCE_ERROR  UpdateErrorType = 1
	UpdateErrorType_UPDATE_SILENT_ERROR UpdateErrorType = 2
)

// Enum value maps for UpdateErrorType.
var (
	UpdateErrorType_name = map[int32]string{
		0: "UPDATE_MANUAL_ERROR",
		1: "UPDATE_FORCE_ERROR",
		2: "UPDATE_SILENT_ERROR",
	}
	UpdateErrorType_value = map[string]int32{
		"UPDATE_MANUAL_ERROR": 0,
		"UPDATE_FORCE_ERROR":  1,
		"UPDATE_SILENT_ERROR": 2,
	}
)

func (x UpdateErrorType) Enum() *UpdateErrorType {
	p := new(UpdateErrorType)
	*p = x
	return p
}

func (x UpdateErrorType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UpdateErrorType) Descriptor() protoreflect.EnumDescriptor {
	return file_bridge_proto_enumTypes[3].Descriptor()
}

func (UpdateErrorType) Type() protoreflect.EnumType {
	return &file_bridge_proto_enumTypes[3]
}

func (x UpdateErrorType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use UpdateErrorType.Descriptor instead.
func (UpdateErrorType) EnumDescriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{3}
}

type DiskCacheErrorType int32

const (
	DiskCacheErrorType_CANT_MOVE_DISK_CACHE_ERROR DiskCacheErrorType = 0
)

// Enum value maps for DiskCacheErrorType.
var (
	DiskCacheErrorType_name = map[int32]string{
		0: "CANT_MOVE_DISK_CACHE_ERROR",
	}
	DiskCacheErrorType_value = map[string]int32{
		"CANT_MOVE_DISK_CACHE_ERROR": 0,
	}
)

func (x DiskCacheErrorType) Enum() *DiskCacheErrorType {
	p := new(DiskCacheErrorType)
	*p = x
	return p
}

func (x DiskCacheErrorType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DiskCacheErrorType) Descriptor() protoreflect.EnumDescriptor {
	return file_bridge_proto_enumTypes[4].Descriptor()
}

func (DiskCacheErrorType) Type() protoreflect.EnumType {
	return &file_bridge_proto_enumTypes[4]
}

func (x DiskCacheErrorType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DiskCacheErrorType.Descriptor instead.
func (DiskCacheErrorType) EnumDescriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{4}
}

type MailServerSettingsErrorType int32

const (
	MailServerSettingsErrorType_IMAP_PORT_STARTUP_ERROR           MailServerSettingsErrorType = 0
	MailServerSettingsErrorType_SMTP_PORT_STARTUP_ERROR           MailServerSettingsErrorType = 1
	MailServerSettingsErrorType_IMAP_PORT_CHANGE_ERROR            MailServerSettingsErrorType = 2
	MailServerSettingsErrorType_SMTP_PORT_CHANGE_ERROR            MailServerSettingsErrorType = 3
	MailServerSettingsErrorType_IMAP_CONNECTION_MODE_CHANGE_ERROR MailServerSettingsErrorType = 4
	MailServerSettingsErrorType_SMTP_CONNECTION_MODE_CHANGE_ERROR MailServerSettingsErrorType = 5
)

// Enum value maps for MailServerSettingsErrorType.
var (
	MailServerSettingsErrorType_name = map[int32]string{
		0: "IMAP_PORT_STARTUP_ERROR",
		1: "SMTP_PORT_STARTUP_ERROR",
		2: "IMAP_PORT_CHANGE_ERROR",
		3: "SMTP_PORT_CHANGE_ERROR",
		4: "IMAP_CONNECTION_MODE_CHANGE_ERROR",
		5: "SMTP_CONNECTION_MODE_CHANGE_ERROR",
	}
	MailServerSettingsErrorType_value = map[string]int32{
		"IMAP_PORT_STARTUP_ERROR":           0,
		"SMTP_PORT_STARTUP_ERROR":           1,
		"IMAP_PORT_CHANGE_ERROR":            2,
		"SMTP_PORT_CHANGE_ERROR":            3,
		"IMAP_CONNECTION_MODE_CHANGE_ERROR": 4,
		"SMTP_CONNECTION_MODE_CHANGE_ERROR": 5,
	}
)

func (x MailServerSettingsErrorType) Enum() *MailServerSettingsErrorType {
	p := new(MailServerSettingsErrorType)
	*p = x
	return p
}

func (x MailServerSettingsErrorType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MailServerSettingsErrorType) Descriptor() protoreflect.EnumDescriptor {
	return file_bridge_proto_enumTypes[5].Descriptor()
}

func (MailServerSettingsErrorType) Type() protoreflect.EnumType {
	return &file_bridge_proto_enumTypes[5]
}

func (x MailServerSettingsErrorType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MailServerSettingsErrorType.Descriptor instead.
func (MailServerSettingsErrorType) EnumDescriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{5}
}

// **********************************************************
// Generic errors
// **********************************************************
type ErrorCode int32

const (
	ErrorCode_UNKNOWN_ERROR         ErrorCode = 0
	ErrorCode_TLS_CERT_EXPORT_ERROR ErrorCode = 1
	ErrorCode_TLS_KEY_EXPORT_ERROR  ErrorCode = 2
)

// Enum value maps for ErrorCode.
var (
	ErrorCode_name = map[int32]string{
		0: "UNKNOWN_ERROR",
		1: "TLS_CERT_EXPORT_ERROR",
		2: "TLS_KEY_EXPORT_ERROR",
	}
	ErrorCode_value = map[string]int32{
		"UNKNOWN_ERROR":         0,
		"TLS_CERT_EXPORT_ERROR": 1,
		"TLS_KEY_EXPORT_ERROR":  2,
	}
)

func (x ErrorCode) Enum() *ErrorCode {
	p := new(ErrorCode)
	*p = x
	return p
}

func (x ErrorCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ErrorCode) Descriptor() protoreflect.EnumDescriptor {
	return file_bridge_proto_enumTypes[6].Descriptor()
}

func (ErrorCode) Type() protoreflect.EnumType {
	return &file_bridge_proto_enumTypes[6]
}

func (x ErrorCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ErrorCode.Descriptor instead.
func (ErrorCode) EnumDescriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{6}
}

type AddLogEntryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Level   LogLevel `protobuf:"varint,1,opt,name=level,proto3,enum=grpc.LogLevel" json:"level,omitempty"`
	Package string   `protobuf:"bytes,2,opt,name=package,proto3" json:"package,omitempty"` // package is Go lingo but it identifies the component responsible for the log entry
	Message string   `protobuf:"bytes,3,opt,name=message,proto3" json:"message,omitempty"`
}

func (x *AddLogEntryRequest) Reset() {
	*x = AddLogEntryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddLogEntryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddLogEntryRequest) ProtoMessage() {}

func (x *AddLogEntryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddLogEntryRequest.ProtoReflect.Descriptor instead.
func (*AddLogEntryRequest) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{0}
}

func (x *AddLogEntryRequest) GetLevel() LogLevel {
	if x != nil {
		return x.Level
	}
	return LogLevel_LOG_PANIC
}

func (x *AddLogEntryRequest) GetPackage() string {
	if x != nil {
		return x.Package
	}
	return ""
}

func (x *AddLogEntryRequest) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

// **********************************************************
//
//	GuiReady
//
// **********************************************************
type GuiReadyResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ShowSplashScreen bool `protobuf:"varint,1,opt,name=showSplashScreen,proto3" json:"showSplashScreen,omitempty"`
}

func (x *GuiReadyResponse) Reset() {
	*x = GuiReadyResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GuiReadyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GuiReadyResponse) ProtoMessage() {}

func (x *GuiReadyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GuiReadyResponse.ProtoReflect.Descriptor instead.
func (*GuiReadyResponse) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{1}
}

func (x *GuiReadyResponse) GetShowSplashScreen() bool {
	if x != nil {
		return x.ShowSplashScreen
	}
	return false
}

// **********************************************************
//
//	Bug reporting related messages.
//
// **********************************************************
type ReportBugRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	OsType      string `protobuf:"bytes,1,opt,name=osType,proto3" json:"osType,omitempty"`
	OsVersion   string `protobuf:"bytes,2,opt,name=osVersion,proto3" json:"osVersion,omitempty"`
	Title       string `protobuf:"bytes,3,opt,name=title,proto3" json:"title,omitempty"`
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	Address     string `protobuf:"bytes,5,opt,name=address,proto3" json:"address,omitempty"`
	EmailClient string `protobuf:"bytes,6,opt,name=emailClient,proto3" json:"emailClient,omitempty"`
	IncludeLogs bool   `protobuf:"varint,7,opt,name=includeLogs,proto3" json:"includeLogs,omitempty"`
}

func (x *ReportBugRequest) Reset() {
	*x = ReportBugRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportBugRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportBugRequest) ProtoMessage() {}

func (x *ReportBugRequest) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportBugRequest.ProtoReflect.Descriptor instead.
func (*ReportBugRequest) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{2}
}

func (x *ReportBugRequest) GetOsType() string {
	if x != nil {
		return x.OsType
	}
	return ""
}

func (x *ReportBugRequest) GetOsVersion() string {
	if x != nil {
		return x.OsVersion
	}
	return ""
}

func (x *ReportBugRequest) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *ReportBugRequest) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *ReportBugRequest) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

func (x *ReportBugRequest) GetEmailClient() string {
	if x != nil {
		return x.EmailClient
	}
	return ""
}

func (x *ReportBugRequest) GetIncludeLogs() bool {
	if x != nil {
		return x.IncludeLogs
	}
	return false
}

type LoginRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Username     string `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
	Password     []byte `protobuf:"bytes,2,opt,name=password,proto3" json:"password,omitempty"`
	UseHvDetails *bool  `protobuf:"varint,3,opt,name=useHvDetails,proto3,oneof" json:"useHvDetails,omitempty"`
}

func (x *LoginRequest) Reset() {
	*x = LoginRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoginRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoginRequest) ProtoMessage() {}

func (x *LoginRequest) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoginRequest.ProtoReflect.Descriptor instead.
func (*LoginRequest) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{3}
}

func (x *LoginRequest) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

func (x *LoginRequest) GetPassword() []byte {
	if x != nil {
		return x.Password
	}
	return nil
}

func (x *LoginRequest) GetUseHvDetails() bool {
	if x != nil && x.UseHvDetails != nil {
		return *x.UseHvDetails
	}
	return false
}

type LoginAbortRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Username string `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
}

func (x *LoginAbortRequest) Reset() {
	*x = LoginAbortRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoginAbortRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoginAbortRequest) ProtoMessage() {}

func (x *LoginAbortRequest) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoginAbortRequest.ProtoReflect.Descriptor instead.
func (*LoginAbortRequest) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{4}
}

func (x *LoginAbortRequest) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

// **********************************************************
// IMAP/SMTP Mail Server settings
// **********************************************************
type ImapSmtpSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ImapPort      int32 `protobuf:"varint,1,opt,name=imapPort,proto3" json:"imapPort,omitempty"`
	SmtpPort      int32 `protobuf:"varint,2,opt,name=smtpPort,proto3" json:"smtpPort,omitempty"`
	UseSSLForImap bool  `protobuf:"varint,3,opt,name=useSSLForImap,proto3" json:"useSSLForImap,omitempty"`
	UseSSLForSmtp bool  `protobuf:"varint,4,opt,name=useSSLForSmtp,proto3" json:"useSSLForSmtp,omitempty"`
}

func (x *ImapSmtpSettings) Reset() {
	*x = ImapSmtpSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImapSmtpSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImapSmtpSettings) ProtoMessage() {}

func (x *ImapSmtpSettings) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImapSmtpSettings.ProtoReflect.Descriptor instead.
func (*ImapSmtpSettings) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{5}
}

func (x *ImapSmtpSettings) GetImapPort() int32 {
	if x != nil {
		return x.ImapPort
	}
	return 0
}

func (x *ImapSmtpSettings) GetSmtpPort() int32 {
	if x != nil {
		return x.SmtpPort
	}
	return 0
}

func (x *ImapSmtpSettings) GetUseSSLForImap() bool {
	if x != nil {
		return x.UseSSLForImap
	}
	return false
}

func (x *ImapSmtpSettings) GetUseSSLForSmtp() bool {
	if x != nil {
		return x.UseSSLForSmtp
	}
	return false
}

// **********************************************************
// Keychain related message
// **********************************************************
type AvailableKeychainsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Keychains []string `protobuf:"bytes,1,rep,name=keychains,proto3" json:"keychains,omitempty"`
}

func (x *AvailableKeychainsResponse) Reset() {
	*x = AvailableKeychainsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AvailableKeychainsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AvailableKeychainsResponse) ProtoMessage() {}

func (x *AvailableKeychainsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AvailableKeychainsResponse.ProtoReflect.Descriptor instead.
func (*AvailableKeychainsResponse) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{6}
}

func (x *AvailableKeychainsResponse) GetKeychains() []string {
	if x != nil {
		return x.Keychains
	}
	return nil
}

type User struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id         string    `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Username   string    `protobuf:"bytes,2,opt,name=username,proto3" json:"username,omitempty"`
	AvatarText string    `protobuf:"bytes,3,opt,name=avatarText,proto3" json:"avatarText,omitempty"`
	State      UserState `protobuf:"varint,4,opt,name=state,proto3,enum=grpc.UserState" json:"state,omitempty"`
	SplitMode  bool      `protobuf:"varint,5,opt,name=splitMode,proto3" json:"splitMode,omitempty"`
	UsedBytes  int64     `protobuf:"varint,6,opt,name=usedBytes,proto3" json:"usedBytes,omitempty"`
	TotalBytes int64     `protobuf:"varint,7,opt,name=totalBytes,proto3" json:"totalBytes,omitempty"`
	Password   []byte    `protobuf:"bytes,8,opt,name=password,proto3" json:"password,omitempty"`
	Addresses  []string  `protobuf:"bytes,9,rep,name=addresses,proto3" json:"addresses,omitempty"`
}

func (x *User) Reset() {
	*x = User{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *User) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*User) ProtoMessage() {}

func (x *User) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use User.ProtoReflect.Descriptor instead.
func (*User) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{7}
}

func (x *User) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *User) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

func (x *User) GetAvatarText() string {
	if x != nil {
		return x.AvatarText
	}
	return ""
}

func (x *User) GetState() UserState {
	if x != nil {
		return x.State
	}
	return UserState_SIGNED_OUT
}

func (x *User) GetSplitMode() bool {
	if x != nil {
		return x.SplitMode
	}
	return false
}

func (x *User) GetUsedBytes() int64 {
	if x != nil {
		return x.UsedBytes
	}
	return 0
}

func (x *User) GetTotalBytes() int64 {
	if x != nil {
		return x.TotalBytes
	}
	return 0
}

func (x *User) GetPassword() []byte {
	if x != nil {
		return x.Password
	}
	return nil
}

func (x *User) GetAddresses() []string {
	if x != nil {
		return x.Addresses
	}
	return nil
}

type UserSplitModeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	UserID string `protobuf:"bytes,1,opt,name=userID,proto3" json:"userID,omitempty"`
	Active bool   `protobuf:"varint,2,opt,name=active,proto3" json:"active,omitempty"`
}

func (x *UserSplitModeRequest) Reset() {
	*x = UserSplitModeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UserSplitModeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserSplitModeRequest) ProtoMessage() {}

func (x *UserSplitModeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserSplitModeRequest.ProtoReflect.Descriptor instead.
func (*UserSplitModeRequest) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{8}
}

func (x *UserSplitModeRequest) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

func (x *UserSplitModeRequest) GetActive() bool {
	if x != nil {
		return x.Active
	}
	return false
}

type UserBadEventFeedbackRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	UserID   string `protobuf:"bytes,1,opt,name=userID,proto3" json:"userID,omitempty"`
	DoResync bool   `protobuf:"varint,2,opt,name=doResync,proto3" json:"doResync,omitempty"`
}

func (x *UserBadEventFeedbackRequest) Reset() {
	*x = UserBadEventFeedbackRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UserBadEventFeedbackRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserBadEventFeedbackRequest) ProtoMessage() {}

func (x *UserBadEventFeedbackRequest) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserBadEventFeedbackRequest.ProtoReflect.Descriptor instead.
func (*UserBadEventFeedbackRequest) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{9}
}

func (x *UserBadEventFeedbackRequest) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

func (x *UserBadEventFeedbackRequest) GetDoResync() bool {
	if x != nil {
		return x.DoResync
	}
	return false
}

type UserListResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Users []*User `protobuf:"bytes,1,rep,name=users,proto3" json:"users,omitempty"`
}

func (x *UserListResponse) Reset() {
	*x = UserListResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UserListResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserListResponse) ProtoMessage() {}

func (x *UserListResponse) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserListResponse.ProtoReflect.Descriptor instead.
func (*UserListResponse) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{10}
}

func (x *UserListResponse) GetUsers() []*User {
	if x != nil {
		return x.Users
	}
	return nil
}

type ConfigureAppleMailRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	UserID  string `protobuf:"bytes,1,opt,name=userID,proto3" json:"userID,omitempty"`
	Address string `protobuf:"bytes,2,opt,name=address,proto3" json:"address,omitempty"`
}

func (x *ConfigureAppleMailRequest) Reset() {
	*x = ConfigureAppleMailRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConfigureAppleMailRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigureAppleMailRequest) ProtoMessage() {}

func (x *ConfigureAppleMailRequest) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigureAppleMailRequest.ProtoReflect.Descriptor instead.
func (*ConfigureAppleMailRequest) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{11}
}

func (x *ConfigureAppleMailRequest) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

func (x *ConfigureAppleMailRequest) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

type EventStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ClientPlatform string `protobuf:"bytes,1,opt,name=ClientPlatform,proto3" json:"ClientPlatform,omitempty"`
}

func (x *EventStreamRequest) Reset() {
	*x = EventStreamRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EventStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EventStreamRequest) ProtoMessage() {}

func (x *EventStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EventStreamRequest.ProtoReflect.Descriptor instead.
func (*EventStreamRequest) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{12}
}

func (x *EventStreamRequest) GetClientPlatform() string {
	if x != nil {
		return x.ClientPlatform
	}
	return ""
}

type StreamEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Event:
	//
	//	*StreamEvent_App
	//	*StreamEvent_Login
	//	*StreamEvent_Update
	//	*StreamEvent_Cache
	//	*StreamEvent_MailServerSettings
	//	*StreamEvent_Keychain
	//	*StreamEvent_Mail
	//	*StreamEvent_User
	//	*StreamEvent_GenericError
	Event isStreamEvent_Event `protobuf_oneof:"event"`
}

func (x *StreamEvent) Reset() {
	*x = StreamEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamEvent) ProtoMessage() {}

func (x *StreamEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamEvent.ProtoReflect.Descriptor instead.
func (*StreamEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{13}
}

func (m *StreamEvent) GetEvent() isStreamEvent_Event {
	if m != nil {
		return m.Event
	}
	return nil
}

func (x *StreamEvent) GetApp() *AppEvent {
	if x, ok := x.GetEvent().(*StreamEvent_App); ok {
		return x.App
	}
	return nil
}

func (x *StreamEvent) GetLogin() *LoginEvent {
	if x, ok := x.GetEvent().(*StreamEvent_Login); ok {
		return x.Login
	}
	return nil
}

func (x *StreamEvent) GetUpdate() *UpdateEvent {
	if x, ok := x.GetEvent().(*StreamEvent_Update); ok {
		return x.Update
	}
	return nil
}

func (x *StreamEvent) GetCache() *DiskCacheEvent {
	if x, ok := x.GetEvent().(*StreamEvent_Cache); ok {
		return x.Cache
	}
	return nil
}

func (x *StreamEvent) GetMailServerSettings() *MailServerSettingsEvent {
	if x, ok := x.GetEvent().(*StreamEvent_MailServerSettings); ok {
		return x.MailServerSettings
	}
	return nil
}

func (x *StreamEvent) GetKeychain() *KeychainEvent {
	if x, ok := x.GetEvent().(*StreamEvent_Keychain); ok {
		return x.Keychain
	}
	return nil
}

func (x *StreamEvent) GetMail() *MailEvent {
	if x, ok := x.GetEvent().(*StreamEvent_Mail); ok {
		return x.Mail
	}
	return nil
}

func (x *StreamEvent) GetUser() *UserEvent {
	if x, ok := x.GetEvent().(*StreamEvent_User); ok {
		return x.User
	}
	return nil
}

func (x *StreamEvent) GetGenericError() *GenericErrorEvent {
	if x, ok := x.GetEvent().(*StreamEvent_GenericError); ok {
		return x.GenericError
	}
	return nil
}

type isStreamEvent_Event interface {
	isStreamEvent_Event()
}

type StreamEvent_App struct {
	App *AppEvent `protobuf:"bytes,1,opt,name=app,proto3,oneof"`
}

type StreamEvent_Login struct {
	Login *LoginEvent `protobuf:"bytes,2,opt,name=login,proto3,oneof"`
}

type StreamEvent_Update struct {
	Update *UpdateEvent `protobuf:"bytes,3,opt,name=update,proto3,oneof"`
}

type StreamEvent_Cache struct {
	Cache *DiskCacheEvent `protobuf:"bytes,4,opt,name=cache,proto3,oneof"`
}

type StreamEvent_MailServerSettings struct {
	MailServerSettings *MailServerSettingsEvent `protobuf:"bytes,5,opt,name=mailServerSettings,proto3,oneof"`
}

type StreamEvent_Keychain struct {
	Keychain *KeychainEvent `protobuf:"bytes,6,opt,name=keychain,proto3,oneof"`
}

type StreamEvent_Mail struct {
	Mail *MailEvent `protobuf:"bytes,7,opt,name=mail,proto3,oneof"`
}

type StreamEvent_User struct {
	User *UserEvent `protobuf:"bytes,8,opt,name=user,proto3,oneof"`
}

type StreamEvent_GenericError struct {
	GenericError *GenericErrorEvent `protobuf:"bytes,9,opt,name=genericError,proto3,oneof"`
}

func (*StreamEvent_App) isStreamEvent_Event() {}

func (*StreamEvent_Login) isStreamEvent_Event() {}

func (*StreamEvent_Update) isStreamEvent_Event() {}

func (*StreamEvent_Cache) isStreamEvent_Event() {}

func (*StreamEvent_MailServerSettings) isStreamEvent_Event() {}

func (*StreamEvent_Keychain) isStreamEvent_Event() {}

func (*StreamEvent_Mail) isStreamEvent_Event() {}

func (*StreamEvent_User) isStreamEvent_Event() {}

func (*StreamEvent_GenericError) isStreamEvent_Event() {}

// **********************************************************
// App related events
// **********************************************************
type AppEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Event:
	//
	//	*AppEvent_InternetStatus
	//	*AppEvent_ToggleAutostartFinished
	//	*AppEvent_ResetFinished
	//	*AppEvent_ReportBugFinished
	//	*AppEvent_ReportBugSuccess
	//	*AppEvent_ReportBugError
	//	*AppEvent_ShowMainWindow
	//	*AppEvent_ReportBugFallback
	//	*AppEvent_CertificateInstallSuccess
	//	*AppEvent_CertificateInstallCanceled
	//	*AppEvent_CertificateInstallFailed
	//	*AppEvent_KnowledgeBaseSuggestions
	//	*AppEvent_RepairStarted
	//	*AppEvent_AllUsersLoaded
	//	*AppEvent_UserNotification
	Event isAppEvent_Event `protobuf_oneof:"event"`
}

func (x *AppEvent) Reset() {
	*x = AppEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AppEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppEvent) ProtoMessage() {}

func (x *AppEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppEvent.ProtoReflect.Descriptor instead.
func (*AppEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{14}
}

func (m *AppEvent) GetEvent() isAppEvent_Event {
	if m != nil {
		return m.Event
	}
	return nil
}

func (x *AppEvent) GetInternetStatus() *InternetStatusEvent {
	if x, ok := x.GetEvent().(*AppEvent_InternetStatus); ok {
		return x.InternetStatus
	}
	return nil
}

func (x *AppEvent) GetToggleAutostartFinished() *ToggleAutostartFinishedEvent {
	if x, ok := x.GetEvent().(*AppEvent_ToggleAutostartFinished); ok {
		return x.ToggleAutostartFinished
	}
	return nil
}

func (x *AppEvent) GetResetFinished() *ResetFinishedEvent {
	if x, ok := x.GetEvent().(*AppEvent_ResetFinished); ok {
		return x.ResetFinished
	}
	return nil
}

func (x *AppEvent) GetReportBugFinished() *ReportBugFinishedEvent {
	if x, ok := x.GetEvent().(*AppEvent_ReportBugFinished); ok {
		return x.ReportBugFinished
	}
	return nil
}

func (x *AppEvent) GetReportBugSuccess() *ReportBugSuccessEvent {
	if x, ok := x.GetEvent().(*AppEvent_ReportBugSuccess); ok {
		return x.ReportBugSuccess
	}
	return nil
}

func (x *AppEvent) GetReportBugError() *ReportBugErrorEvent {
	if x, ok := x.GetEvent().(*AppEvent_ReportBugError); ok {
		return x.ReportBugError
	}
	return nil
}

func (x *AppEvent) GetShowMainWindow() *ShowMainWindowEvent {
	if x, ok := x.GetEvent().(*AppEvent_ShowMainWindow); ok {
		return x.ShowMainWindow
	}
	return nil
}

func (x *AppEvent) GetReportBugFallback() *ReportBugFallbackEvent {
	if x, ok := x.GetEvent().(*AppEvent_ReportBugFallback); ok {
		return x.ReportBugFallback
	}
	return nil
}

func (x *AppEvent) GetCertificateInstallSuccess() *CertificateInstallSuccessEvent {
	if x, ok := x.GetEvent().(*AppEvent_CertificateInstallSuccess); ok {
		return x.CertificateInstallSuccess
	}
	return nil
}

func (x *AppEvent) GetCertificateInstallCanceled() *CertificateInstallCanceledEvent {
	if x, ok := x.GetEvent().(*AppEvent_CertificateInstallCanceled); ok {
		return x.CertificateInstallCanceled
	}
	return nil
}

func (x *AppEvent) GetCertificateInstallFailed() *CertificateInstallFailedEvent {
	if x, ok := x.GetEvent().(*AppEvent_CertificateInstallFailed); ok {
		return x.CertificateInstallFailed
	}
	return nil
}

func (x *AppEvent) GetKnowledgeBaseSuggestions() *KnowledgeBaseSuggestionsEvent {
	if x, ok := x.GetEvent().(*AppEvent_KnowledgeBaseSuggestions); ok {
		return x.KnowledgeBaseSuggestions
	}
	return nil
}

func (x *AppEvent) GetRepairStarted() *RepairStartedEvent {
	if x, ok := x.GetEvent().(*AppEvent_RepairStarted); ok {
		return x.RepairStarted
	}
	return nil
}

func (x *AppEvent) GetAllUsersLoaded() *AllUsersLoadedEvent {
	if x, ok := x.GetEvent().(*AppEvent_AllUsersLoaded); ok {
		return x.AllUsersLoaded
	}
	return nil
}

func (x *AppEvent) GetUserNotification() *UserNotificationEvent {
	if x, ok := x.GetEvent().(*AppEvent_UserNotification); ok {
		return x.UserNotification
	}
	return nil
}

type isAppEvent_Event interface {
	isAppEvent_Event()
}

type AppEvent_InternetStatus struct {
	InternetStatus *InternetStatusEvent `protobuf:"bytes,1,opt,name=internetStatus,proto3,oneof"`
}

type AppEvent_ToggleAutostartFinished struct {
	ToggleAutostartFinished *ToggleAutostartFinishedEvent `protobuf:"bytes,2,opt,name=toggleAutostartFinished,proto3,oneof"`
}

type AppEvent_ResetFinished struct {
	ResetFinished *ResetFinishedEvent `protobuf:"bytes,3,opt,name=resetFinished,proto3,oneof"`
}

type AppEvent_ReportBugFinished struct {
	ReportBugFinished *ReportBugFinishedEvent `protobuf:"bytes,4,opt,name=reportBugFinished,proto3,oneof"`
}

type AppEvent_ReportBugSuccess struct {
	ReportBugSuccess *ReportBugSuccessEvent `protobuf:"bytes,5,opt,name=reportBugSuccess,proto3,oneof"`
}

type AppEvent_ReportBugError struct {
	ReportBugError *ReportBugErrorEvent `protobuf:"bytes,6,opt,name=reportBugError,proto3,oneof"`
}

type AppEvent_ShowMainWindow struct {
	ShowMainWindow *ShowMainWindowEvent `protobuf:"bytes,7,opt,name=showMainWindow,proto3,oneof"`
}

type AppEvent_ReportBugFallback struct {
	ReportBugFallback *ReportBugFallbackEvent `protobuf:"bytes,8,opt,name=reportBugFallback,proto3,oneof"`
}

type AppEvent_CertificateInstallSuccess struct {
	CertificateInstallSuccess *CertificateInstallSuccessEvent `protobuf:"bytes,9,opt,name=certificateInstallSuccess,proto3,oneof"`
}

type AppEvent_CertificateInstallCanceled struct {
	CertificateInstallCanceled *CertificateInstallCanceledEvent `protobuf:"bytes,10,opt,name=certificateInstallCanceled,proto3,oneof"`
}

type AppEvent_CertificateInstallFailed struct {
	CertificateInstallFailed *CertificateInstallFailedEvent `protobuf:"bytes,11,opt,name=certificateInstallFailed,proto3,oneof"`
}

type AppEvent_KnowledgeBaseSuggestions struct {
	KnowledgeBaseSuggestions *KnowledgeBaseSuggestionsEvent `protobuf:"bytes,12,opt,name=knowledgeBaseSuggestions,proto3,oneof"`
}

type AppEvent_RepairStarted struct {
	RepairStarted *RepairStartedEvent `protobuf:"bytes,13,opt,name=repairStarted,proto3,oneof"`
}

type AppEvent_AllUsersLoaded struct {
	AllUsersLoaded *AllUsersLoadedEvent `protobuf:"bytes,14,opt,name=allUsersLoaded,proto3,oneof"`
}

type AppEvent_UserNotification struct {
	UserNotification *UserNotificationEvent `protobuf:"bytes,15,opt,name=userNotification,proto3,oneof"`
}

func (*AppEvent_InternetStatus) isAppEvent_Event() {}

func (*AppEvent_ToggleAutostartFinished) isAppEvent_Event() {}

func (*AppEvent_ResetFinished) isAppEvent_Event() {}

func (*AppEvent_ReportBugFinished) isAppEvent_Event() {}

func (*AppEvent_ReportBugSuccess) isAppEvent_Event() {}

func (*AppEvent_ReportBugError) isAppEvent_Event() {}

func (*AppEvent_ShowMainWindow) isAppEvent_Event() {}

func (*AppEvent_ReportBugFallback) isAppEvent_Event() {}

func (*AppEvent_CertificateInstallSuccess) isAppEvent_Event() {}

func (*AppEvent_CertificateInstallCanceled) isAppEvent_Event() {}

func (*AppEvent_CertificateInstallFailed) isAppEvent_Event() {}

func (*AppEvent_KnowledgeBaseSuggestions) isAppEvent_Event() {}

func (*AppEvent_RepairStarted) isAppEvent_Event() {}

func (*AppEvent_AllUsersLoaded) isAppEvent_Event() {}

func (*AppEvent_UserNotification) isAppEvent_Event() {}

type InternetStatusEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Connected bool `protobuf:"varint,1,opt,name=connected,proto3" json:"connected,omitempty"`
}

func (x *InternetStatusEvent) Reset() {
	*x = InternetStatusEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InternetStatusEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InternetStatusEvent) ProtoMessage() {}

func (x *InternetStatusEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InternetStatusEvent.ProtoReflect.Descriptor instead.
func (*InternetStatusEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{15}
}

func (x *InternetStatusEvent) GetConnected() bool {
	if x != nil {
		return x.Connected
	}
	return false
}

type ToggleAutostartFinishedEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ToggleAutostartFinishedEvent) Reset() {
	*x = ToggleAutostartFinishedEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ToggleAutostartFinishedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToggleAutostartFinishedEvent) ProtoMessage() {}

func (x *ToggleAutostartFinishedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToggleAutostartFinishedEvent.ProtoReflect.Descriptor instead.
func (*ToggleAutostartFinishedEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{16}
}

type ResetFinishedEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ResetFinishedEvent) Reset() {
	*x = ResetFinishedEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResetFinishedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResetFinishedEvent) ProtoMessage() {}

func (x *ResetFinishedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResetFinishedEvent.ProtoReflect.Descriptor instead.
func (*ResetFinishedEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{17}
}

type ReportBugFinishedEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ReportBugFinishedEvent) Reset() {
	*x = ReportBugFinishedEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportBugFinishedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportBugFinishedEvent) ProtoMessage() {}

func (x *ReportBugFinishedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportBugFinishedEvent.ProtoReflect.Descriptor instead.
func (*ReportBugFinishedEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{18}
}

type ReportBugSuccessEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ReportBugSuccessEvent) Reset() {
	*x = ReportBugSuccessEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportBugSuccessEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportBugSuccessEvent) ProtoMessage() {}

func (x *ReportBugSuccessEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportBugSuccessEvent.ProtoReflect.Descriptor instead.
func (*ReportBugSuccessEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{19}
}

type ReportBugErrorEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ReportBugErrorEvent) Reset() {
	*x = ReportBugErrorEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportBugErrorEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportBugErrorEvent) ProtoMessage() {}

func (x *ReportBugErrorEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportBugErrorEvent.ProtoReflect.Descriptor instead.
func (*ReportBugErrorEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{20}
}

type ShowMainWindowEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ShowMainWindowEvent) Reset() {
	*x = ShowMainWindowEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShowMainWindowEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShowMainWindowEvent) ProtoMessage() {}

func (x *ShowMainWindowEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShowMainWindowEvent.ProtoReflect.Descriptor instead.
func (*ShowMainWindowEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{21}
}

type ReportBugFallbackEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ReportBugFallbackEvent) Reset() {
	*x = ReportBugFallbackEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportBugFallbackEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportBugFallbackEvent) ProtoMessage() {}

func (x *ReportBugFallbackEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportBugFallbackEvent.ProtoReflect.Descriptor instead.
func (*ReportBugFallbackEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{22}
}

type CertificateInstallSuccessEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CertificateInstallSuccessEvent) Reset() {
	*x = CertificateInstallSuccessEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificateInstallSuccessEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateInstallSuccessEvent) ProtoMessage() {}

func (x *CertificateInstallSuccessEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateInstallSuccessEvent.ProtoReflect.Descriptor instead.
func (*CertificateInstallSuccessEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{23}
}

type CertificateInstallCanceledEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CertificateInstallCanceledEvent) Reset() {
	*x = CertificateInstallCanceledEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificateInstallCanceledEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateInstallCanceledEvent) ProtoMessage() {}

func (x *CertificateInstallCanceledEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateInstallCanceledEvent.ProtoReflect.Descriptor instead.
func (*CertificateInstallCanceledEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{24}
}

type CertificateInstallFailedEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CertificateInstallFailedEvent) Reset() {
	*x = CertificateInstallFailedEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificateInstallFailedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateInstallFailedEvent) ProtoMessage() {}

func (x *CertificateInstallFailedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateInstallFailedEvent.ProtoReflect.Descriptor instead.
func (*CertificateInstallFailedEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{25}
}

type RepairStartedEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RepairStartedEvent) Reset() {
	*x = RepairStartedEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RepairStartedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RepairStartedEvent) ProtoMessage() {}

func (x *RepairStartedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RepairStartedEvent.ProtoReflect.Descriptor instead.
func (*RepairStartedEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{26}
}

type AllUsersLoadedEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AllUsersLoadedEvent) Reset() {
	*x = AllUsersLoadedEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AllUsersLoadedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllUsersLoadedEvent) ProtoMessage() {}

func (x *AllUsersLoadedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllUsersLoadedEvent.ProtoReflect.Descriptor instead.
func (*AllUsersLoadedEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{27}
}

type KnowledgeBaseSuggestion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Url   string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	Title string `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
}

func (x *KnowledgeBaseSuggestion) Reset() {
	*x = KnowledgeBaseSuggestion{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KnowledgeBaseSuggestion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KnowledgeBaseSuggestion) ProtoMessage() {}

func (x *KnowledgeBaseSuggestion) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KnowledgeBaseSuggestion.ProtoReflect.Descriptor instead.
func (*KnowledgeBaseSuggestion) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{28}
}

func (x *KnowledgeBaseSuggestion) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *KnowledgeBaseSuggestion) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

type KnowledgeBaseSuggestionsEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Suggestions []*KnowledgeBaseSuggestion `protobuf:"bytes,1,rep,name=suggestions,proto3" json:"suggestions,omitempty"`
}

func (x *KnowledgeBaseSuggestionsEvent) Reset() {
	*x = KnowledgeBaseSuggestionsEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KnowledgeBaseSuggestionsEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KnowledgeBaseSuggestionsEvent) ProtoMessage() {}

func (x *KnowledgeBaseSuggestionsEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KnowledgeBaseSuggestionsEvent.ProtoReflect.Descriptor instead.
func (*KnowledgeBaseSuggestionsEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{29}
}

func (x *KnowledgeBaseSuggestionsEvent) GetSuggestions() []*KnowledgeBaseSuggestion {
	if x != nil {
		return x.Suggestions
	}
	return nil
}

// **********************************************************
// Login related events
// **********************************************************
type LoginEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Event:
	//
	//	*LoginEvent_Error
	//	*LoginEvent_TfaRequested
	//	*LoginEvent_TwoPasswordRequested
	//	*LoginEvent_Finished
	//	*LoginEvent_AlreadyLoggedIn
	//	*LoginEvent_HvRequested
	Event isLoginEvent_Event `protobuf_oneof:"event"`
}

func (x *LoginEvent) Reset() {
	*x = LoginEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoginEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoginEvent) ProtoMessage() {}

func (x *LoginEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoginEvent.ProtoReflect.Descriptor instead.
func (*LoginEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{30}
}

func (m *LoginEvent) GetEvent() isLoginEvent_Event {
	if m != nil {
		return m.Event
	}
	return nil
}

func (x *LoginEvent) GetError() *LoginErrorEvent {
	if x, ok := x.GetEvent().(*LoginEvent_Error); ok {
		return x.Error
	}
	return nil
}

func (x *LoginEvent) GetTfaRequested() *LoginTfaRequestedEvent {
	if x, ok := x.GetEvent().(*LoginEvent_TfaRequested); ok {
		return x.TfaRequested
	}
	return nil
}

func (x *LoginEvent) GetTwoPasswordRequested() *LoginTwoPasswordsRequestedEvent {
	if x, ok := x.GetEvent().(*LoginEvent_TwoPasswordRequested); ok {
		return x.TwoPasswordRequested
	}
	return nil
}

func (x *LoginEvent) GetFinished() *LoginFinishedEvent {
	if x, ok := x.GetEvent().(*LoginEvent_Finished); ok {
		return x.Finished
	}
	return nil
}

func (x *LoginEvent) GetAlreadyLoggedIn() *LoginFinishedEvent {
	if x, ok := x.GetEvent().(*LoginEvent_AlreadyLoggedIn); ok {
		return x.AlreadyLoggedIn
	}
	return nil
}

func (x *LoginEvent) GetHvRequested() *LoginHvRequestedEvent {
	if x, ok := x.GetEvent().(*LoginEvent_HvRequested); ok {
		return x.HvRequested
	}
	return nil
}

type isLoginEvent_Event interface {
	isLoginEvent_Event()
}

type LoginEvent_Error struct {
	Error *LoginErrorEvent `protobuf:"bytes,1,opt,name=error,proto3,oneof"`
}

type LoginEvent_TfaRequested struct {
	TfaRequested *LoginTfaRequestedEvent `protobuf:"bytes,2,opt,name=tfaRequested,proto3,oneof"`
}

type LoginEvent_TwoPasswordRequested struct {
	TwoPasswordRequested *LoginTwoPasswordsRequestedEvent `protobuf:"bytes,3,opt,name=twoPasswordRequested,proto3,oneof"`
}

type LoginEvent_Finished struct {
	Finished *LoginFinishedEvent `protobuf:"bytes,4,opt,name=finished,proto3,oneof"`
}

type LoginEvent_AlreadyLoggedIn struct {
	AlreadyLoggedIn *LoginFinishedEvent `protobuf:"bytes,5,opt,name=alreadyLoggedIn,proto3,oneof"`
}

type LoginEvent_HvRequested struct {
	HvRequested *LoginHvRequestedEvent `protobuf:"bytes,6,opt,name=hvRequested,proto3,oneof"`
}

func (*LoginEvent_Error) isLoginEvent_Event() {}

func (*LoginEvent_TfaRequested) isLoginEvent_Event() {}

func (*LoginEvent_TwoPasswordRequested) isLoginEvent_Event() {}

func (*LoginEvent_Finished) isLoginEvent_Event() {}

func (*LoginEvent_AlreadyLoggedIn) isLoginEvent_Event() {}

func (*LoginEvent_HvRequested) isLoginEvent_Event() {}

type LoginErrorEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type    LoginErrorType `protobuf:"varint,1,opt,name=type,proto3,enum=grpc.LoginErrorType" json:"type,omitempty"`
	Message string         `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
}

func (x *LoginErrorEvent) Reset() {
	*x = LoginErrorEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoginErrorEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoginErrorEvent) ProtoMessage() {}

func (x *LoginErrorEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoginErrorEvent.ProtoReflect.Descriptor instead.
func (*LoginErrorEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{31}
}

func (x *LoginErrorEvent) GetType() LoginErrorType {
	if x != nil {
		return x.Type
	}
	return LoginErrorType_USERNAME_PASSWORD_ERROR
}

func (x *LoginErrorEvent) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

type LoginTfaRequestedEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Username string `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
}

func (x *LoginTfaRequestedEvent) Reset() {
	*x = LoginTfaRequestedEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoginTfaRequestedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoginTfaRequestedEvent) ProtoMessage() {}

func (x *LoginTfaRequestedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoginTfaRequestedEvent.ProtoReflect.Descriptor instead.
func (*LoginTfaRequestedEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{32}
}

func (x *LoginTfaRequestedEvent) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

type LoginTwoPasswordsRequestedEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Username string `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
}

func (x *LoginTwoPasswordsRequestedEvent) Reset() {
	*x = LoginTwoPasswordsRequestedEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoginTwoPasswordsRequestedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoginTwoPasswordsRequestedEvent) ProtoMessage() {}

func (x *LoginTwoPasswordsRequestedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoginTwoPasswordsRequestedEvent.ProtoReflect.Descriptor instead.
func (*LoginTwoPasswordsRequestedEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{33}
}

func (x *LoginTwoPasswordsRequestedEvent) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

type LoginFinishedEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	UserID       string `protobuf:"bytes,1,opt,name=userID,proto3" json:"userID,omitempty"`
	WasSignedOut bool   `protobuf:"varint,2,opt,name=wasSignedOut,proto3" json:"wasSignedOut,omitempty"`
}

func (x *LoginFinishedEvent) Reset() {
	*x = LoginFinishedEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoginFinishedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoginFinishedEvent) ProtoMessage() {}

func (x *LoginFinishedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoginFinishedEvent.ProtoReflect.Descriptor instead.
func (*LoginFinishedEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{34}
}

func (x *LoginFinishedEvent) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

func (x *LoginFinishedEvent) GetWasSignedOut() bool {
	if x != nil {
		return x.WasSignedOut
	}
	return false
}

type LoginHvRequestedEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	HvUrl string `protobuf:"bytes,1,opt,name=hvUrl,proto3" json:"hvUrl,omitempty"`
}

func (x *LoginHvRequestedEvent) Reset() {
	*x = LoginHvRequestedEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoginHvRequestedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoginHvRequestedEvent) ProtoMessage() {}

func (x *LoginHvRequestedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoginHvRequestedEvent.ProtoReflect.Descriptor instead.
func (*LoginHvRequestedEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{35}
}

func (x *LoginHvRequestedEvent) GetHvUrl() string {
	if x != nil {
		return x.HvUrl
	}
	return ""
}

// **********************************************************
// Update related events
// **********************************************************
type UpdateEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Event:
	//
	//	*UpdateEvent_Error
	//	*UpdateEvent_ManualReady
	//	*UpdateEvent_ManualRestartNeeded
	//	*UpdateEvent_Force
	//	*UpdateEvent_SilentRestartNeeded
	//	*UpdateEvent_IsLatestVersion
	//	*UpdateEvent_CheckFinished
	//	*UpdateEvent_VersionChanged
	Event isUpdateEvent_Event `protobuf_oneof:"event"`
}

func (x *UpdateEvent) Reset() {
	*x = UpdateEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateEvent) ProtoMessage() {}

func (x *UpdateEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateEvent.ProtoReflect.Descriptor instead.
func (*UpdateEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{36}
}

func (m *UpdateEvent) GetEvent() isUpdateEvent_Event {
	if m != nil {
		return m.Event
	}
	return nil
}

func (x *UpdateEvent) GetError() *UpdateErrorEvent {
	if x, ok := x.GetEvent().(*UpdateEvent_Error); ok {
		return x.Error
	}
	return nil
}

func (x *UpdateEvent) GetManualReady() *UpdateManualReadyEvent {
	if x, ok := x.GetEvent().(*UpdateEvent_ManualReady); ok {
		return x.ManualReady
	}
	return nil
}

func (x *UpdateEvent) GetManualRestartNeeded() *UpdateManualRestartNeededEvent {
	if x, ok := x.GetEvent().(*UpdateEvent_ManualRestartNeeded); ok {
		return x.ManualRestartNeeded
	}
	return nil
}

func (x *UpdateEvent) GetForce() *UpdateForceEvent {
	if x, ok := x.GetEvent().(*UpdateEvent_Force); ok {
		return x.Force
	}
	return nil
}

func (x *UpdateEvent) GetSilentRestartNeeded() *UpdateSilentRestartNeeded {
	if x, ok := x.GetEvent().(*UpdateEvent_SilentRestartNeeded); ok {
		return x.SilentRestartNeeded
	}
	return nil
}

func (x *UpdateEvent) GetIsLatestVersion() *UpdateIsLatestVersion {
	if x, ok := x.GetEvent().(*UpdateEvent_IsLatestVersion); ok {
		return x.IsLatestVersion
	}
	return nil
}

func (x *UpdateEvent) GetCheckFinished() *UpdateCheckFinished {
	if x, ok := x.GetEvent().(*UpdateEvent_CheckFinished); ok {
		return x.CheckFinished
	}
	return nil
}

func (x *UpdateEvent) GetVersionChanged() *UpdateVersionChanged {
	if x, ok := x.GetEvent().(*UpdateEvent_VersionChanged); ok {
		return x.VersionChanged
	}
	return nil
}

type isUpdateEvent_Event interface {
	isUpdateEvent_Event()
}

type UpdateEvent_Error struct {
	Error *UpdateErrorEvent `protobuf:"bytes,1,opt,name=error,proto3,oneof"`
}

type UpdateEvent_ManualReady struct {
	ManualReady *UpdateManualReadyEvent `protobuf:"bytes,2,opt,name=manualReady,proto3,oneof"`
}

type UpdateEvent_ManualRestartNeeded struct {
	ManualRestartNeeded *UpdateManualRestartNeededEvent `protobuf:"bytes,3,opt,name=manualRestartNeeded,proto3,oneof"`
}

type UpdateEvent_Force struct {
	Force *UpdateForceEvent `protobuf:"bytes,4,opt,name=force,proto3,oneof"`
}

type UpdateEvent_SilentRestartNeeded struct {
	SilentRestartNeeded *UpdateSilentRestartNeeded `protobuf:"bytes,5,opt,name=silentRestartNeeded,proto3,oneof"`
}

type UpdateEvent_IsLatestVersion struct {
	IsLatestVersion *UpdateIsLatestVersion `protobuf:"bytes,6,opt,name=isLatestVersion,proto3,oneof"`
}

type UpdateEvent_CheckFinished struct {
	CheckFinished *UpdateCheckFinished `protobuf:"bytes,7,opt,name=checkFinished,proto3,oneof"`
}

type UpdateEvent_VersionChanged struct {
	VersionChanged *UpdateVersionChanged `protobuf:"bytes,8,opt,name=versionChanged,proto3,oneof"`
}

func (*UpdateEvent_Error) isUpdateEvent_Event() {}

func (*UpdateEvent_ManualReady) isUpdateEvent_Event() {}

func (*UpdateEvent_ManualRestartNeeded) isUpdateEvent_Event() {}

func (*UpdateEvent_Force) isUpdateEvent_Event() {}

func (*UpdateEvent_SilentRestartNeeded) isUpdateEvent_Event() {}

func (*UpdateEvent_IsLatestVersion) isUpdateEvent_Event() {}

func (*UpdateEvent_CheckFinished) isUpdateEvent_Event() {}

func (*UpdateEvent_VersionChanged) isUpdateEvent_Event() {}

type UpdateErrorEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type UpdateErrorType `protobuf:"varint,1,opt,name=type,proto3,enum=grpc.UpdateErrorType" json:"type,omitempty"`
}

func (x *UpdateErrorEvent) Reset() {
	*x = UpdateErrorEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateErrorEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateErrorEvent) ProtoMessage() {}

func (x *UpdateErrorEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateErrorEvent.ProtoReflect.Descriptor instead.
func (*UpdateErrorEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{37}
}

func (x *UpdateErrorEvent) GetType() UpdateErrorType {
	if x != nil {
		return x.Type
	}
	return UpdateErrorType_UPDATE_MANUAL_ERROR
}

type UpdateManualReadyEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *UpdateManualReadyEvent) Reset() {
	*x = UpdateManualReadyEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateManualReadyEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateManualReadyEvent) ProtoMessage() {}

func (x *UpdateManualReadyEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateManualReadyEvent.ProtoReflect.Descriptor instead.
func (*UpdateManualReadyEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{38}
}

func (x *UpdateManualReadyEvent) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

type UpdateManualRestartNeededEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *UpdateManualRestartNeededEvent) Reset() {
	*x = UpdateManualRestartNeededEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateManualRestartNeededEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateManualRestartNeededEvent) ProtoMessage() {}

func (x *UpdateManualRestartNeededEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateManualRestartNeededEvent.ProtoReflect.Descriptor instead.
func (*UpdateManualRestartNeededEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{39}
}

type UpdateForceEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *UpdateForceEvent) Reset() {
	*x = UpdateForceEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateForceEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateForceEvent) ProtoMessage() {}

func (x *UpdateForceEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateForceEvent.ProtoReflect.Descriptor instead.
func (*UpdateForceEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{40}
}

func (x *UpdateForceEvent) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

type UpdateSilentRestartNeeded struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *UpdateSilentRestartNeeded) Reset() {
	*x = UpdateSilentRestartNeeded{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateSilentRestartNeeded) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSilentRestartNeeded) ProtoMessage() {}

func (x *UpdateSilentRestartNeeded) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSilentRestartNeeded.ProtoReflect.Descriptor instead.
func (*UpdateSilentRestartNeeded) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{41}
}

type UpdateIsLatestVersion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *UpdateIsLatestVersion) Reset() {
	*x = UpdateIsLatestVersion{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateIsLatestVersion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateIsLatestVersion) ProtoMessage() {}

func (x *UpdateIsLatestVersion) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateIsLatestVersion.ProtoReflect.Descriptor instead.
func (*UpdateIsLatestVersion) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{42}
}

type UpdateCheckFinished struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *UpdateCheckFinished) Reset() {
	*x = UpdateCheckFinished{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateCheckFinished) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateCheckFinished) ProtoMessage() {}

func (x *UpdateCheckFinished) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateCheckFinished.ProtoReflect.Descriptor instead.
func (*UpdateCheckFinished) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{43}
}

type UpdateVersionChanged struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *UpdateVersionChanged) Reset() {
	*x = UpdateVersionChanged{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateVersionChanged) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateVersionChanged) ProtoMessage() {}

func (x *UpdateVersionChanged) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateVersionChanged.ProtoReflect.Descriptor instead.
func (*UpdateVersionChanged) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{44}
}

// **********************************************************
// Cache on disk related events
// **********************************************************
type DiskCacheEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Event:
	//
	//	*DiskCacheEvent_Error
	//	*DiskCacheEvent_PathChanged
	//	*DiskCacheEvent_PathChangeFinished
	Event isDiskCacheEvent_Event `protobuf_oneof:"event"`
}

func (x *DiskCacheEvent) Reset() {
	*x = DiskCacheEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiskCacheEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiskCacheEvent) ProtoMessage() {}

func (x *DiskCacheEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiskCacheEvent.ProtoReflect.Descriptor instead.
func (*DiskCacheEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{45}
}

func (m *DiskCacheEvent) GetEvent() isDiskCacheEvent_Event {
	if m != nil {
		return m.Event
	}
	return nil
}

func (x *DiskCacheEvent) GetError() *DiskCacheErrorEvent {
	if x, ok := x.GetEvent().(*DiskCacheEvent_Error); ok {
		return x.Error
	}
	return nil
}

func (x *DiskCacheEvent) GetPathChanged() *DiskCachePathChangedEvent {
	if x, ok := x.GetEvent().(*DiskCacheEvent_PathChanged); ok {
		return x.PathChanged
	}
	return nil
}

func (x *DiskCacheEvent) GetPathChangeFinished() *DiskCachePathChangeFinishedEvent {
	if x, ok := x.GetEvent().(*DiskCacheEvent_PathChangeFinished); ok {
		return x.PathChangeFinished
	}
	return nil
}

type isDiskCacheEvent_Event interface {
	isDiskCacheEvent_Event()
}

type DiskCacheEvent_Error struct {
	Error *DiskCacheErrorEvent `protobuf:"bytes,1,opt,name=error,proto3,oneof"`
}

type DiskCacheEvent_PathChanged struct {
	PathChanged *DiskCachePathChangedEvent `protobuf:"bytes,2,opt,name=pathChanged,proto3,oneof"`
}

type DiskCacheEvent_PathChangeFinished struct {
	PathChangeFinished *DiskCachePathChangeFinishedEvent `protobuf:"bytes,3,opt,name=pathChangeFinished,proto3,oneof"`
}

func (*DiskCacheEvent_Error) isDiskCacheEvent_Event() {}

func (*DiskCacheEvent_PathChanged) isDiskCacheEvent_Event() {}

func (*DiskCacheEvent_PathChangeFinished) isDiskCacheEvent_Event() {}

type DiskCacheErrorEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type DiskCacheErrorType `protobuf:"varint,1,opt,name=type,proto3,enum=grpc.DiskCacheErrorType" json:"type,omitempty"`
}

func (x *DiskCacheErrorEvent) Reset() {
	*x = DiskCacheErrorEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiskCacheErrorEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiskCacheErrorEvent) ProtoMessage() {}

func (x *DiskCacheErrorEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiskCacheErrorEvent.ProtoReflect.Descriptor instead.
func (*DiskCacheErrorEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{46}
}

func (x *DiskCacheErrorEvent) GetType() DiskCacheErrorType {
	if x != nil {
		return x.Type
	}
	return DiskCacheErrorType_CANT_MOVE_DISK_CACHE_ERROR
}

type DiskCachePathChangedEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
}

func (x *DiskCachePathChangedEvent) Reset() {
	*x = DiskCachePathChangedEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiskCachePathChangedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiskCachePathChangedEvent) ProtoMessage() {}

func (x *DiskCachePathChangedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiskCachePathChangedEvent.ProtoReflect.Descriptor instead.
func (*DiskCachePathChangedEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{47}
}

func (x *DiskCachePathChangedEvent) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

type DiskCachePathChangeFinishedEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DiskCachePathChangeFinishedEvent) Reset() {
	*x = DiskCachePathChangeFinishedEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiskCachePathChangeFinishedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiskCachePathChangeFinishedEvent) ProtoMessage() {}

func (x *DiskCachePathChangeFinishedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiskCachePathChangeFinishedEvent.ProtoReflect.Descriptor instead.
func (*DiskCachePathChangeFinishedEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{48}
}

// **********************************************************
// Mail server settings related events
// **********************************************************
type MailServerSettingsEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Event:
	//
	//	*MailServerSettingsEvent_Error
	//	*MailServerSettingsEvent_MailServerSettingsChanged
	//	*MailServerSettingsEvent_ChangeMailServerSettingsFinished
	Event isMailServerSettingsEvent_Event `protobuf_oneof:"event"`
}

func (x *MailServerSettingsEvent) Reset() {
	*x = MailServerSettingsEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MailServerSettingsEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MailServerSettingsEvent) ProtoMessage() {}

func (x *MailServerSettingsEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MailServerSettingsEvent.ProtoReflect.Descriptor instead.
func (*MailServerSettingsEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{49}
}

func (m *MailServerSettingsEvent) GetEvent() isMailServerSettingsEvent_Event {
	if m != nil {
		return m.Event
	}
	return nil
}

func (x *MailServerSettingsEvent) GetError() *MailServerSettingsErrorEvent {
	if x, ok := x.GetEvent().(*MailServerSettingsEvent_Error); ok {
		return x.Error
	}
	return nil
}

func (x *MailServerSettingsEvent) GetMailServerSettingsChanged() *MailServerSettingsChangedEvent {
	if x, ok := x.GetEvent().(*MailServerSettingsEvent_MailServerSettingsChanged); ok {
		return x.MailServerSettingsChanged
	}
	return nil
}

func (x *MailServerSettingsEvent) GetChangeMailServerSettingsFinished() *ChangeMailServerSettingsFinishedEvent {
	if x, ok := x.GetEvent().(*MailServerSettingsEvent_ChangeMailServerSettingsFinished); ok {
		return x.ChangeMailServerSettingsFinished
	}
	return nil
}

type isMailServerSettingsEvent_Event interface {
	isMailServerSettingsEvent_Event()
}

type MailServerSettingsEvent_Error struct {
	Error *MailServerSettingsErrorEvent `protobuf:"bytes,1,opt,name=error,proto3,oneof"`
}

type MailServerSettingsEvent_MailServerSettingsChanged struct {
	MailServerSettingsChanged *MailServerSettingsChangedEvent `protobuf:"bytes,2,opt,name=mailServerSettingsChanged,proto3,oneof"`
}

type MailServerSettingsEvent_ChangeMailServerSettingsFinished struct {
	ChangeMailServerSettingsFinished *ChangeMailServerSettingsFinishedEvent `protobuf:"bytes,3,opt,name=changeMailServerSettingsFinished,proto3,oneof"`
}

func (*MailServerSettingsEvent_Error) isMailServerSettingsEvent_Event() {}

func (*MailServerSettingsEvent_MailServerSettingsChanged) isMailServerSettingsEvent_Event() {}

func (*MailServerSettingsEvent_ChangeMailServerSettingsFinished) isMailServerSettingsEvent_Event() {}

type MailServerSettingsErrorEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type MailServerSettingsErrorType `protobuf:"varint,1,opt,name=type,proto3,enum=grpc.MailServerSettingsErrorType" json:"type,omitempty"`
}

func (x *MailServerSettingsErrorEvent) Reset() {
	*x = MailServerSettingsErrorEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MailServerSettingsErrorEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MailServerSettingsErrorEvent) ProtoMessage() {}

func (x *MailServerSettingsErrorEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MailServerSettingsErrorEvent.ProtoReflect.Descriptor instead.
func (*MailServerSettingsErrorEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{50}
}

func (x *MailServerSettingsErrorEvent) GetType() MailServerSettingsErrorType {
	if x != nil {
		return x.Type
	}
	return MailServerSettingsErrorType_IMAP_PORT_STARTUP_ERROR
}

type MailServerSettingsChangedEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Settings *ImapSmtpSettings `protobuf:"bytes,1,opt,name=settings,proto3" json:"settings,omitempty"`
}

func (x *MailServerSettingsChangedEvent) Reset() {
	*x = MailServerSettingsChangedEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MailServerSettingsChangedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MailServerSettingsChangedEvent) ProtoMessage() {}

func (x *MailServerSettingsChangedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MailServerSettingsChangedEvent.ProtoReflect.Descriptor instead.
func (*MailServerSettingsChangedEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{51}
}

func (x *MailServerSettingsChangedEvent) GetSettings() *ImapSmtpSettings {
	if x != nil {
		return x.Settings
	}
	return nil
}

type ChangeMailServerSettingsFinishedEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ChangeMailServerSettingsFinishedEvent) Reset() {
	*x = ChangeMailServerSettingsFinishedEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChangeMailServerSettingsFinishedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChangeMailServerSettingsFinishedEvent) ProtoMessage() {}

func (x *ChangeMailServerSettingsFinishedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChangeMailServerSettingsFinishedEvent.ProtoReflect.Descriptor instead.
func (*ChangeMailServerSettingsFinishedEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{52}
}

// **********************************************************
// keychain related events
// **********************************************************
type KeychainEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Event:
	//
	//	*KeychainEvent_ChangeKeychainFinished
	//	*KeychainEvent_HasNoKeychain
	//	*KeychainEvent_RebuildKeychain
	Event isKeychainEvent_Event `protobuf_oneof:"event"`
}

func (x *KeychainEvent) Reset() {
	*x = KeychainEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KeychainEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeychainEvent) ProtoMessage() {}

func (x *KeychainEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeychainEvent.ProtoReflect.Descriptor instead.
func (*KeychainEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{53}
}

func (m *KeychainEvent) GetEvent() isKeychainEvent_Event {
	if m != nil {
		return m.Event
	}
	return nil
}

func (x *KeychainEvent) GetChangeKeychainFinished() *ChangeKeychainFinishedEvent {
	if x, ok := x.GetEvent().(*KeychainEvent_ChangeKeychainFinished); ok {
		return x.ChangeKeychainFinished
	}
	return nil
}

func (x *KeychainEvent) GetHasNoKeychain() *HasNoKeychainEvent {
	if x, ok := x.GetEvent().(*KeychainEvent_HasNoKeychain); ok {
		return x.HasNoKeychain
	}
	return nil
}

func (x *KeychainEvent) GetRebuildKeychain() *RebuildKeychainEvent {
	if x, ok := x.GetEvent().(*KeychainEvent_RebuildKeychain); ok {
		return x.RebuildKeychain
	}
	return nil
}

type isKeychainEvent_Event interface {
	isKeychainEvent_Event()
}

type KeychainEvent_ChangeKeychainFinished struct {
	ChangeKeychainFinished *ChangeKeychainFinishedEvent `protobuf:"bytes,1,opt,name=changeKeychainFinished,proto3,oneof"`
}

type KeychainEvent_HasNoKeychain struct {
	HasNoKeychain *HasNoKeychainEvent `protobuf:"bytes,2,opt,name=hasNoKeychain,proto3,oneof"`
}

type KeychainEvent_RebuildKeychain struct {
	RebuildKeychain *RebuildKeychainEvent `protobuf:"bytes,3,opt,name=rebuildKeychain,proto3,oneof"`
}

func (*KeychainEvent_ChangeKeychainFinished) isKeychainEvent_Event() {}

func (*KeychainEvent_HasNoKeychain) isKeychainEvent_Event() {}

func (*KeychainEvent_RebuildKeychain) isKeychainEvent_Event() {}

type ChangeKeychainFinishedEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ChangeKeychainFinishedEvent) Reset() {
	*x = ChangeKeychainFinishedEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChangeKeychainFinishedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChangeKeychainFinishedEvent) ProtoMessage() {}

func (x *ChangeKeychainFinishedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChangeKeychainFinishedEvent.ProtoReflect.Descriptor instead.
func (*ChangeKeychainFinishedEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{54}
}

type HasNoKeychainEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *HasNoKeychainEvent) Reset() {
	*x = HasNoKeychainEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HasNoKeychainEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HasNoKeychainEvent) ProtoMessage() {}

func (x *HasNoKeychainEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HasNoKeychainEvent.ProtoReflect.Descriptor instead.
func (*HasNoKeychainEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{55}
}

type RebuildKeychainEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RebuildKeychainEvent) Reset() {
	*x = RebuildKeychainEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RebuildKeychainEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RebuildKeychainEvent) ProtoMessage() {}

func (x *RebuildKeychainEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RebuildKeychainEvent.ProtoReflect.Descriptor instead.
func (*RebuildKeychainEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{56}
}

// **********************************************************
// Mail related events
// **********************************************************
type MailEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Event:
	//
	//	*MailEvent_AddressChanged
	//	*MailEvent_AddressChangedLogout
	//	*MailEvent_ApiCertIssue
	Event isMailEvent_Event `protobuf_oneof:"event"`
}

func (x *MailEvent) Reset() {
	*x = MailEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[57]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MailEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MailEvent) ProtoMessage() {}

func (x *MailEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[57]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MailEvent.ProtoReflect.Descriptor instead.
func (*MailEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{57}
}

func (m *MailEvent) GetEvent() isMailEvent_Event {
	if m != nil {
		return m.Event
	}
	return nil
}

func (x *MailEvent) GetAddressChanged() *AddressChangedEvent {
	if x, ok := x.GetEvent().(*MailEvent_AddressChanged); ok {
		return x.AddressChanged
	}
	return nil
}

func (x *MailEvent) GetAddressChangedLogout() *AddressChangedLogoutEvent {
	if x, ok := x.GetEvent().(*MailEvent_AddressChangedLogout); ok {
		return x.AddressChangedLogout
	}
	return nil
}

func (x *MailEvent) GetApiCertIssue() *ApiCertIssueEvent {
	if x, ok := x.GetEvent().(*MailEvent_ApiCertIssue); ok {
		return x.ApiCertIssue
	}
	return nil
}

type isMailEvent_Event interface {
	isMailEvent_Event()
}

type MailEvent_AddressChanged struct {
	AddressChanged *AddressChangedEvent `protobuf:"bytes,1,opt,name=addressChanged,proto3,oneof"`
}

type MailEvent_AddressChangedLogout struct {
	AddressChangedLogout *AddressChangedLogoutEvent `protobuf:"bytes,2,opt,name=addressChangedLogout,proto3,oneof"`
}

type MailEvent_ApiCertIssue struct {
	ApiCertIssue *ApiCertIssueEvent `protobuf:"bytes,3,opt,name=apiCertIssue,proto3,oneof"`
}

func (*MailEvent_AddressChanged) isMailEvent_Event() {}

func (*MailEvent_AddressChangedLogout) isMailEvent_Event() {}

func (*MailEvent_ApiCertIssue) isMailEvent_Event() {}

type AddressChangedEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
}

func (x *AddressChangedEvent) Reset() {
	*x = AddressChangedEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[58]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddressChangedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddressChangedEvent) ProtoMessage() {}

func (x *AddressChangedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[58]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddressChangedEvent.ProtoReflect.Descriptor instead.
func (*AddressChangedEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{58}
}

func (x *AddressChangedEvent) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

type AddressChangedLogoutEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
}

func (x *AddressChangedLogoutEvent) Reset() {
	*x = AddressChangedLogoutEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[59]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddressChangedLogoutEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddressChangedLogoutEvent) ProtoMessage() {}

func (x *AddressChangedLogoutEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[59]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddressChangedLogoutEvent.ProtoReflect.Descriptor instead.
func (*AddressChangedLogoutEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{59}
}

func (x *AddressChangedLogoutEvent) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

type ApiCertIssueEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ApiCertIssueEvent) Reset() {
	*x = ApiCertIssueEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[60]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApiCertIssueEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApiCertIssueEvent) ProtoMessage() {}

func (x *ApiCertIssueEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[60]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApiCertIssueEvent.ProtoReflect.Descriptor instead.
func (*ApiCertIssueEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{60}
}

type UserEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Event:
	//
	//	*UserEvent_ToggleSplitModeFinished
	//	*UserEvent_UserDisconnected
	//	*UserEvent_UserChanged
	//	*UserEvent_UserBadEvent
	//	*UserEvent_UsedBytesChangedEvent
	//	*UserEvent_ImapLoginFailedEvent
	//	*UserEvent_SyncStartedEvent
	//	*UserEvent_SyncFinishedEvent
	//	*UserEvent_SyncProgressEvent
	Event isUserEvent_Event `protobuf_oneof:"event"`
}

func (x *UserEvent) Reset() {
	*x = UserEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[61]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UserEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserEvent) ProtoMessage() {}

func (x *UserEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[61]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserEvent.ProtoReflect.Descriptor instead.
func (*UserEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{61}
}

func (m *UserEvent) GetEvent() isUserEvent_Event {
	if m != nil {
		return m.Event
	}
	return nil
}

func (x *UserEvent) GetToggleSplitModeFinished() *ToggleSplitModeFinishedEvent {
	if x, ok := x.GetEvent().(*UserEvent_ToggleSplitModeFinished); ok {
		return x.ToggleSplitModeFinished
	}
	return nil
}

func (x *UserEvent) GetUserDisconnected() *UserDisconnectedEvent {
	if x, ok := x.GetEvent().(*UserEvent_UserDisconnected); ok {
		return x.UserDisconnected
	}
	return nil
}

func (x *UserEvent) GetUserChanged() *UserChangedEvent {
	if x, ok := x.GetEvent().(*UserEvent_UserChanged); ok {
		return x.UserChanged
	}
	return nil
}

func (x *UserEvent) GetUserBadEvent() *UserBadEvent {
	if x, ok := x.GetEvent().(*UserEvent_UserBadEvent); ok {
		return x.UserBadEvent
	}
	return nil
}

func (x *UserEvent) GetUsedBytesChangedEvent() *UsedBytesChangedEvent {
	if x, ok := x.GetEvent().(*UserEvent_UsedBytesChangedEvent); ok {
		return x.UsedBytesChangedEvent
	}
	return nil
}

func (x *UserEvent) GetImapLoginFailedEvent() *ImapLoginFailedEvent {
	if x, ok := x.GetEvent().(*UserEvent_ImapLoginFailedEvent); ok {
		return x.ImapLoginFailedEvent
	}
	return nil
}

func (x *UserEvent) GetSyncStartedEvent() *SyncStartedEvent {
	if x, ok := x.GetEvent().(*UserEvent_SyncStartedEvent); ok {
		return x.SyncStartedEvent
	}
	return nil
}

func (x *UserEvent) GetSyncFinishedEvent() *SyncFinishedEvent {
	if x, ok := x.GetEvent().(*UserEvent_SyncFinishedEvent); ok {
		return x.SyncFinishedEvent
	}
	return nil
}

func (x *UserEvent) GetSyncProgressEvent() *SyncProgressEvent {
	if x, ok := x.GetEvent().(*UserEvent_SyncProgressEvent); ok {
		return x.SyncProgressEvent
	}
	return nil
}

type isUserEvent_Event interface {
	isUserEvent_Event()
}

type UserEvent_ToggleSplitModeFinished struct {
	ToggleSplitModeFinished *ToggleSplitModeFinishedEvent `protobuf:"bytes,1,opt,name=toggleSplitModeFinished,proto3,oneof"`
}

type UserEvent_UserDisconnected struct {
	UserDisconnected *UserDisconnectedEvent `protobuf:"bytes,2,opt,name=userDisconnected,proto3,oneof"`
}

type UserEvent_UserChanged struct {
	UserChanged *UserChangedEvent `protobuf:"bytes,3,opt,name=userChanged,proto3,oneof"`
}

type UserEvent_UserBadEvent struct {
	UserBadEvent *UserBadEvent `protobuf:"bytes,4,opt,name=userBadEvent,proto3,oneof"`
}

type UserEvent_UsedBytesChangedEvent struct {
	UsedBytesChangedEvent *UsedBytesChangedEvent `protobuf:"bytes,5,opt,name=usedBytesChangedEvent,proto3,oneof"`
}

type UserEvent_ImapLoginFailedEvent struct {
	ImapLoginFailedEvent *ImapLoginFailedEvent `protobuf:"bytes,6,opt,name=imapLoginFailedEvent,proto3,oneof"`
}

type UserEvent_SyncStartedEvent struct {
	SyncStartedEvent *SyncStartedEvent `protobuf:"bytes,7,opt,name=syncStartedEvent,proto3,oneof"`
}

type UserEvent_SyncFinishedEvent struct {
	SyncFinishedEvent *SyncFinishedEvent `protobuf:"bytes,8,opt,name=syncFinishedEvent,proto3,oneof"`
}

type UserEvent_SyncProgressEvent struct {
	SyncProgressEvent *SyncProgressEvent `protobuf:"bytes,9,opt,name=syncProgressEvent,proto3,oneof"`
}

func (*UserEvent_ToggleSplitModeFinished) isUserEvent_Event() {}

func (*UserEvent_UserDisconnected) isUserEvent_Event() {}

func (*UserEvent_UserChanged) isUserEvent_Event() {}

func (*UserEvent_UserBadEvent) isUserEvent_Event() {}

func (*UserEvent_UsedBytesChangedEvent) isUserEvent_Event() {}

func (*UserEvent_ImapLoginFailedEvent) isUserEvent_Event() {}

func (*UserEvent_SyncStartedEvent) isUserEvent_Event() {}

func (*UserEvent_SyncFinishedEvent) isUserEvent_Event() {}

func (*UserEvent_SyncProgressEvent) isUserEvent_Event() {}

type ToggleSplitModeFinishedEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	UserID string `protobuf:"bytes,1,opt,name=userID,proto3" json:"userID,omitempty"`
}

func (x *ToggleSplitModeFinishedEvent) Reset() {
	*x = ToggleSplitModeFinishedEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[62]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ToggleSplitModeFinishedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToggleSplitModeFinishedEvent) ProtoMessage() {}

func (x *ToggleSplitModeFinishedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[62]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToggleSplitModeFinishedEvent.ProtoReflect.Descriptor instead.
func (*ToggleSplitModeFinishedEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{62}
}

func (x *ToggleSplitModeFinishedEvent) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

type UserDisconnectedEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Username string `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
}

func (x *UserDisconnectedEvent) Reset() {
	*x = UserDisconnectedEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[63]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UserDisconnectedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserDisconnectedEvent) ProtoMessage() {}

func (x *UserDisconnectedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[63]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserDisconnectedEvent.ProtoReflect.Descriptor instead.
func (*UserDisconnectedEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{63}
}

func (x *UserDisconnectedEvent) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

type UserChangedEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	UserID string `protobuf:"bytes,1,opt,name=userID,proto3" json:"userID,omitempty"`
}

func (x *UserChangedEvent) Reset() {
	*x = UserChangedEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[64]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UserChangedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserChangedEvent) ProtoMessage() {}

func (x *UserChangedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[64]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserChangedEvent.ProtoReflect.Descriptor instead.
func (*UserChangedEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{64}
}

func (x *UserChangedEvent) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

type UserBadEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	UserID       string `protobuf:"bytes,1,opt,name=userID,proto3" json:"userID,omitempty"`
	ErrorMessage string `protobuf:"bytes,2,opt,name=errorMessage,proto3" json:"errorMessage,omitempty"`
}

func (x *UserBadEvent) Reset() {
	*x = UserBadEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[65]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UserBadEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserBadEvent) ProtoMessage() {}

func (x *UserBadEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[65]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserBadEvent.ProtoReflect.Descriptor instead.
func (*UserBadEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{65}
}

func (x *UserBadEvent) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

func (x *UserBadEvent) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

type UsedBytesChangedEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	UserID    string `protobuf:"bytes,1,opt,name=userID,proto3" json:"userID,omitempty"`
	UsedBytes int64  `protobuf:"varint,2,opt,name=usedBytes,proto3" json:"usedBytes,omitempty"`
}

func (x *UsedBytesChangedEvent) Reset() {
	*x = UsedBytesChangedEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[66]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UsedBytesChangedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UsedBytesChangedEvent) ProtoMessage() {}

func (x *UsedBytesChangedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[66]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UsedBytesChangedEvent.ProtoReflect.Descriptor instead.
func (*UsedBytesChangedEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{66}
}

func (x *UsedBytesChangedEvent) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

func (x *UsedBytesChangedEvent) GetUsedBytes() int64 {
	if x != nil {
		return x.UsedBytes
	}
	return 0
}

type ImapLoginFailedEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Username string `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
}

func (x *ImapLoginFailedEvent) Reset() {
	*x = ImapLoginFailedEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[67]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImapLoginFailedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImapLoginFailedEvent) ProtoMessage() {}

func (x *ImapLoginFailedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[67]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImapLoginFailedEvent.ProtoReflect.Descriptor instead.
func (*ImapLoginFailedEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{67}
}

func (x *ImapLoginFailedEvent) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

type SyncStartedEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	UserID string `protobuf:"bytes,1,opt,name=userID,proto3" json:"userID,omitempty"`
}

func (x *SyncStartedEvent) Reset() {
	*x = SyncStartedEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[68]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SyncStartedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncStartedEvent) ProtoMessage() {}

func (x *SyncStartedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[68]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyncStartedEvent.ProtoReflect.Descriptor instead.
func (*SyncStartedEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{68}
}

func (x *SyncStartedEvent) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

type SyncFinishedEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	UserID string `protobuf:"bytes,1,opt,name=userID,proto3" json:"userID,omitempty"`
}

func (x *SyncFinishedEvent) Reset() {
	*x = SyncFinishedEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[69]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SyncFinishedEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncFinishedEvent) ProtoMessage() {}

func (x *SyncFinishedEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[69]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyncFinishedEvent.ProtoReflect.Descriptor instead.
func (*SyncFinishedEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{69}
}

func (x *SyncFinishedEvent) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

type SyncProgressEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	UserID      string  `protobuf:"bytes,1,opt,name=userID,proto3" json:"userID,omitempty"`
	Progress    float64 `protobuf:"fixed64,2,opt,name=progress,proto3" json:"progress,omitempty"`
	ElapsedMs   int64   `protobuf:"varint,3,opt,name=elapsedMs,proto3" json:"elapsedMs,omitempty"`
	RemainingMs int64   `protobuf:"varint,4,opt,name=remainingMs,proto3" json:"remainingMs,omitempty"`
}

func (x *SyncProgressEvent) Reset() {
	*x = SyncProgressEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[70]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SyncProgressEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncProgressEvent) ProtoMessage() {}

func (x *SyncProgressEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[70]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyncProgressEvent.ProtoReflect.Descriptor instead.
func (*SyncProgressEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{70}
}

func (x *SyncProgressEvent) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

func (x *SyncProgressEvent) GetProgress() float64 {
	if x != nil {
		return x.Progress
	}
	return 0
}

func (x *SyncProgressEvent) GetElapsedMs() int64 {
	if x != nil {
		return x.ElapsedMs
	}
	return 0
}

func (x *SyncProgressEvent) GetRemainingMs() int64 {
	if x != nil {
		return x.RemainingMs
	}
	return 0
}

type UserNotificationEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Title    string `protobuf:"bytes,1,opt,name=title,proto3" json:"title,omitempty"`
	Subtitle string `protobuf:"bytes,2,opt,name=subtitle,proto3" json:"subtitle,omitempty"`
	Body     string `protobuf:"bytes,3,opt,name=body,proto3" json:"body,omitempty"`
	UserID   string `protobuf:"bytes,4,opt,name=userID,proto3" json:"userID,omitempty"`
}

func (x *UserNotificationEvent) Reset() {
	*x = UserNotificationEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[71]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UserNotificationEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserNotificationEvent) ProtoMessage() {}

func (x *UserNotificationEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[71]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserNotificationEvent.ProtoReflect.Descriptor instead.
func (*UserNotificationEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{71}
}

func (x *UserNotificationEvent) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *UserNotificationEvent) GetSubtitle() string {
	if x != nil {
		return x.Subtitle
	}
	return ""
}

func (x *UserNotificationEvent) GetBody() string {
	if x != nil {
		return x.Body
	}
	return ""
}

func (x *UserNotificationEvent) GetUserID() string {
	if x != nil {
		return x.UserID
	}
	return ""
}

type GenericErrorEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Code ErrorCode `protobuf:"varint,1,opt,name=code,proto3,enum=grpc.ErrorCode" json:"code,omitempty"`
}

func (x *GenericErrorEvent) Reset() {
	*x = GenericErrorEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_bridge_proto_msgTypes[72]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenericErrorEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenericErrorEvent) ProtoMessage() {}

func (x *GenericErrorEvent) ProtoReflect() protoreflect.Message {
	mi := &file_bridge_proto_msgTypes[72]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenericErrorEvent.ProtoReflect.Descriptor instead.
func (*GenericErrorEvent) Descriptor() ([]byte, []int) {
	return file_bridge_proto_rawDescGZIP(), []int{72}
}

func (x *GenericErrorEvent) GetCode() ErrorCode {
	if x != nil {
		return x.Code
	}
	return ErrorCode_UNKNOWN_ERROR
}

var File_bridge_proto protoreflect.FileDescriptor

var file_bridge_proto_rawDesc = []byte{
	0x0a, 0x0c, 0x62, 0x72, 0x69, 0x64, 0x67, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x04,
	0x67, 0x72, 0x70, 0x63, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0x6e, 0x0a, 0x12, 0x41, 0x64, 0x64, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x05, 0x6c, 0x65, 0x76, 0x65, 0x6c,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x0e, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x4c, 0x6f,
	0x67, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x05, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x18, 0x0a,
	0x07, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x22, 0x3e, 0x0a, 0x10, 0x47, 0x75, 0x69, 0x52, 0x65, 0x61, 0x64, 0x79, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2a, 0x0a, 0x10, 0x73, 0x68, 0x6f, 0x77, 0x53, 0x70, 0x6c,
	0x61, 0x73, 0x68, 0x53, 0x63, 0x72, 0x65, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x10, 0x73, 0x68, 0x6f, 0x77, 0x53, 0x70, 0x6c, 0x61, 0x73, 0x68, 0x53, 0x63, 0x72, 0x65, 0x65,
	0x6e, 0x22, 0xde, 0x01, 0x0a, 0x10, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x42, 0x75, 0x67, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x73, 0x54, 0x79, 0x70, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6f, 0x73, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c,
	0x0a, 0x09, 0x6f, 0x73, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x6f, 0x73, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05,
	0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x69, 0x74,
	0x6c, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x20,
	0x0a, 0x0b, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x12, 0x20, 0x0a, 0x0b, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x4c, 0x6f, 0x67, 0x73, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x4c, 0x6f,
	0x67, 0x73, 0x22, 0x80, 0x01, 0x0a, 0x0c, 0x4c, 0x6f, 0x67, 0x69, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x1a, 0x0a, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x12, 0x27, 0x0a, 0x0c, 0x75,
	0x73, 0x65, 0x48, 0x76, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x08, 0x48, 0x00, 0x52, 0x0c, 0x75, 0x73, 0x65, 0x48, 0x76, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x88, 0x01, 0x01, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x75, 0x73, 0x65, 0x48, 0x76, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0x2f, 0x0a, 0x11, 0x4c, 0x6f, 0x67, 0x69, 0x6e, 0x41, 0x62,
	0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x75, 0x73,
	0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x75, 0x73,
	0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x96, 0x01, 0x0a, 0x10, 0x49, 0x6d, 0x61, 0x70, 0x53,
	0x6d, 0x74, 0x70, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x69,
	0x6d, 0x61, 0x70, 0x50, 0x6f, 0x72, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x69,
	0x6d, 0x61, 0x70, 0x50, 0x6f, 0x72, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x73, 0x6d, 0x74, 0x70, 0x50,
	0x6f, 0x72, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x73, 0x6d, 0x74, 0x70, 0x50,
	0x6f, 0x72, 0x74, 0x12, 0x24, 0x0a, 0x0d, 0x75, 0x73, 0x65, 0x53, 0x53, 0x4c, 0x46, 0x6f, 0x72,
	0x49, 0x6d, 0x61, 0x70, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x75, 0x73, 0x65, 0x53,
	0x53, 0x4c, 0x46, 0x6f, 0x72, 0x49, 0x6d, 0x61, 0x70, 0x12, 0x24, 0x0a, 0x0d, 0x75, 0x73, 0x65,
	0x53, 0x53, 0x4c, 0x46, 0x6f, 0x72, 0x53, 0x6d, 0x74, 0x70, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0d, 0x75, 0x73, 0x65, 0x53, 0x53, 0x4c, 0x46, 0x6f, 0x72, 0x53, 0x6d, 0x74, 0x70, 0x22,
	0x3a, 0x0a, 0x1a, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x4b, 0x65, 0x79, 0x63,
	0x68, 0x61, 0x69, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1c, 0x0a,
	0x09, 0x6b, 0x65, 0x79, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x09, 0x6b, 0x65, 0x79, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x73, 0x22, 0x8f, 0x02, 0x0a, 0x04,
	0x55, 0x73, 0x65, 0x72, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x02, 0x69, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x1e, 0x0a, 0x0a, 0x61, 0x76, 0x61, 0x74, 0x61, 0x72, 0x54, 0x65, 0x78, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x61, 0x76, 0x61, 0x74, 0x61, 0x72, 0x54, 0x65, 0x78, 0x74,
	0x12, 0x25, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x0f, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x73, 0x70, 0x6c, 0x69, 0x74,
	0x4d, 0x6f, 0x64, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x73, 0x70, 0x6c, 0x69,
	0x74, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x75, 0x73, 0x65, 0x64, 0x42, 0x79, 0x74,
	0x65, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x75, 0x73, 0x65, 0x64, 0x42, 0x79,
	0x74, 0x65, 0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x42, 0x79, 0x74, 0x65,
	0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x42, 0x79,
	0x74, 0x65, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x12,
	0x1c, 0x0a, 0x09, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x18, 0x09, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x09, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x22, 0x46, 0x0a,
	0x14, 0x55, 0x73, 0x65, 0x72, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x12, 0x16, 0x0a,
	0x06, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x61,
	0x63, 0x74, 0x69, 0x76, 0x65, 0x22, 0x51, 0x0a, 0x1b, 0x55, 0x73, 0x65, 0x72, 0x42, 0x61, 0x64,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x12, 0x1a, 0x0a, 0x08,
	0x64, 0x6f, 0x52, 0x65, 0x73, 0x79, 0x6e, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08,
	0x64, 0x6f, 0x52, 0x65, 0x73, 0x79, 0x6e, 0x63, 0x22, 0x34, 0x0a, 0x10, 0x55, 0x73, 0x65, 0x72,
	0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x20, 0x0a, 0x05,
	0x75, 0x73, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0a, 0x2e, 0x67, 0x72,
	0x70, 0x63, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x52, 0x05, 0x75, 0x73, 0x65, 0x72, 0x73, 0x22, 0x4d,
	0x0a, 0x19, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x41, 0x70, 0x70, 0x6c, 0x65,
	0x4d, 0x61, 0x69, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x75,
	0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x75, 0x73, 0x65,
	0x72, 0x49, 0x44, 0x12, 0x18, 0x0a, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x22, 0x3c, 0x0a,
	0x12, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x26, 0x0a, 0x0e, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x50, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x43, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x22, 0xd0, 0x03, 0x0a, 0x0b,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x22, 0x0a, 0x03, 0x61,
	0x70, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e,
	0x41, 0x70, 0x70, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x03, 0x61, 0x70, 0x70, 0x12,
	0x28, 0x0a, 0x05, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x10,
	0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x4c, 0x6f, 0x67, 0x69, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x48, 0x00, 0x52, 0x05, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x12, 0x2b, 0x0a, 0x06, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x72, 0x70, 0x63,
	0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x06,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x2c, 0x0a, 0x05, 0x63, 0x61, 0x63, 0x68, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x44, 0x69, 0x73,
	0x6b, 0x43, 0x61, 0x63, 0x68, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x05, 0x63,
	0x61, 0x63, 0x68, 0x65, 0x12, 0x4f, 0x0a, 0x12, 0x6d, 0x61, 0x69, 0x6c, 0x53, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1d, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x4d, 0x61, 0x69, 0x6c, 0x53, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48,
	0x00, 0x52, 0x12, 0x6d, 0x61, 0x69, 0x6c, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x31, 0x0a, 0x08, 0x6b, 0x65, 0x79, 0x63, 0x68, 0x61, 0x69,
	0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x4b,
	0x65, 0x79, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x08,
	0x6b, 0x65, 0x79, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x12, 0x25, 0x0a, 0x04, 0x6d, 0x61, 0x69, 0x6c,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x4d, 0x61,
	0x69, 0x6c, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x04, 0x6d, 0x61, 0x69, 0x6c, 0x12,
	0x25, 0x0a, 0x04, 0x75, 0x73, 0x65, 0x72, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e,
	0x67, 0x72, 0x70, 0x63, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00,
	0x52, 0x04, 0x75, 0x73, 0x65, 0x72, 0x12, 0x3d, 0x0a, 0x0c, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69,
	0x63, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67,
	0x72, 0x70, 0x63, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x45, 0x72, 0x72, 0x6f, 0x72,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x0c, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63,
	0x45, 0x72, 0x72, 0x6f, 0x72, 0x42, 0x07, 0x0a, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x22, 0xd2,
	0x09, 0x0a, 0x08, 0x41, 0x70, 0x70, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x43, 0x0a, 0x0e, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72,
	0x6e, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00,
	0x52, 0x0e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x5e, 0x0a, 0x17, 0x74, 0x6f, 0x67, 0x67, 0x6c, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x46, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x22, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x54, 0x6f, 0x67, 0x67, 0x6c, 0x65, 0x41,
	0x75, 0x74, 0x6f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x46, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x65, 0x64,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x17, 0x74, 0x6f, 0x67, 0x67, 0x6c, 0x65, 0x41,
	0x75, 0x74, 0x6f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x46, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x65, 0x64,
	0x12, 0x40, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x65, 0x74, 0x46, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x65,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x52,
	0x65, 0x73, 0x65, 0x74, 0x46, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x48, 0x00, 0x52, 0x0d, 0x72, 0x65, 0x73, 0x65, 0x74, 0x46, 0x69, 0x6e, 0x69, 0x73, 0x68,
	0x65, 0x64, 0x12, 0x4c, 0x0a, 0x11, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x42, 0x75, 0x67, 0x46,
	0x69, 0x6e, 0x69, 0x73, 0x68, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x67, 0x72, 0x70, 0x63, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x42, 0x75, 0x67, 0x46, 0x69,
	0x6e, 0x69, 0x73, 0x68, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x11, 0x72,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x42, 0x75, 0x67, 0x46, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x65, 0x64,
	0x12, 0x49, 0x0a, 0x10, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x42, 0x75, 0x67, 0x53, 0x75, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x72, 0x70,
	0x63, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x42, 0x75, 0x67, 0x53, 0x75, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x10, 0x72, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x42, 0x75, 0x67, 0x53, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x43, 0x0a, 0x0e, 0x72,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x42, 0x75, 0x67, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x42, 0x75, 0x67, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00,
	0x52, 0x0e, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x42, 0x75, 0x67, 0x45, 0x72, 0x72, 0x6f, 0x72,
	0x12, 0x43, 0x0a, 0x0e, 0x73, 0x68, 0x6f, 0x77, 0x4d, 0x61, 0x69, 0x6e, 0x57, 0x69, 0x6e, 0x64,
	0x6f, 0x77, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e,
	0x53, 0x68, 0x6f, 0x77, 0x4d, 0x61, 0x69, 0x6e, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x0e, 0x73, 0x68, 0x6f, 0x77, 0x4d, 0x61, 0x69, 0x6e, 0x57,
	0x69, 0x6e, 0x64, 0x6f, 0x77, 0x12, 0x4c, 0x0a, 0x11, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x42,
	0x75, 0x67, 0x46, 0x61, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1c, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x42, 0x75,
	0x67, 0x46, 0x61, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00,
	0x52, 0x11, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x42, 0x75, 0x67, 0x46, 0x61, 0x6c, 0x6c, 0x62,
	0x61, 0x63, 0x6b, 0x12, 0x64, 0x0a, 0x19, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x53, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x43, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c,
	0x53, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x19,
	0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6c, 0x6c, 0x53, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x67, 0x0a, 0x1a, 0x63, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x43,
	0x61, 0x6e, 0x63, 0x65, 0x6c, 0x65, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e,
	0x67, 0x72, 0x70, 0x63, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x65, 0x64, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x1a, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c,
	0x65, 0x64, 0x12, 0x61, 0x0a, 0x18, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x46, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x43, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x46, 0x61,
	0x69, 0x6c, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x18, 0x63, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x46,
	0x61, 0x69, 0x6c, 0x65, 0x64, 0x12, 0x61, 0x0a, 0x18, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64,
	0x67, 0x65, 0x42, 0x61, 0x73, 0x65, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x4b,
	0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x42, 0x61, 0x73, 0x65, 0x53, 0x75, 0x67, 0x67,
	0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x18,
	0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x42, 0x61, 0x73, 0x65, 0x53, 0x75, 0x67,
	0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x40, 0x0a, 0x0d, 0x72, 0x65, 0x70, 0x61,
	0x69, 0x72, 0x53, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x18, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x52, 0x65, 0x70, 0x61, 0x69, 0x72, 0x53, 0x74, 0x61,
	0x72, 0x74, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x0d, 0x72, 0x65, 0x70,
	0x61, 0x69, 0x72, 0x53, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x12, 0x43, 0x0a, 0x0e, 0x61, 0x6c,
	0x6c, 0x55, 0x73, 0x65, 0x72, 0x73, 0x4c, 0x6f, 0x61, 0x64, 0x65, 0x64, 0x18, 0x0e, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x41, 0x6c, 0x6c, 0x55, 0x73, 0x65,
	0x72, 0x73, 0x4c, 0x6f, 0x61, 0x64, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52,
	0x0e, 0x61, 0x6c, 0x6c, 0x55, 0x73, 0x65, 0x72, 0x73, 0x4c, 0x6f, 0x61, 0x64, 0x65, 0x64, 0x12,
	0x49, 0x0a, 0x10, 0x75, 0x73, 0x65, 0x72, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x72, 0x70, 0x63,
	0x2e, 0x55, 0x73, 0x65, 0x72, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x10, 0x75, 0x73, 0x65, 0x72, 0x4e, 0x6f,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x07, 0x0a, 0x05, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x22, 0x33, 0x0a, 0x13, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x1c, 0x0a, 0x09, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x22, 0x1e, 0x0a, 0x1c, 0x54, 0x6f, 0x67, 0x67,
	0x6c, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x46, 0x69, 0x6e, 0x69, 0x73,
	0x68, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x22, 0x14, 0x0a, 0x12, 0x52, 0x65, 0x73, 0x65,
	0x74, 0x46, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x22, 0x18,
	0x0a, 0x16, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x42, 0x75, 0x67, 0x46, 0x69, 0x6e, 0x69, 0x73,
	0x68, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x22, 0x17, 0x0a, 0x15, 0x52, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x42, 0x75, 0x67, 0x53, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x22, 0x15, 0x0a, 0x13, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x42, 0x75, 0x67, 0x45, 0x72,
	0x72, 0x6f, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x22, 0x15, 0x0a, 0x13, 0x53, 0x68, 0x6f, 0x77,
	0x4d, 0x61, 0x69, 0x6e, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x22,
	0x18, 0x0a, 0x16, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x42, 0x75, 0x67, 0x46, 0x61, 0x6c, 0x6c,
	0x62, 0x61, 0x63, 0x6b, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x22, 0x20, 0x0a, 0x1e, 0x43, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x53,
	0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x22, 0x21, 0x0a, 0x1f, 0x43,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c,
	0x6c, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x22, 0x1f,
	0x0a, 0x1d, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6c, 0x6c, 0x46, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x22,
	0x14, 0x0a, 0x12, 0x52, 0x65, 0x70, 0x61, 0x69, 0x72, 0x53, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x22, 0x15, 0x0a, 0x13, 0x41, 0x6c, 0x6c, 0x55, 0x73, 0x65, 0x72,
	0x73, 0x4c, 0x6f, 0x61, 0x64, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x22, 0x41, 0x0a, 0x17,
	0x4b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x42, 0x61, 0x73, 0x65, 0x53, 0x75, 0x67,
	0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x69, 0x74,
	0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x22,
	0x60, 0x0a, 0x1d, 0x4b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x42, 0x61, 0x73, 0x65,
	0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x12, 0x3f, 0x0a, 0x0b, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x4b, 0x6e, 0x6f,
	0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x42, 0x61, 0x73, 0x65, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x22, 0xa4, 0x03, 0x0a, 0x0a, 0x4c, 0x6f, 0x67, 0x69, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x12, 0x2d, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x15, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x4c, 0x6f, 0x67, 0x69, 0x6e, 0x45, 0x72, 0x72, 0x6f,
	0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12,
	0x42, 0x0a, 0x0c, 0x74, 0x66, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x4c, 0x6f, 0x67,
	0x69, 0x6e, 0x54, 0x66, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x0c, 0x74, 0x66, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x65, 0x64, 0x12, 0x5b, 0x0a, 0x14, 0x74, 0x77, 0x6f, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f,
	0x72, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x25, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x4c, 0x6f, 0x67, 0x69, 0x6e, 0x54, 0x77,
	0x6f, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x14, 0x74, 0x77, 0x6f, 0x50,
	0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64,
	0x12, 0x36, 0x0a, 0x08, 0x66, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x18, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x4c, 0x6f, 0x67, 0x69, 0x6e, 0x46,
	0x69, 0x6e, 0x69, 0x73, 0x68, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x08,
	0x66, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x65, 0x64, 0x12, 0x44, 0x0a, 0x0f, 0x61, 0x6c, 0x72, 0x65,
	0x61, 0x64, 0x79, 0x4c, 0x6f, 0x67, 0x67, 0x65, 0x64, 0x49, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x18, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x4c, 0x6f, 0x67, 0x69, 0x6e, 0x46, 0x69,
	0x6e, 0x69, 0x73, 0x68, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x0f, 0x61,
	0x6c, 0x72, 0x65, 0x61, 0x64, 0x79, 0x4c, 0x6f, 0x67, 0x67, 0x65, 0x64, 0x49, 0x6e, 0x12, 0x3f,
	0x0a, 0x0b, 0x68, 0x76, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x4c, 0x6f, 0x67, 0x69, 0x6e,
	0x48, 0x76, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x48, 0x00, 0x52, 0x0b, 0x68, 0x76, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x42,
	0x07, 0x0a, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x22, 0x55, 0x0a, 0x0f, 0x4c, 0x6f, 0x67, 0x69,
	0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x28, 0x0a, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x14, 0x2e, 0x67, 0x72, 0x70, 0x63,
	0x2e, 0x4c, 0x6f, 0x67, 0x69, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22,
	0x34, 0x0a, 0x16, 0x4c, 0x6f, 0x67, 0x69, 0x6e, 0x54, 0x66, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x75, 0x73, 0x65,
	0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x75, 0x73, 0x65,
	0x72, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x3d, 0x0a, 0x1f, 0x4c, 0x6f, 0x67, 0x69, 0x6e, 0x54, 0x77,
	0x6f, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x75, 0x73, 0x65, 0x72,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0x50, 0x0a, 0x12, 0x4c, 0x6f, 0x67, 0x69, 0x6e, 0x46, 0x69, 0x6e,
	0x69, 0x73, 0x68, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x75, 0x73,
	0x65, 0x72, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x75, 0x73, 0x65, 0x72,
	0x49, 0x44, 0x12, 0x22, 0x0a, 0x0c, 0x77, 0x61, 0x73, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x4f,
	0x75, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x77, 0x61, 0x73, 0x53, 0x69, 0x67,
	0x6e, 0x65, 0x64, 0x4f, 0x75, 0x74, 0x22, 0x2d, 0x0a, 0x15, 0x4c, 0x6f, 0x67, 0x69, 0x6e, 0x48,
	0x76, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12,
	0x14, 0x0a, 0x05, 0x68, 0x76, 0x55, 0x72, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x68, 0x76, 0x55, 0x72, 0x6c, 0x22, 0xb9, 0x04, 0x0a, 0x0b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x2e, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x05,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x40, 0x0a, 0x0b, 0x6d, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x52,
	0x65, 0x61, 0x64, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x72, 0x70,
	0x63, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x52, 0x65,
	0x61, 0x64, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x0b, 0x6d, 0x61, 0x6e, 0x75,
	0x61, 0x6c, 0x52, 0x65, 0x61, 0x64, 0x79, 0x12, 0x58, 0x0a, 0x13, 0x6d, 0x61, 0x6e, 0x75, 0x61,
	0x6c, 0x52, 0x65, 0x73, 0x74, 0x61, 0x72, 0x74, 0x4e, 0x65, 0x65, 0x64, 0x65, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4d, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x74, 0x61, 0x72, 0x74, 0x4e,
	0x65, 0x65, 0x64, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x13, 0x6d, 0x61,
	0x6e, 0x75, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x74, 0x61, 0x72, 0x74, 0x4e, 0x65, 0x65, 0x64, 0x65,
	0x64, 0x12, 0x2e, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x16, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x6f,
	0x72, 0x63, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63,
	0x65, 0x12, 0x53, 0x0a, 0x13, 0x73, 0x69, 0x6c, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x4e, 0x65, 0x65, 0x64, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f,
	0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x69, 0x6c, 0x65,
	0x6e, 0x74, 0x52, 0x65, 0x73, 0x74, 0x61, 0x72, 0x74, 0x4e, 0x65, 0x65, 0x64, 0x65, 0x64, 0x48,
	0x00, 0x52, 0x13, 0x73, 0x69, 0x6c, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x4e, 0x65, 0x65, 0x64, 0x65, 0x64, 0x12, 0x47, 0x0a, 0x0f, 0x69, 0x73, 0x4c, 0x61, 0x74, 0x65,
	0x73, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x73, 0x4c,
	0x61, 0x74, 0x65, 0x73, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0f,
	0x69, 0x73, 0x4c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x41, 0x0a, 0x0d, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x46, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x65, 0x64,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x46, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x65,
	0x64, 0x48, 0x00, 0x52, 0x0d, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x46, 0x69, 0x6e, 0x69, 0x73, 0x68,
	0x65, 0x64, 0x12, 0x44, 0x0a, 0x0e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x72, 0x70,
	0x63, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x43,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x48, 0x00, 0x52, 0x0e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x42, 0x07, 0x0a, 0x05, 0x65, 0x76, 0x65, 0x6e,
	0x74, 0x22, 0x3d, 0x0a, 0x10, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x72, 0x72, 0x6f, 0x72,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x29, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x15, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x22, 0x32, 0x0a, 0x16, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x6e, 0x75, 0x61, 0x6c,
	0x52, 0x65, 0x61, 0x64, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x22, 0x20, 0x0a, 0x1e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61,
	0x6e, 0x75, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x74, 0x61, 0x72, 0x74, 0x4e, 0x65, 0x65, 0x64, 0x65,
	0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x22, 0x2c, 0x0a, 0x10, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x46, 0x6f, 0x72, 0x63, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x22, 0x1b, 0x0a, 0x19, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x69,
	0x6c, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x74, 0x61, 0x72, 0x74, 0x4e, 0x65, 0x65, 0x64, 0x65,
	0x64, 0x22, 0x17, 0x0a, 0x15, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x73, 0x4c, 0x61, 0x74,
	0x65, 0x73, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x15, 0x0a, 0x13, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x46, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x65,
	0x64, 0x22, 0x16, 0x0a, 0x14, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x22, 0xeb, 0x01, 0x0a, 0x0e, 0x44, 0x69,
	0x73, 0x6b, 0x43, 0x61, 0x63, 0x68, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x31, 0x0a, 0x05,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x72,
	0x70, 0x63, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x43, 0x61, 0x63, 0x68, 0x65, 0x45, 0x72, 0x72, 0x6f,
	0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12,
	0x43, 0x0a, 0x0b, 0x70, 0x61, 0x74, 0x68, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x44, 0x69, 0x73, 0x6b,
	0x43, 0x61, 0x63, 0x68, 0x65, 0x50, 0x61, 0x74, 0x68, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x0b, 0x70, 0x61, 0x74, 0x68, 0x43, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x64, 0x12, 0x58, 0x0a, 0x12, 0x70, 0x61, 0x74, 0x68, 0x43, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x46, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x43, 0x61, 0x63, 0x68,
	0x65, 0x50, 0x61, 0x74, 0x68, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x46, 0x69, 0x6e, 0x69, 0x73,
	0x68, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x12, 0x70, 0x61, 0x74, 0x68,
	0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x46, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x65, 0x64, 0x42, 0x07,
	0x0a, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x22, 0x43, 0x0a, 0x13, 0x44, 0x69, 0x73, 0x6b, 0x43,
	0x61, 0x63, 0x68, 0x65, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x2c,
	0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x18, 0x2e, 0x67,
	0x72, 0x70, 0x63, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x43, 0x61, 0x63, 0x68, 0x65, 0x45, 0x72, 0x72,
	0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x2f, 0x0a, 0x19,
	0x44, 0x69, 0x73, 0x6b, 0x43, 0x61, 0x63, 0x68, 0x65, 0x50, 0x61, 0x74, 0x68, 0x43, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74,
	0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x22, 0x22, 0x0a,
	0x20, 0x44, 0x69, 0x73, 0x6b, 0x43, 0x61, 0x63, 0x68, 0x65, 0x50, 0x61, 0x74, 0x68, 0x43, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x46, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x22, 0xbf, 0x02, 0x0a, 0x17, 0x4d, 0x61, 0x69, 0x6c, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x3a, 0x0a,
	0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67,
	0x72, 0x70, 0x63, 0x2e, 0x4d, 0x61, 0x69, 0x6c, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x48, 0x00, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x64, 0x0a, 0x19, 0x6d, 0x61, 0x69,
	0x6c, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x43,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67,
	0x72, 0x70, 0x63, 0x2e, 0x4d, 0x61, 0x69, 0x6c, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x48, 0x00, 0x52, 0x19, 0x6d, 0x61, 0x69, 0x6c, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x12,
	0x79, 0x0a, 0x20, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x4d, 0x61, 0x69, 0x6c, 0x53, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x46, 0x69, 0x6e, 0x69, 0x73,
	0x68, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x72, 0x70, 0x63,
	0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x4d, 0x61, 0x69, 0x6c, 0x53, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x46, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x65,
	0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x20, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x4d, 0x61, 0x69, 0x6c, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x46, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x65, 0x64, 0x42, 0x07, 0x0a, 0x05, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x22, 0x55, 0x0a, 0x1c, 0x4d, 0x61, 0x69, 0x6c, 0x53, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x12, 0x35, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x21, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x4d, 0x61, 0x69, 0x6c, 0x53, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x45, 0x72, 0x72, 0x6f, 0x72,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x54, 0x0a, 0x1e, 0x4d, 0x61,
	0x69, 0x6c, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x32, 0x0a, 0x08,
	0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16,
	0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x49, 0x6d, 0x61, 0x70, 0x53, 0x6d, 0x74, 0x70, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x22, 0x27, 0x0a, 0x25, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x4d, 0x61, 0x69, 0x6c, 0x53, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x46, 0x69, 0x6e, 0x69,
	0x73, 0x68, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x22, 0xff, 0x01, 0x0a, 0x0d, 0x4b, 0x65,
	0x79, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x5b, 0x0a, 0x16, 0x63,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x4b, 0x65, 0x79, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x46, 0x69, 0x6e,
	0x69, 0x73, 0x68, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x72,
	0x70, 0x63, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x4b, 0x65, 0x79, 0x63, 0x68, 0x61, 0x69,
	0x6e, 0x46, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00,
	0x52, 0x16, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x4b, 0x65, 0x79, 0x63, 0x68, 0x61, 0x69, 0x6e,
	0x46, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x65, 0x64, 0x12, 0x40, 0x0a, 0x0d, 0x68, 0x61, 0x73, 0x4e,
	0x6f, 0x4b, 0x65, 0x79, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x18, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x48, 0x61, 0x73, 0x4e, 0x6f, 0x4b, 0x65, 0x79, 0x63,
	0x68, 0x61, 0x69, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x0d, 0x68, 0x61, 0x73,
	0x4e, 0x6f, 0x4b, 0x65, 0x79, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x12, 0x46, 0x0a, 0x0f, 0x72, 0x65,
	0x62, 0x75, 0x69, 0x6c, 0x64, 0x4b, 0x65, 0x79, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x52, 0x65, 0x62, 0x75, 0x69,
	0x6c, 0x64, 0x4b, 0x65, 0x79, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48,
	0x00, 0x52, 0x0f, 0x72, 0x65, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x4b, 0x65, 0x79, 0x63, 0x68, 0x61,
	0x69, 0x6e, 0x42, 0x07, 0x0a, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x22, 0x1d, 0x0a, 0x1b, 0x43,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x4b, 0x65, 0x79, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x46, 0x69, 0x6e,
	0x69, 0x73, 0x68, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x22, 0x14, 0x0a, 0x12, 0x48, 0x61,
	0x73, 0x4e, 0x6f, 0x4b, 0x65, 0x79, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x22, 0x16, 0x0a, 0x14, 0x52, 0x65, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x4b, 0x65, 0x79, 0x63, 0x68,
	0x61, 0x69, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x22, 0xef, 0x01, 0x0a, 0x09, 0x4d, 0x61, 0x69,
	0x6c, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x43, 0x0a, 0x0e, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x43, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x0e, 0x61, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x12, 0x55, 0x0a, 0x14, 0x61,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x4c, 0x6f, 0x67,
	0x6f, 0x75, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x72, 0x70, 0x63,
	0x2e, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x4c,
	0x6f, 0x67, 0x6f, 0x75, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x14, 0x61, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x4c, 0x6f, 0x67, 0x6f,
	0x75, 0x74, 0x12, 0x3d, 0x0a, 0x0c, 0x61, 0x70, 0x69, 0x43, 0x65, 0x72, 0x74, 0x49, 0x73, 0x73,
	0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e,
	0x41, 0x70, 0x69, 0x43, 0x65, 0x72, 0x74, 0x49, 0x73, 0x73, 0x75, 0x65, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x48, 0x00, 0x52, 0x0c, 0x61, 0x70, 0x69, 0x43, 0x65, 0x72, 0x74, 0x49, 0x73, 0x73, 0x75,
	0x65, 0x42, 0x07, 0x0a, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x22, 0x2f, 0x0a, 0x13, 0x41, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x12, 0x18, 0x0a, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x22, 0x35, 0x0a, 0x19, 0x41,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x4c, 0x6f, 0x67,
	0x6f, 0x75, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x61, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x22, 0x13, 0x0a, 0x11, 0x41, 0x70, 0x69, 0x43, 0x65, 0x72, 0x74, 0x49, 0x73, 0x73,
	0x75, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x22, 0xb4, 0x05, 0x0a, 0x09, 0x55, 0x73, 0x65, 0x72,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x5e, 0x0a, 0x17, 0x74, 0x6f, 0x67, 0x67, 0x6c, 0x65, 0x53,
	0x70, 0x6c, 0x69, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x46, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x65, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x54, 0x6f,
	0x67, 0x67, 0x6c, 0x65, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x46, 0x69, 0x6e,
	0x69, 0x73, 0x68, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x17, 0x74, 0x6f,
	0x67, 0x67, 0x6c, 0x65, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x46, 0x69, 0x6e,
	0x69, 0x73, 0x68, 0x65, 0x64, 0x12, 0x49, 0x0a, 0x10, 0x75, 0x73, 0x65, 0x72, 0x44, 0x69, 0x73,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x44, 0x69, 0x73, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x10,
	0x75, 0x73, 0x65, 0x72, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64,
	0x12, 0x3a, 0x0a, 0x0b, 0x75, 0x73, 0x65, 0x72, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x55, 0x73, 0x65,
	0x72, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52,
	0x0b, 0x75, 0x73, 0x65, 0x72, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x12, 0x38, 0x0a, 0x0c,
	0x75, 0x73, 0x65, 0x72, 0x42, 0x61, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x42, 0x61,
	0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x0c, 0x75, 0x73, 0x65, 0x72, 0x42, 0x61,
	0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x53, 0x0a, 0x15, 0x75, 0x73, 0x65, 0x64, 0x42, 0x79,
	0x74, 0x65, 0x73, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x55, 0x73, 0x65,
	0x64, 0x42, 0x79, 0x74, 0x65, 0x73, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x48, 0x00, 0x52, 0x15, 0x75, 0x73, 0x65, 0x64, 0x42, 0x79, 0x74, 0x65, 0x73, 0x43,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x50, 0x0a, 0x14, 0x69,
	0x6d, 0x61, 0x70, 0x4c, 0x6f, 0x67, 0x69, 0x6e, 0x46, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x72, 0x70, 0x63,
	0x2e, 0x49, 0x6d, 0x61, 0x70, 0x4c, 0x6f, 0x67, 0x69, 0x6e, 0x46, 0x61, 0x69, 0x6c, 0x65, 0x64,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x14, 0x69, 0x6d, 0x61, 0x70, 0x4c, 0x6f, 0x67,
	0x69, 0x6e, 0x46, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x44, 0x0a,
	0x10, 0x73, 0x79, 0x6e, 0x63, 0x53, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x53,
	0x79, 0x6e, 0x63, 0x53, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48,
	0x00, 0x52, 0x10, 0x73, 0x79, 0x6e, 0x63, 0x53, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x12, 0x47, 0x0a, 0x11, 0x73, 0x79, 0x6e, 0x63, 0x46, 0x69, 0x6e, 0x69, 0x73,
	0x68, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17,
	0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x79, 0x6e, 0x63, 0x46, 0x69, 0x6e, 0x69, 0x73, 0x68,
	0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x11, 0x73, 0x79, 0x6e, 0x63, 0x46,
	0x69, 0x6e, 0x69, 0x73, 0x68, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x47, 0x0a, 0x11,
	0x73, 0x79, 0x6e, 0x63, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x53,
	0x79, 0x6e, 0x63, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x48, 0x00, 0x52, 0x11, 0x73, 0x79, 0x6e, 0x63, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x42, 0x07, 0x0a, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x22, 0x36,
	0x0a, 0x1c, 0x54, 0x6f, 0x67, 0x67, 0x6c, 0x65, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x4d, 0x6f, 0x64,
	0x65, 0x46, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x16,
	0x0a, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x22, 0x33, 0x0a, 0x15, 0x55, 0x73, 0x65, 0x72, 0x44, 0x69,
	0x73, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12,
	0x1a, 0x0a, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x2a, 0x0a, 0x10, 0x55,
	0x73, 0x65, 0x72, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12,
	0x16, 0x0a, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x22, 0x4a, 0x0a, 0x0c, 0x55, 0x73, 0x65, 0x72, 0x42,
	0x61, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49,
	0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x12,
	0x22, 0x0a, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x22, 0x4d, 0x0a, 0x15, 0x55, 0x73, 0x65, 0x64, 0x42, 0x79, 0x74, 0x65, 0x73,
	0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06,
	0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x75, 0x73,
	0x65, 0x72, 0x49, 0x44, 0x12, 0x1c, 0x0a, 0x09, 0x75, 0x73, 0x65, 0x64, 0x42, 0x79, 0x74, 0x65,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x75, 0x73, 0x65, 0x64, 0x42, 0x79, 0x74,
	0x65, 0x73, 0x22, 0x32, 0x0a, 0x14, 0x49, 0x6d, 0x61, 0x70, 0x4c, 0x6f, 0x67, 0x69, 0x6e, 0x46,
	0x61, 0x69, 0x6c, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x75, 0x73,
	0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x75, 0x73,
	0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x2a, 0x0a, 0x10, 0x53, 0x79, 0x6e, 0x63, 0x53, 0x74,
	0x61, 0x72, 0x74, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x75, 0x73,
	0x65, 0x72, 0x49, 0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x75, 0x73, 0x65, 0x72,
	0x49, 0x44, 0x22, 0x2b, 0x0a, 0x11, 0x53, 0x79, 0x6e, 0x63, 0x46, 0x69, 0x6e, 0x69, 0x73, 0x68,
	0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49,
	0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x22,
	0x87, 0x01, 0x0a, 0x11, 0x53, 0x79, 0x6e, 0x63, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44, 0x12, 0x1a, 0x0a,
	0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52,
	0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x1c, 0x0a, 0x09, 0x65, 0x6c, 0x61,
	0x70, 0x73, 0x65, 0x64, 0x4d, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x65, 0x6c,
	0x61, 0x70, 0x73, 0x65, 0x64, 0x4d, 0x73, 0x12, 0x20, 0x0a, 0x0b, 0x72, 0x65, 0x6d, 0x61, 0x69,
	0x6e, 0x69, 0x6e, 0x67, 0x4d, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0b, 0x72, 0x65,
	0x6d, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x4d, 0x73, 0x22, 0x75, 0x0a, 0x15, 0x55, 0x73, 0x65,
	0x72, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x73, 0x75, 0x62, 0x74,
	0x69, 0x74, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x73, 0x75, 0x62, 0x74,
	0x69, 0x74, 0x6c, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x12, 0x16, 0x0a, 0x06, 0x75, 0x73, 0x65, 0x72,
	0x49, 0x44, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x75, 0x73, 0x65, 0x72, 0x49, 0x44,
	0x22, 0x38, 0x0a, 0x11, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x45, 0x72, 0x72, 0x6f, 0x72,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x23, 0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x0f, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72,
	0x43, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x2a, 0x71, 0x0a, 0x08, 0x4c, 0x6f,
	0x67, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x0d, 0x0a, 0x09, 0x4c, 0x4f, 0x47, 0x5f, 0x50, 0x41,
	0x4e, 0x49, 0x43, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x4c, 0x4f, 0x47, 0x5f, 0x46, 0x41, 0x54,
	0x41, 0x4c, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x4c, 0x4f, 0x47, 0x5f, 0x45, 0x52, 0x52, 0x4f,
	0x52, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x4c, 0x4f, 0x47, 0x5f, 0x57, 0x41, 0x52, 0x4e, 0x10,
	0x03, 0x12, 0x0c, 0x0a, 0x08, 0x4c, 0x4f, 0x47, 0x5f, 0x49, 0x4e, 0x46, 0x4f, 0x10, 0x04, 0x12,
	0x0d, 0x0a, 0x09, 0x4c, 0x4f, 0x47, 0x5f, 0x44, 0x45, 0x42, 0x55, 0x47, 0x10, 0x05, 0x12, 0x0d,
	0x0a, 0x09, 0x4c, 0x4f, 0x47, 0x5f, 0x54, 0x52, 0x41, 0x43, 0x45, 0x10, 0x06, 0x2a, 0x36, 0x0a,
	0x09, 0x55, 0x73, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x0e, 0x0a, 0x0a, 0x53, 0x49,
	0x47, 0x4e, 0x45, 0x44, 0x5f, 0x4f, 0x55, 0x54, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x4c, 0x4f,
	0x43, 0x4b, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43,
	0x54, 0x45, 0x44, 0x10, 0x02, 0x2a, 0xb0, 0x01, 0x0a, 0x0e, 0x4c, 0x6f, 0x67, 0x69, 0x6e, 0x45,
	0x72, 0x72, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x55, 0x53, 0x45, 0x52,
	0x4e, 0x41, 0x4d, 0x45, 0x5f, 0x50, 0x41, 0x53, 0x53, 0x57, 0x4f, 0x52, 0x44, 0x5f, 0x45, 0x52,
	0x52, 0x4f, 0x52, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x46, 0x52, 0x45, 0x45, 0x5f, 0x55, 0x53,
	0x45, 0x52, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x54, 0x46,
	0x41, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x54, 0x46, 0x41,
	0x5f, 0x41, 0x42, 0x4f, 0x52, 0x54, 0x10, 0x04, 0x12, 0x17, 0x0a, 0x13, 0x54, 0x57, 0x4f, 0x5f,
	0x50, 0x41, 0x53, 0x53, 0x57, 0x4f, 0x52, 0x44, 0x53, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10,
	0x05, 0x12, 0x17, 0x0a, 0x13, 0x54, 0x57, 0x4f, 0x5f, 0x50, 0x41, 0x53, 0x53, 0x57, 0x4f, 0x52,
	0x44, 0x53, 0x5f, 0x41, 0x42, 0x4f, 0x52, 0x54, 0x10, 0x06, 0x12, 0x0c, 0x0a, 0x08, 0x48, 0x56,
	0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x07, 0x2a, 0x5b, 0x0a, 0x0f, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x17, 0x0a, 0x13, 0x55,
	0x50, 0x44, 0x41, 0x54, 0x45, 0x5f, 0x4d, 0x41, 0x4e, 0x55, 0x41, 0x4c, 0x5f, 0x45, 0x52, 0x52,
	0x4f, 0x52, 0x10, 0x00, 0x12, 0x16, 0x0a, 0x12, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x5f, 0x46,
	0x4f, 0x52, 0x43, 0x45, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x01, 0x12, 0x17, 0x0a, 0x13,
	0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x5f, 0x53, 0x49, 0x4c, 0x45, 0x4e, 0x54, 0x5f, 0x45, 0x52,
	0x52, 0x4f, 0x52, 0x10, 0x02, 0x2a, 0x34, 0x0a, 0x12, 0x44, 0x69, 0x73, 0x6b, 0x43, 0x61, 0x63,
	0x68, 0x65, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1e, 0x0a, 0x1a, 0x43,
	0x41, 0x4e, 0x54, 0x5f, 0x4d, 0x4f, 0x56, 0x45, 0x5f, 0x44, 0x49, 0x53, 0x4b, 0x5f, 0x43, 0x41,
	0x43, 0x48, 0x45, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x00, 0x2a, 0xdd, 0x01, 0x0a, 0x1b,
	0x4d, 0x61, 0x69, 0x6c, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x49,
	0x4d, 0x41, 0x50, 0x5f, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x52, 0x54, 0x55, 0x50,
	0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x00, 0x12, 0x1b, 0x0a, 0x17, 0x53, 0x4d, 0x54, 0x50,
	0x5f, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x52, 0x54, 0x55, 0x50, 0x5f, 0x45, 0x52,
	0x52, 0x4f, 0x52, 0x10, 0x01, 0x12, 0x1a, 0x0a, 0x16, 0x49, 0x4d, 0x41, 0x50, 0x5f, 0x50, 0x4f,
	0x52, 0x54, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10,
	0x02, 0x12, 0x1a, 0x0a, 0x16, 0x53, 0x4d, 0x54, 0x50, 0x5f, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x43,
	0x48, 0x41, 0x4e, 0x47, 0x45, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x03, 0x12, 0x25, 0x0a,
	0x21, 0x49, 0x4d, 0x41, 0x50, 0x5f, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x5f, 0x45, 0x52, 0x52,
	0x4f, 0x52, 0x10, 0x04, 0x12, 0x25, 0x0a, 0x21, 0x53, 0x4d, 0x54, 0x50, 0x5f, 0x43, 0x4f, 0x4e,
	0x4e, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x43, 0x48, 0x41,
	0x4e, 0x47, 0x45, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x05, 0x2a, 0x53, 0x0a, 0x09, 0x45,
	0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x11, 0x0a, 0x0d, 0x55, 0x4e, 0x4b, 0x4e,
	0x4f, 0x57, 0x4e, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x00, 0x12, 0x19, 0x0a, 0x15, 0x54,
	0x4c, 0x53, 0x5f, 0x43, 0x45, 0x52, 0x54, 0x5f, 0x45, 0x58, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x45,
	0x52, 0x52, 0x4f, 0x52, 0x10, 0x01, 0x12, 0x18, 0x0a, 0x14, 0x54, 0x4c, 0x53, 0x5f, 0x4b, 0x45,
	0x59, 0x5f, 0x45, 0x58, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x02,
	0x32, 0xbd, 0x21, 0x0a, 0x06, 0x42, 0x72, 0x69, 0x64, 0x67, 0x65, 0x12, 0x49, 0x0a, 0x0b, 0x43,
	0x68, 0x65, 0x63, 0x6b, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x12, 0x1c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72,
	0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x1a, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x3f, 0x0a, 0x0b, 0x41, 0x64, 0x64, 0x4c, 0x6f, 0x67,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x18, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x41, 0x64, 0x64,
	0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x3a, 0x0a, 0x08, 0x47, 0x75, 0x69, 0x52, 0x65,
	0x61, 0x64, 0x79, 0x12, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x16, 0x2e, 0x67, 0x72,
	0x70, 0x63, 0x2e, 0x47, 0x75, 0x69, 0x52, 0x65, 0x61, 0x64, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x36, 0x0a, 0x04, 0x51, 0x75, 0x69, 0x74, 0x12, 0x16, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d,
	0x70, 0x74, 0x79, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x39, 0x0a, 0x07, 0x52,
	0x65, 0x73, 0x74, 0x61, 0x72, 0x74, 0x12, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x16,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x43, 0x0a, 0x0d, 0x53, 0x68, 0x6f, 0x77, 0x4f, 0x6e,
	0x53, 0x74, 0x61, 0x72, 0x74, 0x75, 0x70, 0x12, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x46, 0x0a, 0x10, 0x53,
	0x65, 0x74, 0x49, 0x73, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x4f, 0x6e, 0x12,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x1a, 0x16, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d,
	0x70, 0x74, 0x79, 0x12, 0x43, 0x0a, 0x0d, 0x49, 0x73, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x4f, 0x6e, 0x12, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42,
	0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x46, 0x0a, 0x10, 0x53, 0x65, 0x74, 0x49,
	0x73, 0x42, 0x65, 0x74, 0x61, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42,
	0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x12, 0x43, 0x0a, 0x0d, 0x49, 0x73, 0x42, 0x65, 0x74, 0x61, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x64, 0x12, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x49, 0x0a, 0x13, 0x53, 0x65, 0x74, 0x49, 0x73, 0x41, 0x6c,
	0x6c, 0x4d, 0x61, 0x69, 0x6c, 0x56, 0x69, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x12, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42,
	0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x12, 0x46, 0x0a, 0x10, 0x49, 0x73, 0x41, 0x6c, 0x6c, 0x4d, 0x61, 0x69, 0x6c, 0x56, 0x69, 0x73,
	0x69, 0x62, 0x6c, 0x65, 0x12, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42,
	0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x4c, 0x0a, 0x16, 0x53, 0x65, 0x74, 0x49,
	0x73, 0x54, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c,
	0x65, 0x64, 0x12, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x1a, 0x16,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x49, 0x0a, 0x13, 0x49, 0x73, 0x54, 0x65, 0x6c, 0x65,
	0x6d, 0x65, 0x74, 0x72, 0x79, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x16, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x12, 0x3c, 0x0a, 0x04, 0x47, 0x6f, 0x4f, 0x73, 0x12, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74,
	0x79, 0x1a, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12,
	0x3e, 0x0a, 0x0c, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x52, 0x65, 0x73, 0x65, 0x74, 0x12,
	0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12,
	0x3f, 0x0a, 0x07, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x16, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70,
	0x74, 0x79, 0x1a, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x12, 0x40, 0x0a, 0x08, 0x4c, 0x6f, 0x67, 0x73, 0x50, 0x61, 0x74, 0x68, 0x12, 0x16, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45,
	0x6d, 0x70, 0x74, 0x79, 0x1a, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x43, 0x0a, 0x0b, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x50, 0x61, 0x74,
	0x68, 0x12, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x4c, 0x0a, 0x14, 0x52, 0x65, 0x6c, 0x65, 0x61,
	0x73, 0x65, 0x4e, 0x6f, 0x74, 0x65, 0x73, 0x50, 0x61, 0x67, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x12,
	0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x4e, 0x0a, 0x16, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65,
	0x6e, 0x63, 0x79, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x12,
	0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x47, 0x0a, 0x0f, 0x4c, 0x61, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x50, 0x61, 0x67, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x1a, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x4a,
	0x0a, 0x12, 0x53, 0x65, 0x74, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x65,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x47, 0x0a, 0x0f, 0x43, 0x6f,
	0x6c, 0x6f, 0x72, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x12, 0x4a, 0x0a, 0x12, 0x43, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x45, 0x6d,
	0x61, 0x69, 0x6c, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74,
	0x79, 0x1a, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12,
	0x3b, 0x0a, 0x09, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x42, 0x75, 0x67, 0x12, 0x16, 0x2e, 0x67,
	0x72, 0x70, 0x63, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x42, 0x75, 0x67, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x45, 0x0a, 0x0d,
	0x46, 0x6f, 0x72, 0x63, 0x65, 0x4c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x65, 0x72, 0x12, 0x1c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x1a, 0x16, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d,
	0x70, 0x74, 0x79, 0x12, 0x49, 0x0a, 0x11, 0x53, 0x65, 0x74, 0x4d, 0x61, 0x69, 0x6e, 0x45, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x57,
	0x0a, 0x1f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64,
	0x67, 0x65, 0x42, 0x61, 0x73, 0x65, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x1a,
	0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x33, 0x0a, 0x05, 0x4c, 0x6f, 0x67, 0x69, 0x6e,
	0x12, 0x12, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x4c, 0x6f, 0x67, 0x69, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x36, 0x0a, 0x08,
	0x4c, 0x6f, 0x67, 0x69, 0x6e, 0x32, 0x46, 0x41, 0x12, 0x12, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e,
	0x4c, 0x6f, 0x67, 0x69, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45,
	0x6d, 0x70, 0x74, 0x79, 0x12, 0x3d, 0x0a, 0x0f, 0x4c, 0x6f, 0x67, 0x69, 0x6e, 0x32, 0x50, 0x61,
	0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x73, 0x12, 0x12, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x4c,
	0x6f, 0x67, 0x69, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d,
	0x70, 0x74, 0x79, 0x12, 0x3d, 0x0a, 0x0a, 0x4c, 0x6f, 0x67, 0x69, 0x6e, 0x41, 0x62, 0x6f, 0x72,
	0x74, 0x12, 0x17, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x4c, 0x6f, 0x67, 0x69, 0x6e, 0x41, 0x62,
	0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70,
	0x74, 0x79, 0x12, 0x3d, 0x0a, 0x0b, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x12, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74,
	0x79, 0x12, 0x3f, 0x0a, 0x0d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x12, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70,
	0x74, 0x79, 0x12, 0x4c, 0x0a, 0x16, 0x53, 0x65, 0x74, 0x49, 0x73, 0x41, 0x75, 0x74, 0x6f, 0x6d,
	0x61, 0x74, 0x69, 0x63, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x12, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42,
	0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x12, 0x49, 0x0a, 0x13, 0x49, 0x73, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x12, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x45, 0x0a, 0x0d, 0x44,
	0x69, 0x73, 0x6b, 0x43, 0x61, 0x63, 0x68, 0x65, 0x50, 0x61, 0x74, 0x68, 0x12, 0x16, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45,
	0x6d, 0x70, 0x74, 0x79, 0x1a, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x48, 0x0a, 0x10, 0x53, 0x65, 0x74, 0x44, 0x69, 0x73, 0x6b, 0x43, 0x61, 0x63,
	0x68, 0x65, 0x50, 0x61, 0x74, 0x68, 0x12, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x45, 0x0a, 0x0f,
	0x53, 0x65, 0x74, 0x49, 0x73, 0x44, 0x6f, 0x48, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x1a, 0x16, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d,
	0x70, 0x74, 0x79, 0x12, 0x42, 0x0a, 0x0c, 0x49, 0x73, 0x44, 0x6f, 0x48, 0x45, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x12, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f,
	0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x44, 0x0a, 0x12, 0x4d, 0x61, 0x69, 0x6c, 0x53,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x16, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x16, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x49, 0x6d, 0x61,
	0x70, 0x53, 0x6d, 0x74, 0x70, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x47, 0x0a,
	0x15, 0x53, 0x65, 0x74, 0x4d, 0x61, 0x69, 0x6c, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x16, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x49, 0x6d,
	0x61, 0x70, 0x53, 0x6d, 0x74, 0x70, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x1a, 0x16,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x40, 0x0a, 0x08, 0x48, 0x6f, 0x73, 0x74, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x1c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72,
	0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x45, 0x0a, 0x0a, 0x49, 0x73, 0x50, 0x6f,
	0x72, 0x74, 0x46, 0x72, 0x65, 0x65, 0x12, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x1a, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12,
	0x4e, 0x0a, 0x12, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x4b, 0x65, 0x79, 0x63,
	0x68, 0x61, 0x69, 0x6e, 0x73, 0x12, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x20, 0x2e,
	0x67, 0x72, 0x70, 0x63, 0x2e, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x4b, 0x65,
	0x79, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x4a, 0x0a, 0x12, 0x53, 0x65, 0x74, 0x43, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x4b, 0x65, 0x79,
	0x63, 0x68, 0x61, 0x69, 0x6e, 0x12, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x47, 0x0a, 0x0f, 0x43,
	0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x4b, 0x65, 0x79, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x12, 0x16,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x12, 0x3d, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x55, 0x73, 0x65, 0x72, 0x4c,
	0x69, 0x73, 0x74, 0x12, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x16, 0x2e, 0x67, 0x72,
	0x70, 0x63, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x33, 0x0a, 0x07, 0x47, 0x65, 0x74, 0x55, 0x73, 0x65, 0x72, 0x12, 0x1c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x1a, 0x0a, 0x2e, 0x67,
	0x72, 0x70, 0x63, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x12, 0x46, 0x0a, 0x10, 0x53, 0x65, 0x74, 0x55,
	0x73, 0x65, 0x72, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x1a, 0x2e, 0x67,
	0x72, 0x70, 0x63, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x4d, 0x6f, 0x64,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x12, 0x55, 0x0a, 0x18, 0x53, 0x65, 0x6e, 0x64, 0x42, 0x61, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x55, 0x73, 0x65, 0x72, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x12, 0x21, 0x2e, 0x67,
	0x72, 0x70, 0x63, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x42, 0x61, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x42, 0x0a, 0x0a, 0x4c, 0x6f, 0x67, 0x6f, 0x75,
	0x74, 0x55, 0x73, 0x65, 0x72, 0x12, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x42, 0x0a, 0x0a, 0x52,
	0x65, 0x6d, 0x6f, 0x76, 0x65, 0x55, 0x73, 0x65, 0x72, 0x12, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12,
	0x51, 0x0a, 0x16, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x55, 0x73, 0x65, 0x72,
	0x41, 0x70, 0x70, 0x6c, 0x65, 0x4d, 0x61, 0x69, 0x6c, 0x12, 0x1f, 0x2e, 0x67, 0x72, 0x70, 0x63,
	0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x41, 0x70, 0x70, 0x6c, 0x65, 0x4d,
	0x61, 0x69, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70,
	0x74, 0x79, 0x12, 0x4f, 0x0a, 0x19, 0x49, 0x73, 0x54, 0x4c, 0x53, 0x43, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x12,
	0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x12, 0x47, 0x0a, 0x15, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x54, 0x4c,
	0x53, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x16, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45,
	0x6d, 0x70, 0x74, 0x79, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x4d, 0x0a, 0x15,
	0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x4c, 0x53, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x73, 0x12, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x3f, 0x0a, 0x0e, 0x52,
	0x75, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x18, 0x2e,
	0x67, 0x72, 0x70, 0x63, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x11, 0x2e, 0x67, 0x72, 0x70, 0x63, 0x2e, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x30, 0x01, 0x12, 0x41, 0x0a, 0x0f,
	0x53, 0x74, 0x6f, 0x70, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12,
	0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12,
	0x3f, 0x0a, 0x0d, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x52, 0x65, 0x70, 0x61, 0x69, 0x72,
	0x12, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x42, 0x36, 0x5a, 0x34, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x6e, 0x4d, 0x61, 0x69, 0x6c, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x6e,
	0x2d, 0x62, 0x72, 0x69, 0x64, 0x67, 0x65, 0x2f, 0x76, 0x33, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x2f, 0x67, 0x72, 0x70, 0x63, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_bridge_proto_rawDescOnce sync.Once
	file_bridge_proto_rawDescData = file_bridge_proto_rawDesc
)

func file_bridge_proto_rawDescGZIP() []byte {
	file_bridge_proto_rawDescOnce.Do(func() {
		file_bridge_proto_rawDescData = protoimpl.X.CompressGZIP(file_bridge_proto_rawDescData)
	})
	return file_bridge_proto_rawDescData
}

var file_bridge_proto_enumTypes = make([]protoimpl.EnumInfo, 7)
var file_bridge_proto_msgTypes = make([]protoimpl.MessageInfo, 73)
var file_bridge_proto_goTypes = []interface{}{
	(LogLevel)(0),                                 // 0: grpc.LogLevel
	(UserState)(0),                                // 1: grpc.UserState
	(LoginErrorType)(0),                           // 2: grpc.LoginErrorType
	(UpdateErrorType)(0),                          // 3: grpc.UpdateErrorType
	(DiskCacheErrorType)(0),                       // 4: grpc.DiskCacheErrorType
	(MailServerSettingsErrorType)(0),              // 5: grpc.MailServerSettingsErrorType
	(ErrorCode)(0),                                // 6: grpc.ErrorCode
	(*AddLogEntryRequest)(nil),                    // 7: grpc.AddLogEntryRequest
	(*GuiReadyResponse)(nil),                      // 8: grpc.GuiReadyResponse
	(*ReportBugRequest)(nil),                      // 9: grpc.ReportBugRequest
	(*LoginRequest)(nil),                          // 10: grpc.LoginRequest
	(*LoginAbortRequest)(nil),                     // 11: grpc.LoginAbortRequest
	(*ImapSmtpSettings)(nil),                      // 12: grpc.ImapSmtpSettings
	(*AvailableKeychainsResponse)(nil),            // 13: grpc.AvailableKeychainsResponse
	(*User)(nil),                                  // 14: grpc.User
	(*UserSplitModeRequest)(nil),                  // 15: grpc.UserSplitModeRequest
	(*UserBadEventFeedbackRequest)(nil),           // 16: grpc.UserBadEventFeedbackRequest
	(*UserListResponse)(nil),                      // 17: grpc.UserListResponse
	(*ConfigureAppleMailRequest)(nil),             // 18: grpc.ConfigureAppleMailRequest
	(*EventStreamRequest)(nil),                    // 19: grpc.EventStreamRequest
	(*StreamEvent)(nil),                           // 20: grpc.StreamEvent
	(*AppEvent)(nil),                              // 21: grpc.AppEvent
	(*InternetStatusEvent)(nil),                   // 22: grpc.InternetStatusEvent
	(*ToggleAutostartFinishedEvent)(nil),          // 23: grpc.ToggleAutostartFinishedEvent
	(*ResetFinishedEvent)(nil),                    // 24: grpc.ResetFinishedEvent
	(*ReportBugFinishedEvent)(nil),                // 25: grpc.ReportBugFinishedEvent
	(*ReportBugSuccessEvent)(nil),                 // 26: grpc.ReportBugSuccessEvent
	(*ReportBugErrorEvent)(nil),                   // 27: grpc.ReportBugErrorEvent
	(*ShowMainWindowEvent)(nil),                   // 28: grpc.ShowMainWindowEvent
	(*ReportBugFallbackEvent)(nil),                // 29: grpc.ReportBugFallbackEvent
	(*CertificateInstallSuccessEvent)(nil),        // 30: grpc.CertificateInstallSuccessEvent
	(*CertificateInstallCanceledEvent)(nil),       // 31: grpc.CertificateInstallCanceledEvent
	(*CertificateInstallFailedEvent)(nil),         // 32: grpc.CertificateInstallFailedEvent
	(*RepairStartedEvent)(nil),                    // 33: grpc.RepairStartedEvent
	(*AllUsersLoadedEvent)(nil),                   // 34: grpc.AllUsersLoadedEvent
	(*KnowledgeBaseSuggestion)(nil),               // 35: grpc.KnowledgeBaseSuggestion
	(*KnowledgeBaseSuggestionsEvent)(nil),         // 36: grpc.KnowledgeBaseSuggestionsEvent
	(*LoginEvent)(nil),                            // 37: grpc.LoginEvent
	(*LoginErrorEvent)(nil),                       // 38: grpc.LoginErrorEvent
	(*LoginTfaRequestedEvent)(nil),                // 39: grpc.LoginTfaRequestedEvent
	(*LoginTwoPasswordsRequestedEvent)(nil),       // 40: grpc.LoginTwoPasswordsRequestedEvent
	(*LoginFinishedEvent)(nil),                    // 41: grpc.LoginFinishedEvent
	(*LoginHvRequestedEvent)(nil),                 // 42: grpc.LoginHvRequestedEvent
	(*UpdateEvent)(nil),                           // 43: grpc.UpdateEvent
	(*UpdateErrorEvent)(nil),                      // 44: grpc.UpdateErrorEvent
	(*UpdateManualReadyEvent)(nil),                // 45: grpc.UpdateManualReadyEvent
	(*UpdateManualRestartNeededEvent)(nil),        // 46: grpc.UpdateManualRestartNeededEvent
	(*UpdateForceEvent)(nil),                      // 47: grpc.UpdateForceEvent
	(*UpdateSilentRestartNeeded)(nil),             // 48: grpc.UpdateSilentRestartNeeded
	(*UpdateIsLatestVersion)(nil),                 // 49: grpc.UpdateIsLatestVersion
	(*UpdateCheckFinished)(nil),                   // 50: grpc.UpdateCheckFinished
	(*UpdateVersionChanged)(nil),                  // 51: grpc.UpdateVersionChanged
	(*DiskCacheEvent)(nil),                        // 52: grpc.DiskCacheEvent
	(*DiskCacheErrorEvent)(nil),                   // 53: grpc.DiskCacheErrorEvent
	(*DiskCachePathChangedEvent)(nil),             // 54: grpc.DiskCachePathChangedEvent
	(*DiskCachePathChangeFinishedEvent)(nil),      // 55: grpc.DiskCachePathChangeFinishedEvent
	(*MailServerSettingsEvent)(nil),               // 56: grpc.MailServerSettingsEvent
	(*MailServerSettingsErrorEvent)(nil),          // 57: grpc.MailServerSettingsErrorEvent
	(*MailServerSettingsChangedEvent)(nil),        // 58: grpc.MailServerSettingsChangedEvent
	(*ChangeMailServerSettingsFinishedEvent)(nil), // 59: grpc.ChangeMailServerSettingsFinishedEvent
	(*KeychainEvent)(nil),                         // 60: grpc.KeychainEvent
	(*ChangeKeychainFinishedEvent)(nil),           // 61: grpc.ChangeKeychainFinishedEvent
	(*HasNoKeychainEvent)(nil),                    // 62: grpc.HasNoKeychainEvent
	(*RebuildKeychainEvent)(nil),                  // 63: grpc.RebuildKeychainEvent
	(*MailEvent)(nil),                             // 64: grpc.MailEvent
	(*AddressChangedEvent)(nil),                   // 65: grpc.AddressChangedEvent
	(*AddressChangedLogoutEvent)(nil),             // 66: grpc.AddressChangedLogoutEvent
	(*ApiCertIssueEvent)(nil),                     // 67: grpc.ApiCertIssueEvent
	(*UserEvent)(nil),                             // 68: grpc.UserEvent
	(*ToggleSplitModeFinishedEvent)(nil),          // 69: grpc.ToggleSplitModeFinishedEvent
	(*UserDisconnectedEvent)(nil),                 // 70: grpc.UserDisconnectedEvent
	(*UserChangedEvent)(nil),                      // 71: grpc.UserChangedEvent
	(*UserBadEvent)(nil),                          // 72: grpc.UserBadEvent
	(*UsedBytesChangedEvent)(nil),                 // 73: grpc.UsedBytesChangedEvent
	(*ImapLoginFailedEvent)(nil),                  // 74: grpc.ImapLoginFailedEvent
	(*SyncStartedEvent)(nil),                      // 75: grpc.SyncStartedEvent
	(*SyncFinishedEvent)(nil),                     // 76: grpc.SyncFinishedEvent
	(*SyncProgressEvent)(nil),                     // 77: grpc.SyncProgressEvent
	(*UserNotificationEvent)(nil),                 // 78: grpc.UserNotificationEvent
	(*GenericErrorEvent)(nil),                     // 79: grpc.GenericErrorEvent
	(*wrapperspb.StringValue)(nil),                // 80: google.protobuf.StringValue
	(*emptypb.Empty)(nil),                         // 81: google.protobuf.Empty
	(*wrapperspb.BoolValue)(nil),                  // 82: google.protobuf.BoolValue
	(*wrapperspb.Int32Value)(nil),                 // 83: google.protobuf.Int32Value
}
var file_bridge_proto_depIdxs = []int32{
	0,   // 0: grpc.AddLogEntryRequest.level:type_name -> grpc.LogLevel
	1,   // 1: grpc.User.state:type_name -> grpc.UserState
	14,  // 2: grpc.UserListResponse.users:type_name -> grpc.User
	21,  // 3: grpc.StreamEvent.app:type_name -> grpc.AppEvent
	37,  // 4: grpc.StreamEvent.login:type_name -> grpc.LoginEvent
	43,  // 5: grpc.StreamEvent.update:type_name -> grpc.UpdateEvent
	52,  // 6: grpc.StreamEvent.cache:type_name -> grpc.DiskCacheEvent
	56,  // 7: grpc.StreamEvent.mailServerSettings:type_name -> grpc.MailServerSettingsEvent
	60,  // 8: grpc.StreamEvent.keychain:type_name -> grpc.KeychainEvent
	64,  // 9: grpc.StreamEvent.mail:type_name -> grpc.MailEvent
	68,  // 10: grpc.StreamEvent.user:type_name -> grpc.UserEvent
	79,  // 11: grpc.StreamEvent.genericError:type_name -> grpc.GenericErrorEvent
	22,  // 12: grpc.AppEvent.internetStatus:type_name -> grpc.InternetStatusEvent
	23,  // 13: grpc.AppEvent.toggleAutostartFinished:type_name -> grpc.ToggleAutostartFinishedEvent
	24,  // 14: grpc.AppEvent.resetFinished:type_name -> grpc.ResetFinishedEvent
	25,  // 15: grpc.AppEvent.reportBugFinished:type_name -> grpc.ReportBugFinishedEvent
	26,  // 16: grpc.AppEvent.reportBugSuccess:type_name -> grpc.ReportBugSuccessEvent
	27,  // 17: grpc.AppEvent.reportBugError:type_name -> grpc.ReportBugErrorEvent
	28,  // 18: grpc.AppEvent.showMainWindow:type_name -> grpc.ShowMainWindowEvent
	29,  // 19: grpc.AppEvent.reportBugFallback:type_name -> grpc.ReportBugFallbackEvent
	30,  // 20: grpc.AppEvent.certificateInstallSuccess:type_name -> grpc.CertificateInstallSuccessEvent
	31,  // 21: grpc.AppEvent.certificateInstallCanceled:type_name -> grpc.CertificateInstallCanceledEvent
	32,  // 22: grpc.AppEvent.certificateInstallFailed:type_name -> grpc.CertificateInstallFailedEvent
	36,  // 23: grpc.AppEvent.knowledgeBaseSuggestions:type_name -> grpc.KnowledgeBaseSuggestionsEvent
	33,  // 24: grpc.AppEvent.repairStarted:type_name -> grpc.RepairStartedEvent
	34,  // 25: grpc.AppEvent.allUsersLoaded:type_name -> grpc.AllUsersLoadedEvent
	78,  // 26: grpc.AppEvent.userNotification:type_name -> grpc.UserNotificationEvent
	35,  // 27: grpc.KnowledgeBaseSuggestionsEvent.suggestions:type_name -> grpc.KnowledgeBaseSuggestion
	38,  // 28: grpc.LoginEvent.error:type_name -> grpc.LoginErrorEvent
	39,  // 29: grpc.LoginEvent.tfaRequested:type_name -> grpc.LoginTfaRequestedEvent
	40,  // 30: grpc.LoginEvent.twoPasswordRequested:type_name -> grpc.LoginTwoPasswordsRequestedEvent
	41,  // 31: grpc.LoginEvent.finished:type_name -> grpc.LoginFinishedEvent
	41,  // 32: grpc.LoginEvent.alreadyLoggedIn:type_name -> grpc.LoginFinishedEvent
	42,  // 33: grpc.LoginEvent.hvRequested:type_name -> grpc.LoginHvRequestedEvent
	2,   // 34: grpc.LoginErrorEvent.type:type_name -> grpc.LoginErrorType
	44,  // 35: grpc.UpdateEvent.error:type_name -> grpc.UpdateErrorEvent
	45,  // 36: grpc.UpdateEvent.manualReady:type_name -> grpc.UpdateManualReadyEvent
	46,  // 37: grpc.UpdateEvent.manualRestartNeeded:type_name -> grpc.UpdateManualRestartNeededEvent
	47,  // 38: grpc.UpdateEvent.force:type_name -> grpc.UpdateForceEvent
	48,  // 39: grpc.UpdateEvent.silentRestartNeeded:type_name -> grpc.UpdateSilentRestartNeeded
	49,  // 40: grpc.UpdateEvent.isLatestVersion:type_name -> grpc.UpdateIsLatestVersion
	50,  // 41: grpc.UpdateEvent.checkFinished:type_name -> grpc.UpdateCheckFinished
	51,  // 42: grpc.UpdateEvent.versionChanged:type_name -> grpc.UpdateVersionChanged
	3,   // 43: grpc.UpdateErrorEvent.type:type_name -> grpc.UpdateErrorType
	53,  // 44: grpc.DiskCacheEvent.error:type_name -> grpc.DiskCacheErrorEvent
	54,  // 45: grpc.DiskCacheEvent.pathChanged:type_name -> grpc.DiskCachePathChangedEvent
	55,  // 46: grpc.DiskCacheEvent.pathChangeFinished:type_name -> grpc.DiskCachePathChangeFinishedEvent
	4,   // 47: grpc.DiskCacheErrorEvent.type:type_name -> grpc.DiskCacheErrorType
	57,  // 48: grpc.MailServerSettingsEvent.error:type_name -> grpc.MailServerSettingsErrorEvent
	58,  // 49: grpc.MailServerSettingsEvent.mailServerSettingsChanged:type_name -> grpc.MailServerSettingsChangedEvent
	59,  // 50: grpc.MailServerSettingsEvent.changeMailServerSettingsFinished:type_name -> grpc.ChangeMailServerSettingsFinishedEvent
	5,   // 51: grpc.MailServerSettingsErrorEvent.type:type_name -> grpc.MailServerSettingsErrorType
	12,  // 52: grpc.MailServerSettingsChangedEvent.settings:type_name -> grpc.ImapSmtpSettings
	61,  // 53: grpc.KeychainEvent.changeKeychainFinished:type_name -> grpc.ChangeKeychainFinishedEvent
	62,  // 54: grpc.KeychainEvent.hasNoKeychain:type_name -> grpc.HasNoKeychainEvent
	63,  // 55: grpc.KeychainEvent.rebuildKeychain:type_name -> grpc.RebuildKeychainEvent
	65,  // 56: grpc.MailEvent.addressChanged:type_name -> grpc.AddressChangedEvent
	66,  // 57: grpc.MailEvent.addressChangedLogout:type_name -> grpc.AddressChangedLogoutEvent
	67,  // 58: grpc.MailEvent.apiCertIssue:type_name -> grpc.ApiCertIssueEvent
	69,  // 59: grpc.UserEvent.toggleSplitModeFinished:type_name -> grpc.ToggleSplitModeFinishedEvent
	70,  // 60: grpc.UserEvent.userDisconnected:type_name -> grpc.UserDisconnectedEvent
	71,  // 61: grpc.UserEvent.userChanged:type_name -> grpc.UserChangedEvent
	72,  // 62: grpc.UserEvent.userBadEvent:type_name -> grpc.UserBadEvent
	73,  // 63: grpc.UserEvent.usedBytesChangedEvent:type_name -> grpc.UsedBytesChangedEvent
	74,  // 64: grpc.UserEvent.imapLoginFailedEvent:type_name -> grpc.ImapLoginFailedEvent
	75,  // 65: grpc.UserEvent.syncStartedEvent:type_name -> grpc.SyncStartedEvent
	76,  // 66: grpc.UserEvent.syncFinishedEvent:type_name -> grpc.SyncFinishedEvent
	77,  // 67: grpc.UserEvent.syncProgressEvent:type_name -> grpc.SyncProgressEvent
	6,   // 68: grpc.GenericErrorEvent.code:type_name -> grpc.ErrorCode
	80,  // 69: grpc.Bridge.CheckTokens:input_type -> google.protobuf.StringValue
	7,   // 70: grpc.Bridge.AddLogEntry:input_type -> grpc.AddLogEntryRequest
	81,  // 71: grpc.Bridge.GuiReady:input_type -> google.protobuf.Empty
	81,  // 72: grpc.Bridge.Quit:input_type -> google.protobuf.Empty
	81,  // 73: grpc.Bridge.Restart:input_type -> google.protobuf.Empty
	81,  // 74: grpc.Bridge.ShowOnStartup:input_type -> google.protobuf.Empty
	82,  // 75: grpc.Bridge.SetIsAutostartOn:input_type -> google.protobuf.BoolValue
	81,  // 76: grpc.Bridge.IsAutostartOn:input_type -> google.protobuf.Empty
	82,  // 77: grpc.Bridge.SetIsBetaEnabled:input_type -> google.protobuf.BoolValue
	81,  // 78: grpc.Bridge.IsBetaEnabled:input_type -> google.protobuf.Empty
	82,  // 79: grpc.Bridge.SetIsAllMailVisible:input_type -> google.protobuf.BoolValue
	81,  // 80: grpc.Bridge.IsAllMailVisible:input_type -> google.protobuf.Empty
	82,  // 81: grpc.Bridge.SetIsTelemetryDisabled:input_type -> google.protobuf.BoolValue
	81,  // 82: grpc.Bridge.IsTelemetryDisabled:input_type -> google.protobuf.Empty
	81,  // 83: grpc.Bridge.GoOs:input_type -> google.protobuf.Empty
	81,  // 84: grpc.Bridge.TriggerReset:input_type -> google.protobuf.Empty
	81,  // 85: grpc.Bridge.Version:input_type -> google.protobuf.Empty
	81,  // 86: grpc.Bridge.LogsPath:input_type -> google.protobuf.Empty
	81,  // 87: grpc.Bridge.LicensePath:input_type -> google.protobuf.Empty
	81,  // 88: grpc.Bridge.ReleaseNotesPageLink:input_type -> google.protobuf.Empty
	81,  // 89: grpc.Bridge.DependencyLicensesLink:input_type -> google.protobuf.Empty
	81,  // 90: grpc.Bridge.LandingPageLink:input_type -> google.protobuf.Empty
	80,  // 91: grpc.Bridge.SetColorSchemeName:input_type -> google.protobuf.StringValue
	81,  // 92: grpc.Bridge.ColorSchemeName:input_type -> google.protobuf.Empty
	81,  // 93: grpc.Bridge.CurrentEmailClient:input_type -> google.protobuf.Empty
	9,   // 94: grpc.Bridge.ReportBug:input_type -> grpc.ReportBugRequest
	80,  // 95: grpc.Bridge.ForceLauncher:input_type -> google.protobuf.StringValue
	80,  // 96: grpc.Bridge.SetMainExecutable:input_type -> google.protobuf.StringValue
	80,  // 97: grpc.Bridge.RequestKnowledgeBaseSuggestions:input_type -> google.protobuf.StringValue
	10,  // 98: grpc.Bridge.Login:input_type -> grpc.LoginRequest
	10,  // 99: grpc.Bridge.Login2FA:input_type -> grpc.LoginRequest
	10,  // 100: grpc.Bridge.Login2Passwords:input_type -> grpc.LoginRequest
	11,  // 101: grpc.Bridge.LoginAbort:input_type -> grpc.LoginAbortRequest
	81,  // 102: grpc.Bridge.CheckUpdate:input_type -> google.protobuf.Empty
	81,  // 103: grpc.Bridge.InstallUpdate:input_type -> google.protobuf.Empty
	82,  // 104: grpc.Bridge.SetIsAutomaticUpdateOn:input_type -> google.protobuf.BoolValue
	81,  // 105: grpc.Bridge.IsAutomaticUpdateOn:input_type -> google.protobuf.Empty
	81,  // 106: grpc.Bridge.DiskCachePath:input_type -> google.protobuf.Empty
	80,  // 107: grpc.Bridge.SetDiskCachePath:input_type -> google.protobuf.StringValue
	82,  // 108: grpc.Bridge.SetIsDoHEnabled:input_type -> google.protobuf.BoolValue
	81,  // 109: grpc.Bridge.IsDoHEnabled:input_type -> google.protobuf.Empty
	81,  // 110: grpc.Bridge.MailServerSettings:input_type -> google.protobuf.Empty
	12,  // 111: grpc.Bridge.SetMailServerSettings:input_type -> grpc.ImapSmtpSettings
	81,  // 112: grpc.Bridge.Hostname:input_type -> google.protobuf.Empty
	83,  // 113: grpc.Bridge.IsPortFree:input_type -> google.protobuf.Int32Value
	81,  // 114: grpc.Bridge.AvailableKeychains:input_type -> google.protobuf.Empty
	80,  // 115: grpc.Bridge.SetCurrentKeychain:input_type -> google.protobuf.StringValue
	81,  // 116: grpc.Bridge.CurrentKeychain:input_type -> google.protobuf.Empty
	81,  // 117: grpc.Bridge.GetUserList:input_type -> google.protobuf.Empty
	80,  // 118: grpc.Bridge.GetUser:input_type -> google.protobuf.StringValue
	15,  // 119: grpc.Bridge.SetUserSplitMode:input_type -> grpc.UserSplitModeRequest
	16,  // 120: grpc.Bridge.SendBadEventUserFeedback:input_type -> grpc.UserBadEventFeedbackRequest
	80,  // 121: grpc.Bridge.LogoutUser:input_type -> google.protobuf.StringValue
	80,  // 122: grpc.Bridge.RemoveUser:input_type -> google.protobuf.StringValue
	18,  // 123: grpc.Bridge.ConfigureUserAppleMail:input_type -> grpc.ConfigureAppleMailRequest
	81,  // 124: grpc.Bridge.IsTLSCertificateInstalled:input_type -> google.protobuf.Empty
	81,  // 125: grpc.Bridge.InstallTLSCertificate:input_type -> google.protobuf.Empty
	80,  // 126: grpc.Bridge.ExportTLSCertificates:input_type -> google.protobuf.StringValue
	19,  // 127: grpc.Bridge.RunEventStream:input_type -> grpc.EventStreamRequest
	81,  // 128: grpc.Bridge.StopEventStream:input_type -> google.protobuf.Empty
	81,  // 129: grpc.Bridge.TriggerRepair:input_type -> google.protobuf.Empty
	80,  // 130: grpc.Bridge.CheckTokens:output_type -> google.protobuf.StringValue
	81,  // 131: grpc.Bridge.AddLogEntry:output_type -> google.protobuf.Empty
	8,   // 132: grpc.Bridge.GuiReady:output_type -> grpc.GuiReadyResponse
	81,  // 133: grpc.Bridge.Quit:output_type -> google.protobuf.Empty
	81,  // 134: grpc.Bridge.Restart:output_type -> google.protobuf.Empty
	82,  // 135: grpc.Bridge.ShowOnStartup:output_type -> google.protobuf.BoolValue
	81,  // 136: grpc.Bridge.SetIsAutostartOn:output_type -> google.protobuf.Empty
	82,  // 137: grpc.Bridge.IsAutostartOn:output_type -> google.protobuf.BoolValue
	81,  // 138: grpc.Bridge.SetIsBetaEnabled:output_type -> google.protobuf.Empty
	82,  // 139: grpc.Bridge.IsBetaEnabled:output_type -> google.protobuf.BoolValue
	81,  // 140: grpc.Bridge.SetIsAllMailVisible:output_type -> google.protobuf.Empty
	82,  // 141: grpc.Bridge.IsAllMailVisible:output_type -> google.protobuf.BoolValue
	81,  // 142: grpc.Bridge.SetIsTelemetryDisabled:output_type -> google.protobuf.Empty
	82,  // 143: grpc.Bridge.IsTelemetryDisabled:output_type -> google.protobuf.BoolValue
	80,  // 144: grpc.Bridge.GoOs:output_type -> google.protobuf.StringValue
	81,  // 145: grpc.Bridge.TriggerReset:output_type -> google.protobuf.Empty
	80,  // 146: grpc.Bridge.Version:output_type -> google.protobuf.StringValue
	80,  // 147: grpc.Bridge.LogsPath:output_type -> google.protobuf.StringValue
	80,  // 148: grpc.Bridge.LicensePath:output_type -> google.protobuf.StringValue
	80,  // 149: grpc.Bridge.ReleaseNotesPageLink:output_type -> google.protobuf.StringValue
	80,  // 150: grpc.Bridge.DependencyLicensesLink:output_type -> google.protobuf.StringValue
	80,  // 151: grpc.Bridge.LandingPageLink:output_type -> google.protobuf.StringValue
	81,  // 152: grpc.Bridge.SetColorSchemeName:output_type -> google.protobuf.Empty
	80,  // 153: grpc.Bridge.ColorSchemeName:output_type -> google.protobuf.StringValue
	80,  // 154: grpc.Bridge.CurrentEmailClient:output_type -> google.protobuf.StringValue
	81,  // 155: grpc.Bridge.ReportBug:output_type -> google.protobuf.Empty
	81,  // 156: grpc.Bridge.ForceLauncher:output_type -> google.protobuf.Empty
	81,  // 157: grpc.Bridge.SetMainExecutable:output_type -> google.protobuf.Empty
	81,  // 158: grpc.Bridge.RequestKnowledgeBaseSuggestions:output_type -> google.protobuf.Empty
	81,  // 159: grpc.Bridge.Login:output_type -> google.protobuf.Empty
	81,  // 160: grpc.Bridge.Login2FA:output_type -> google.protobuf.Empty
	81,  // 161: grpc.Bridge.Login2Passwords:output_type -> google.protobuf.Empty
	81,  // 162: grpc.Bridge.LoginAbort:output_type -> google.protobuf.Empty
	81,  // 163: grpc.Bridge.CheckUpdate:output_type -> google.protobuf.Empty
	81,  // 164: grpc.Bridge.InstallUpdate:output_type -> google.protobuf.Empty
	81,  // 165: grpc.Bridge.SetIsAutomaticUpdateOn:output_type -> google.protobuf.Empty
	82,  // 166: grpc.Bridge.IsAutomaticUpdateOn:output_type -> google.protobuf.BoolValue
	80,  // 167: grpc.Bridge.DiskCachePath:output_type -> google.protobuf.StringValue
	81,  // 168: grpc.Bridge.SetDiskCachePath:output_type -> google.protobuf.Empty
	81,  // 169: grpc.Bridge.SetIsDoHEnabled:output_type -> google.protobuf.Empty
	82,  // 170: grpc.Bridge.IsDoHEnabled:output_type -> google.protobuf.BoolValue
	12,  // 171: grpc.Bridge.MailServerSettings:output_type -> grpc.ImapSmtpSettings
	81,  // 172: grpc.Bridge.SetMailServerSettings:output_type -> google.protobuf.Empty
	80,  // 173: grpc.Bridge.Hostname:output_type -> google.protobuf.StringValue
	82,  // 174: grpc.Bridge.IsPortFree:output_type -> google.protobuf.BoolValue
	13,  // 175: grpc.Bridge.AvailableKeychains:output_type -> grpc.AvailableKeychainsResponse
	81,  // 176: grpc.Bridge.SetCurrentKeychain:output_type -> google.protobuf.Empty
	80,  // 177: grpc.Bridge.CurrentKeychain:output_type -> google.protobuf.StringValue
	17,  // 178: grpc.Bridge.GetUserList:output_type -> grpc.UserListResponse
	14,  // 179: grpc.Bridge.GetUser:output_type -> grpc.User
	81,  // 180: grpc.Bridge.SetUserSplitMode:output_type -> google.protobuf.Empty
	81,  // 181: grpc.Bridge.SendBadEventUserFeedback:output_type -> google.protobuf.Empty
	81,  // 182: grpc.Bridge.LogoutUser:output_type -> google.protobuf.Empty
	81,  // 183: grpc.Bridge.RemoveUser:output_type -> google.protobuf.Empty
	81,  // 184: grpc.Bridge.ConfigureUserAppleMail:output_type -> google.protobuf.Empty
	82,  // 185: grpc.Bridge.IsTLSCertificateInstalled:output_type -> google.protobuf.BoolValue
	81,  // 186: grpc.Bridge.InstallTLSCertificate:output_type -> google.protobuf.Empty
	81,  // 187: grpc.Bridge.ExportTLSCertificates:output_type -> google.protobuf.Empty
	20,  // 188: grpc.Bridge.RunEventStream:output_type -> grpc.StreamEvent
	81,  // 189: grpc.Bridge.StopEventStream:output_type -> google.protobuf.Empty
	81,  // 190: grpc.Bridge.TriggerRepair:output_type -> google.protobuf.Empty
	130, // [130:191] is the sub-list for method output_type
	69,  // [69:130] is the sub-list for method input_type
	69,  // [69:69] is the sub-list for extension type_name
	69,  // [69:69] is the sub-list for extension extendee
	0,   // [0:69] is the sub-list for field type_name
}

func init() { file_bridge_proto_init() }
func file_bridge_proto_init() {
	if File_bridge_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_bridge_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddLogEntryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GuiReadyResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportBugRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LoginRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LoginAbortRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImapSmtpSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AvailableKeychainsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*User); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UserSplitModeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UserBadEventFeedbackRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UserListResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConfigureAppleMailRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EventStreamRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AppEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InternetStatusEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ToggleAutostartFinishedEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResetFinishedEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportBugFinishedEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportBugSuccessEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportBugErrorEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShowMainWindowEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportBugFallbackEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CertificateInstallSuccessEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CertificateInstallCanceledEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CertificateInstallFailedEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RepairStartedEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AllUsersLoadedEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KnowledgeBaseSuggestion); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KnowledgeBaseSuggestionsEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LoginEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LoginErrorEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LoginTfaRequestedEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LoginTwoPasswordsRequestedEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LoginFinishedEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LoginHvRequestedEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateErrorEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateManualReadyEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateManualRestartNeededEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateForceEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateSilentRestartNeeded); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateIsLatestVersion); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateCheckFinished); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateVersionChanged); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DiskCacheEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DiskCacheErrorEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DiskCachePathChangedEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DiskCachePathChangeFinishedEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MailServerSettingsEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[50].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MailServerSettingsErrorEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MailServerSettingsChangedEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ChangeMailServerSettingsFinishedEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[53].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KeychainEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[54].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ChangeKeychainFinishedEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[55].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HasNoKeychainEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[56].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RebuildKeychainEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[57].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MailEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[58].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddressChangedEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[59].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddressChangedLogoutEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[60].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApiCertIssueEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[61].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UserEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[62].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ToggleSplitModeFinishedEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[63].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UserDisconnectedEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[64].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UserChangedEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[65].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UserBadEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[66].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UsedBytesChangedEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[67].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImapLoginFailedEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[68].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SyncStartedEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[69].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SyncFinishedEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[70].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SyncProgressEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[71].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UserNotificationEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_bridge_proto_msgTypes[72].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenericErrorEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_bridge_proto_msgTypes[3].OneofWrappers = []interface{}{}
	file_bridge_proto_msgTypes[13].OneofWrappers = []interface{}{
		(*StreamEvent_App)(nil),
		(*StreamEvent_Login)(nil),
		(*StreamEvent_Update)(nil),
		(*StreamEvent_Cache)(nil),
		(*StreamEvent_MailServerSettings)(nil),
		(*StreamEvent_Keychain)(nil),
		(*StreamEvent_Mail)(nil),
		(*StreamEvent_User)(nil),
		(*StreamEvent_GenericError)(nil),
	}
	file_bridge_proto_msgTypes[14].OneofWrappers = []interface{}{
		(*AppEvent_InternetStatus)(nil),
		(*AppEvent_ToggleAutostartFinished)(nil),
		(*AppEvent_ResetFinished)(nil),
		(*AppEvent_ReportBugFinished)(nil),
		(*AppEvent_ReportBugSuccess)(nil),
		(*AppEvent_ReportBugError)(nil),
		(*AppEvent_ShowMainWindow)(nil),
		(*AppEvent_ReportBugFallback)(nil),
		(*AppEvent_CertificateInstallSuccess)(nil),
		(*AppEvent_CertificateInstallCanceled)(nil),
		(*AppEvent_CertificateInstallFailed)(nil),
		(*AppEvent_KnowledgeBaseSuggestions)(nil),
		(*AppEvent_RepairStarted)(nil),
		(*AppEvent_AllUsersLoaded)(nil),
		(*AppEvent_UserNotification)(nil),
	}
	file_bridge_proto_msgTypes[30].OneofWrappers = []interface{}{
		(*LoginEvent_Error)(nil),
		(*LoginEvent_TfaRequested)(nil),
		(*LoginEvent_TwoPasswordRequested)(nil),
		(*LoginEvent_Finished)(nil),
		(*LoginEvent_AlreadyLoggedIn)(nil),
		(*LoginEvent_HvRequested)(nil),
	}
	file_bridge_proto_msgTypes[36].OneofWrappers = []interface{}{
		(*UpdateEvent_Error)(nil),
		(*UpdateEvent_ManualReady)(nil),
		(*UpdateEvent_ManualRestartNeeded)(nil),
		(*UpdateEvent_Force)(nil),
		(*UpdateEvent_SilentRestartNeeded)(nil),
		(*UpdateEvent_IsLatestVersion)(nil),
		(*UpdateEvent_CheckFinished)(nil),
		(*UpdateEvent_VersionChanged)(nil),
	}
	file_bridge_proto_msgTypes[45].OneofWrappers = []interface{}{
		(*DiskCacheEvent_Error)(nil),
		(*DiskCacheEvent_PathChanged)(nil),
		(*DiskCacheEvent_PathChangeFinished)(nil),
	}
	file_bridge_proto_msgTypes[49].OneofWrappers = []interface{}{
		(*MailServerSettingsEvent_Error)(nil),
		(*MailServerSettingsEvent_MailServerSettingsChanged)(nil),
		(*MailServerSettingsEvent_ChangeMailServerSettingsFinished)(nil),
	}
	file_bridge_proto_msgTypes[53].OneofWrappers = []interface{}{
		(*KeychainEvent_ChangeKeychainFinished)(nil),
		(*KeychainEvent_HasNoKeychain)(nil),
		(*KeychainEvent_RebuildKeychain)(nil),
	}
	file_bridge_proto_msgTypes[57].OneofWrappers = []interface{}{
		(*MailEvent_AddressChanged)(nil),
		(*MailEvent_AddressChangedLogout)(nil),
		(*MailEvent_ApiCertIssue)(nil),
	}
	file_bridge_proto_msgTypes[61].OneofWrappers = []interface{}{
		(*UserEvent_ToggleSplitModeFinished)(nil),
		(*UserEvent_UserDisconnected)(nil),
		(*UserEvent_UserChanged)(nil),
		(*UserEvent_UserBadEvent)(nil),
		(*UserEvent_UsedBytesChangedEvent)(nil),
		(*UserEvent_ImapLoginFailedEvent)(nil),
		(*UserEvent_SyncStartedEvent)(nil),
		(*UserEvent_SyncFinishedEvent)(nil),
		(*UserEvent_SyncProgressEvent)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_bridge_proto_rawDesc,
			NumEnums:      7,
			NumMessages:   73,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_bridge_proto_goTypes,
		DependencyIndexes: file_bridge_proto_depIdxs,
		EnumInfos:         file_bridge_proto_enumTypes,
		MessageInfos:      file_bridge_proto_msgTypes,
	}.Build()
	File_bridge_proto = out.File
	file_bridge_proto_rawDesc = nil
	file_bridge_proto_goTypes = nil
	file_bridge_proto_depIdxs = nil
}
