// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package mwaaiface provides an interface to enable mocking the AmazonMWAA service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package mwaaiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/mwaa"
)

// MWAAAPI provides an interface to enable mocking the
// mwaa.MWAA service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // AmazonMWAA.
//    func myFunc(svc mwaaiface.MWAAAPI) bool {
//        // Make svc.CreateCliToken request
//    }
//
//    func main() {
//        sess := session.New()
//        svc := mwaa.New(sess)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockMWAAClient struct {
//        mwaaiface.MWAAAPI
//    }
//    func (m *mockMWAAClient) CreateCliToken(input *mwaa.CreateCliTokenInput) (*mwaa.CreateCliTokenOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockMWAAClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type MWAAAPI interface {
	CreateCliToken(*mwaa.CreateCliTokenInput) (*mwaa.CreateCliTokenOutput, error)
	CreateCliTokenWithContext(aws.Context, *mwaa.CreateCliTokenInput, ...request.Option) (*mwaa.CreateCliTokenOutput, error)
	CreateCliTokenRequest(*mwaa.CreateCliTokenInput) (*request.Request, *mwaa.CreateCliTokenOutput)

	CreateEnvironment(*mwaa.CreateEnvironmentInput) (*mwaa.CreateEnvironmentOutput, error)
	CreateEnvironmentWithContext(aws.Context, *mwaa.CreateEnvironmentInput, ...request.Option) (*mwaa.CreateEnvironmentOutput, error)
	CreateEnvironmentRequest(*mwaa.CreateEnvironmentInput) (*request.Request, *mwaa.CreateEnvironmentOutput)

	CreateWebLoginToken(*mwaa.CreateWebLoginTokenInput) (*mwaa.CreateWebLoginTokenOutput, error)
	CreateWebLoginTokenWithContext(aws.Context, *mwaa.CreateWebLoginTokenInput, ...request.Option) (*mwaa.CreateWebLoginTokenOutput, error)
	CreateWebLoginTokenRequest(*mwaa.CreateWebLoginTokenInput) (*request.Request, *mwaa.CreateWebLoginTokenOutput)

	DeleteEnvironment(*mwaa.DeleteEnvironmentInput) (*mwaa.DeleteEnvironmentOutput, error)
	DeleteEnvironmentWithContext(aws.Context, *mwaa.DeleteEnvironmentInput, ...request.Option) (*mwaa.DeleteEnvironmentOutput, error)
	DeleteEnvironmentRequest(*mwaa.DeleteEnvironmentInput) (*request.Request, *mwaa.DeleteEnvironmentOutput)

	GetEnvironment(*mwaa.GetEnvironmentInput) (*mwaa.GetEnvironmentOutput, error)
	GetEnvironmentWithContext(aws.Context, *mwaa.GetEnvironmentInput, ...request.Option) (*mwaa.GetEnvironmentOutput, error)
	GetEnvironmentRequest(*mwaa.GetEnvironmentInput) (*request.Request, *mwaa.GetEnvironmentOutput)

	ListEnvironments(*mwaa.ListEnvironmentsInput) (*mwaa.ListEnvironmentsOutput, error)
	ListEnvironmentsWithContext(aws.Context, *mwaa.ListEnvironmentsInput, ...request.Option) (*mwaa.ListEnvironmentsOutput, error)
	ListEnvironmentsRequest(*mwaa.ListEnvironmentsInput) (*request.Request, *mwaa.ListEnvironmentsOutput)

	ListEnvironmentsPages(*mwaa.ListEnvironmentsInput, func(*mwaa.ListEnvironmentsOutput, bool) bool) error
	ListEnvironmentsPagesWithContext(aws.Context, *mwaa.ListEnvironmentsInput, func(*mwaa.ListEnvironmentsOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*mwaa.ListTagsForResourceInput) (*mwaa.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *mwaa.ListTagsForResourceInput, ...request.Option) (*mwaa.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*mwaa.ListTagsForResourceInput) (*request.Request, *mwaa.ListTagsForResourceOutput)

	PublishMetrics(*mwaa.PublishMetricsInput) (*mwaa.PublishMetricsOutput, error)
	PublishMetricsWithContext(aws.Context, *mwaa.PublishMetricsInput, ...request.Option) (*mwaa.PublishMetricsOutput, error)
	PublishMetricsRequest(*mwaa.PublishMetricsInput) (*request.Request, *mwaa.PublishMetricsOutput)

	TagResource(*mwaa.TagResourceInput) (*mwaa.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *mwaa.TagResourceInput, ...request.Option) (*mwaa.TagResourceOutput, error)
	TagResourceRequest(*mwaa.TagResourceInput) (*request.Request, *mwaa.TagResourceOutput)

	UntagResource(*mwaa.UntagResourceInput) (*mwaa.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *mwaa.UntagResourceInput, ...request.Option) (*mwaa.UntagResourceOutput, error)
	UntagResourceRequest(*mwaa.UntagResourceInput) (*request.Request, *mwaa.UntagResourceOutput)

	UpdateEnvironment(*mwaa.UpdateEnvironmentInput) (*mwaa.UpdateEnvironmentOutput, error)
	UpdateEnvironmentWithContext(aws.Context, *mwaa.UpdateEnvironmentInput, ...request.Option) (*mwaa.UpdateEnvironmentOutput, error)
	UpdateEnvironmentRequest(*mwaa.UpdateEnvironmentInput) (*request.Request, *mwaa.UpdateEnvironmentOutput)
}

var _ MWAAAPI = (*mwaa.MWAA)(nil)
