// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package kendrarankingiface provides an interface to enable mocking the Amazon Kendra Intelligent Ranking service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package kendrarankingiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/kendraranking"
)

// KendraRankingAPI provides an interface to enable mocking the
// kendraranking.KendraRanking service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// Amazon Kendra Intelligent Ranking.
//	func myFunc(svc kendrarankingiface.KendraRankingAPI) bool {
//	    // Make svc.CreateRescoreExecutionPlan request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := kendraranking.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockKendraRankingClient struct {
//	    kendrarankingiface.KendraRankingAPI
//	}
//	func (m *mockKendraRankingClient) CreateRescoreExecutionPlan(input *kendraranking.CreateRescoreExecutionPlanInput) (*kendraranking.CreateRescoreExecutionPlanOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockKendraRankingClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type KendraRankingAPI interface {
	CreateRescoreExecutionPlan(*kendraranking.CreateRescoreExecutionPlanInput) (*kendraranking.CreateRescoreExecutionPlanOutput, error)
	CreateRescoreExecutionPlanWithContext(aws.Context, *kendraranking.CreateRescoreExecutionPlanInput, ...request.Option) (*kendraranking.CreateRescoreExecutionPlanOutput, error)
	CreateRescoreExecutionPlanRequest(*kendraranking.CreateRescoreExecutionPlanInput) (*request.Request, *kendraranking.CreateRescoreExecutionPlanOutput)

	DeleteRescoreExecutionPlan(*kendraranking.DeleteRescoreExecutionPlanInput) (*kendraranking.DeleteRescoreExecutionPlanOutput, error)
	DeleteRescoreExecutionPlanWithContext(aws.Context, *kendraranking.DeleteRescoreExecutionPlanInput, ...request.Option) (*kendraranking.DeleteRescoreExecutionPlanOutput, error)
	DeleteRescoreExecutionPlanRequest(*kendraranking.DeleteRescoreExecutionPlanInput) (*request.Request, *kendraranking.DeleteRescoreExecutionPlanOutput)

	DescribeRescoreExecutionPlan(*kendraranking.DescribeRescoreExecutionPlanInput) (*kendraranking.DescribeRescoreExecutionPlanOutput, error)
	DescribeRescoreExecutionPlanWithContext(aws.Context, *kendraranking.DescribeRescoreExecutionPlanInput, ...request.Option) (*kendraranking.DescribeRescoreExecutionPlanOutput, error)
	DescribeRescoreExecutionPlanRequest(*kendraranking.DescribeRescoreExecutionPlanInput) (*request.Request, *kendraranking.DescribeRescoreExecutionPlanOutput)

	ListRescoreExecutionPlans(*kendraranking.ListRescoreExecutionPlansInput) (*kendraranking.ListRescoreExecutionPlansOutput, error)
	ListRescoreExecutionPlansWithContext(aws.Context, *kendraranking.ListRescoreExecutionPlansInput, ...request.Option) (*kendraranking.ListRescoreExecutionPlansOutput, error)
	ListRescoreExecutionPlansRequest(*kendraranking.ListRescoreExecutionPlansInput) (*request.Request, *kendraranking.ListRescoreExecutionPlansOutput)

	ListRescoreExecutionPlansPages(*kendraranking.ListRescoreExecutionPlansInput, func(*kendraranking.ListRescoreExecutionPlansOutput, bool) bool) error
	ListRescoreExecutionPlansPagesWithContext(aws.Context, *kendraranking.ListRescoreExecutionPlansInput, func(*kendraranking.ListRescoreExecutionPlansOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*kendraranking.ListTagsForResourceInput) (*kendraranking.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *kendraranking.ListTagsForResourceInput, ...request.Option) (*kendraranking.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*kendraranking.ListTagsForResourceInput) (*request.Request, *kendraranking.ListTagsForResourceOutput)

	Rescore(*kendraranking.RescoreInput) (*kendraranking.RescoreOutput, error)
	RescoreWithContext(aws.Context, *kendraranking.RescoreInput, ...request.Option) (*kendraranking.RescoreOutput, error)
	RescoreRequest(*kendraranking.RescoreInput) (*request.Request, *kendraranking.RescoreOutput)

	TagResource(*kendraranking.TagResourceInput) (*kendraranking.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *kendraranking.TagResourceInput, ...request.Option) (*kendraranking.TagResourceOutput, error)
	TagResourceRequest(*kendraranking.TagResourceInput) (*request.Request, *kendraranking.TagResourceOutput)

	UntagResource(*kendraranking.UntagResourceInput) (*kendraranking.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *kendraranking.UntagResourceInput, ...request.Option) (*kendraranking.UntagResourceOutput, error)
	UntagResourceRequest(*kendraranking.UntagResourceInput) (*request.Request, *kendraranking.UntagResourceOutput)

	UpdateRescoreExecutionPlan(*kendraranking.UpdateRescoreExecutionPlanInput) (*kendraranking.UpdateRescoreExecutionPlanOutput, error)
	UpdateRescoreExecutionPlanWithContext(aws.Context, *kendraranking.UpdateRescoreExecutionPlanInput, ...request.Option) (*kendraranking.UpdateRescoreExecutionPlanOutput, error)
	UpdateRescoreExecutionPlanRequest(*kendraranking.UpdateRescoreExecutionPlanInput) (*request.Request, *kendraranking.UpdateRescoreExecutionPlanOutput)
}

var _ KendraRankingAPI = (*kendraranking.KendraRanking)(nil)
